/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.coverage;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;
import org.jetbrains.kotlin.idea.coverage.KotlinCoverageExtension;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J3\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\rH\u0016\u00a2\u0006\u0002\u0010#\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension;", "Lcom/intellij/coverage/JavaCoverageEngineExtension;", "()V", "collectOutputFiles", "", "srcFile", "Lcom/intellij/psi/PsiFile;", "output", "Lcom/intellij/openapi/vfs/VirtualFile;", "testoutput", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "classFiles", "", "Ljava/io/File;", "getSummaryCoverageInfo", "Lcom/intellij/coverage/PackageAnnotator$ClassCoverageInfo;", "coverageAnnotator", "Lcom/intellij/coverage/JavaCoverageAnnotator;", "element", "Lcom/intellij/psi/PsiNamedElement;", "isApplicableTo", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lorg/jetbrains/kotlin/idea/run/RunConfigurationBaseAny;", "keepCoverageInfoForClassWithoutSource", "bundle", "classFile", "suggestQualifiedName", "sourceFile", "classes", "", "Lcom/intellij/psi/PsiClass;", "names", "", "(Lcom/intellij/psi/PsiFile;[Lcom/intellij/psi/PsiClass;Ljava/util/Set;)Z", "Companion", "idea-jvm"})
public final class KotlinCoverageExtension
extends JavaCoverageEngineExtension {
    private static final Logger LOG;
    public static final Companion Companion;

    public boolean isApplicableTo(@Nullable RunConfigurationBase<?> conf) {
        return conf instanceof KotlinRunConfiguration;
    }

    public boolean suggestQualifiedName(@NotNull PsiFile sourceFile, @NotNull PsiClass[] classes2, @NotNull Set<String> names2) {
        List<String> qNames;
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)classes2, (String)"classes");
        Intrinsics.checkParameterIsNotNull(names2, (String)"names");
        if (sourceFile instanceof KtFile && (qNames = Companion.collectGeneratedClassQualifiedNames(KotlinCoverageExtension.Companion.findOutputRoot((KtFile)sourceFile), (KtFile)sourceFile)) != null) {
            names2.addAll((Collection<String>)qNames);
            return true;
        }
        return false;
    }

    @Nullable
    public PackageAnnotator.ClassCoverageInfo getSummaryCoverageInfo(@NotNull JavaCoverageAnnotator coverageAnnotator, @NotNull PsiNamedElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)coverageAnnotator, (String)"coverageAnnotator");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!(element3 instanceof KtFile)) {
            return null;
        }
        LOG.info("Retrieving coverage for " + ((KtFile)element3).getName());
        List<String> qualifiedNames = Companion.collectGeneratedClassQualifiedNames(KotlinCoverageExtension.Companion.findOutputRoot((KtFile)element3), (KtFile)element3);
        return qualifiedNames == null ? null : KotlinCoverageExtension.Companion.totalCoverageForQualifiedNames(coverageAnnotator, qualifiedNames);
    }

    public boolean keepCoverageInfoForClassWithoutSource(@NotNull CoverageSuitesBundle bundle, @NotNull File classFile) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        return true;
    }

    public boolean collectOutputFiles(@NotNull PsiFile srcFile, @Nullable VirtualFile output, @Nullable VirtualFile testoutput, @NotNull CoverageSuitesBundle suite, @NotNull Set<File> classFiles) {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        Intrinsics.checkParameterIsNotNull(classFiles, (String)"classFiles");
        if (srcFile instanceof KtFile) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)srcFile.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getIn\u2026nce(srcFile.getProject())");
            ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026e.getProject()).fileIndex");
            ProjectFileIndex fileIndex = projectFileIndex;
            if (fileIndex.isInLibraryClasses(srcFile.getVirtualFile()) || fileIndex.isInLibrarySource(srcFile.getVirtualFile())) {
                return false;
            }
            ApplicationUtilsKt.runReadAction((Function0)new Function0<Set<File>>(srcFile, classFiles){
                final /* synthetic */ PsiFile $srcFile;
                final /* synthetic */ Set $classFiles;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Set<File> invoke() {
                    void $this$mapTo$iv;
                    VirtualFile outputRoot = org.jetbrains.kotlin.idea.coverage.KotlinCoverageExtension$Companion.access$findOutputRoot(KotlinCoverageExtension.Companion, (KtFile)this.$srcFile);
                    List existingClassFiles = org.jetbrains.kotlin.idea.coverage.KotlinCoverageExtension$Companion.access$getClassesGeneratedFromFile(KotlinCoverageExtension.Companion, outputRoot, (KtFile)this.$srcFile);
                    Iterable iterable = existingClassFiles;
                    Collection destination$iv = this.$classFiles;
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void it;
                        VirtualFile virtualFile2 = (VirtualFile)item$iv;
                        Collection collection = destination$iv;
                        boolean bl = false;
                        File file2 = new File(it.getPath());
                        collection.add(file2);
                    }
                    return (Set)destination$iv;
                }
                {
                    this.$srcFile = psiFile;
                    this.$classFiles = set2;
                    super(0);
                }
            });
            return true;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinCoverageExtension.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Kotli\u2026ageExtension::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "collectClassFilePrefixes", "", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectGeneratedClassQualifiedNames", "", "outputRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "findOutputRoot", "getClassesGeneratedFromFile", "totalCoverageForQualifiedNames", "Lcom/intellij/coverage/PackageAnnotator$ClassCoverageInfo;", "coverageAnnotator", "Lcom/intellij/coverage/JavaCoverageAnnotator;", "qualifiedNames", "idea-jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<String> collectGeneratedClassQualifiedNames(@Nullable VirtualFile outputRoot, @NotNull KtFile file2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            List<VirtualFile> existingClassFiles = this.getClassesGeneratedFromFile(outputRoot, file2);
            if (existingClassFiles.isEmpty()) {
                return null;
            }
            LOG.debug("ClassFiles: [" + CollectionsKt.joinToString$default((Iterable)existingClassFiles, null, null, null, (int)0, null, (Function1)collectGeneratedClassQualifiedNames.1.INSTANCE, (int)31, null) + ']');
            Iterable $this$map$iv = existingClassFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String relativePath;
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile3 = outputRoot;
                if (virtualFile3 == null) {
                    Intrinsics.throwNpe();
                }
                if (VfsUtilCore.getRelativePath((VirtualFile)it, (VirtualFile)virtualFile3) == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"VfsUtilCore.getRelativePath(it, outputRoot!!)!!");
                String string = StringUtil.trimEnd((String)relativePath, (String)".class");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.trimEnd(relativePath, \".class\")");
                String string2 = StringsKt.replace$default((String)string, (String)"/", (String)".", (boolean)false, (int)4, null);
                collection.add(string2);
            }
            return (List)destination$iv$iv;
        }

        private final PackageAnnotator.ClassCoverageInfo totalCoverageForQualifiedNames(JavaCoverageAnnotator coverageAnnotator, List<String> qualifiedNames) {
            PackageAnnotator.ClassCoverageInfo result2 = new PackageAnnotator.ClassCoverageInfo();
            result2.totalClassCount = 0;
            Iterable $this$forEach$iv = qualifiedNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                PackageAnnotator.ClassCoverageInfo classInfo = coverageAnnotator.getClassCoverageInfo(it);
                if (classInfo != null) {
                    result2.totalClassCount += classInfo.totalClassCount;
                    result2.coveredClassCount += classInfo.coveredClassCount;
                    result2.totalMethodCount += classInfo.totalMethodCount;
                    result2.coveredMethodCount += classInfo.coveredMethodCount;
                    result2.totalLineCount += classInfo.totalLineCount;
                    result2.fullyCoveredLineCount += classInfo.fullyCoveredLineCount;
                    result2.partiallyCoveredLineCount += classInfo.partiallyCoveredLineCount;
                    continue;
                }
                LOG.debug("Found no coverage for " + it);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> getClassesGeneratedFromFile(VirtualFile outputRoot, KtFile file2) {
            void $this$filterTo$iv$iv;
            String string = file2.getPackageFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.packageFqName.asString()");
            String relativePath = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
            VirtualFile virtualFile2 = outputRoot;
            if (virtualFile2 == null || (virtualFile2 = virtualFile2.findFileByRelativePath(relativePath)) == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"outputRoot?.findFileByRe\u2026ePath) ?: return listOf()");
            VirtualFile packageOutputDir = virtualFile2;
            Collection<String> prefixes = this.collectClassFilePrefixes(file2);
            LOG.debug("ClassFile prefixes: [" + CollectionsKt.joinToString$default((Iterable)prefixes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ']');
            VirtualFile[] virtualFileArray = packageOutputDir.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"packageOutputDir.children");
            VirtualFile[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            VirtualFile[] virtualFileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var11_12 = $this$filterTo$iv$iv;
            int n = ((void)var11_12).length;
            for (int j = 0; j < n; ++j) {
                boolean bl;
                void element$iv$iv;
                block5: {
                    void packageFile = element$iv$iv = var11_12[j];
                    boolean bl2 = false;
                    Iterable $this$any$iv = prefixes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            void v4 = packageFile;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"packageFile");
                            String string2 = v4.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"packageFile.name");
                            if (!(StringsKt.startsWith$default((String)string2, (String)(it + '$'), (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)packageFile.getName()), (Object)"class") || Intrinsics.areEqual((Object)packageFile.getName(), (Object)(it + ".class")))) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final VirtualFile findOutputRoot(KtFile file2) {
            VirtualFile virtualFile2;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file2));
            if (module == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026ment(file) ?: return null");
            Module module2 = module;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)file2.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(file.project)");
            ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026e(file.project).fileIndex");
            ProjectFileIndex fileIndex = projectFileIndex;
            FileIndex fileIndex2 = (FileIndex)fileIndex;
            VirtualFile virtualFile3 = file2.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file.virtualFile");
            boolean inTests = FileIndexUtilsKt.isInTestSourceContentKotlinAware(fileIndex2, virtualFile3);
            CompilerModuleExtension compilerOutputExtension = CompilerModuleExtension.getInstance((Module)module2);
            if (inTests) {
                CompilerModuleExtension compilerModuleExtension = compilerOutputExtension;
                if (compilerModuleExtension == null) {
                    Intrinsics.throwNpe();
                }
                virtualFile2 = compilerModuleExtension.getCompilerOutputPathForTests();
            } else {
                CompilerModuleExtension compilerModuleExtension = compilerOutputExtension;
                if (compilerModuleExtension == null) {
                    Intrinsics.throwNpe();
                }
                virtualFile2 = compilerModuleExtension.getCompilerOutputPath();
            }
            return virtualFile2;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<String> collectClassFilePrefixes(KtFile file2) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = file2.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"file.children");
            PsiElement[] $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtClassOrObject)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtClassOrObject it = (KtClassOrObject)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            FqName packagePartFqName = JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName();
            return CollectionsKt.union((Iterable)result2, (Iterable)CollectionsKt.arrayListOf((Object[])new String[]{packagePartFqName.shortName().asString()}));
        }

        private Companion() {
        }

        public static final /* synthetic */ List access$getClassesGeneratedFromFile(Companion $this, VirtualFile outputRoot, KtFile file2) {
            return $this.getClassesGeneratedFromFile(outputRoot, file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

