/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "xBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "hasTargetLine", "", "classType", "Lcom/sun/jdi/ReferenceType;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "processClassPrepare", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "idea-jvm"})
public final class KotlinLineBreakpoint
extends LineBreakpoint<JavaLineBreakpointProperties> {
    public void processClassPrepare(@Nullable DebugProcess debugProcess, @Nullable ReferenceType classType) {
        XSourcePosition sourcePosition;
        XBreakpoint xBreakpoint = this.getXBreakpoint();
        Object object = sourcePosition = xBreakpoint != null ? xBreakpoint.getSourcePosition() : null;
        if (classType != null && sourcePosition != null && !this.hasTargetLine(classType, sourcePosition)) {
            return;
        }
        super.processClassPrepare(debugProcess, classType);
    }

    private final boolean hasTargetLine(ReferenceType classType, XSourcePosition sourcePosition) {
        List list2 = DebuggerUtilsEx.allLineLocations((ReferenceType)classType);
        if (list2 == null) {
            return true;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"DebuggerUtilsEx.allLineL\u2026classType) ?: return true");
        List allLineLocations = list2;
        if (NoStrataPositionManagerHelperKt.isDexDebug(classType.virtualMachine())) {
            return true;
        }
        VirtualFile virtualFile2 = sourcePosition.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"sourcePosition.file");
        String string = virtualFile2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourcePosition.file.name");
        String fileName = string;
        int lineNumber = sourcePosition.getLine() + 1;
        for (Location location2 : allLineLocations) {
            try {
                String kotlinFileName = location2.sourceName("Kotlin");
                int kotlinLineNumber = location2.lineNumber("Kotlin");
                if (!Intrinsics.areEqual((Object)kotlinFileName, (Object)fileName) || kotlinLineNumber != lineNumber) continue;
                return true;
            }
            catch (AbsentInformationException e) {
                if (!Intrinsics.areEqual((Object)location2.sourceName(), (Object)fileName) || location2.lineNumber() != lineNumber) continue;
                return true;
            }
        }
        return false;
    }

    public KotlinLineBreakpoint(@Nullable Project project, @Nullable XBreakpoint<? extends XBreakpointProperties<?>> xBreakpoint) {
        super(project, xBreakpoint);
    }
}

