/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001c\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ(\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*00J(\u0010)\u001a\u0004\u0018\u00010*2\u0006\u00101\u001a\u0002022\u0006\u0010-\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*00J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000202J\u0016\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0014J&\u00106\u001a\u0002022\u0006\u0010+\u001a\u00020,2\u0006\u0010;\u001a\u00020.2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*00R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;Lcom/intellij/debugger/jdi/StackFrameProxyImpl;)V", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "getClassLoader", "()Lcom/sun/jdi/ClassLoaderReference;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "getEvaluationContext", "()Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "getFrameProxy", "()Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "invokePolicy", "", "getInvokePolicy", "()I", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "vm", "Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "getVm", "()Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "findClass", "Lcom/sun/jdi/ReferenceType;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "invokeMethod", "Lcom/sun/jdi/Value;", "type", "Lcom/sun/jdi/ClassType;", "method", "Lcom/sun/jdi/Method;", "args", "", "obj", "Lcom/sun/jdi/ObjectReference;", "keepReference", "", "reference", "newInstance", "Lcom/sun/jdi/ArrayReference;", "arrayType", "Lcom/sun/jdi/ArrayType;", "dimension", "constructor", "idea-jvm"})
public final class ExecutionContext {
    private final int invokePolicy;
    @NotNull
    private final EvaluationContextImpl evaluationContext;
    @NotNull
    private final StackFrameProxyImpl frameProxy;

    @NotNull
    public final VirtualMachineProxyImpl getVm() {
        DebugProcessImpl debugProcessImpl = this.evaluationContext.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"evaluationContext.debugProcess");
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"evaluationContext.debugProcess.virtualMachineProxy");
        return virtualMachineProxyImpl;
    }

    @Nullable
    public final ClassLoaderReference getClassLoader() {
        return this.evaluationContext.getClassLoader();
    }

    @NotNull
    public final SuspendContextImpl getSuspendContext() {
        SuspendContextImpl suspendContextImpl = this.evaluationContext.getSuspendContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl, (String)"evaluationContext.suspendContext");
        return suspendContextImpl;
    }

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        DebugProcessImpl debugProcessImpl = this.evaluationContext.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"evaluationContext.debugProcess");
        return debugProcessImpl;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.evaluationContext.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"evaluationContext.project");
        return project;
    }

    public final int getInvokePolicy() {
        return this.invokePolicy;
    }

    @Nullable
    public final Value invokeMethod(@NotNull ObjectReference obj, @NotNull Method method, @NotNull List<? extends Value> args) throws EvaluateException {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        return this.getDebugProcess().invokeInstanceMethod((EvaluationContext)this.evaluationContext, obj, method, args, this.invokePolicy);
    }

    @Nullable
    public final Value invokeMethod(@NotNull ClassType type2, @NotNull Method method, @NotNull List<? extends Value> args) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        return this.getDebugProcess().invokeMethod((EvaluationContext)this.evaluationContext, type2, method, args);
    }

    @NotNull
    public final ObjectReference newInstance(@NotNull ClassType type2, @NotNull Method constructor2, @NotNull List<? extends Value> args) throws EvaluateException {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        ObjectReference objectReference = this.getDebugProcess().newInstance((EvaluationContext)this.evaluationContext, type2, constructor2, args);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectReference, (String)"debugProcess.newInstance\u2026 type, constructor, args)");
        return objectReference;
    }

    @NotNull
    public final ArrayReference newInstance(@NotNull ArrayType arrayType, int dimension) throws EvaluateException {
        Intrinsics.checkParameterIsNotNull((Object)arrayType, (String)"arrayType");
        ArrayReference arrayReference = this.getDebugProcess().newInstance(arrayType, dimension);
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayReference, (String)"debugProcess.newInstance(arrayType, dimension)");
        return arrayReference;
    }

    @Nullable
    public final ReferenceType findClass(@NotNull String name2, @Nullable ClassLoaderReference classLoader) throws EvaluateException {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        ReferenceType referenceType = this.getDebugProcess().findClass((EvaluationContext)this.evaluationContext, name2, classLoader);
        if (referenceType != null) {
            ReferenceType referenceType2 = referenceType;
            boolean bl = false;
            boolean bl2 = false;
            ReferenceType it = referenceType2;
            boolean bl3 = false;
            return it;
        }
        if (!this.evaluationContext.isAutoLoadClasses()) {
            try {
                this.getDebugProcess().loadClass(this.evaluationContext, name2, classLoader);
            }
            catch (InvocationException e) {
                EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.createEvaluateException(e)");
                throw (Throwable)evaluateException;
            }
            catch (ClassNotLoadedException e) {
                EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.createEvaluateException(e)");
                throw (Throwable)evaluateException;
            }
            catch (IncompatibleThreadStateException e) {
                EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.createEvaluateException(e)");
                throw (Throwable)evaluateException;
            }
            catch (InvalidTypeException e) {
                EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.createEvaluateException(e)");
                throw (Throwable)evaluateException;
            }
        }
        return null;
    }

    public static /* synthetic */ ReferenceType findClass$default(ExecutionContext executionContext, String string, ClassLoaderReference classLoaderReference, int n, Object object) throws EvaluateException {
        if ((n & 2) != 0) {
            classLoaderReference = null;
        }
        return executionContext.findClass(string, classLoaderReference);
    }

    @Nullable
    public final ReferenceType findClass(@NotNull Type asmType, @Nullable ClassLoaderReference classLoader) throws EvaluateException {
        Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
        if (asmType.getSort() != 10 && asmType.getSort() != 9) {
            return null;
        }
        String string = asmType.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asmType.className");
        return this.findClass(string, classLoader);
    }

    public static /* synthetic */ ReferenceType findClass$default(ExecutionContext executionContext, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) throws EvaluateException {
        if ((n & 2) != 0) {
            classLoaderReference = null;
        }
        return executionContext.findClass(type2, classLoaderReference);
    }

    public final void keepReference(@NotNull ObjectReference reference2) {
        Intrinsics.checkParameterIsNotNull((Object)reference2, (String)"reference");
        DebuggerUtilsEx.keep((Value)reference2, (EvaluationContext)((EvaluationContext)this.evaluationContext));
    }

    @NotNull
    public final EvaluationContextImpl getEvaluationContext() {
        return this.evaluationContext;
    }

    @NotNull
    public final StackFrameProxyImpl getFrameProxy() {
        return this.frameProxy;
    }

    public ExecutionContext(@NotNull EvaluationContextImpl evaluationContext, @NotNull StackFrameProxyImpl frameProxy) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkParameterIsNotNull((Object)frameProxy, (String)"frameProxy");
        this.evaluationContext = evaluationContext;
        this.frameProxy = frameProxy;
        ExecutionContext executionContext = this;
        ExecutionContext executionContext2 = this;
        boolean bl = false;
        boolean bl2 = false;
        ExecutionContext $this$run = executionContext;
        boolean bl3 = false;
        SuspendContextImpl suspendContextImpl = $this$run.evaluationContext.getSuspendContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl, (String)"evaluationContext.suspendContext");
        SuspendContextImpl suspendContext = suspendContextImpl;
        executionContext2.invokePolicy = n = suspendContext.getSuspendPolicy() == 1 ? 1 : 0;
    }
}

