/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.EdtTestUtilKt;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval4JInterpretingException;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationError;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatus;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatusKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledDataDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledDataDescriptorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.ClassLoadingResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0002./B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016JI\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u001a\u0010'\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u0012\u0004\u0012\u0002H&0(H\u0002\u00a2\u0006\u0002\u0010)J\u0014\u0010*\u001a\u00020+*\u00020\u00032\u0006\u0010,\u001a\u00020-H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "getSourcePosition", "()Lcom/intellij/debugger/SourcePosition;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "status", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "calculateMainMethodCallArguments", "", "Lcom/sun/jdi/Value;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "compiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;", "compileCodeFragment", "evaluate", "", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "evaluateSafe", "evaluateWithCompilation", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "evaluateWithEval4J", "Lorg/jetbrains/eval4j/InterpreterResult;", "evaluateWithStatus", "getModifier", "", "runEvaluation", "T", "block", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;Lcom/sun/jdi/ClassLoaderReference;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "wrapToStringIfNeeded", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Companion", "ErrorCheckingResult", "idea-jvm"})
public final class KotlinEvaluator
implements Evaluator {
    @NotNull
    private final KtCodeFragment codeFragment;
    @Nullable
    private final SourcePosition sourcePosition;
    private static final Set<DiagnosticFactory<?>> IGNORED_DIAGNOSTICS;
    private static final List<Type> DEFAULT_METHOD_MARKERS;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        String string = this.codeFragment.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"codeFragment.text");
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() == 0) {
            DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
            return debugProcessImpl.getVirtualMachineProxy().mirrorOfVoid();
        }
        EvaluationStatus status2 = new EvaluationStatus();
        KotlinDebuggerEvaluator.EvaluationType evaluationType = (KotlinDebuggerEvaluator.EvaluationType)((Object)this.codeFragment.getUserData(KotlinCodeFragmentFactory.Companion.getEVALUATION_TYPE()));
        if (evaluationType != null) {
            status2.evaluationType(evaluationType);
        }
        EvaluationStatus.EvaluationContextLanguage language = Intrinsics.areEqual((Object)(object = this.codeFragment.getLanguage()), (Object)((Object)KotlinLanguage.INSTANCE)) ? EvaluationStatus.EvaluationContextLanguage.Kotlin : (Intrinsics.areEqual((Object)object, (Object)JavaLanguage.INSTANCE) ? EvaluationStatus.EvaluationContextLanguage.Java : EvaluationStatus.EvaluationContextLanguage.Other);
        EvaluationStatusKt.contextLanguage(status2, language);
        try {
            object = this.evaluateWithStatus(context2, status2);
            return object;
        }
        finally {
            status2.send();
        }
    }

    private final Object evaluateWithStatus(EvaluationContextImpl context2, EvaluationStatus status2) {
        DumbService dumbService = DumbService.getInstance((Project)this.codeFragment.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(codeFragment.project)");
        if (dumbService.isDumb()) {
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException("Code fragment evaluation is not available in the dumb mode");
            throw null;
        }
        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            KotlinEvaluator kotlinEvaluator2 = this;
            boolean bl = false;
            boolean bl2 = false;
            KotlinEvaluator $this$run = kotlinEvaluator2;
            boolean bl3 = false;
            status2.error(EvaluationError.NoFrameProxy);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException("Cannot evaluate a code fragment: frame proxy is not available");
            throw null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)stackFrameProxyImpl, (String)"context.frameProxy ?: ru\u2026not available\")\n        }");
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        SuspendContextImpl suspendContextImpl = context2.getSuspendContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl, (String)"context.suspendContext");
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        if (threadReferenceProxyImpl == null) {
            KotlinEvaluator kotlinEvaluator3 = this;
            boolean bl = false;
            boolean $this$run = false;
            KotlinEvaluator $this$run2 = kotlinEvaluator3;
            boolean bl4 = false;
            status2.error(EvaluationError.ThreadNotAvailable);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException("Cannot evaluate a code fragment: thread is not available");
            throw null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)threadReferenceProxyImpl, (String)"context.suspendContext.t\u2026not available\")\n        }");
        ThreadReferenceProxyImpl operatingThread = threadReferenceProxyImpl;
        if (!operatingThread.isSuspended()) {
            status2.error(EvaluationError.ThreadNotSuspended);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException("Evaluation is available only for the suspended threads");
            throw null;
        }
        try {
            ExecutionContext executionContext = new ExecutionContext(context2, frameProxy);
            return this.evaluateSafe(executionContext, status2);
        }
        catch (EvaluateException e) {
            status2.error(EvaluationError.EvaluateException);
            throw (Throwable)e;
        }
        catch (ProcessCanceledException e) {
            status2.error(EvaluationError.ProcessCancelledException);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(e);
            throw null;
        }
        catch (Eval4JInterpretingException e) {
            status2.error(EvaluationError.InterpretingException);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(e.getCause());
            throw null;
        }
        catch (Exception e) {
            boolean isSpecialException = KotlinEvaluatorBuilderKt.access$isSpecialException(e);
            if (isSpecialException) {
                status2.error(EvaluationError.SpecialException);
                Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(e);
                throw null;
            }
            status2.error(EvaluationError.GenericException);
            String string = e.getMessage();
            if (string == null) {
                string = "An exception occurred";
            }
            KotlinEvaluatorBuilderKt.access$reportError(this.codeFragment, this.sourcePosition, string, e);
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException("Cannot evaluate the expression: " + cause);
            throw null;
        }
    }

    private final Object evaluateSafe(ExecutionContext context2, EvaluationStatus status2) {
        InterpreterResult interpreterResult;
        ClassLoaderReference classLoaderRef;
        Function0<CompiledDataDescriptor> $fun$compilerFactory$1 = new Function0<CompiledDataDescriptor>(this, context2, status2){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ EvaluationStatus $status;

            @NotNull
            public final CompiledDataDescriptor invoke() {
                return KotlinEvaluator.access$compileCodeFragment(this.this$0, this.$context, this.$status);
            }
            {
                this.this$0 = kotlinEvaluator2;
                this.$context = executionContext;
                this.$status = evaluationStatus;
                super(0);
            }
        };
        Pair<CompiledDataDescriptor, Boolean> pair2 = KotlinDebuggerCaches.Companion.compileCodeFragmentCacheAware(this.codeFragment, this.sourcePosition, (Function0<CompiledDataDescriptor>)((Function0)new Function0<CompiledDataDescriptor>($fun$compilerFactory$1){
            final /* synthetic */ evaluateSafe.1 $compilerFactory$1;

            @NotNull
            public final CompiledDataDescriptor invoke() {
                return this.$compilerFactory$1.invoke();
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "compilerFactory";
            }

            public final String getSignature() {
                return "invoke()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;";
            }
            {
                this.$compilerFactory$1 = var1_1;
                super(0);
            }
        }), false);
        CompiledDataDescriptor compiledData = (CompiledDataDescriptor)pair2.component1();
        ClassLoadingResult classLoadingResult = CompilingEvaluatorKt.loadClassesSafely(context2, (Collection<ClassToLoad>)compiledData.getClasses());
        ClassLoadingResult classLoadingResult2 = classLoadingResult;
        if (!(classLoadingResult2 instanceof ClassLoadingResult.Success)) {
            classLoadingResult2 = null;
        }
        ClassLoadingResult.Success success2 = (ClassLoadingResult.Success)classLoadingResult2;
        ClassLoaderReference classLoaderReference = classLoaderRef = success2 != null ? success2.getClassLoader() : null;
        if (classLoadingResult instanceof ClassLoadingResult.Failure) {
            EvaluationStatusKt.classLoadingFailed(status2);
        }
        if (classLoaderRef != null) {
            try {
                EvaluationStatusKt.usedEvaluator(status2, EvaluationStatus.EvaluatorType.Bytecode);
                return this.evaluateWithCompilation(context2, compiledData, classLoaderRef);
            }
            catch (Throwable e) {
                InterpreterResult interpreterResult2;
                EvaluationStatusKt.compilingEvaluatorFailed(status2);
                KotlinEvaluatorBuilderKt.getLOG().warn("Compiling evaluator failed", e);
                EvaluationStatusKt.usedEvaluator(status2, EvaluationStatus.EvaluatorType.Eval4j);
                interpreterResult = interpreterResult2 = this.evaluateWithEval4J(context2, compiledData, classLoaderRef);
            }
        } else {
            EvaluationStatusKt.usedEvaluator(status2, EvaluationStatus.EvaluatorType.Eval4j);
            interpreterResult = this.evaluateWithEval4J(context2, compiledData, classLoaderRef);
        }
        InterpreterResult result2 = interpreterResult;
        return KotlinEvaluator.Companion.toJdiValue(result2, context2);
    }

    /*
     * WARNING - void declaration
     */
    private final CompiledDataDescriptor compileCodeFragment(ExecutionContext context2, EvaluationStatus status2) {
        void analysisResult;
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.analyze(this.codeFragment, status2, debugProcess);
        if (this.wrapToStringIfNeeded(this.codeFragment, ((ErrorCheckingResult)analysisResult.element).getBindingContext())) {
            analysisResult.element = this.analyze(this.codeFragment, status2, debugProcess);
        }
        Pair pair2 = (Pair)ApplicationUtilsKt.runReadAction((Function0)new Function0<Pair<? extends BindingContext, ? extends List<? extends KtFile>>>(this, (Ref.ObjectRef)analysisResult){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ Ref.ObjectRef $analysisResult;

            @NotNull
            public final Pair<BindingContext, List<KtFile>> invoke() {
                Project project = this.this$0.getCodeFragment().getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"codeFragment.project");
                return DebuggerUtils.INSTANCE.analyzeInlinedFunctions(KotlinCacheService.Companion.getInstance(project).getResolutionFacade(CollectionsKt.listOf((Object)this.this$0.getCodeFragment())), this.this$0.getCodeFragment(), false, ((ErrorCheckingResult)this.$analysisResult.element).getBindingContext());
            }
            {
                this.this$0 = kotlinEvaluator2;
                this.$analysisResult = objectRef;
                super(0);
            }
        });
        BindingContext bindingContext2 = (BindingContext)pair2.component1();
        ModuleDescriptor moduleDescriptor2 = ((ErrorCheckingResult)analysisResult.element).getModuleDescriptor();
        try {
            CodeFragmentCompiler.CompilationResult result2 = new CodeFragmentCompiler(context2).compile(this.codeFragment, bindingContext2, moduleDescriptor2);
            return CompiledDataDescriptor.Companion.from(result2, this.sourcePosition);
        }
        catch (Throwable e) {
            status2.error(EvaluationError.BackendException);
            throw e;
        }
    }

    private final boolean wrapToStringIfNeeded(@NotNull KtCodeFragment $this$wrapToStringIfNeeded, BindingContext bindingContext2) {
        KotlinType expressionType;
        if (!($this$wrapToStringIfNeeded instanceof KtExpressionCodeFragment)) {
            return false;
        }
        KtExpression contentElement2 = (KtExpression)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtExpression>($this$wrapToStringIfNeeded){
            final /* synthetic */ KtCodeFragment $this_wrapToStringIfNeeded;

            @Nullable
            public final KtExpression invoke() {
                return ((KtExpressionCodeFragment)this.$this_wrapToStringIfNeeded).getContentElement();
            }
            {
                this.$this_wrapToStringIfNeeded = ktCodeFragment;
                super(0);
            }
        });
        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)bindingContext2.get(BindingContext.EXPRESSION_TYPE_INFO, contentElement2);
        KotlinType kotlinType2 = expressionType = kotlinTypeInfo != null ? kotlinTypeInfo.getType() : null;
        if (contentElement2 != null) {
            KotlinType kotlinType3 = expressionType;
            if (kotlinType3 != null) {
                if (InlineClassesUtilsKt.isInlineClassType(kotlinType3)) {
                    KtExpression newExpression2 = (KtExpression)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtExpression>($this$wrapToStringIfNeeded, contentElement2){
                        final /* synthetic */ KtCodeFragment $this_wrapToStringIfNeeded;
                        final /* synthetic */ KtExpression $contentElement;

                        @NotNull
                        public final KtExpression invoke() {
                            String expressionText2 = this.$contentElement.getText();
                            Project project = ((KtExpressionCodeFragment)this.$this_wrapToStringIfNeeded).getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                            return new KtPsiFactory(project, false, 2, null).createExpression('(' + expressionText2 + ").toString()");
                        }
                        {
                            this.$this_wrapToStringIfNeeded = ktCodeFragment;
                            this.$contentElement = ktExpression;
                            super(0);
                        }
                    });
                    EdtTestUtilKt.runInEdtAndWait((Function0)((Function0)new Function0<Unit>($this$wrapToStringIfNeeded, contentElement2, newExpression2){
                        final /* synthetic */ KtCodeFragment $this_wrapToStringIfNeeded;
                        final /* synthetic */ KtExpression $contentElement;
                        final /* synthetic */ KtExpression $newExpression;

                        public final void invoke() {
                            Project project = ((KtExpressionCodeFragment)this.$this_wrapToStringIfNeeded).getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                            ApplicationUtilsKt.executeWriteCommand(project, "Wrap with 'toString()'", (Function0<Unit>)((Function0)new Function0<Unit>(this){
                                final /* synthetic */ wrapToStringIfNeeded.1 this$0;

                                public final void invoke() {
                                    this.this$0.$contentElement.replace((PsiElement)this.this$0.$newExpression);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            }));
                        }
                        {
                            this.$this_wrapToStringIfNeeded = ktCodeFragment;
                            this.$contentElement = ktExpression;
                            this.$newExpression = ktExpression2;
                            super(0);
                        }
                    }));
                    return true;
                }
            }
        }
        return false;
    }

    private final ErrorCheckingResult analyze(KtCodeFragment codeFragment, EvaluationStatus status2, DebugProcessImpl debugProcess) {
        return (ErrorCheckingResult)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)new Function0<ErrorCheckingResult>(codeFragment, debugProcess, status2){
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ EvaluationStatus $status;

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final ErrorCheckingResult invoke() {
                block9: {
                    try {
                        AnalyzingUtils.checkForSyntacticErrors((PsiElement)this.$codeFragment);
                    }
                    catch (IllegalArgumentException e) {
                        v0 = e.getMessage();
                        if (v0 == null) {
                            v0 = e.toString();
                        }
                        v1 = KotlinEvaluatorBuilderKt.access$evaluationException(v0);
                        throw null;
                    }
                    filesToAnalyze = CollectionsKt.listOf((Object)this.$codeFragment);
                    v2 = this.$codeFragment.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"codeFragment.project");
                    resolutionFacade = KotlinCacheService.Companion.getInstance(v2).getResolutionFacade(filesToAnalyze);
                    new DebugLabelPropertyDescriptorProvider(this.$codeFragment, this.$debugProcess).supplyDebugLabels();
                    analysisResult = resolutionFacade.analyzeWithAllCompilerChecks(filesToAnalyze);
                    if (analysisResult.isError()) {
                        this.$status.error(EvaluationError.FrontendException);
                        v3 = KotlinEvaluatorBuilderKt.access$evaluationException(analysisResult.getError());
                        throw null;
                    }
                    bindingContext = analysisResult.getBindingContext();
                    v4 = bindingContext.getDiagnostics();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"bindingContext.diagnostics");
                    $this$filter$iv = v4;
                    $i$f$filter = false;
                    var7_8 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Diagnostic)element$iv$iv;
                        $i$a$-filter-KotlinEvaluator$analyze$1$1 = false;
                        if (!(KotlinEvaluator.access$getIGNORED_DIAGNOSTICS$cp().contains(it.getFactory()) == false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$firstOrNull$iv = (List)destination$iv$iv;
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (Diagnostic)element$iv;
                        $i$a$-firstOrNull-KotlinEvaluator$analyze$1$2 = false;
                        if (it.getSeverity() != Severity.ERROR) ** GOTO lbl-1000
                        v5 = it.getPsiElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it.psiElement");
                        if (Intrinsics.areEqual((Object)v5.getContainingFile(), (Object)this.$codeFragment)) {
                            v6 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v6 = false;
                        }
                        if (!v6) continue;
                        v7 = element$iv;
                        break block9;
                    }
                    v7 = null;
                }
                v8 = v7;
                if (v8 != null) {
                    var5_6 = v8;
                    var6_7 = false;
                    var7_9 = false;
                    it = var5_6;
                    $i$a$-let-KotlinEvaluator$analyze$1$3 = false;
                    this.$status.error(EvaluationError.ErrorsInCode);
                    v9 = DefaultErrorMessages.render(it);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"DefaultErrorMessages.render(it)");
                    v10 = KotlinEvaluatorBuilderKt.access$evaluationException(v9);
                    throw null;
                }
                v11 = analysisResult.getModuleDescriptor();
                v12 = Collections.singletonList(this.$codeFragment);
                Intrinsics.checkExpressionValueIsNotNull(v12, (String)"Collections.singletonList(codeFragment)");
                return new ErrorCheckingResult(bindingContext, v11, v12);
            }
            {
                this.$codeFragment = ktCodeFragment;
                this.$debugProcess = debugProcessImpl;
                this.$status = evaluationStatus;
                super(0);
            }
        });
    }

    private final com.sun.jdi.Value evaluateWithCompilation(ExecutionContext context2, CompiledDataDescriptor compiledData, ClassLoaderReference classLoader) {
        return (com.sun.jdi.Value)this.runEvaluation(context2, compiledData, classLoader, (Function1)new Function1<List<? extends com.sun.jdi.Value>, com.sun.jdi.Value>(context2, classLoader){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ClassLoaderReference $classLoader;

            @Nullable
            public final com.sun.jdi.Value invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Method mainMethod;
                Intrinsics.checkParameterIsNotNull(args, (String)"args");
                ReferenceType referenceType = this.$context.findClass("Generated_for_debugger_class", this.$classLoader);
                if (!(referenceType instanceof ClassType)) {
                    referenceType = null;
                }
                ClassType classType = (ClassType)referenceType;
                if (classType == null) {
                    String string = "Can not find class \"Generated_for_debugger_class\"";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                ClassType mainClassType = classType;
                List<Method> list2 = mainClassType.methods();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"mainClassType.methods()");
                Iterable $this$single$iv = list2;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (T element$iv : $this$single$iv) {
                    Method it = (Method)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)"generated_for_debugger_fun")) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Method method = mainMethod = (Method)single$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"mainMethod");
                com.sun.jdi.Value returnValue = this.$context.invokeMethod(mainClassType, method, args);
                return new EvaluatorValueConverter(this.$context).unref(returnValue);
            }
            {
                this.$context = executionContext;
                this.$classLoader = classLoaderReference;
                super(1);
            }
        });
    }

    private final InterpreterResult evaluateWithEval4J(ExecutionContext context2, CompiledDataDescriptor compiledData, ClassLoaderReference classLoader) {
        Object element$iv2;
        block2: {
            byte[] mainClassBytecode = CompiledDataDescriptorKt.getMainClass(compiledData).getBytes();
            ClassNode classNode = new ClassNode();
            boolean bl = false;
            boolean bl2 = false;
            ClassNode $this$apply = classNode;
            boolean bl3 = false;
            new ClassReader(mainClassBytecode).accept((ClassVisitor)$this$apply, 0);
            ClassNode mainClassAsmNode = classNode;
            List list2 = mainClassAsmNode.methods;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"mainClassAsmNode.methods");
            Iterable $this$first$iv = list2;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MethodNode it = (MethodNode)element$iv2;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)"generated_for_debugger_fun")) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        MethodNode mainMethod = (MethodNode)element$iv2;
        ClassLoaderReference classLoaderReference = classLoader;
        if (classLoaderReference == null) {
            classLoaderReference = context2.getEvaluationContext().getClassLoader();
        }
        return (InterpreterResult)this.runEvaluation(context2, compiledData, classLoaderReference, (Function1)new Function1<List<? extends com.sun.jdi.Value>, InterpreterResult>(context2, classLoader, mainMethod){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ClassLoaderReference $classLoader;
            final /* synthetic */ MethodNode $mainMethod;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InterpreterResult invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Collection<Value> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String it;
                Object object;
                VirtualMachine vm;
                block4: {
                    boolean bl;
                    String string;
                    block3: {
                        Intrinsics.checkParameterIsNotNull(args, (String)"args");
                        VirtualMachine virtualMachine = this.$context.getVm().getVirtualMachine();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"context.vm.virtualMachine");
                        vm = virtualMachine;
                        object = this.$context.getSuspendContext().getThread();
                        if (object == null || (object = object.getThreadReference()) == null) break block3;
                        string = object;
                        bl = false;
                        boolean bl2 = false;
                        it = string;
                        boolean bl3 = false;
                        object = it.isSuspended() ? string : null;
                        if (object != null) break block4;
                    }
                    string = "Can not find a thread to run evaluation on";
                    bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Object thread = object;
                JDIEval eval2 = new JDIEval(vm, this.$classLoader, (ThreadReference)thread, this.$context.getInvokePolicy());
                MethodNode methodNode = this.$mainMethod;
                Intrinsics.checkExpressionValueIsNotNull((Object)methodNode, (String)"mainMethod");
                MethodNode methodNode2 = this.$mainMethod;
                Intrinsics.checkExpressionValueIsNotNull((Object)methodNode2, (String)"mainMethod");
                Iterable iterable = args;
                MethodNode methodNode3 = methodNode2;
                MethodNode methodNode4 = methodNode;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    com.sun.jdi.Value value2 = (com.sun.jdi.Value)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Value value3 = JdiValuesKt.asValue((com.sun.jdi.Value)it2);
                    collection.add(value3);
                }
                collection = (List)destination$iv$iv;
                return InterpreterLoopKt.interpreterLoop$default(methodNode4, JdiValuesKt.makeInitialFrame(methodNode3, (List<? extends Value>)collection), eval2, null, 8, null);
            }
            {
                this.$context = executionContext;
                this.$classLoader = classLoaderReference;
                this.$mainMethod = methodNode;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T runEvaluation(ExecutionContext context2, CompiledDataDescriptor compiledData, ClassLoaderReference classLoader, Function1<? super List<? extends com.sun.jdi.Value>, ? extends T> block) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = compiledData.getClasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClassToLoad it = (ClassToLoad)element$iv$iv;
            boolean bl = false;
            if (!(!it.isMainClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassToLoad it = (ClassToLoad)element$iv;
            boolean bl = false;
            context2.findClass(it.getClassName(), classLoader);
        }
        VirtualMachine virtualMachine = context2.getVm().getVirtualMachine();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"context.vm.virtualMachine");
        return (T)KotlinEvaluatorBuilderKt.access$executeWithBreakpointsDisabled(virtualMachine, new Function0<T>(this, compiledData, context2, classLoader, block){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ CompiledDataDescriptor $compiledData;
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ClassLoaderReference $classLoader;
            final /* synthetic */ Function1 $block;

            public final T invoke() {
                for (Type parameterType : this.$compiledData.getMainMethodSignature().getParameterTypes()) {
                    this.$context.findClass(parameterType, this.$classLoader);
                }
                List args = KotlinEvaluator.access$calculateMainMethodCallArguments(this.this$0, this.$context, this.$compiledData);
                return (T)this.$block.invoke((Object)args);
            }
            {
                this.this$0 = kotlinEvaluator2;
                this.$compiledData = compiledDataDescriptor;
                this.$context = executionContext;
                this.$classLoader = classLoaderReference;
                this.$block = function1;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> calculateMainMethodCallArguments(ExecutionContext context2, CompiledDataDescriptor compiledData) {
        void $this$mapTo$iv$iv;
        List<Type> asmValueParameters = compiledData.getMainMethodSignature().getParameterTypes();
        List<CodeFragmentParameter.Dumb> valueParameters2 = compiledData.getParameters();
        boolean bl = asmValueParameters.size() == valueParameters2.size();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List args = CollectionsKt.zip((Iterable)valueParameters2, (Iterable)asmValueParameters);
        VariableFinder variableFinder = new VariableFinder(context2);
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Type asmType;
            void $dstr$parameter$asmType;
            Pair pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            CodeFragmentParameter.Dumb parameter = (CodeFragmentParameter.Dumb)$dstr$parameter$asmType.component1();
            VariableFinder.Result result2 = variableFinder.find(parameter, asmType = (Type)$dstr$parameter$asmType.component2());
            if (result2 == null) {
                String name2 = parameter.getDebugString();
                Function0<Boolean> $fun$isInsideDefaultInterfaceMethod$1 = new Function0<Boolean>(variableFinder, context2, compiledData){
                    final /* synthetic */ VariableFinder $variableFinder$inlined;
                    final /* synthetic */ ExecutionContext $context$inlined;
                    final /* synthetic */ CompiledDataDescriptor $compiledData$inlined;
                    {
                        this.$variableFinder$inlined = variableFinder;
                        this.$context$inlined = executionContext;
                        this.$compiledData$inlined = compiledDataDescriptor;
                        super(0);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean invoke() {
                        Type type2;
                        StringBuilder stringBuilder;
                        CharSequence charSequence;
                        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)this.$context$inlined.getFrameProxy());
                        Comparable<Location> comparable = location2;
                        if (location2 == null) return false;
                        Method method = SafeUtilKt.safeMethod((Location)comparable);
                        comparable = method;
                        if (method == null) return false;
                        Comparable<Location> method2 = comparable;
                        String desc2 = method2.signature();
                        String string = method2.name();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name()");
                        if (!StringsKt.endsWith$default((String)string, (String)"$default", (boolean)false, (int)2, null)) return false;
                        Iterable $this$any$iv = KotlinEvaluator.access$getDEFAULT_METHOD_MARKERS$cp();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            return false;
                        }
                        Iterator<T> iterator2 = $this$any$iv.iterator();
                        do {
                            if (!iterator2.hasNext()) return false;
                            T element$iv = iterator2.next();
                            Type it = (Type)element$iv;
                            boolean bl = false;
                            String string2 = desc2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"desc");
                            charSequence = string2;
                            stringBuilder = new StringBuilder().append('I');
                            type2 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"it");
                        } while (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)stringBuilder.append(type2.getDescriptor()).append(')').toString(), (boolean)false, (int)2, null));
                        return true;
                    }
                };
                if (compiledData.getCrossingBounds().contains(parameter)) {
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException('\'' + name2 + "' is not captured");
                    throw null;
                }
                if (parameter.getKind() == CodeFragmentParameter.Kind.FIELD_VAR) {
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException("Cannot find the backing field '" + parameter.getName() + '\'');
                    throw null;
                }
                if (parameter.getKind() == CodeFragmentParameter.Kind.ORDINARY && $fun$isInsideDefaultInterfaceMethod$1.invoke()) {
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException("Parameter evaluation is not supported for '$default' methods");
                    throw null;
                }
                ExecutionContext executionContext = context2;
                VariableFinder.Companion companion = VariableFinder.Companion;
                boolean bl7 = false;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl8 = false;
                boolean bl9 = false;
                StringBuilder $this$buildString = stringBuilder;
                boolean bl10 = false;
                $this$buildString.append("Cannot find local variable: name = '").append(name2).append("', type = ").append(asmType.getClassName());
                String string = stringBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                String string2 = string;
                throw (Throwable)companion.variableNotFound(executionContext, string2);
            }
            com.sun.jdi.Value value2 = result2.getValue();
            collection.add(value2);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Void getModifier() {
        return null;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @Nullable
    public final SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public KotlinEvaluator(@NotNull KtCodeFragment codeFragment, @Nullable SourcePosition sourcePosition) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition;
    }

    static {
        Companion = new Companion(null);
        ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.INVISIBLE_REFERENCE_DIAGNOSTICS;
        Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"Errors.INVISIBLE_REFERENCE_DIAGNOSTICS");
        IGNORED_DIAGNOSTICS = SetsKt.plus((Set)((Set)immutableSet), (Iterable)SetsKt.setOf(Errors.EXPERIMENTAL_API_USAGE_ERROR));
        DEFAULT_METHOD_MARKERS = CollectionsKt.listOf((Object[])new Type[]{AsmTypes.OBJECT_TYPE, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER});
    }

    public static final /* synthetic */ CompiledDataDescriptor access$compileCodeFragment(KotlinEvaluator $this, ExecutionContext context2, EvaluationStatus status2) {
        return $this.compileCodeFragment(context2, status2);
    }

    public static final /* synthetic */ Set access$getIGNORED_DIAGNOSTICS$cp() {
        return IGNORED_DIAGNOSTICS;
    }

    public static final /* synthetic */ List access$calculateMainMethodCallArguments(KotlinEvaluator $this, ExecutionContext context2, CompiledDataDescriptor compiledData) {
        return $this.calculateMainMethodCallArguments(context2, compiledData);
    }

    public static final /* synthetic */ List access$getDEFAULT_METHOD_MARKERS$cp() {
        return DEFAULT_METHOD_MARKERS;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFiles", "()Ljava/util/List;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea-jvm"})
    private static final class ErrorCheckingResult {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final ModuleDescriptor moduleDescriptor;
        @NotNull
        private final List<KtFile> files;

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> getFiles() {
            return this.files;
        }

        public ErrorCheckingResult(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor2, @NotNull List<? extends KtFile> files2) {
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor2, (String)"moduleDescriptor");
            Intrinsics.checkParameterIsNotNull(files2, (String)"files");
            this.bindingContext = bindingContext2;
            this.moduleDescriptor = moduleDescriptor2;
            this.files = files2;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor component2() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> component3() {
            return this.files;
        }

        @NotNull
        public final ErrorCheckingResult copy(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor2, @NotNull List<? extends KtFile> files2) {
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor2, (String)"moduleDescriptor");
            Intrinsics.checkParameterIsNotNull(files2, (String)"files");
            return new ErrorCheckingResult(bindingContext2, moduleDescriptor2, files2);
        }

        public static /* synthetic */ ErrorCheckingResult copy$default(ErrorCheckingResult errorCheckingResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext2 = errorCheckingResult.bindingContext;
            }
            if ((n & 2) != 0) {
                moduleDescriptor2 = errorCheckingResult.moduleDescriptor;
            }
            if ((n & 4) != 0) {
                list2 = errorCheckingResult.files;
            }
            return errorCheckingResult.copy(bindingContext2, moduleDescriptor2, list2);
        }

        @NotNull
        public String toString() {
            return "ErrorCheckingResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ")";
        }

        public int hashCode() {
            BindingContext bindingContext2 = this.bindingContext;
            ModuleDescriptor moduleDescriptor2 = this.moduleDescriptor;
            List<KtFile> list2 = this.files;
            return ((bindingContext2 != null ? bindingContext2.hashCode() : 0) * 31 + (moduleDescriptor2 != null ? moduleDescriptor2.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ErrorCheckingResult)) break block3;
                    ErrorCheckingResult errorCheckingResult = (ErrorCheckingResult)object;
                    if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)errorCheckingResult.bindingContext) || !Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)errorCheckingResult.moduleDescriptor) || !Intrinsics.areEqual(this.files, errorCheckingResult.files)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "()V", "DEFAULT_METHOD_MARKERS", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "IGNORED_DIAGNOSTICS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getValueIfSharedVar", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "value", "Lorg/jetbrains/eval4j/Value;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "toJdiValue", "Lcom/sun/jdi/Value;", "Lorg/jetbrains/eval4j/InterpreterResult;", "idea-jvm"})
    public static final class Companion {
        private final com.sun.jdi.Value toJdiValue(@NotNull InterpreterResult $this$toJdiValue, ExecutionContext context2) {
            InterpreterResult interpreterResult = $this$toJdiValue;
            if (!(interpreterResult instanceof ValueReturned)) {
                if (interpreterResult instanceof ExceptionThrown) {
                    if (((ExceptionThrown)$this$toJdiValue).getKind() == ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE) {
                        Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                        if (v == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                        }
                        Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(new InvocationException((ObjectReference)v));
                        throw null;
                    }
                    if (((ExceptionThrown)$this$toJdiValue).getKind() == ExceptionThrown.ExceptionKind.BROKEN_CODE) {
                        Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                        if (v == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                        }
                        throw (Throwable)v;
                    }
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(((ExceptionThrown)$this$toJdiValue).getException().toString());
                    throw null;
                }
                if (interpreterResult instanceof AbnormalTermination) {
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(((AbnormalTermination)$this$toJdiValue).getMessage());
                    throw null;
                }
                throw (Throwable)new IllegalStateException("Unknown result value produced by eval4j");
            }
            Value jdiValue = ((ValueReturned)$this$toJdiValue).getResult();
            VariableFinder.Result sharedVar = jdiValue instanceof AbstractValue ? this.getValueIfSharedVar(jdiValue, context2) : null;
            Object object = sharedVar;
            if (object == null || (object = ((VariableFinder.Result)object).getValue()) == null) {
                VirtualMachine virtualMachine = context2.getVm().getVirtualMachine();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"context.vm.virtualMachine");
                object = JdiValuesKt.asJdiValue(jdiValue, virtualMachine, jdiValue.getAsmType());
            }
            return object;
        }

        private final VariableFinder.Result getValueIfSharedVar(Value value2, ExecutionContext context2) {
            Object object = ValuesKt.obj(value2, value2.getAsmType());
            if (!(object instanceof ObjectReference)) {
                object = null;
            }
            ObjectReference objectReference = (ObjectReference)object;
            if (objectReference == null) {
                return null;
            }
            ObjectReference obj = objectReference;
            return new VariableFinder.Result(new EvaluatorValueConverter(context2).unref(obj));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

