/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeImpl;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/EvaluatorMemberScopeForMethod;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScopeImpl;", "methodDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;)V", "getContributedDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kindFilter", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "getContributedFunctions", "name", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getFunctionNames", "", "printScopeStructure", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "idea-jvm"})
final class EvaluatorMemberScopeForMethod
extends MemberScopeImpl {
    private final SimpleFunctionDescriptor methodDescriptor;

    @NotNull
    public Collection<SimpleFunctionDescriptor> getContributedFunctions(@NotNull Name name2, @NotNull LookupLocation location2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        return Intrinsics.areEqual((Object)name2, (Object)this.methodDescriptor.getName()) ? (Collection)CollectionsKt.listOf((Object)this.methodDescriptor) : (Collection)CollectionsKt.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter2, (String)"nameFilter");
        if (kindFilter.accepts(this.methodDescriptor)) {
            Name name2 = this.methodDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"methodDescriptor.name");
            if (((Boolean)nameFilter2.invoke((Object)name2)).booleanValue()) {
                collection = CollectionsKt.listOf((Object)this.methodDescriptor);
                return collection;
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    @Override
    @NotNull
    public Set<Name> getFunctionNames() {
        return SetsKt.setOf((Object)this.methodDescriptor.getName());
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        p.println(this.getClass().getSimpleName());
    }

    public EvaluatorMemberScopeForMethod(@NotNull SimpleFunctionDescriptor methodDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)methodDescriptor, (String)"methodDescriptor");
        this.methodDescriptor = methodDescriptor;
    }
}

