/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\t\u00a8\u0006\n"}, d2={"callName", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "previousCall", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "resolveType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea-jvm"})
public final class KotlinPsiUtilKt {
    @NotNull
    public static final KotlinType resolveType(@NotNull KtExpression $this$resolveType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveType, (String)"$this$resolveType");
        KotlinType kotlinType2 = ResolutionUtils.analyze($this$resolveType, BodyResolveMode.PARTIAL).getType($this$resolveType);
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        return kotlinType2;
    }

    @NotNull
    public static final String callName(@NotNull KtCallExpression $this$callName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$callName, (String)"$this$callName");
        KtExpression ktExpression = $this$callName.getCalleeExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"this.calleeExpression!!");
        String string = ktExpression.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.calleeExpression!!.text");
        return string;
    }

    @Nullable
    public static final ReceiverValue receiverValue(@NotNull KtCallExpression $this$receiverValue) {
        Intrinsics.checkParameterIsNotNull((Object)$this$receiverValue, (String)"$this$receiverValue");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$receiverValue, ResolutionUtils.analyze($this$receiverValue, BodyResolveMode.PARTIAL));
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        ReceiverValue receiverValue = resolvedCall3.getDispatchReceiver();
        if (receiverValue == null) {
            receiverValue = resolvedCall3.getExtensionReceiver();
        }
        return receiverValue;
    }

    @Nullable
    public static final KtCallExpression previousCall(@NotNull KtCallExpression $this$previousCall) {
        Intrinsics.checkParameterIsNotNull((Object)$this$previousCall, (String)"$this$previousCall");
        PsiElement psiElement2 = $this$previousCall.getParent();
        if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
            psiElement2 = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
        if (ktDotQualifiedExpression == null) {
            return null;
        }
        KtDotQualifiedExpression parent2 = ktDotQualifiedExpression;
        KtExpression receiverExpression = parent2.getReceiverExpression();
        if (receiverExpression instanceof KtCallExpression) {
            return (KtCallExpression)receiverExpression;
        }
        if (receiverExpression instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression = ((KtDotQualifiedExpression)receiverExpression).getSelectorExpression();
            if (!(ktExpression instanceof KtCallExpression)) {
                ktExpression = null;
            }
            return (KtCallExpression)ktExpression;
        }
        return null;
    }

    @Nullable
    public static final KotlinType receiverType(@NotNull KtCallExpression $this$receiverType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$receiverType, (String)"$this$receiverType");
        ReceiverValue receiverValue = KotlinPsiUtilKt.receiverValue($this$receiverType);
        return receiverValue != null ? receiverValue.getType() : null;
    }
}

