/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.editor.LtGtTypingUtils;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;

public class KotlinTypedHandler
extends TypedHandlerDelegate {
    private static final TokenSet CONTROL_FLOW_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.IF, KtNodeTypes.ELSE, KtNodeTypes.FOR, KtNodeTypes.WHILE, KtNodeTypes.TRY});
    private static final TokenSet SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER = TokenSet.create((IElementType[])new IElementType[]{KtTokens.RPAR, KtTokens.ELSE_KEYWORD, KtTokens.TRY_KEYWORD});
    private boolean kotlinLTTyped;
    private boolean isGlobalPreviousDollarInString;
    private static final Key<Integer> PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY = Key.create((String)"PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY");

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$3(0);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$3(1);
        }
        if (file2 == null) {
            KotlinTypedHandler.$$$reportNull$$$3(2);
        }
        if (fileType == null) {
            KotlinTypedHandler.$$$reportNull$$$3(3);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$2(0);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$2(1);
        }
        if (file2 == null) {
            KotlinTypedHandler.$$$reportNull$$$2(2);
        }
        if (fileType == null) {
            KotlinTypedHandler.$$$reportNull$$$2(3);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$1(0);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$1(1);
        }
        if (file2 == null) {
            KotlinTypedHandler.$$$reportNull$$$1(2);
        }
        if (fileType == null) {
            KotlinTypedHandler.$$$reportNull$$$1(3);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            KotlinTypedHandler.$$$reportNull$$$0(3);
        }
        if (!(file2 instanceof KtFile)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$0(4);
            }
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$1(4);
            }
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$2(4);
            }
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$3(4);
            }
            return result2;
        }
        switch (c) {
            case '<': {
                this.kotlinLTTyped = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.shouldAutoCloseAngleBracket(editor2.getCaretModel().getOffset(), editor2);
                KotlinTypedHandler.autoPopupParameterInfo(project, editor2);
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
                if (result3 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(5);
                }
                if (result3 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(5);
                }
                if (result3 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(5);
                }
                if (result3 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(5);
                }
                return result3;
            }
            case '>': {
                if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.handleKotlinGTInsert(editor2)) {
                    TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(6);
                    }
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$1(6);
                    }
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$2(6);
                    }
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$3(6);
                    }
                    return result4;
                }
                TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
                if (result5 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(7);
                }
                if (result5 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(7);
                }
                if (result5 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(7);
                }
                if (result5 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(7);
                }
                return result5;
            }
            case '{': {
                ASTNode nonWhitespaceSibling;
                PsiElement parent2;
                int offset2 = editor2.getCaretModel().getOffset();
                if (offset2 == 0) {
                    TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result6 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(8);
                    }
                    if (result6 == null) {
                        KotlinTypedHandler.$$$reportNull$$$1(8);
                    }
                    if (result6 == null) {
                        KotlinTypedHandler.$$$reportNull$$$2(8);
                    }
                    if (result6 == null) {
                        KotlinTypedHandler.$$$reportNull$$$3(8);
                    }
                    return result6;
                }
                HighlighterIterator iterator2 = ((EditorEx)editor2).getHighlighter().createIterator(offset2 - 1);
                while (!iterator2.atEnd() && iterator2.getTokenType() == TokenType.WHITE_SPACE) {
                    iterator2.retreat();
                }
                if (iterator2.atEnd() || !SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER.contains(iterator2.getTokenType())) {
                    AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor2, null);
                    TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result7 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(9);
                    }
                    if (result7 == null) {
                        KotlinTypedHandler.$$$reportNull$$$1(9);
                    }
                    if (result7 == null) {
                        KotlinTypedHandler.$$$reportNull$$$2(9);
                    }
                    if (result7 == null) {
                        KotlinTypedHandler.$$$reportNull$$$3(9);
                    }
                    return result7;
                }
                int tokenBeforeBraceOffset = iterator2.getStart();
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
                PsiElement leaf = file2.findElementAt(offset2);
                if (leaf != null && (parent2 = leaf.getParent()) != null && CONTROL_FLOW_EXPRESSIONS.contains(parent2.getNode().getElementType()) && (nonWhitespaceSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)leaf.getNode())) != null && nonWhitespaceSibling.getStartOffset() == tokenBeforeBraceOffset) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)"{", (boolean)false, (boolean)true);
                    KotlinTypedHandler.indentBrace(project, editor2);
                    TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.STOP;
                    if (result8 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(10);
                    }
                    if (result8 == null) {
                        KotlinTypedHandler.$$$reportNull$$$1(10);
                    }
                    if (result8 == null) {
                        KotlinTypedHandler.$$$reportNull$$$2(10);
                    }
                    if (result8 == null) {
                        KotlinTypedHandler.$$$reportNull$$$3(10);
                    }
                    return result8;
                }
                TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.CONTINUE;
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(11);
                }
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(11);
                }
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(11);
                }
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(11);
                }
                return result9;
            }
            case '.': {
                KotlinTypedHandler.autoPopupMemberLookup(project, editor2);
                TypedHandlerDelegate.Result result10 = TypedHandlerDelegate.Result.CONTINUE;
                if (result10 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(12);
                }
                if (result10 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(12);
                }
                if (result10 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(12);
                }
                if (result10 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(12);
                }
                return result10;
            }
            case '@': {
                KotlinTypedHandler.autoPopupLabelLookup(project, editor2);
                KotlinTypedHandler.autoPopupKDocTag(project, editor2);
                TypedHandlerDelegate.Result result11 = TypedHandlerDelegate.Result.CONTINUE;
                if (result11 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(13);
                }
                if (result11 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(13);
                }
                if (result11 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(13);
                }
                if (result11 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(13);
                }
                return result11;
            }
            case ':': {
                KotlinTypedHandler.autoPopupCallableReferenceLookup(project, editor2);
                TypedHandlerDelegate.Result result12 = TypedHandlerDelegate.Result.CONTINUE;
                if (result12 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(14);
                }
                if (result12 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(14);
                }
                if (result12 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(14);
                }
                if (result12 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(14);
                }
                return result12;
            }
            case '[': {
                KotlinTypedHandler.autoPopupParameterInfo(project, editor2);
                TypedHandlerDelegate.Result result13 = TypedHandlerDelegate.Result.CONTINUE;
                if (result13 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(15);
                }
                if (result13 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(15);
                }
                if (result13 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(15);
                }
                if (result13 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(15);
                }
                return result13;
            }
        }
        TypedHandlerDelegate.Result result14 = TypedHandlerDelegate.Result.CONTINUE;
        if (result14 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(16);
        }
        if (result14 == null) {
            KotlinTypedHandler.$$$reportNull$$$1(16);
        }
        if (result14 == null) {
            KotlinTypedHandler.$$$reportNull$$$2(16);
        }
        if (result14 == null) {
            KotlinTypedHandler.$$$reportNull$$$3(16);
        }
        return result14;
    }

    private static void autoPopupParameterInfo(Project project, Editor editor2) {
        int offset2 = editor2.getCaretModel().getOffset();
        if (offset2 == 0) {
            return;
        }
        HighlighterIterator iterator2 = ((EditorEx)editor2).getHighlighter().createIterator(offset2 - 1);
        IElementType tokenType = iterator2.getTokenType();
        if (KtTokens.COMMENTS.contains(tokenType) || tokenType == KtTokens.REGULAR_STRING_PART || tokenType == KtTokens.OPEN_QUOTE || tokenType == KtTokens.CHARACTER_LITERAL) {
            return;
        }
        AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor2, null);
    }

    private static void autoPopupMemberLookup(Project project, Editor editor2) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, file2 -> {
            int offset2 = editor2.getCaretModel().getOffset();
            PsiElement lastToken = file2.findElementAt(offset2 - 1);
            if (lastToken == null) {
                return false;
            }
            IElementType elementType = lastToken.getNode().getElementType();
            if (elementType == KtTokens.DOT || elementType == KtTokens.SAFE_ACCESS) {
                return true;
            }
            if (elementType == KtTokens.REGULAR_STRING_PART && lastToken.getTextRange().getStartOffset() == offset2 - 1) {
                PsiElement prevSibling2 = lastToken.getParent().getPrevSibling();
                return prevSibling2 instanceof KtSimpleNameStringTemplateEntry;
            }
            return false;
        });
    }

    private static void autoPopupKDocTag(Project project, Editor editor2) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, file2 -> {
            int offset2 = editor2.getCaretModel().getOffset();
            PsiElement lastElement = file2.findElementAt(offset2 - 1);
            if (lastElement == null) {
                return false;
            }
            return lastElement.getNode().getElementType() == KDocTokens.TEXT;
        });
    }

    private static void autoPopupLabelLookup(Project project, Editor editor2) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, file2 -> {
            int offset2 = editor2.getCaretModel().getOffset();
            CharSequence chars = editor2.getDocument().getCharsSequence();
            if (!(KotlinTypedHandler.endsWith(chars, offset2, "this@") || KotlinTypedHandler.endsWith(chars, offset2, "return@") || KotlinTypedHandler.endsWith(chars, offset2, "break@") || KotlinTypedHandler.endsWith(chars, offset2, "continue@"))) {
                return false;
            }
            PsiElement lastElement = file2.findElementAt(offset2 - 1);
            if (lastElement == null) {
                return false;
            }
            return lastElement.getNode().getElementType() == KtTokens.AT;
        });
    }

    private static void autoPopupCallableReferenceLookup(Project project, Editor editor2) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, file2 -> {
            int offset2 = editor2.getCaretModel().getOffset();
            PsiElement lastElement = file2.findElementAt(offset2 - 1);
            if (lastElement == null) {
                return false;
            }
            return lastElement.getNode().getElementType() == KtTokens.COLONCOLON;
        });
    }

    private static boolean endsWith(CharSequence chars, int offset2, String text2) {
        if (offset2 < text2.length()) {
            return false;
        }
        return chars.subSequence(offset2 - text2.length(), offset2).toString().equals(text2);
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        int offset2;
        PsiElement element3;
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$3(17);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$3(18);
        }
        if (file2 == null) {
            KotlinTypedHandler.$$$reportNull$$$3(19);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$2(17);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$2(18);
        }
        if (file2 == null) {
            KotlinTypedHandler.$$$reportNull$$$2(19);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$1(17);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$1(18);
        }
        if (file2 == null) {
            KotlinTypedHandler.$$$reportNull$$$1(19);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$0(17);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(19);
        }
        if (!(file2 instanceof KtFile)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$0(20);
            }
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$1(20);
            }
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$2(20);
            }
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$3(20);
            }
            return result2;
        }
        Integer previousDollarInStringOffset = null;
        if (this.isGlobalPreviousDollarInString) {
            this.isGlobalPreviousDollarInString = false;
            previousDollarInStringOffset = (Integer)editor2.getUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY);
        }
        editor2.putUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY, null);
        if (this.kotlinLTTyped) {
            this.kotlinLTTyped = false;
            LtGtTypingUtils.handleKotlinAutoCloseLT(editor2);
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
            if (result3 == null) {
                KotlinTypedHandler.$$$reportNull$$$0(21);
            }
            if (result3 == null) {
                KotlinTypedHandler.$$$reportNull$$$1(21);
            }
            if (result3 == null) {
                KotlinTypedHandler.$$$reportNull$$$2(21);
            }
            if (result3 == null) {
                KotlinTypedHandler.$$$reportNull$$$3(21);
            }
            return result3;
        }
        if (c == '{' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
            int offset3 = editor2.getCaretModel().getOffset();
            PsiElement previousElement2 = file2.findElementAt(offset3 - 1);
            if (previousElement2 instanceof LeafPsiElement && ((LeafPsiElement)previousElement2).getElementType() == KtTokens.LONG_TEMPLATE_ENTRY_START) {
                boolean isSimpleLongTemplateEntry;
                boolean isNextTokenIsIdentifier;
                PsiElement currentElement = file2.findElementAt(offset3);
                boolean bl = isNextTokenIsIdentifier = currentElement instanceof LeafPsiElement && ((LeafPsiElement)currentElement).getElementType() == KtTokens.IDENTIFIER;
                if (!isNextTokenIsIdentifier) {
                    editor2.getDocument().insertString(offset3, (CharSequence)"}");
                    TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(22);
                    }
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$1(22);
                    }
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$2(22);
                    }
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$3(22);
                    }
                    return result4;
                }
                PsiElement lastInLongTemplateEntry = previousElement2.getParent().getLastChild();
                boolean bl2 = isSimpleLongTemplateEntry = lastInLongTemplateEntry instanceof LeafPsiElement && ((LeafPsiElement)lastInLongTemplateEntry).getElementType() == KtTokens.LONG_TEMPLATE_ENTRY_END && lastInLongTemplateEntry.getParent().getTextLength() == currentElement.getTextLength() + "${}".length();
                if (!isSimpleLongTemplateEntry) {
                    boolean isAfterTypedDollar;
                    boolean bl3 = isAfterTypedDollar = previousDollarInStringOffset != null && previousDollarInStringOffset == offset3 - 1;
                    if (isAfterTypedDollar) {
                        editor2.getDocument().insertString(offset3, (CharSequence)"}");
                        TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.STOP;
                        if (result5 == null) {
                            KotlinTypedHandler.$$$reportNull$$$0(23);
                        }
                        if (result5 == null) {
                            KotlinTypedHandler.$$$reportNull$$$1(23);
                        }
                        if (result5 == null) {
                            KotlinTypedHandler.$$$reportNull$$$2(23);
                        }
                        if (result5 == null) {
                            KotlinTypedHandler.$$$reportNull$$$3(23);
                        }
                        return result5;
                    }
                }
            }
        } else if (c == ':') {
            if (KotlinTypedHandler.autoIndentCase(editor2, project, file2, KtClassOrObject.class) || KotlinTypedHandler.autoIndentCase(editor2, project, file2, KtOperationReferenceExpression.class)) {
                TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.STOP;
                if (result6 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(24);
                }
                if (result6 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(24);
                }
                if (result6 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(24);
                }
                if (result6 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(24);
                }
                return result6;
            }
        } else if (c == '.') {
            if (KotlinTypedHandler.autoIndentCase(editor2, project, file2, KtQualifiedExpression.class)) {
                TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.STOP;
                if (result7 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(25);
                }
                if (result7 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(25);
                }
                if (result7 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(25);
                }
                if (result7 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(25);
                }
                return result7;
            }
        } else if (c == '|') {
            if (KotlinTypedHandler.autoIndentCase(editor2, project, file2, KtOperationReferenceExpression.class)) {
                TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.STOP;
                if (result8 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(26);
                }
                if (result8 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(26);
                }
                if (result8 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(26);
                }
                if (result8 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(26);
                }
                return result8;
            }
        } else if (c == '&') {
            if (KotlinTypedHandler.autoIndentCase(editor2, project, file2, KtOperationReferenceExpression.class)) {
                TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.STOP;
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(27);
                }
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$1(27);
                }
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$2(27);
                }
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$3(27);
                }
                return result9;
            }
        } else if (c == '$' && (element3 = file2.findElementAt(offset2 = editor2.getCaretModel().getOffset())) instanceof LeafPsiElement && ((LeafPsiElement)element3).getElementType() == KtTokens.REGULAR_STRING_PART) {
            editor2.putUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY, (Object)offset2);
            this.isGlobalPreviousDollarInString = true;
        }
        TypedHandlerDelegate.Result result10 = TypedHandlerDelegate.Result.CONTINUE;
        if (result10 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(28);
        }
        if (result10 == null) {
            KotlinTypedHandler.$$$reportNull$$$1(28);
        }
        if (result10 == null) {
            KotlinTypedHandler.$$$reportNull$$$2(28);
        }
        if (result10 == null) {
            KotlinTypedHandler.$$$reportNull$$$3(28);
        }
        return result10;
    }

    private static void indentBrace(@NotNull Project project, @NotNull Editor editor2) {
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$3(29);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$3(30);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$2(29);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$2(30);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$1(29);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$1(30);
        }
        if (project == null) {
            KotlinTypedHandler.$$$reportNull$$$0(29);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(30);
        }
        int offset2 = editor2.getCaretModel().getOffset() - 1;
        Document document = editor2.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset2 < 0 || chars.charAt(offset2) != '{') {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset2 - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            boolean isBrace;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(document);
            PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null || !file2.isWritable()) {
                return;
            }
            PsiElement element3 = file2.findElementAt(offset2);
            if (element3 == null) {
                return;
            }
            EditorHighlighter highlighter = ((EditorEx)editor2).getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(offset2);
            FileType fileType = file2.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher((FileType)fileType, (HighlighterIterator)iterator2);
            boolean bl = isBrace = braceMatcher.isLBraceToken(iterator2, chars, fileType) || braceMatcher.isRBraceToken(iterator2, chars, fileType);
            if (element3.getNode() != null && isBrace) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    int newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, offset2);
                    editor2.getCaretModel().moveToOffset(newOffset + 1);
                    editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    editor2.getSelectionModel().removeSelection();
                });
            }
        }
    }

    private static boolean autoIndentCase(Editor editor2, Project project, PsiFile file2, Class<?> kclass) {
        int offset2 = editor2.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
        PsiElement currElement = file2.findElementAt(offset2 - 1);
        if (currElement != null) {
            PsiElement prevLeaf2 = PsiTreeUtil.prevLeaf((PsiElement)currElement);
            if (!(prevLeaf2 instanceof PsiWhiteSpace) || !prevLeaf2.getText().contains("\n")) {
                return false;
            }
            PsiElement parent2 = currElement.getParent();
            if (kclass.isInstance(parent2)) {
                int curElementLength = currElement.getText().length();
                if (offset2 < curElementLength) {
                    return false;
                }
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, offset2 - curElementLength);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$3(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

