/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinPredefinedCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KtCodeStyleSettingsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/ProjectCodeStyleImporter;", "", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "codeStyleStr", "", "", "predefinedCodeStyle", "Lorg/jetbrains/kotlin/idea/formatter/KotlinPredefinedCodeStyle;", "formatter"})
public final class ProjectCodeStyleImporter {
    public static final ProjectCodeStyleImporter INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean apply(@NotNull Project project, @Nullable String codeStyleStr) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = codeStyleStr;
        if (string == null) return false;
        switch (string) {
            case "obsolete": {
                INSTANCE.apply(project, KotlinObsoleteCodeStyle.Companion.getINSTANCE());
                return true;
            }
            case "official": {
                INSTANCE.apply(project, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
                return true;
            }
            default: {
                return false;
            }
        }
    }

    public final void apply(@NotNull Project project, @NotNull KotlinPredefinedCodeStyle predefinedCodeStyle) {
        CodeStyleSettings codeStyleSettings;
        CodeStyleSettingsManager settingsManager;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)predefinedCodeStyle), (String)"predefinedCodeStyle");
        CodeStyleSettingsManager codeStyleSettingsManager = settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettingsManager, (String)"settingsManager");
        CodeStyleSettings codeStyleSettings2 = codeStyleSettingsManager.getCurrentSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings2, (String)"settingsManager.currentSettings");
        CodeStyleSettings currentSettings = codeStyleSettings2;
        if (Intrinsics.areEqual((Object)predefinedCodeStyle.getCodeStyleId(), (Object)KtCodeStyleSettingsKt.kotlinCodeStyleDefaults(currentSettings))) {
            return;
        }
        if (settingsManager.USE_PER_PROJECT_SETTINGS) {
            CodeStyleSettings codeStyleSettings3 = settingsManager.getCurrentSettings().clone();
            codeStyleSettings = codeStyleSettings3;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings3, (String)"settingsManager.currentSettings.clone()");
        } else {
            codeStyleSettings = new CodeStyleSettings();
        }
        CodeStyleSettings projectSettingsUpdated = codeStyleSettings;
        settingsManager.USE_PER_PROJECT_SETTINGS = true;
        predefinedCodeStyle.apply(projectSettingsUpdated);
        settingsManager.setMainProjectCodeStyle(projectSettingsUpdated);
    }

    private ProjectCodeStyleImporter() {
    }

    static {
        ProjectCodeStyleImporter projectCodeStyleImporter;
        INSTANCE = projectCodeStyleImporter = new ProjectCodeStyleImporter();
    }
}

