/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.highlighter.AnnotationPresentationInfo;
import org.jetbrains.kotlin.idea.highlighter.ElementAnnotator$WhenMappings;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiCheckerKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroup;
import org.jetbrains.kotlin.idea.inspections.KotlinUniversalQuickFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J\u001e\u0010\u0012\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ElementAnnotator;", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "shouldSuppressUnusedParameter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/annotation/AnnotationHolder;Lkotlin/jvm/functions/Function1;)V", "registerDiagnosticAnnotations", "", "diagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "registerDiagnosticsAnnotations", "", "setUpAnnotations", "data", "Lorg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo;", "Companion", "idea-core"})
final class ElementAnnotator {
    private final PsiElement element;
    private final AnnotationHolder holder;
    private final Function1<KtParameter, Boolean> shouldSuppressUnusedParameter;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void registerDiagnosticsAnnotations(@NotNull Collection<? extends Diagnostic> diagnostics2) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(diagnostics2, (String)"diagnostics");
        Iterable $this$groupBy$iv = diagnostics2;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Diagnostic it = (Diagnostic)element$iv$iv;
            boolean bl = false;
            DiagnosticFactory<?> key$iv$iv = it.getFactory();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry group = element$iv = iterator2.next();
            boolean bl3 = false;
            this.registerDiagnosticAnnotations((List)group.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerDiagnosticAnnotations(List<? extends Diagnostic> diagnostics2) {
        AnnotationPresentationInfo annotationPresentationInfo;
        boolean bl;
        boolean $i$f$all;
        ProblemHighlightType factory2;
        Diagnostic diagnostic;
        block21: {
            void $this$filterTo$iv$iv;
            Collection collection = diagnostics2;
            boolean bl2 = false;
            boolean bl3 = !collection.isEmpty();
            bl2 = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl3) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $this$filter$iv = diagnostics2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Diagnostic it = (Diagnostic)element$iv$iv;
                boolean bl6 = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validDiagnostics = (List)destination$iv$iv;
            if (validDiagnostics.isEmpty()) {
                return;
            }
            diagnostic = (Diagnostic)CollectionsKt.first(diagnostics2);
            ProblemHighlightType problemHighlightType2 = diagnostic.getFactory();
            Intrinsics.checkExpressionValueIsNotNull(problemHighlightType2, (String)"diagnostic.factory");
            factory2 = problemHighlightType2;
            Iterable $this$all$iv = diagnostics2;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv22 : $this$all$iv) {
                    Diagnostic it = (Diagnostic)element$iv22;
                    boolean bl7 = false;
                    if (Intrinsics.areEqual((Object)it.getPsiElement(), (Object)this.element) && Intrinsics.areEqual(it.getFactory(), factory2)) continue;
                    bl = false;
                    break block21;
                }
                bl = true;
            }
        }
        boolean $this$all$iv = bl;
        $i$f$all = false;
        boolean bl8 = false;
        if (_Assertions.ENABLED && !$this$all$iv) {
            boolean element$iv22 = false;
            String element$iv22 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)element$iv22));
        }
        List<TextRange> list2 = diagnostic.getTextRanges();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"diagnostic.textRanges");
        List<TextRange> ranges2 = list2;
        switch (ElementAnnotator$WhenMappings.$EnumSwitchMapping$0[factory2.getSeverity().ordinal()]) {
            case 1: {
                ProblemHighlightType problemHighlightType3 = factory2;
                ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS;
                Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS");
                if (CollectionsKt.contains((Iterable)((Iterable)immutableSet), problemHighlightType3)) {
                    PsiElement psiElement2 = this.element;
                    if (psiElement2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
                    }
                    KtReferenceExpression referenceExpression = (KtReferenceExpression)psiElement2;
                    KtReference reference2 = ReferenceUtilKt.getMainReference(referenceExpression);
                    if (reference2 instanceof MultiRangeReference) {
                        Collection<TextRange> collection;
                        void $this$mapTo$iv$iv;
                        List list3 = ((MultiRangeReference)reference2).getRanges();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"reference.ranges");
                        Iterable $this$map$iv = list3;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            TextRange textRange = (TextRange)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl9 = false;
                            TextRange textRange2 = it.shiftRight(referenceExpression.getTextOffset());
                            collection.add(textRange2);
                        }
                        collection = (List)destination$iv$iv;
                        DefaultConstructorMarker defaultConstructorMarker2 = null;
                        int n = 10;
                        TextAttributesKey textAttributesKey = null;
                        ProblemHighlightType problemHighlightType4 = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                        String string = null;
                        List list4 = collection;
                        annotationPresentationInfo = new AnnotationPresentationInfo(list4, string, problemHighlightType4, textAttributesKey, n, defaultConstructorMarker2);
                        break;
                    }
                    annotationPresentationInfo = new AnnotationPresentationInfo(ranges2, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, null, 10, null);
                    break;
                }
                if (Intrinsics.areEqual(problemHighlightType3, Errors.ILLEGAL_ESCAPE)) {
                    annotationPresentationInfo = new AnnotationPresentationInfo(ranges2, null, null, KotlinHighlightingColors.INVALID_STRING_ESCAPE, 6, null);
                    break;
                }
                if (Intrinsics.areEqual(problemHighlightType3, Errors.REDECLARATION)) {
                    List<TextRange> list5 = diagnostic.getTextRanges();
                    Intrinsics.checkExpressionValueIsNotNull(list5, (String)"diagnostic.textRanges");
                    annotationPresentationInfo = new AnnotationPresentationInfo(CollectionsKt.listOf((Object)CollectionsKt.first(list5)), "", null, null, 12, null);
                    break;
                }
                annotationPresentationInfo = new AnnotationPresentationInfo(ranges2, null, (ProblemHighlightType)(Intrinsics.areEqual(factory2, Errors.INVISIBLE_REFERENCE) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : null), null, 10, null);
                break;
            }
            case 2: {
                ProblemHighlightType problemHighlightType5;
                if (Intrinsics.areEqual(factory2, Errors.UNUSED_PARAMETER)) {
                    PsiElement psiElement3 = this.element;
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                    }
                    if (((Boolean)this.shouldSuppressUnusedParameter.invoke((Object)((KtParameter)psiElement3))).booleanValue()) {
                        return;
                    }
                }
                Object object = Intrinsics.areEqual(problemHighlightType5 = factory2, Errors.DEPRECATION) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : (Intrinsics.areEqual(problemHighlightType5, Errors.UNUSED_ANONYMOUS_PARAMETER) ? CodeInsightColors.WEAK_WARNING_ATTRIBUTES : null);
                problemHighlightType5 = factory2;
                ImmutableSet<? extends DiagnosticFactory<?>> immutableSet = Errors.UNUSED_ELEMENT_DIAGNOSTICS;
                Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"Errors.UNUSED_ELEMENT_DIAGNOSTICS");
                problemHighlightType5 = CollectionsKt.contains((Iterable)((Iterable)immutableSet), problemHighlightType5) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (Intrinsics.areEqual((Object)problemHighlightType5, Errors.UNUSED_ANONYMOUS_PARAMETER) ? ProblemHighlightType.WEAK_WARNING : null);
                TextAttributesKey textAttributesKey = object;
                AnnotationPresentationInfo annotationPresentationInfo2 = new AnnotationPresentationInfo(ranges2, null, problemHighlightType5, textAttributesKey, 2, null);
                annotationPresentationInfo = annotationPresentationInfo2;
                break;
            }
            case 3: {
                annotationPresentationInfo = new AnnotationPresentationInfo(ranges2, null, ProblemHighlightType.INFORMATION, null, 10, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AnnotationPresentationInfo presentationInfo = annotationPresentationInfo;
        this.setUpAnnotations(diagnostics2, presentationInfo);
    }

    private final void setUpAnnotations(List<? extends Diagnostic> diagnostics2, AnnotationPresentationInfo data) {
        MultiMap multiMap;
        try {
            multiMap = KotlinPsiCheckerKt.access$createQuickFixes(diagnostics2);
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw (Throwable)e;
            }
            LOG.error((Throwable)e);
            multiMap = new MultiMap();
        }
        MultiMap fixesMap = multiMap;
        for (TextRange range : data.getRanges()) {
            for (Diagnostic diagnostic : diagnostics2) {
                Collection fixes;
                Annotation annotation2 = data.create(diagnostic, range, this.holder);
                Intrinsics.checkExpressionValueIsNotNull((Object)fixesMap.get((Object)diagnostic), (String)"fixesMap[diagnostic]");
                Iterable $this$forEach$iv = fixes;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IntentionAction it = (IntentionAction)element$iv;
                    boolean bl = false;
                    IntentionAction intentionAction = it;
                    if (intentionAction instanceof KotlinUniversalQuickFix) {
                        annotation2.registerUniversalFix(it, null, null);
                        continue;
                    }
                    if (!(intentionAction instanceof IntentionAction)) continue;
                    annotation2.registerFix(it);
                }
                if (diagnostic.getSeverity() != Severity.WARNING) continue;
                DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
                annotation2.setProblemGroup((ProblemGroup)new KotlinSuppressableWarningProblemGroup(diagnosticFactory));
                if (!fixes.isEmpty()) continue;
                DiagnosticFactory<?> diagnosticFactory2 = diagnostic.getFactory();
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory2, (String)"diagnostic.factory");
                annotation2.registerFix((IntentionAction)new EmptyIntentionAction(diagnosticFactory2.getName()));
            }
        }
    }

    public ElementAnnotator(@NotNull PsiElement element3, @NotNull AnnotationHolder holder, @NotNull Function1<? super KtParameter, Boolean> shouldSuppressUnusedParameter) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull(shouldSuppressUnusedParameter, (String)"shouldSuppressUnusedParameter");
        this.element = element3;
        this.holder = holder;
        this.shouldSuppressUnusedParameter = shouldSuppressUnusedParameter;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ElementAnnotator.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(ElementAnnotator::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ElementAnnotator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

