/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportUtils;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportWrapper;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/OutsidersPsiFileSupportUtils;", "", "()V", "getOutsiderFileOrigin", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "idea-core"})
public final class OutsidersPsiFileSupportUtils {
    public static final OutsidersPsiFileSupportUtils INSTANCE;

    @Nullable
    public final VirtualFile getOutsiderFileOrigin(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        if (!OutsidersPsiFileSupportWrapper.INSTANCE.isOutsiderFile(virtualFile2)) {
            return null;
        }
        String string = OutsidersPsiFileSupportWrapper.INSTANCE.getOriginalFilePath(virtualFile2);
        if (string == null) {
            return null;
        }
        String originalFilePath = string;
        return (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence((Object)VfsUtil.findFile((Path)Paths.get(originalFilePath, new String[0]), (boolean)true), (Function1)((Function1)new Function1<VirtualFile, VirtualFile>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final VirtualFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$project.getBaseDir()) ? null : it.getParent();
            }
            {
                this.$project = project;
                super(1);
            }
        })), (Function1)getOutsiderFileOrigin.2.INSTANCE));
    }

    private OutsidersPsiFileSupportUtils() {
    }

    static {
        OutsidersPsiFileSupportUtils outsidersPsiFileSupportUtils;
        INSTANCE = outsidersPsiFileSupportUtils = new OutsidersPsiFileSupportUtils();
    }
}

