/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import kotlin.script.experimental.dependencies.ScriptReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdater;
import org.jetbrains.kotlin.idea.highlighter.ScriptExternalHighlightingPass$WhenMappings;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\n*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\n*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "computeOffsets", "Lkotlin/Pair;", "", "position", "Lkotlin/script/experimental/dependencies/ScriptReport$Position;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "showNotification", "message", "", "coerceLineIn", "convertSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Lkotlin/script/experimental/dependencies/ScriptReport$Severity;", "offsetBy", "line", "col", "Factory", "idea-core"})
public final class ScriptExternalHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private final KtFile file;

    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkParameterIsNotNull((Object)progress2, (String)"progress");
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"document ?: return");
        Document document2 = document;
        if (!this.file.isScript()) {
            return;
        }
        Project project = this.file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        if (!ScriptDefinitionsManager.Companion.getInstance(project).isReady()) {
            this.showNotification(this.file, "Highlighting in scripts is not available until all Script Definitions are loaded");
        }
        if (!ScriptDependenciesUpdater.Companion.areDependenciesCached(this.file)) {
            Project project2 = this.file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
            ScriptDependenciesManager scriptDependenciesManager = ScriptDependenciesManager.Companion.getInstance(project2);
            VirtualFile virtualFile2 = this.file.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
            ScriptDependencies scriptDependencies2 = scriptDependenciesManager.getScriptDependencies(virtualFile2);
            if (Intrinsics.areEqual((Object)scriptDependencies2, (Object)ScriptDependencies.Companion.getEmpty())) {
                this.showNotification(this.file, "Highlighting in scripts is not available until all Script Dependencies are loaded");
            }
        }
        List list2 = (List)this.file.getVirtualFile().getUserData((Key)IdeScriptReportSink.Reports.INSTANCE);
        if (list2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"file.virtualFile.getUser\u2026rtSink.Reports) ?: return");
        List reports = list2;
        Iterable $this$mapNotNull$iv = reports;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Annotation> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Annotation annotation2;
            Pair<Integer, Integer> pair2;
            ScriptReport.Severity severity;
            String message2;
            block15: {
                block14: {
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ScriptReport $dstr$message$severity$position = (ScriptReport)element$iv$iv;
                    boolean bl2 = false;
                    message2 = $dstr$message$severity$position.component1();
                    severity = $dstr$message$severity$position.component2();
                    Pair<Integer, Integer> position2 = $dstr$message$severity$position.component3();
                    pair2 = position2;
                    if (pair2 == null) break block14;
                    Pair<Integer, Integer> pair3 = pair2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Pair<Integer, Integer> it = pair3;
                    boolean bl5 = false;
                    pair2 = this.computeOffsets(document2, (ScriptReport.Position)position2);
                    if (pair2 != null) break block15;
                }
                pair2 = TuplesKt.to((Object)0, (Object)0);
            }
            Pair<Integer, Integer> pair4 = pair2;
            int n = ((Number)pair4.component1()).intValue();
            int endOffset = ((Number)pair4.component2()).intValue();
            if (this.convertSeverity(severity) == null) {
                Annotation annotation3;
                annotation2 = annotation3 = null;
            } else {
                void startOffset;
                HighlightSeverity highlightSeverity;
                int n2;
                void var40_43;
                String string = message2;
                String string2 = message2;
                Annotation annotation4 = new Annotation((int)var40_43, n2, highlightSeverity, string2, string);
                annotation4.setFileLevelAnnotation(startOffset == endOffset);
                annotation2 = annotation4;
            }
            if (annotation2 == null) continue;
            Annotation annotation5 = annotation2;
            boolean bl = false;
            boolean bl6 = false;
            Annotation it$iv$iv = annotation5;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotations2 = (List)destination$iv$iv;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (Annotation)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            HighlightInfo highlightInfo = HighlightInfo.fromAnnotation((Annotation)it);
            collection.add(highlightInfo);
        }
        List infos2 = (List)destination$iv$iv2;
        Document document3 = this.myDocument;
        if (document3 == null) {
            Intrinsics.throwNpe();
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)document3, (int)0, (int)this.file.getTextLength(), (Collection)infos2, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private final Pair<Integer, Integer> computeOffsets(Document document, ScriptReport.Position position2) {
        int startLine = this.coerceLineIn(position2.getStartLine(), document);
        int startOffset = this.offsetBy(document, startLine, position2.getStartColumn());
        Integer n = position2.getEndLine();
        int endLine = n != null ? this.coerceLineIn(RangesKt.coerceAtLeast((int)n, (int)startLine), document) : startLine;
        Integer n2 = position2.getEndColumn();
        int endOffset = RangesKt.coerceAtLeast((int)this.offsetBy(document, endLine, n2 != null ? n2.intValue() : document.getLineEndOffset(endLine)), (int)startOffset);
        return TuplesKt.to((Object)startOffset, (Object)endOffset);
    }

    private final int coerceLineIn(int $this$coerceLineIn, Document document) {
        return RangesKt.coerceIn((int)$this$coerceLineIn, (int)0, (int)(document.getLineCount() - 1));
    }

    private final int offsetBy(@NotNull Document $this$offsetBy, int line, int col) {
        return RangesKt.coerceIn((int)($this$offsetBy.getLineStartOffset(line) + col), (int)$this$offsetBy.getLineStartOffset(line), (int)$this$offsetBy.getLineEndOffset(line));
    }

    private final HighlightSeverity convertSeverity(@NotNull ScriptReport.Severity $this$convertSeverity) {
        HighlightSeverity highlightSeverity;
        switch (ScriptExternalHighlightingPass$WhenMappings.$EnumSwitchMapping$0[$this$convertSeverity.ordinal()]) {
            case 1: {
                highlightSeverity = HighlightSeverity.ERROR;
                break;
            }
            case 2: {
                highlightSeverity = HighlightSeverity.ERROR;
                break;
            }
            case 3: {
                highlightSeverity = HighlightSeverity.WARNING;
                break;
            }
            case 4: {
                highlightSeverity = HighlightSeverity.INFORMATION;
                break;
            }
            case 5: {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) {
                    highlightSeverity = HighlightSeverity.INFORMATION;
                    break;
                }
                highlightSeverity = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return highlightSeverity;
    }

    private final void showNotification(KtFile file2, String message2) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(file2, message2){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ String $message;

            public final void run() {
                IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.$file.getProject());
                if (ideFrame != null) {
                    StatusBar statusBar = ideFrame.getStatusBar();
                    if (statusBar == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.ex.StatusBarEx");
                    }
                    StatusBarEx statusBar2 = (StatusBarEx)statusBar;
                    statusBar2.notifyProgressByBalloon(MessageType.WARNING, this.$message, null, null);
                }
            }
            {
                this.$file = ktFile2;
                this.$message = string;
            }
        });
    }

    public ScriptExternalHighlightingPass(@NotNull KtFile file2, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        super(file2.getProject(), document);
        this.file = file2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass$Factory;", "Lcom/intellij/openapi/components/ProjectComponent;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "(Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea-core"})
    public static final class Factory
    implements ProjectComponent,
    TextEditorHighlightingPassFactory {
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
            if (!(file2 instanceof KtFile)) {
                return null;
            }
            KtFile ktFile2 = (KtFile)file2;
            Document document = editor2.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
            return new ScriptExternalHighlightingPass(ktFile2, document);
        }

        public Factory(@NotNull TextEditorHighlightingPassRegistrar registrar) {
            Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 1, false, false);
        }
    }
}

