/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.TestUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinThrowableNotThrownInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isUsed", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea"})
public final class KotlinThrowableNotThrownInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor((Function1<? super KtCallExpression, Unit>)((Function1)new Function1<KtCallExpression, Unit>(this, holder){
            final /* synthetic */ KotlinThrowableNotThrownInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtCallExpression callExpression2) {
                Intrinsics.checkParameterIsNotNull((Object)callExpression2, (String)"callExpression");
                KtExpression ktExpression = callExpression2.getCalleeExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"callExpression.calleeExpression ?: return");
                KtExpression calleeExpression2 = ktExpression;
                String string = calleeExpression2.getText();
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                String string2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                if (!(StringsKt.contains$default((CharSequence)string2, (CharSequence)"Exception", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"Error", (boolean)false, (int)2, null))) {
                    return;
                }
                if (TestUtils.isInTestSourceContent((PsiElement)((PsiElement)callExpression2))) {
                    return;
                }
                ResolvedCall<D> resolvedCall2 = ResolutionUtils.resolveToCall$default(callExpression2, null, 1, null);
                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                    return;
                }
                ResolvedCall<D> resultingDescriptor = resolvedCall2;
                KotlinType kotlinType2 = resultingDescriptor.getReturnType();
                if (kotlinType2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"resultingDescriptor.returnType ?: return");
                KotlinType type2 = kotlinType2;
                if (TypeUtilsKt.isNothing(type2) || KotlinTypeKt.isNullable(type2)) {
                    return;
                }
                ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
                if (classDescriptor2 == null) {
                    return;
                }
                ClassDescriptor classDescriptor3 = classDescriptor2;
                ClassDescriptor classDescriptor4 = DefaultBuiltIns.Companion.getInstance().getThrowable();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor4, (String)"DefaultBuiltIns.Instance.throwable");
                if (!DescriptorUtilsKt.isSubclassOf(classDescriptor3, classDescriptor4)) {
                    return;
                }
                if (KotlinThrowableNotThrownInspection.access$isUsed(this.this$0, callExpression2)) {
                    return;
                }
                String description2 = resultingDescriptor instanceof ConstructorDescriptor ? "Throwable instance '" + calleeExpression2.getText() + "' is not thrown" : "Result of '" + calleeExpression2.getText() + "' call is not thrown";
                this.$holder.registerProblem((PsiElement)calleeExpression2, description2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
            {
                this.this$0 = kotlinThrowableNotThrownInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUsed(@NotNull KtExpression $this$isUsed) {
        if (!BindingContextUtilsKt.isUsedAsExpression($this$isUsed, ResolutionUtils.analyze($this$isUsed, BodyResolveMode.PARTIAL_WITH_CFA))) {
            return false;
        }
        Object t = PsiUtilsKt.getParentOfTypes((PsiElement)$this$isUsed, true, KtThrowExpression.class, KtReturnExpression.class, KtProperty.class);
        if (!(t instanceof KtProperty)) {
            t = null;
        }
        KtProperty ktProperty = (KtProperty)t;
        if (ktProperty == null) return true;
        KtProperty property2 = ktProperty;
        if (!property2.isLocal()) return true;
        Query query = ReferencesSearch.search((PsiElement)property2);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(property)");
        if (!CollectionsKt.any((Iterable)((Iterable)query))) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isUsed(KotlinThrowableNotThrownInspection $this, KtExpression $this$access_u24isUsed) {
        return $this.isUsed($this$access_u24isUsed);
    }
}

