/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.LeakingThisDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\b*\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LeakingThisInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "hasOverriddenMember", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "Companion", "idea"})
public final class LeakingThisInspection
extends AbstractKotlinInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return VisitorWrappersKt.classVisitor((Function1<? super KtClass, Unit>)((Function1)new Function1<KtClass, Unit>(this, holder){
            final /* synthetic */ LeakingThisInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtClass klass2) {
                Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
                BindingContext context2 = ResolutionUtils.analyzeWithContent(klass2);
                ImmutableMap<K, V> immutableMap = context2.getSliceContents(BindingContext.LEAKING_THIS);
                Intrinsics.checkExpressionValueIsNotNull(immutableMap, (String)"context.getSliceContents(LEAKING_THIS)");
                ImmutableMap<K, V> leakingThese = immutableMap;
                Map map2 = (Map)leakingThese;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    IntentionWrapper[] intentionWrapperArray;
                    void thisCollection$iv;
                    void $this$toTypedArray$iv;
                    IntentionWrapper intentionWrapper;
                    CallableMemberDescriptor memberDescriptorToFix;
                    String string;
                    boolean $i$f$none2;
                    KtEnumEntry[] enumEntries;
                    Map.Entry<K, V> entry;
                    Map.Entry<K, V> entry2 = entry = iterator2.next();
                    boolean bl2 = false;
                    KtExpression expression2 = (KtExpression)entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    KtEnumEntry[] leakingThisDescriptor = (KtEnumEntry[])entry2.getValue();
                    if (Intrinsics.areEqual((Object)leakingThisDescriptor.getClassOrObject(), (Object)klass2) ^ true) continue;
                    KtEnumEntry[] ktEnumEntryArray = leakingThisDescriptor;
                    if (ktEnumEntryArray instanceof LeakingThisDescriptor.NonFinalClass) {
                        if (!(expression2 instanceof KtThisExpression)) continue;
                        PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression2;
                        boolean $i$f$getStrictParentOfType = false;
                        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassLiteralExpression.class, (boolean)true) != null) continue;
                        if (klass2.isEnum()) {
                            boolean bl3;
                            block17: {
                                KtEnumEntry[] ktEnumEntryArray2 = klass2.getBody();
                                if (ktEnumEntryArray2 == null) continue;
                                PsiElement $this$getChildrenOfType$iv = (PsiElement)ktEnumEntryArray2;
                                boolean $i$f$getChildrenOfType = false;
                                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtEnumEntry.class);
                                if (psiElementArray == null) {
                                    psiElementArray = new KtEnumEntry[]{};
                                }
                                if ((ktEnumEntryArray2 = (KtEnumEntry[])psiElementArray) == null) {
                                    continue;
                                }
                                KtEnumEntry[] $this$none$iv = enumEntries = ktEnumEntryArray2;
                                $i$f$none2 = false;
                                KtEnumEntry[] ktEnumEntryArray3 = $this$none$iv;
                                int n = ktEnumEntryArray3.length;
                                for (int j = 0; j < n; ++j) {
                                    KtEnumEntry element$iv;
                                    KtEnumEntry it = element$iv = ktEnumEntryArray3[j];
                                    boolean bl4 = false;
                                    if (!LeakingThisInspection.access$hasOverriddenMember(this.this$0, it)) continue;
                                    bl3 = false;
                                    break block17;
                                }
                                bl3 = true;
                            }
                            if (bl3) continue;
                            string = "Leaking 'this' in constructor of enum class " + ((LeakingThisDescriptor.NonFinalClass)leakingThisDescriptor).getKlass().getName() + " (with overridable members)";
                        } else {
                            string = "Leaking 'this' in constructor of non-final class " + ((LeakingThisDescriptor.NonFinalClass)leakingThisDescriptor).getKlass().getName();
                        }
                    } else if (ktEnumEntryArray instanceof LeakingThisDescriptor.NonFinalProperty) {
                        string = "Accessing non-final property " + ((LeakingThisDescriptor.NonFinalProperty)leakingThisDescriptor).getProperty().getName() + " in constructor";
                    } else {
                        if (!(ktEnumEntryArray instanceof LeakingThisDescriptor.NonFinalFunction)) continue;
                        string = "Calling non-final function " + ((LeakingThisDescriptor.NonFinalFunction)leakingThisDescriptor).getFunction().getName() + " in constructor";
                    }
                    String description2 = string;
                    enumEntries = leakingThisDescriptor;
                    CallableMemberDescriptor callableMemberDescriptor = enumEntries instanceof LeakingThisDescriptor.NonFinalProperty ? (CallableMemberDescriptor)((LeakingThisDescriptor.NonFinalProperty)leakingThisDescriptor).getProperty() : (memberDescriptorToFix = enumEntries instanceof LeakingThisDescriptor.NonFinalFunction ? (CallableMemberDescriptor)((LeakingThisDescriptor.NonFinalFunction)leakingThisDescriptor).getFunction() : null);
                    if (memberDescriptorToFix != null) {
                        CallableMemberDescriptor $this$none$iv;
                        $i$f$none2 = false;
                        boolean bl5 = false;
                        CallableMemberDescriptor it = $this$none$iv;
                        boolean bl6 = false;
                        if (it.getModality() == Modality.OPEN) {
                            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(it);
                            if (!(psiElement2 instanceof KtDeclaration)) {
                                psiElement2 = null;
                            }
                            KtDeclaration modifierListOwner = (KtDeclaration)psiElement2;
                            intentionWrapper = org.jetbrains.kotlin.idea.inspections.LeakingThisInspection$Companion.access$createMakeFinalFix(LeakingThisInspection.Companion, modifierListOwner);
                        } else {
                            intentionWrapper = null;
                        }
                    } else {
                        intentionWrapper = null;
                    }
                    IntentionWrapper memberFix = intentionWrapper;
                    IntentionWrapper classFix = klass2.hasModifier(KtTokens.OPEN_KEYWORD) ? org.jetbrains.kotlin.idea.inspections.LeakingThisInspection$Companion.access$createMakeFinalFix(LeakingThisInspection.Companion, klass2) : null;
                    Object $i$f$none2 = leakingThisDescriptor;
                    ProblemHighlightType problemHighlightType2 = $i$f$none2 instanceof LeakingThisDescriptor.NonFinalProperty || $i$f$none2 instanceof LeakingThisDescriptor.NonFinalFunction ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING;
                    $i$f$none2 = ArraysKt.filterNotNull((Object[])new IntentionWrapper[]{memberFix, classFix});
                    ProblemHighlightType problemHighlightType3 = problemHighlightType2;
                    String string2 = description2;
                    PsiElement psiElement3 = (PsiElement)expression2;
                    ProblemsHolder problemsHolder = this.$holder;
                    boolean $i$f$toTypedArray = false;
                    if ($this$toTypedArray$iv == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    if (thisCollection$iv.toArray(new IntentionWrapper[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])intentionWrapperArray;
                    problemsHolder.registerProblem(psiElement3, string2, problemHighlightType3, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
            {
                this.this$0 = leakingThisInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasOverriddenMember(@NotNull KtEnumEntry $this$hasOverriddenMember) {
        KtModifierListOwner[] ktModifierListOwnerArray = $this$hasOverriddenMember.getBody();
        KtModifierListOwner[] ktModifierListOwnerArray2 = ktModifierListOwnerArray;
        if (ktModifierListOwnerArray == null) return false;
        PsiElement $this$getChildrenOfType$iv = (PsiElement)ktModifierListOwnerArray2;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtModifierListOwner.class);
        if (psiElementArray == null) {
            psiElementArray = new KtModifierListOwner[]{};
        }
        KtModifierListOwner[] ktModifierListOwnerArray3 = (KtModifierListOwner[])psiElementArray;
        ktModifierListOwnerArray2 = ktModifierListOwnerArray3;
        if (ktModifierListOwnerArray3 == null) return false;
        KtModifierListOwner[] $this$any$iv = ktModifierListOwnerArray2;
        boolean $i$f$any = false;
        KtModifierListOwner[] ktModifierListOwnerArray4 = $this$any$iv;
        int n = ktModifierListOwnerArray4.length;
        int n2 = 0;
        while (n2 < n) {
            KtModifierListOwner element$iv;
            KtModifierListOwner it = element$iv = ktModifierListOwnerArray4[n2];
            boolean bl = false;
            if (it.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$hasOverriddenMember(LeakingThisInspection $this, KtEnumEntry $this$access_u24hasOverriddenMember) {
        return $this.hasOverriddenMember($this$access_u24hasOverriddenMember);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LeakingThisInspection$Companion;", "", "()V", "createMakeFinalFix", "Lcom/intellij/codeInspection/IntentionWrapper;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
    public static final class Companion {
        private final IntentionWrapper createMakeFinalFix(KtDeclaration declaration2) {
            if (declaration2 == null) {
                return null;
            }
            SearchScope searchScope2 = declaration2.getUseScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"declaration.useScope");
            SearchScope useScope2 = searchScope2;
            if (DefinitionsScopedSearch.search((PsiElement)declaration2, (SearchScope)useScope2).findFirst() != null) {
                return null;
            }
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(declaration2);
            if (!(ktClassOrObject instanceof KtClass)) {
                ktClassOrObject = null;
            }
            KtClass ktClass2 = (KtClass)ktClassOrObject;
            if (ktClass2 != null) {
                if (ktClass2.isInterface()) {
                    return null;
                }
            }
            KtModifierListOwner ktModifierListOwner = declaration2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.FINAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.FINAL_KEYWORD");
            return new IntentionWrapper((IntentionAction)new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken), declaration2.getContainingFile());
        }

        private Companion() {
        }

        public static final /* synthetic */ IntentionWrapper access$createMakeFinalFix(Companion $this, KtDeclaration declaration2) {
            return $this.createMakeFinalFix(declaration2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

