/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.regexp.RegExpFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.inspections.NamingRule;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%BN\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0018\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "", "entityName", "", "defaultNamePattern", "setNamePatternCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "", "rules", "", "Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;)V", "getDefaultNamePattern", "()Ljava/lang/String;", "namePattern", "getNamePattern", "setNamePattern", "(Ljava/lang/String;)V", "nameRegex", "Lkotlin/text/Regex;", "getNameRegex", "()Lkotlin/text/Regex;", "setNameRegex", "(Lkotlin/text/Regex;)V", "[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "createOptionsPanel", "Ljavax/swing/JPanel;", "getDefaultErrorMessage", "getNameMismatchMessage", "verifyName", "element", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "NamingConventionOptionsPanel", "idea"})
public final class NamingConventionInspectionSettings {
    @Nullable
    private Regex nameRegex;
    @NotNull
    private String namePattern;
    private final String entityName;
    @NotNull
    private final String defaultNamePattern;
    private final Function1<String, Unit> setNamePatternCallback;
    private final NamingRule[] rules;

    @Nullable
    public final Regex getNameRegex() {
        return this.nameRegex;
    }

    public final void setNameRegex(@Nullable Regex regex) {
        this.nameRegex = regex;
    }

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String value2) {
        NamingConventionInspectionSettings namingConventionInspectionSettings;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.namePattern = value2;
        this.setNamePatternCallback.invoke((Object)value2);
        NamingConventionInspectionSettings namingConventionInspectionSettings2 = this;
        try {
            string = value2;
            NamingConventionInspectionSettings namingConventionInspectionSettings3 = namingConventionInspectionSettings2;
            boolean bl = false;
            Regex regex = new Regex(string);
            namingConventionInspectionSettings = namingConventionInspectionSettings3;
            string = regex;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            namingConventionInspectionSettings = namingConventionInspectionSettings2;
            string = null;
        }
        namingConventionInspectionSettings.nameRegex = string;
    }

    public final void verifyName(@NotNull PsiNameIdentifierOwner element3, @NotNull ProblemsHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        String name2 = element3.getName();
        PsiElement nameIdentifier = element3.getNameIdentifier();
        if (name2 != null && nameIdentifier != null) {
            Regex regex = this.nameRegex;
            if (regex != null) {
                if (!regex.matches((CharSequence)name2)) {
                    String message2 = this.getNameMismatchMessage(name2);
                    PsiElement psiElement2 = element3.getNameIdentifier();
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    holder.registerProblem(psiElement2, this.entityName + " name <code>#ref</code> " + message2 + " #loc", new LocalQuickFix[]{new RenameIdentifierFix()});
                }
            }
        }
    }

    @NotNull
    public final String getNameMismatchMessage(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (Intrinsics.areEqual((Object)this.namePattern, (Object)this.defaultNamePattern) ^ true) {
            return this.getDefaultErrorMessage();
        }
        String string = NamingConventionInspectionsKt.access$findRuleMessage(name2, this.rules);
        if (string == null) {
            string = this.getDefaultErrorMessage();
        }
        return string;
    }

    @NotNull
    public final String getDefaultErrorMessage() {
        return "doesn't match regex '" + this.namePattern + '\'';
    }

    @NotNull
    public final JPanel createOptionsPanel() {
        return new NamingConventionOptionsPanel(this);
    }

    @NotNull
    public final String getDefaultNamePattern() {
        return this.defaultNamePattern;
    }

    public NamingConventionInspectionSettings(@NotNull String entityName, @Language(value="RegExp") @NotNull String defaultNamePattern, @NotNull Function1<? super String, Unit> setNamePatternCallback, NamingRule ... rules) {
        Regex regex;
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        Intrinsics.checkParameterIsNotNull((Object)defaultNamePattern, (String)"defaultNamePattern");
        Intrinsics.checkParameterIsNotNull(setNamePatternCallback, (String)"setNamePatternCallback");
        Intrinsics.checkParameterIsNotNull((Object)rules, (String)"rules");
        this.entityName = entityName;
        this.defaultNamePattern = defaultNamePattern;
        this.setNamePatternCallback = setNamePatternCallback;
        this.rules = rules;
        String string = this.defaultNamePattern;
        NamingConventionInspectionSettings namingConventionInspectionSettings = this;
        boolean bl = false;
        namingConventionInspectionSettings.nameRegex = regex = new Regex(string);
        this.namePattern = this.defaultNamePattern;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings$NamingConventionOptionsPanel;", "Ljavax/swing/JPanel;", "settings", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "(Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;)V", "idea"})
    private static final class NamingConventionOptionsPanel
    extends JPanel {
        public NamingConventionOptionsPanel(final @NotNull NamingConventionInspectionSettings settings2) {
            Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
            this.setLayout(new BorderLayout());
            EditorTextField editorTextField = new EditorTextField(settings2.getNamePattern(), null, (FileType)RegExpFileType.INSTANCE);
            boolean bl = false;
            boolean bl2 = false;
            EditorTextField $this$apply = editorTextField;
            boolean bl3 = false;
            $this$apply.setOneLineMode(true);
            final EditorTextField regexField = editorTextField;
            regexField.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    String string = regexField.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"regexField.text");
                    settings2.setNamePattern(string);
                }
            });
            LabeledComponent labeledComponent = LabeledComponent.create((JComponent)((JComponent)regexField), (String)"Pattern:", (String)"West");
            Intrinsics.checkExpressionValueIsNotNull((Object)labeledComponent, (String)"LabeledComponent.create(\u2026ern:\", BorderLayout.WEST)");
            LabeledComponent labeledComponent2 = labeledComponent;
            this.add((Component)labeledComponent2, "North");
        }
    }
}

