/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.RedundantUnitExpressionInspectionKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"expectedReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isRedundantUnit", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "isUnitLiteral", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea"})
public final class RedundantUnitExpressionInspectionKt {
    /*
     * WARNING - void declaration
     */
    private static final boolean isRedundantUnit(@NotNull KtReferenceExpression $this$isRedundantUnit) {
        if (!RedundantUnitExpressionInspectionKt.isUnitLiteral($this$isRedundantUnit)) {
            return false;
        }
        PsiElement psiElement2 = $this$isRedundantUnit.getParent();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement parent2 = psiElement2;
        if (parent2 instanceof KtReturnExpression) {
            KotlinType kotlinType2 = RedundantUnitExpressionInspectionKt.expectedReturnType((KtReturnExpression)parent2);
            if (kotlinType2 == null) {
                return false;
            }
            KotlinType expectedReturnType = kotlinType2;
            return Intrinsics.areEqual((Object)DescriptorUtilsKt.getNameIfStandardType(expectedReturnType), (Object)KotlinBuiltIns.FQ_NAMES.any.shortName()) ^ true && !expectedReturnType.isMarkedNullable();
        }
        if (parent2 instanceof KtBlockExpression) {
            void $this$getParentOfType$iv;
            PsiElement expectedReturnType = parent2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtFunctionLiteral.class, (boolean)strict$iv) != null) {
                return false;
            }
            if (Intrinsics.areEqual((Object)$this$isRedundantUnit, (Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)parent2))) {
                KotlinType prevType;
                KtExpression ktExpression = CommonUtilsKt.previousStatement($this$isRedundantUnit);
                if (ktExpression == null) {
                    return true;
                }
                KtExpression prev2 = ktExpression;
                if (RedundantUnitExpressionInspectionKt.isUnitLiteral(prev2)) {
                    return true;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = ResolutionUtils.resolveToCall(prev2, BodyResolveMode.FULL);
                KotlinType kotlinType3 = resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? resolvedCall2.getReturnType() : (prevType = null);
                if (prevType != null) {
                    return TypeUtilsKt.isUnit(prevType);
                }
                if (!(prev2 instanceof KtDeclaration)) {
                    return false;
                }
                if (!(prev2 instanceof KtFunction)) {
                    return true;
                }
                return PsiUtilsKt.getParentOfTypesAndPredicate(parent2, true, new Class[]{KtIfExpression.class, KtWhenExpression.class}, isRedundantUnit.1.INSTANCE) == null;
            }
            return true;
        }
        return false;
    }

    private static final boolean isUnitLiteral(@NotNull KtExpression $this$isUnitLiteral) {
        Name name2 = KotlinBuiltIns.FQ_NAMES.unit.shortName();
        KtExpression ktExpression = $this$isUnitLiteral;
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        return Intrinsics.areEqual((Object)name2, (Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedNameAsName() : null));
    }

    private static final KotlinType expectedReturnType(@NotNull KtReturnExpression $this$expectedReturnType) {
        KtFunctionLiteral functionLiteral;
        FunctionDescriptor functionDescriptor2 = BindingContextUtilsKt.getTargetFunctionDescriptor($this$expectedReturnType, ResolutionUtils.analyze$default($this$expectedReturnType, null, 1, null));
        if (functionDescriptor2 == null) {
            return null;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor3);
        if (!(psiElement2 instanceof KtFunctionLiteral)) {
            psiElement2 = null;
        }
        if ((functionLiteral = (KtFunctionLiteral)psiElement2) != null) {
            PsiElement $this$getStrictParentOfType$iv = functionLiteral;
            boolean $i$f$getStrictParentOfType = false;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(callExpression2, null, 1, null);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            PsiElement $this$getStrictParentOfType$iv2 = functionLiteral;
            boolean $i$f$getStrictParentOfType2 = false;
            KtValueArgument ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtValueArgument.class, (boolean)true);
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument valueArgument = ktValueArgument;
            ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(valueArgument);
            if (!(argumentMapping instanceof ArgumentMatch)) {
                argumentMapping = null;
            }
            ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
            if (argumentMatch == null) {
                return null;
            }
            ArgumentMatch mapping2 = argumentMatch;
            Object object = mapping2.getValueParameter().getReturnType();
            return object != null && (object = ((KotlinType)object).getArguments()) != null && (object = (TypeProjection)CollectionsKt.lastOrNull((List)object)) != null ? object.getType() : null;
        }
        return functionDescriptor3.getReturnType();
    }

    public static final /* synthetic */ boolean access$isRedundantUnit(KtReferenceExpression $this$access_u24isRedundantUnit) {
        return RedundantUnitExpressionInspectionKt.isRedundantUnit($this$access_u24isRedundantUnit);
    }
}

