/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameQuickFix;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a&\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002\u001aT\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u0005*\u0002H\u00102\u0019\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u0002H\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u0012\u00a2\u0006\u0002\b\u00132\u0019\u0010\u0014\u001a\u0015\u0012\u0004\u0012\u0002H\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u0012\u00a2\u0006\u0002\b\u0013H\u0082\u0010\u00a2\u0006\u0002\u0010\u0015\u001a\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0082\u0010\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002\u00a8\u0006\u001a"}, d2={"reportProblem", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "applicableExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "originalExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "oldContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "importableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "firstApplicableExpression", "T", "validator", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "generator", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/psi/KtElement;", "firstExpressionWithoutReceiver", "isApplicableReceiver", "", "context", "idea"})
public final class RemoveRedundantQualifierNameInspectionKt {
    private static final KtDotQualifiedExpression firstExpressionWithoutReceiver(@NotNull KtDotQualifiedExpression $this$firstExpressionWithoutReceiver) {
        KtDotQualifiedExpression ktDotQualifiedExpression;
        block3: {
            KtExpression ktExpression;
            do {
                PsiElement psiElement2;
                Object object;
                if (!(((object = KtPsiUtilKt.getQualifiedElementSelector($this$firstExpressionWithoutReceiver)) != null && (object = ReferenceUtilKt.getMainReference((KtElement)object)) != null ? object.resolve() : (psiElement2 = null)) instanceof KtCallableDeclaration)) {
                    psiElement2 = null;
                }
                KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement2;
                if ((ktCallableDeclaration != null ? ktCallableDeclaration.getReceiverTypeReference() : null) == null) {
                    ktDotQualifiedExpression = $this$firstExpressionWithoutReceiver;
                    break block3;
                }
                ktExpression = $this$firstExpressionWithoutReceiver.getReceiverExpression();
                if (ktExpression instanceof KtDotQualifiedExpression) continue;
                ktExpression = null;
            } while ((KtDotQualifiedExpression)ktExpression != null);
            ktDotQualifiedExpression = null;
        }
        return ktDotQualifiedExpression;
    }

    private static final <T extends KtElement> T firstApplicableExpression(@NotNull T $this$firstApplicableExpression, Function1<? super T, ? extends T> validator2, Function1<? super T, ? extends T> generator) {
        KtElement ktElement;
        while ((ktElement = (KtElement)validator2.invoke($this$firstApplicableExpression)) == null) {
            if ((KtElement)generator.invoke($this$firstApplicableExpression) != null) continue;
            ktElement = null;
            break;
        }
        return (T)ktElement;
    }

    private static final KtDotQualifiedExpression applicableExpression(@NotNull KtDotQualifiedExpression $this$applicableExpression, KtExpression originalExpression, BindingContext oldContext, FqName importableFqName) {
        if (!RemoveRedundantQualifierNameInspectionKt.isApplicableReceiver($this$applicableExpression.getReceiverExpression(), oldContext) || !ShortenReferences.Companion.canBePossibleToDropReceiver($this$applicableExpression, oldContext)) {
            return null;
        }
        String string = originalExpression.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"originalExpression.text");
        String string2 = string;
        PsiElement psiElement2 = $this$applicableExpression.getLastChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"lastChild");
        int n = PsiUtilsKt.getStartOffset(psiElement2) - PsiUtilsKt.getStartOffset((PsiElement)originalExpression);
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String expressionText2 = string4;
        KtExpression newExpression2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)originalExpression, false, 2, null).createExpression(expressionText2);
        BindingContext newContext = AnalyzerUtilKt.analyzeAsReplacement$default(newExpression2, originalExpression, oldContext, null, null, null, 28, null);
        Object object = KtPsiUtilKt.getQualifiedElementSelector(newExpression2);
        if (object == null || (object = CallUtilKt.getResolvedCall((KtElement)object, newContext)) == null || (object = object.getResultingDescriptor()) == null) {
            return null;
        }
        Object newDescriptor2 = object;
        KtDotQualifiedExpression ktDotQualifiedExpression = $this$applicableExpression;
        boolean bl2 = false;
        boolean bl3 = false;
        KtDotQualifiedExpression it = ktDotQualifiedExpression;
        boolean bl4 = false;
        return Intrinsics.areEqual((Object)importableFqName, (Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)newDescriptor2)) ? ktDotQualifiedExpression : null;
    }

    private static final boolean isApplicableReceiver(@NotNull KtExpression $this$isApplicableReceiver, BindingContext context2) {
        if ($this$isApplicableReceiver instanceof KtInstanceExpressionWithLabel) {
            return false;
        }
        KtElement reference2 = KtPsiUtilKt.getQualifiedElementSelector($this$isApplicableReceiver);
        Object object = reference2;
        if (object == null || (object = ReferenceUtilKt.getMainReference((KtElement)object)) == null || (object = object.resolveToDescriptors(context2)) == null || (object = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)((Iterable)object))) == null) {
            return false;
        }
        Object descriptor2 = object;
        return !DescriptorUtilsKt.isCompanionObject((DeclarationDescriptor)descriptor2) ? true : Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)reference2.getText()) ^ true;
    }

    private static final KtUserType applicableExpression(@NotNull KtUserType $this$applicableExpression) {
        if (!($this$applicableExpression.getFirstChild() instanceof KtUserType)) {
            return null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = $this$applicableExpression.getReferenceExpression();
        if (!(ktSimpleNameExpression instanceof KtNameReferenceExpression)) {
            ktSimpleNameExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktSimpleNameExpression;
        if (ktNameReferenceExpression == null) {
            return null;
        }
        KtNameReferenceExpression referenceExpression = ktNameReferenceExpression;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors(referenceExpression));
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor originalDescriptor = declarationDescriptor;
        Object object = ImportsUtils.getImportableFqName(originalDescriptor);
        if (object == null || (object = ((FqName)object).shortName()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"originalDescriptor.impor\u2026hortName() ?: return null");
        Object shortName = object;
        LexicalScope scope2 = ScopeUtils.getResolutionScope(referenceExpression);
        DescriptorWithDeprecation<ClassifierDescriptor> descriptorWithDeprecation = ScopeUtilsKt.findFirstClassifierWithDeprecationStatus(scope2, (Name)shortName, NoLookupLocation.FROM_IDE);
        if (descriptorWithDeprecation == null || (descriptorWithDeprecation = descriptorWithDeprecation.getDescriptor()) == null) {
            return null;
        }
        DescriptorWithDeprecation<ClassifierDescriptor> descriptor2 = descriptorWithDeprecation;
        return Intrinsics.areEqual((Object)descriptor2, (Object)originalDescriptor) ? $this$applicableExpression : null;
    }

    private static final void reportProblem(ProblemsHolder holder, KtElement element3) {
        PsiElement firstChild = element3.getFirstChild();
        PsiElement psiElement2 = (PsiElement)element3;
        PsiElement psiElement3 = firstChild;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"firstChild");
        holder.registerProblem(psiElement2, "Redundant qualifier name", ProblemHighlightType.LIKE_UNUSED_SYMBOL, TextRange.from((int)psiElement3.getStartOffsetInParent(), (int)(firstChild.getTextLength() + 1)), new LocalQuickFix[]{new RemoveRedundantQualifierNameQuickFix()});
    }

    public static final /* synthetic */ KtDotQualifiedExpression access$firstExpressionWithoutReceiver(KtDotQualifiedExpression $this$access_u24firstExpressionWithoutReceiver) {
        return RemoveRedundantQualifierNameInspectionKt.firstExpressionWithoutReceiver($this$access_u24firstExpressionWithoutReceiver);
    }

    public static final /* synthetic */ KtElement access$firstApplicableExpression(KtElement $this$access_u24firstApplicableExpression, Function1 validator2, Function1 generator) {
        return RemoveRedundantQualifierNameInspectionKt.firstApplicableExpression($this$access_u24firstApplicableExpression, validator2, generator);
    }

    public static final /* synthetic */ KtDotQualifiedExpression access$applicableExpression(KtDotQualifiedExpression $this$access_u24applicableExpression, KtExpression originalExpression, BindingContext oldContext, FqName importableFqName) {
        return RemoveRedundantQualifierNameInspectionKt.applicableExpression($this$access_u24applicableExpression, originalExpression, oldContext, importableFqName);
    }

    public static final /* synthetic */ void access$reportProblem(ProblemsHolder holder, KtElement element3) {
        RemoveRedundantQualifierNameInspectionKt.reportProblem(holder, element3);
    }

    public static final /* synthetic */ KtUserType access$applicableExpression(KtUserType $this$access_u24applicableExpression) {
        return RemoveRedundantQualifierNameInspectionKt.applicableExpression($this$access_u24applicableExpression);
    }
}

