/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.RedundantWithInspectionKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantWithFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
final class RemoveRedundantWithFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return "Remove redundant 'with' call";
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        block7: {
            KtBlockExpression ktBlockExpression;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
            PsiElement psiElement3 = psiElement2.getParent();
            if (!(psiElement3 instanceof KtCallExpression)) {
                psiElement3 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement3;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            List<KtValueArgument> list2 = callExpression2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callExpression.valueArguments");
            KtElement ktElement = (KtValueArgument)CollectionsKt.getOrNull(list2, (int)1);
            if (ktElement == null || (ktElement = RedundantWithInspectionKt.access$lambdaExpression((KtValueArgument)ktElement)) == null || (ktElement = ((KtLambdaExpression)ktElement).getBodyExpression()) == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"callExpression.valueArgu\u2026.bodyExpression ?: return");
            KtElement lambdaBody = ktElement;
            PsiElement $this$replaced$iv = (PsiElement)callExpression2;
            boolean $i$f$replaced = false;
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)lambdaBody);
            PsiElement psiElement4 = result$iv;
            if (!(psiElement4 instanceof KtBlockExpression)) {
                psiElement4 = null;
            }
            if ((ktBlockExpression = (KtBlockExpression)psiElement4) == null) {
                PsiElement psiElement5 = result$iv;
                if (psiElement5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression = ((KtParenthesizedExpression)psiElement5).getExpression();
                if (ktExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                }
                ktBlockExpression = (KtBlockExpression)ktExpression;
            }
            KtBlockExpression replaced2 = ktBlockExpression;
            Editor editor2 = IntentionBasedInspectionKt.findExistingEditor((PsiElement)replaced2);
            if (editor2 == null) break block7;
            GenerateUtilKt.moveCaret$default(editor2, replaced2.getStartOffset(), null, 2, null);
        }
    }
}

