/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableMutabilityFix;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousVarPropertyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "idea"})
public final class SuspiciousVarPropertyInspection
extends AbstractKotlinInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.propertyVisitor((Function1<? super KtProperty, Unit>)((Function1)new Function1<KtProperty, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                if (property2.isLocal() || !property2.isVar() || property2.getInitializer() == null || property2.getSetter() != null) {
                    return;
                }
                KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
                if (ktPropertyAccessor == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor, (String)"property.getter ?: return");
                KtPropertyAccessor getter2 = ktPropertyAccessor;
                BindingContext context2 = ResolutionUtils.analyze$default(property2, null, 1, null);
                DeclarationDescriptor declarationDescriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)declarationDescriptor;
                if (propertyDescriptor2 == null) {
                    return;
                }
                PropertyDescriptor descriptor2 = propertyDescriptor2;
                if (Intrinsics.areEqual((Object)((Boolean)context2.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2)), (Object)false)) {
                    return;
                }
                if (org.jetbrains.kotlin.idea.inspections.SuspiciousVarPropertyInspection$Companion.access$hasBackingFieldReference(SuspiciousVarPropertyInspection.Companion, getter2)) {
                    return;
                }
                this.$holder.registerProblem(property2.getValOrVarKeyword(), "Suspicious 'var' property: its setter does not influence its getter result", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new ChangeVariableMutabilityFix(property2, false, null, true, 4, null), property2.getContainingFile())});
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002J\u0012\u0010\u0006\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0006\u001a\u00020\u0004*\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousVarPropertyInspection$Companion;", "", "()V", "hasBackingFieldReference", "", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "isBackingFieldReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasBackingFieldReference(@NotNull KtPropertyAccessor $this$hasBackingFieldReference) {
            void result$iv$iv$iv;
            void $this$anyDescendantOfType$iv;
            KtExpression ktExpression = $this$hasBackingFieldReference.getBodyExpression();
            if (ktExpression == null) return true;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"this.bodyExpression ?: return true");
            KtExpression bodyExpression = ktExpression;
            KtProperty ktProperty = $this$hasBackingFieldReference.getProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"property");
            if (this.isBackingFieldReference(bodyExpression, ktProperty)) return true;
            PsiElement psiElement2 = (PsiElement)bodyExpression;
            Function1 predicate$iv = (Function1)new Function1<KtNameReferenceExpression, Boolean>($this$hasBackingFieldReference){
                final /* synthetic */ KtPropertyAccessor $this_hasBackingFieldReference;

                public final boolean invoke(@NotNull KtNameReferenceExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    KtProperty ktProperty = this.$this_hasBackingFieldReference.getProperty();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"property");
                    return org.jetbrains.kotlin.idea.inspections.SuspiciousVarPropertyInspection$Companion.access$isBackingFieldReference(SuspiciousVarPropertyInspection.Companion, it, ktProperty);
                }
                {
                    this.$this_hasBackingFieldReference = ktPropertyAccessor;
                    super(1);
                }
            };
            boolean $i$f$anyDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    if (element3 instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                        this.$result.element = element3;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element3;
                    boolean bl = false;
                    super.visitElement(element3);
                }
            });
            if ((PsiElement)result$iv$iv$iv.element == null) return false;
            return true;
        }

        public final boolean isBackingFieldReference(@NotNull KtExpression $this$isBackingFieldReference, @NotNull KtProperty property2) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isBackingFieldReference, (String)"$this$isBackingFieldReference");
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            return $this$isBackingFieldReference instanceof KtNameReferenceExpression && this.isBackingFieldReference((KtNameReferenceExpression)$this$isBackingFieldReference, property2);
        }

        private final boolean isBackingFieldReference(@NotNull KtNameReferenceExpression $this$isBackingFieldReference, KtProperty property2) {
            String string = $this$isBackingFieldReference.getText();
            KtKeywordToken ktKeywordToken = KtTokens.FIELD_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"KtTokens.FIELD_KEYWORD");
            return Intrinsics.areEqual((Object)string, (Object)ktKeywordToken.getValue()) && Intrinsics.areEqual((Object)ReferenceUtilKt.getMainReference($this$isBackingFieldReference).resolve(), (Object)property2);
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$hasBackingFieldReference(Companion $this, KtPropertyAccessor $this$access_u24hasBackingFieldReference) {
            return $this.hasBackingFieldReference($this$access_u24hasBackingFieldReference);
        }

        public static final /* synthetic */ boolean access$isBackingFieldReference(Companion $this, KtNameReferenceExpression $this$access_u24isBackingFieldReference, KtProperty property2) {
            return $this.isBackingFieldReference($this$access_u24isBackingFieldReference, property2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

