/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.blockingCallsDetection;

import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineNonBlockingContextChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/NonBlockingContextChecker;", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isContextNonBlockingFor", "element", "Lcom/intellij/psi/PsiElement;", "getFirstArgument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Companion", "idea"})
public final class CoroutineNonBlockingContextChecker
implements NonBlockingContextChecker {
    private static final String BLOCKING_CONTEXT_ANNOTATION = "org.jetbrains.annotations.BlockingContext";
    private static final String IO_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.IO";
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Project project = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        LanguageVersionSettings languageVersionSettings = PlatformKt.getLanguageVersionSettings$default(project, null, null, null, 7, null);
        return languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    public boolean isContextNonBlockingFor(@NotNull PsiElement element3) {
        Object v0;
        block14: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            if (!(element3 instanceof KtCallExpression)) {
                return false;
            }
            Sequence<PsiElement> $this$firstOrNull$iv = PsiUtilsKt.getParents(element3);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtLambdaExpression && ResolutionUtils.analyze$default((KtElement)it, null, 1, null).get(BindingContext.LAMBDA_INVOCATIONS, it) == null)) continue;
                v0 = element$iv;
                break block14;
            }
            v0 = null;
        }
        PsiElement containingLambda = v0;
        KtValueArgument containingArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)containingLambda, KtValueArgument.class);
        if (containingArgument != null) {
            Boolean bl;
            Boolean hasBlockingAnnotation;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)containingArgument), KtCallExpression.class);
            if (ktCallExpression == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktCallExpression, (String)"PsiTreeUtil.getParentOfT\u2026ass.java) ?: return false");
            KtCallExpression callExpression2 = ktCallExpression;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = ResolutionUtils.resolveToCall(callExpression2, BodyResolveMode.PARTIAL);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> call2 = resolvedCall2;
            Object object = this.getFirstArgument(call2);
            Annotated argumentDescriptor = object != null && (object = ResolutionUtils.resolveToCall$default((KtElement)object, null, 1, null)) != null ? object.getResultingDescriptor() : null;
            Object object2 = argumentDescriptor;
            Boolean bl2 = object2 != null && (object2 = object2.getAnnotations()) != null ? Boolean.valueOf(object2.hasAnnotation(new FqName(BLOCKING_CONTEXT_ANNOTATION))) : (hasBlockingAnnotation = null);
            if (Intrinsics.areEqual(hasBlockingAnnotation, (Object)true)) {
                return false;
            }
            Object object3 = argumentDescriptor;
            boolean isIoDispatcherUsed = Intrinsics.areEqual(object3 != null && (object3 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object3)) != null ? ((FqName)object3).asString() : null, (Object)IO_DISPATCHER_FQN);
            if (isIoDispatcherUsed) {
                return false;
            }
            ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(call2, containingArgument);
            if (valueParameterDescriptor == null) {
                return false;
            }
            ValueParameterDescriptor parameterForArgument = valueParameterDescriptor;
            KotlinType kotlinType2 = parameterForArgument.getReturnType();
            if (kotlinType2 == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"parameterForArgument.returnType ?: return false");
            KotlinType type2 = kotlinType2;
            if (FunctionTypesKt.isBuiltinFunctionalType(type2)) {
                KotlinType kotlinType3 = FunctionTypesKt.getReceiverTypeFromFunctionType(type2);
                if (kotlinType3 != null) {
                    Project project = ((KtCallExpression)element3).getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
                    bl = CoroutineCallCheckerKt.isRestrictsSuspensionReceiver(kotlinType3, PlatformKt.getLanguageVersionSettings$default(project, null, null, null, 7, null));
                } else {
                    bl = null;
                }
            } else {
                bl = null;
            }
            Boolean hasRestrictSuspensionAnnotation = bl;
            return Intrinsics.areEqual(hasRestrictSuspensionAnnotation, (Object)true) ^ true && FunctionTypesKt.isSuspendFunctionType(type2);
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)element3, KtNamedFunction.class);
        if (ktNamedFunction == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedFunction, (String)"PsiTreeUtil.getParentOfT\u2026ass.java) ?: return false");
        KtNamedFunction callingMethod = ktNamedFunction;
        return callingMethod.hasModifier(KtTokens.SUSPEND_KEYWORD);
    }

    private final KtExpression getFirstArgument(@NotNull ResolvedCall<?> $this$getFirstArgument) {
        List<ResolvedValueArgument> list2 = $this$getFirstArgument.getValueArgumentsByIndex();
        return list2 != null && (list2 = (ResolvedValueArgument)CollectionsKt.firstOrNull(list2)) != null && (list2 = list2.getArguments()) != null && (list2 = (ValueArgument)CollectionsKt.firstOrNull(list2)) != null ? list2.getArgumentExpression() : null;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineNonBlockingContextChecker$Companion;", "", "()V", "BLOCKING_CONTEXT_ANNOTATION", "", "IO_DISPATCHER_FQN", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

