/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.coroutines;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.UnusedReceiverParameterInspection;
import org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection;
import org.jetbrains.kotlin.idea.intentions.ConvertReceiverToParameterIntention;
import org.jetbrains.kotlin.idea.intentions.MoveMemberToCompanionObjectIntention;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/SuspendFunctionOnCoroutineScopeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "WrapWithCoroutineScopeFix", "idea"})
public final class SuspendFunctionOnCoroutineScopeInspection
extends AbstractKotlinInspection {
    private static final String COROUTINE_SCOPE = "kotlinx.coroutines.CoroutineScope";
    private static final String COROUTINE_SCOPE_WRAPPER = "kotlinx.coroutines.coroutineScope";
    private static final String COROUTINE_CONTEXT = "coroutineContext";
    private static final String MESSAGE = "Ambiguous coroutineContext due to CoroutineScope receiver of suspend function";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.namedFunctionVisitor((Function1<? super KtNamedFunction, Unit>)((Function1)new Function1<KtNamedFunction, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtNamedFunction function2) {
                PsiElement $this$forEachDescendantOfType$iv;
                void extensionOfCoroutineScope;
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                if (!function2.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                    return;
                }
                if (!function2.hasBody()) {
                    return;
                }
                BindingContext context2 = ResolutionUtils.analyzeWithContent(function2);
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get(BindingContext.FUNCTION, function2);
                if (simpleFunctionDescriptor == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"context[BindingContext.F\u2026TION, function] ?: return");
                SimpleFunctionDescriptor descriptor2 = simpleFunctionDescriptor;
                boolean bl = false;
                boolean bl2 = false;
                SimpleFunctionDescriptor $this$with = descriptor2;
                boolean bl3 = false;
                Pair pair2 = TuplesKt.to((Object)org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection$Companion.access$ofCoroutineScopeType(SuspendFunctionOnCoroutineScopeInspection.Companion, $this$with.getExtensionReceiverParameter()), (Object)org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection$Companion.access$ofCoroutineScopeType(SuspendFunctionOnCoroutineScopeInspection.Companion, $this$with.getDispatchReceiverParameter()));
                boolean bl4 = (Boolean)pair2.component1();
                boolean memberOfCoroutineScope = (Boolean)pair2.component2();
                if (extensionOfCoroutineScope == false && !memberOfCoroutineScope) {
                    return;
                }
                Function1<DeclarationDescriptor, Boolean> $fun$isReceiverOfAnalyzedFunction$2 = new Function1<DeclarationDescriptor, Boolean>((boolean)extensionOfCoroutineScope, descriptor2, memberOfCoroutineScope){
                    final /* synthetic */ boolean $extensionOfCoroutineScope;
                    final /* synthetic */ SimpleFunctionDescriptor $descriptor;
                    final /* synthetic */ boolean $memberOfCoroutineScope;

                    public final boolean invoke(@NotNull DeclarationDescriptor $this$isReceiverOfAnalyzedFunction) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$isReceiverOfAnalyzedFunction, (String)"$this$isReceiverOfAnalyzedFunction");
                        if (this.$extensionOfCoroutineScope && Intrinsics.areEqual((Object)$this$isReceiverOfAnalyzedFunction, (Object)this.$descriptor)) {
                            return true;
                        }
                        return this.$memberOfCoroutineScope && Intrinsics.areEqual((Object)$this$isReceiverOfAnalyzedFunction, (Object)this.$descriptor.getContainingDeclaration());
                    }
                    {
                        this.$extensionOfCoroutineScope = bl;
                        this.$descriptor = simpleFunctionDescriptor;
                        this.$memberOfCoroutineScope = bl2;
                        super(1);
                    }
                };
                Function2<ReceiverValue, KtExpression, Unit> $fun$checkSuspiciousReceiver$3 = new Function2<ReceiverValue, KtExpression, Unit>(this, $fun$isReceiverOfAnalyzedFunction$2, context2, (boolean)extensionOfCoroutineScope, function2, memberOfCoroutineScope){
                    final /* synthetic */ buildVisitor.1 this$0;
                    final /* synthetic */ buildVisitor.2 $isReceiverOfAnalyzedFunction$2;
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ boolean $extensionOfCoroutineScope;
                    final /* synthetic */ KtNamedFunction $function;
                    final /* synthetic */ boolean $memberOfCoroutineScope;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ReceiverValue receiver2, @NotNull KtExpression problemExpression) {
                        LocalQuickFix[] localQuickFixArray;
                        void $this$toTypedArray$iv;
                        PsiElement psiElement2;
                        Object containingDeclaration2;
                        boolean bl;
                        KtExpression ktExpression;
                        Object instanceReference2;
                        Intrinsics.checkParameterIsNotNull((Object)receiver2, (String)"receiver");
                        Intrinsics.checkParameterIsNotNull((Object)problemExpression, (String)"problemExpression");
                        ReceiverValue receiverValue = receiver2;
                        if (receiverValue instanceof ImplicitReceiver) {
                            if (!this.$isReceiverOfAnalyzedFunction$2.invoke(((ImplicitReceiver)receiver2).getDeclarationDescriptor())) {
                                return;
                            }
                        } else if (receiverValue instanceof ExpressionReceiver) {
                            KtExpression ktExpression2 = ((ExpressionReceiver)receiver2).getExpression();
                            if (!(ktExpression2 instanceof KtThisExpression)) {
                                ktExpression2 = null;
                            }
                            KtThisExpression ktThisExpression = (KtThisExpression)ktExpression2;
                            if (ktThisExpression == null) {
                                return;
                            }
                            KtThisExpression receiverThisExpression = ktThisExpression;
                            if (receiverThisExpression.getTargetLabel() != null) {
                                KtReferenceExpression ktReferenceExpression = receiverThisExpression.getInstanceReference();
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktReferenceExpression, (String)"receiverThisExpression.instanceReference");
                                instanceReference2 = ktReferenceExpression;
                                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.$context.get(BindingContext.REFERENCE_TARGET, instanceReference2);
                                if (declarationDescriptor == null || !this.$isReceiverOfAnalyzedFunction$2.invoke(declarationDescriptor)) {
                                    return;
                                }
                            }
                        }
                        boolean receiverThisExpression = false;
                        List fixes = new ArrayList<E>();
                        KtExpression ktExpression3 = problemExpression;
                        if (!(ktExpression3 instanceof KtCallExpression)) {
                            ktExpression3 = null;
                        }
                        if ((ktExpression = (KtCallExpression)ktExpression3) == null || (ktExpression = ktExpression.getCalleeExpression()) == null) {
                            ktExpression = problemExpression;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"(problemExpression as? K\u2026sion ?: problemExpression");
                        KtExpression reportElement = ktExpression;
                        this.this$0.$holder.registerProblem((PsiElement)reportElement, "Ambiguous coroutineContext due to CoroutineScope receiver of suspend function", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new WrapWithCoroutineScopeFix(false, true)});
                        instanceReference2 = fixes;
                        Object object = new WrapWithCoroutineScopeFix(this.$extensionOfCoroutineScope, false);
                        boolean bl2 = false;
                        instanceReference2.add(object);
                        KtFile ktFile2 = this.$function.getContainingKtFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"function.containingKtFile");
                        KtFile file2 = ktFile2;
                        if (this.$extensionOfCoroutineScope) {
                            object = fixes;
                            IntentionWrapper intentionWrapper = new IntentionWrapper((IntentionAction)new ConvertReceiverToParameterIntention(), (PsiFile)file2);
                            bl = false;
                            object.add(intentionWrapper);
                        }
                        if (this.$memberOfCoroutineScope && (containingDeclaration2 = KtPsiUtilKt.getContainingClassOrObject(this.$function)) instanceof KtClass && !((KtClass)containingDeclaration2).isInterface() && this.$function.hasBody()) {
                            Collection collection = fixes;
                            IntentionWrapper intentionWrapper = new IntentionWrapper((IntentionAction)new MoveMemberToCompanionObjectIntention(), (PsiFile)file2);
                            boolean bl3 = false;
                            collection.add(intentionWrapper);
                        }
                        containingDeclaration2 = this.$function;
                        ProblemsHolder problemsHolder = this.this$0.$holder;
                        bl2 = false;
                        bl = false;
                        KtTypeParameterListOwnerStub $this$with = containingDeclaration2;
                        boolean bl4 = false;
                        KtTypeReference ktTypeReference = ((KtNamedFunction)$this$with).getReceiverTypeReference();
                        PsiElement psiElement3 = ktTypeReference != null ? (PsiElement)ktTypeReference : $this$with.getNameIdentifier();
                        if (psiElement3 == null) {
                            psiElement3 = psiElement2 = ((KtNamedFunction)$this$with).getFunKeyword();
                        }
                        if (psiElement3 == null) {
                            psiElement2 = $this$with;
                        }
                        PsiElement psiElement4 = psiElement2;
                        containingDeclaration2 = fixes;
                        ProblemHighlightType problemHighlightType2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                        String string = "Ambiguous coroutineContext due to CoroutineScope receiver of suspend function";
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                        if (localQuickFixArray2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                        problemsHolder.registerProblem(psiElement4, string, problemHighlightType2, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$isReceiverOfAnalyzedFunction$2 = var2_2;
                        this.$context = bindingContext2;
                        this.$extensionOfCoroutineScope = bl;
                        this.$function = ktNamedFunction;
                        this.$memberOfCoroutineScope = bl2;
                        super(2);
                    }
                };
                PsiElement psiElement2 = function2;
                Function1 action$iv = (Function1)new Function1<KtCallExpression, Unit>(context2, $fun$checkSuspiciousReceiver$3){
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ buildVisitor.3 $checkSuspiciousReceiver$3;

                    public final void invoke(@NotNull KtCallExpression callExpression2) {
                        Intrinsics.checkParameterIsNotNull((Object)callExpression2, (String)"callExpression");
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, this.$context);
                        if (resolvedCall2 == null) {
                            return;
                        }
                        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                        ReceiverParameterDescriptor receiverParameterDescriptor = resolvedCall3.getResultingDescriptor().getExtensionReceiverParameter();
                        if (receiverParameterDescriptor == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"resolvedCall.resultingDe\u2026ceiverParameter ?: return");
                        ReceiverParameterDescriptor extensionReceiverParameter2 = receiverParameterDescriptor;
                        KotlinType kotlinType2 = extensionReceiverParameter2.getType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"extensionReceiverParameter.type");
                        if (!org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection$Companion.access$isCoroutineScope(SuspendFunctionOnCoroutineScopeInspection.Companion, kotlinType2)) {
                            return;
                        }
                        ReceiverValue receiverValue = resolvedCall3.getExtensionReceiver();
                        if (receiverValue == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"resolvedCall.extensionReceiver ?: return");
                        ReceiverValue extensionReceiver2 = receiverValue;
                        this.$checkSuspiciousReceiver$3.invoke(extensionReceiver2, callExpression2);
                    }
                    {
                        this.$context = bindingContext2;
                        this.$checkSuspiciousReceiver$3 = var2_2;
                        super(1);
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                PsiElement $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
                boolean $i$f$forEachDescendantOfType2 = false;
                $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $captured_local_variable$1;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                        if (element3 instanceof KtCallExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
                $this$forEachDescendantOfType$iv = function2;
                action$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(context2, $fun$checkSuspiciousReceiver$3){
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ buildVisitor.3 $checkSuspiciousReceiver$3;

                    public final void invoke(@NotNull KtNameReferenceExpression nameReferenceExpression) {
                        Intrinsics.checkParameterIsNotNull((Object)nameReferenceExpression, (String)"nameReferenceExpression");
                        if (Intrinsics.areEqual((Object)nameReferenceExpression.getReferencedName(), (Object)"coroutineContext") ^ true) {
                            return;
                        }
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(nameReferenceExpression, this.$context);
                        if (resolvedCall2 == null) {
                            return;
                        }
                        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor()).asString(), (Object)"kotlinx.coroutines.CoroutineScope.coroutineContext")) {
                            ReceiverValue receiverValue = resolvedCall3.getDispatchReceiver();
                            if (receiverValue == null) {
                                return;
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"resolvedCall.dispatchReceiver ?: return");
                            ReceiverValue dispatchReceiver = receiverValue;
                            this.$checkSuspiciousReceiver$3.invoke(dispatchReceiver, nameReferenceExpression);
                        }
                    }
                    {
                        this.$context = bindingContext2;
                        this.$checkSuspiciousReceiver$3 = var2_2;
                        super(1);
                    }
                };
                $i$f$forEachDescendantOfType = false;
                $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
                $i$f$forEachDescendantOfType2 = false;
                $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $captured_local_variable$1;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                        if (element3 instanceof KtNameReferenceExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/SuspendFunctionOnCoroutineScopeInspection$WrapWithCoroutineScopeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "removeReceiver", "", "wrapCallOnly", "(ZZ)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "startInWriteAction", "idea"})
    private static final class WrapWithCoroutineScopeFix
    implements LocalQuickFix {
        private final boolean removeReceiver;
        private final boolean wrapCallOnly;

        @NotNull
        public String getFamilyName() {
            return "Wrap with coroutineScope";
        }

        @NotNull
        public String getName() {
            return this.removeReceiver && !this.wrapCallOnly ? "Remove receiver & wrap with 'coroutineScope { ... }'" : (this.wrapCallOnly ? "Wrap call with 'coroutineScope { ... }'" : "Wrap function body with 'coroutineScope { ... }'");
        }

        public boolean startInWriteAction() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void expressionToWrap;
            PsiElement problemElement;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                return;
            }
            PsiElement $this$getNonStrictParentOfType$iv = problemElement = psiElement2;
            boolean $i$f$getNonStrictParentOfType = false;
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNamedFunction.class, (boolean)false);
            if (ktNamedFunction == null) {
                return;
            }
            KtNamedFunction function2 = ktNamedFunction;
            FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(function2, null, 1, null);
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)function2)) {
                return;
            }
            KtExpression bodyExpression = function2.getBodyExpression();
            Function0<KtExpression> $fun$getExpressionToWrapCall$1 = new Function0<KtExpression>(problemElement){
                final /* synthetic */ PsiElement $problemElement;

                @Nullable
                public final KtExpression invoke() {
                    PsiElement psiElement2 = this.$problemElement;
                    if (!(psiElement2 instanceof KtExpression)) {
                        psiElement2 = null;
                    }
                    KtExpression ktExpression = (KtExpression)psiElement2;
                    if (ktExpression == null) {
                        return null;
                    }
                    KtExpression result2 = ktExpression;
                    while (result2.getParent() instanceof KtQualifiedExpression || result2.getParent() instanceof KtCallExpression) {
                        PsiElement psiElement3 = result2.getParent();
                        if (psiElement3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                        result2 = (KtExpression)psiElement3;
                    }
                    return result2;
                }
                {
                    this.$problemElement = psiElement2;
                    super(0);
                }
            };
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            Object object = this.wrapCallOnly ? $fun$getExpressionToWrapCall$1.invoke() : bodyExpression;
            if (object == null) {
                return;
            }
            objectRef.element = object;
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            if (Companion.ofCoroutineScopeType(functionDescriptor3 != null ? functionDescriptor3.getExtensionReceiverParameter() : null)) {
                void $this$forEachDescendantOfType$iv;
                BindingContext context2 = ResolutionUtils.analyzeWithContent(function2);
                PsiElement psiElement3 = (PsiElement)((KtExpression)expressionToWrap.element);
                Function1 action$iv = (Function1)new Function1<KtDotQualifiedExpression, Unit>(functionDescriptor2, context2, (Ref.ObjectRef)expressionToWrap){
                    final /* synthetic */ FunctionDescriptor $functionDescriptor;
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ Ref.ObjectRef $expressionToWrap;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull KtDotQualifiedExpression it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        KtExpression ktExpression = it.getReceiverExpression();
                        if (!(ktExpression instanceof KtThisExpression)) {
                            ktExpression = null;
                        }
                        KtThisExpression receiverExpression = (KtThisExpression)ktExpression;
                        KtExpression selectorExpression = it.getSelectorExpression();
                        KtThisExpression ktThisExpression = receiverExpression;
                        if ((ktThisExpression != null ? ktThisExpression.getTargetLabel() : null) != null && selectorExpression != null && Intrinsics.areEqual((Object)((DeclarationDescriptor)this.$context.get(BindingContext.REFERENCE_TARGET, receiverExpression.getInstanceReference())), (Object)this.$functionDescriptor)) {
                            if (it == (KtExpression)this.$expressionToWrap.element) {
                                KtExpression ktExpression2;
                                void $this$replaced$iv;
                                PsiElement psiElement2 = (PsiElement)it;
                                Ref.ObjectRef objectRef = this.$expressionToWrap;
                                boolean $i$f$replaced = false;
                                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)selectorExpression);
                                PsiElement psiElement3 = result$iv;
                                if (!(psiElement3 instanceof KtExpression)) {
                                    psiElement3 = null;
                                }
                                if ((ktExpression2 = (KtExpression)psiElement3) == null) {
                                    PsiElement psiElement4 = result$iv;
                                    if (psiElement4 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                    }
                                    ktExpression2 = ((KtParenthesizedExpression)psiElement4).getExpression();
                                    if (ktExpression2 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                    }
                                }
                                KtExpression ktExpression3 = ktExpression2;
                                objectRef.element = ktExpression3;
                            } else {
                                Intrinsics.checkExpressionValueIsNotNull((Object)it.replace((PsiElement)selectorExpression), (String)"it.replace(selectorExpression)");
                            }
                        }
                    }
                    {
                        this.$functionDescriptor = functionDescriptor2;
                        this.$context = bindingContext2;
                        this.$expressionToWrap = objectRef;
                        super(1);
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
                boolean $i$f$forEachDescendantOfType2 = false;
                $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $captured_local_variable$1;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                        if (element3 instanceof KtDotQualifiedExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
            }
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default(function2, false, 2, null);
            KtBlockExpression blockExpression2 = function2.getBodyBlockExpression();
            ApplicationUtilsKt.executeWriteCommand(project, this.getName(), this, (Function0)new Function0<KtElement>((Ref.ObjectRef)expressionToWrap, bodyExpression, factory2, blockExpression2, project){
                final /* synthetic */ Ref.ObjectRef $expressionToWrap;
                final /* synthetic */ KtExpression $bodyExpression;
                final /* synthetic */ KtPsiFactory $factory;
                final /* synthetic */ KtBlockExpression $blockExpression;
                final /* synthetic */ Project $project;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final KtElement invoke() {
                    PsiElement reformatted;
                    KtExpression ktExpression;
                    PsiElement $this$replaced$iv;
                    PsiElement newElement$iv22;
                    if (Intrinsics.areEqual((Object)((KtExpression)this.$expressionToWrap.element), (Object)this.$bodyExpression) ^ true) {
                        PsiElement psiElement2 = (PsiElement)((KtExpression)this.$expressionToWrap.element);
                        newElement$iv22 = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(this.$factory, "kotlinx.coroutines.coroutineScope { $0 }", new Object[]{(KtExpression)this.$expressionToWrap.element}, false, 4, null);
                        boolean $i$f$replaced = false;
                        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv22);
                        PsiElement psiElement3 = result$iv;
                        if (!(psiElement3 instanceof KtExpression)) {
                            psiElement3 = null;
                        }
                        if ((ktExpression = (KtExpression)psiElement3) == null) {
                            PsiElement psiElement4 = result$iv;
                            if (psiElement4 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            }
                            ktExpression = ((KtParenthesizedExpression)psiElement4).getExpression();
                            if (ktExpression == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                        }
                    } else if (this.$blockExpression == null) {
                        $this$replaced$iv = (PsiElement)this.$bodyExpression;
                        newElement$iv22 = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(this.$factory, "kotlinx.coroutines.coroutineScope { $0 }", new Object[]{this.$bodyExpression}, false, 4, null);
                        boolean $i$f$replaced = false;
                        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv22);
                        PsiElement psiElement5 = result$iv;
                        if (!(psiElement5 instanceof KtExpression)) {
                            psiElement5 = null;
                        }
                        if ((ktExpression = (KtExpression)psiElement5) == null) {
                            PsiElement psiElement6 = result$iv;
                            if (psiElement6 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            }
                            ktExpression = ((KtParenthesizedExpression)psiElement6).getExpression();
                            if (ktExpression == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                        }
                    } else {
                        KtBlockExpression ktBlockExpression;
                        void $this$replaced$iv2;
                        boolean newElement$iv22 = false;
                        StringBuilder $i$f$replaced = new StringBuilder();
                        boolean result$iv = false;
                        boolean bl = false;
                        StringBuilder $this$buildString = $i$f$replaced;
                        boolean bl2 = false;
                        Iterator<KtExpression> iterator2 = this.$blockExpression.getStatements().iterator();
                        while (iterator2.hasNext()) {
                            KtExpression statement2;
                            KtExpression ktExpression2 = statement2 = iterator2.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"statement");
                            $this$buildString.append(ktExpression2.getText());
                        }
                        String string = $i$f$replaced.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                        String bodyText = string;
                        newElement$iv22 = (PsiElement)this.$blockExpression;
                        PsiElement newElement$iv = (PsiElement)this.$factory.createBlock("kotlinx.coroutines.coroutineScope { " + bodyText + " }");
                        boolean $i$f$replaced2 = false;
                        PsiElement result$iv2 = $this$replaced$iv2.replace(newElement$iv);
                        PsiElement psiElement7 = result$iv2;
                        if (!(psiElement7 instanceof KtBlockExpression)) {
                            psiElement7 = null;
                        }
                        if ((ktBlockExpression = (KtBlockExpression)psiElement7) == null) {
                            PsiElement psiElement8 = result$iv2;
                            if (psiElement8 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            }
                            KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement8).getExpression();
                            if (ktExpression3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                            }
                            ktBlockExpression = (KtBlockExpression)ktExpression3;
                        }
                        ktExpression = ktBlockExpression;
                    }
                    KtExpression result2 = ktExpression;
                    PsiElement psiElement9 = CodeStyleManager.getInstance((Project)this.$project).reformat((PsiElement)result2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement9, (String)"CodeStyleManager.getInst\u2026project).reformat(result)");
                    PsiElement psiElement10 = reformatted = psiElement9;
                    if (psiElement10 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    }
                    return ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement10, null, 2, null);
                }
                {
                    this.$expressionToWrap = objectRef;
                    this.$bodyExpression = ktExpression;
                    this.$factory = ktPsiFactory;
                    this.$blockExpression = ktBlockExpression;
                    this.$project = project;
                    super(0);
                }
            });
            KtTypeReference receiverTypeReference = function2.getReceiverTypeReference();
            if (this.removeReceiver && !this.wrapCallOnly && receiverTypeReference != null) {
                UnusedReceiverParameterInspection.RemoveReceiverFix.Companion.apply$default(UnusedReceiverParameterInspection.RemoveReceiverFix.Companion, receiverTypeReference, project, false, 4, null);
            }
        }

        public WrapWithCoroutineScopeFix(boolean removeReceiver, boolean wrapCallOnly) {
            this.removeReceiver = removeReceiver;
            this.wrapCallOnly = wrapCallOnly;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\t*\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/SuspendFunctionOnCoroutineScopeInspection$Companion;", "", "()V", "COROUTINE_CONTEXT", "", "COROUTINE_SCOPE", "COROUTINE_SCOPE_WRAPPER", "MESSAGE", "isCoroutineScope", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "ofCoroutineScopeType", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "idea"})
    public static final class Companion {
        private final boolean isCoroutineScope(@NotNull KotlinType $this$isCoroutineScope) {
            Object object = $this$isCoroutineScope.getConstructor().getDeclarationDescriptor();
            return Intrinsics.areEqual(object != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null ? ((FqName)object).asString() : null, (Object)SuspendFunctionOnCoroutineScopeInspection.COROUTINE_SCOPE);
        }

        private final boolean ofCoroutineScopeType(@Nullable ReceiverParameterDescriptor $this$ofCoroutineScopeType) {
            boolean bl;
            block5: {
                if ($this$ofCoroutineScopeType == null) {
                    return false;
                }
                KotlinType kotlinType2 = $this$ofCoroutineScopeType.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
                if (this.isCoroutineScope(kotlinType2)) {
                    return true;
                }
                Collection<KotlinType> collection = $this$ofCoroutineScopeType.getType().getConstructor().getSupertypes();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"type.constructor.supertypes");
                Iterable $this$any$iv = CollectionsKt.reversed((Iterable)collection);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        KotlinType kotlinType3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"it");
                        if (!Companion.isCoroutineScope(kotlinType3)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isCoroutineScope(Companion $this, KotlinType $this$access_u24isCoroutineScope) {
            return $this.isCoroutineScope($this$access_u24isCoroutineScope);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

