/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.configuration.KotlinMigrationProjectComponentKt;
import org.jetbrains.kotlin.idea.configuration.MigrationInfo;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.migration.CoroutineMigrationProblem;
import org.jetbrains.kotlin.idea.inspections.migration.ExperimentalImportUsage;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExtensionFunctionUsage;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteTopLevelFunctionUsage;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExperimentalCoroutinesInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrationFix;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isApplicable", "migrationInfo", "Lorg/jetbrains/kotlin/idea/configuration/MigrationInfo;", "Companion", "idea"})
public final class ObsoleteExperimentalCoroutinesInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool,
MigrationFix {
    private static final List<CoroutineMigrationProblem> PROBLEMS;
    public static final Companion Companion;

    @Override
    public boolean isApplicable(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkParameterIsNotNull((Object)migrationInfo, (String)"migrationInfo");
        return KotlinMigrationProjectComponentKt.isLanguageVersionUpdate(migrationInfo, LanguageVersion.KOTLIN_1_2, LanguageVersion.KOTLIN_1_3);
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.simpleNameExpressionVisitor((Function1<? super KtSimpleNameExpression, Unit>)((Function1)new Function1<KtSimpleNameExpression, Unit>(this, holder, isOnTheFly){
            final /* synthetic */ ObsoleteExperimentalCoroutinesInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public final void invoke(@NotNull KtSimpleNameExpression simpleNameExpression) {
                boolean versionAtLeast13;
                Intrinsics.checkParameterIsNotNull((Object)simpleNameExpression, (String)"simpleNameExpression");
                ObsoleteExperimentalCoroutinesInspection obsoleteExperimentalCoroutinesInspection = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                ObsoleteExperimentalCoroutinesInspection $this$run = obsoleteExperimentalCoroutinesInspection;
                boolean bl3 = false;
                boolean bl4 = versionAtLeast13 = PlatformKt.getLanguageVersionSettings((PsiElement)simpleNameExpression).getLanguageVersion().compareTo((Enum)LanguageVersion.KOTLIN_1_3) >= 0;
                if (!versionAtLeast13) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode()) {
                        return;
                    }
                }
                for (CoroutineMigrationProblem registeredProblem : ObsoleteExperimentalCoroutinesInspection.access$getPROBLEMS$cp()) {
                    if (!registeredProblem.report(this.$holder, this.$isOnTheFly, simpleNameExpression)) continue;
                    return;
                }
            }
            {
                this.this$0 = obsoleteExperimentalCoroutinesInspection;
                this.$holder = problemsHolder;
                this.$isOnTheFly = bl;
                super(1);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        PROBLEMS = CollectionsKt.listOf((Object[])new CoroutineMigrationProblem[]{new ObsoleteTopLevelFunctionUsage("buildSequence", "kotlin.coroutines.experimental.buildSequence", "kotlin.sequences.sequence"), new ObsoleteTopLevelFunctionUsage("buildIterator", "kotlin.coroutines.experimental.buildIterator", "kotlin.sequences.iterator"), new ObsoleteExtensionFunctionUsage("resume", "kotlin.coroutines.experimental.Continuation.resume", "kotlin.coroutines.resume"), new ObsoleteExtensionFunctionUsage("resumeWithException", "kotlin.coroutines.experimental.Continuation.resumeWithException", "kotlin.coroutines.resumeWithException"), new ExperimentalImportUsage()});
    }

    public static final /* synthetic */ List access$getPROBLEMS$cp() {
        return PROBLEMS;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExperimentalCoroutinesInspection$Companion;", "", "()V", "PROBLEMS", "", "Lorg/jetbrains/kotlin/idea/inspections/migration/CoroutineMigrationProblem;", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

