/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.AbstractChopListIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B)\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00122\u0006\u0010\r\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00122\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u001b*\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AbstractChopListIntention;", "TList", "Lorg/jetbrains/kotlin/psi/KtElement;", "TElement", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "listClass", "Ljava/lang/Class;", "elementClass", "text", "", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/openapi/editor/Editor;)V", "hasLineBreakAfter", "", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "hasLineBreakBefore", "isApplicableTo", "nextBreak", "Lcom/intellij/psi/PsiWhiteSpace;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lcom/intellij/psi/PsiWhiteSpace;", "prevBreak", "elements", "", "(Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/util/List;", "idea"})
public abstract class AbstractChopListIntention<TList extends KtElement, TElement extends KtElement>
extends SelfTargetingOffsetIndependentIntention<TList> {
    private final Class<TList> listClass;
    private final Class<TElement> elementClass;

    @Override
    public boolean isApplicableTo(@NotNull TList element3) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull(element3, (String)"element");
            List<TElement> elements2 = this.elements(element3);
            if (elements2.size() <= 1) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.dropLast(elements2, (int)1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtElement it = (KtElement)element$iv;
                    boolean bl2 = false;
                    if (this.hasLineBreakAfter(it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return !bl;
    }

    @Override
    public void applyTo(@NotNull TList element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull(element3, (String)"element");
        Project project = element3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        Project project2 = project;
        Editor editor3 = editor2;
        if (editor3 == null) {
            Intrinsics.throwNpe();
        }
        Document document = editor3.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor!!.document");
        Document document2 = document;
        int startOffset = PsiUtilsKt.getStartOffset((PsiElement)element3);
        List<TElement> elements2 = this.elements(element3);
        if (!this.hasLineBreakAfter((KtElement)CollectionsKt.last(elements2))) {
            Sequence $this$lastOrNull$iv2 = PsiUtilsKt.getAllChildren((PsiElement)element3);
            boolean $i$f$lastOrNull = false;
            Object last$iv2 = null;
            for (Object element$iv : $this$lastOrNull$iv2) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                ASTNode aSTNode = it.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
                if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.RPAR))) continue;
                last$iv2 = element$iv;
            }
            PsiElement psiElement2 = last$iv2;
            if (psiElement2 != null) {
                int $this$lastOrNull$iv2 = PsiUtilsKt.getStartOffset(psiElement2);
                $i$f$lastOrNull = false;
                boolean last$iv2 = false;
                int it = $this$lastOrNull$iv2;
                boolean bl = false;
                document2.insertString(it, (CharSequence)"\n");
            }
        }
        for (KtElement e : CollectionsKt.asReversed(elements2)) {
            if (this.hasLineBreakBefore(e)) continue;
            document2.insertString(PsiUtilsKt.getStartOffset((PsiElement)e), (CharSequence)"\n");
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitDocument(document2);
        PsiFile psiFile = documentManager.getPsiFile(document2);
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"documentManager.getPsiFile(document) ?: return");
        PsiFile psiFile2 = psiFile;
        PsiElement psiElement3 = psiFile2.findElementAt(startOffset);
        if (psiElement3 == null) {
            return;
        }
        KtElement ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement3, this.listClass);
        if (ktElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"PsiTreeUtil.getParentOfT\u2026urn, listClass) ?: return");
        KtElement newList = ktElement;
        CodeStyleManager.getInstance((Project)project2).adjustLineIndent(psiFile2, newList.getTextRange());
    }

    protected final boolean hasLineBreakAfter(@NotNull TElement element3) {
        Intrinsics.checkParameterIsNotNull(element3, (String)"element");
        return this.nextBreak(element3) != null;
    }

    @Nullable
    protected final PsiWhiteSpace nextBreak(@NotNull TElement element3) {
        Object v1;
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull(element3, (String)"element");
            Sequence $this$firstOrNull$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)element3, false, false, 1, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
                final /* synthetic */ AbstractChopListIntention this$0;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return !AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
                }
                {
                    this.this$0 = abstractChopListIntention;
                    super(1);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof PsiWhiteSpace)) {
            v1 = null;
        }
        return v1;
    }

    protected final boolean hasLineBreakBefore(@NotNull TElement element3) {
        Intrinsics.checkParameterIsNotNull(element3, (String)"element");
        return this.prevBreak(element3) != null;
    }

    @Nullable
    protected final PsiWhiteSpace prevBreak(@NotNull TElement element3) {
        Object v1;
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull(element3, (String)"element");
            boolean bl = false;
            boolean bl2 = false;
            Sequence $this$firstOrNull$iv = SequencesKt.takeWhile(PsiUtilsKt.siblings((PsiElement)element3, bl, bl2), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
                final /* synthetic */ AbstractChopListIntention this$0;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return !AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
                }
                {
                    this.this$0 = abstractChopListIntention;
                    super(1);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl3 = false;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof PsiWhiteSpace)) {
            v1 = null;
        }
        return v1;
    }

    @NotNull
    protected final List<TElement> elements(@NotNull TList $this$elements) {
        Intrinsics.checkParameterIsNotNull($this$elements, (String)"$this$elements");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.getAllChildren((PsiElement)$this$elements), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
            final /* synthetic */ AbstractChopListIntention this$0;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
            }
            {
                this.this$0 = abstractChopListIntention;
                super(1);
            }
        })), (Function1)elements.2.INSTANCE));
    }

    public AbstractChopListIntention(@NotNull Class<TList> listClass, @NotNull Class<TElement> elementClass, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(listClass, (String)"listClass");
        Intrinsics.checkParameterIsNotNull(elementClass, (String)"elementClass");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        super(listClass, text2, null, 4, null);
        this.listClass = listClass;
        this.elementClass = elementClass;
    }

    public static final /* synthetic */ Class access$getElementClass$p(AbstractChopListIntention $this) {
        return $this.elementClass;
    }
}

