/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.AddJvmOverloadsIntentionKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddJvmOverloadsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class AddJvmOverloadsIntention
extends SelfTargetingIntention<KtModifierListOwner>
implements LowPriorityAction {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtModifierListOwner element3, int caretOffset) {
        KtParameter it;
        void targetName;
        Pair pair2;
        int n;
        KtParameterList valueParameterList;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtModifierListOwner ktModifierListOwner = element3;
        if (ktModifierListOwner instanceof KtNamedFunction) {
            PsiElement psiElement2 = ((KtNamedFunction)element3).getFunKeyword();
            if (psiElement2 == null) return false;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.funKeyword ?: return false");
            PsiElement funKeyword = psiElement2;
            KtParameterList ktParameterList = ((KtNamedFunction)element3).getValueParameterList();
            if (ktParameterList == null) return false;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameterList, (String)"element.valueParameterList ?: return false");
            valueParameterList = ktParameterList;
            n = caretOffset;
            if (PsiUtilsKt.getStartOffset(funKeyword) > n) return false;
            if (PsiUtilsKt.getEndOffset((PsiElement)valueParameterList) < n) {
                return false;
            }
            pair2 = TuplesKt.to((Object)("function '" + ((KtNamedFunction)element3).getName() + '\''), valueParameterList.getParameters());
        } else if (ktModifierListOwner instanceof KtSecondaryConstructor) {
            PsiElement constructorKeyword = ((KtSecondaryConstructor)element3).getConstructorKeyword();
            KtParameterList ktParameterList = ((KtSecondaryConstructor)element3).getValueParameterList();
            if (ktParameterList == null) return false;
            valueParameterList = ktParameterList;
            n = caretOffset;
            if (PsiUtilsKt.getStartOffset(constructorKeyword) > n) return false;
            if (PsiUtilsKt.getEndOffset((PsiElement)valueParameterList) < n) {
                return false;
            }
            pair2 = TuplesKt.to((Object)"secondary constructor", valueParameterList.getParameters());
        } else {
            if (!(ktModifierListOwner instanceof KtPrimaryConstructor)) return false;
            KtParameterList ktParameterList = ((KtPrimaryConstructor)element3).getValueParameterList();
            if (ktParameterList == null) return false;
            List<KtParameter> list2 = ktParameterList.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"(element.valueParameterL\u2026 return false).parameters");
            List<KtParameter> parameters2 = list2;
            KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull(parameters2);
            if (ktParameter != null) {
                if (ktParameter.hasDefaultValue()) {
                    return false;
                }
            }
            pair2 = TuplesKt.to((Object)"primary constructor", parameters2);
        }
        Pair pair3 = pair2;
        String string = (String)pair3.component1();
        List parameters3 = (List)pair3.component2();
        this.setText("Add '@JvmOverloads' annotation to " + (String)targetName);
        if (!Intrinsics.areEqual((Object)TargetPlatformDetector.getPlatform(element3.getContainingKtFile()), (Object)JvmPlatform.INSTANCE)) return false;
        List list3 = parameters3;
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"parameters");
        Iterable $this$any$iv = list3;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KtParameter)element$iv;
            boolean bl = false;
        } while (!it.hasDefaultValue());
        boolean bl = true;
        if (!bl) return false;
        if (ModifierListModifactorKt.findAnnotation(element3, AddJvmOverloadsIntentionKt.access$getAnnotationFqName$p()) != null) return false;
        return true;
    }

    @Override
    public void applyTo(@NotNull KtModifierListOwner element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3 instanceof KtPrimaryConstructor) {
            if (((KtPrimaryConstructor)element3).getConstructorKeyword() == null) {
                element3.addBefore(KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createConstructorKeyword(), (PsiElement)((KtPrimaryConstructor)element3).getValueParameterList());
            }
            ModifierListModifactorKt.addAnnotation$default(element3, AddJvmOverloadsIntentionKt.access$getAnnotationFqName$p(), null, " ", null, 10, null);
        } else {
            ModifierListModifactorKt.addAnnotation$default(element3, AddJvmOverloadsIntentionKt.access$getAnnotationFqName$p(), null, null, null, 14, null);
        }
    }

    public AddJvmOverloadsIntention() {
        super(KtModifierListOwner.class, "Add '@JvmOverloads' annotation", null, 4, null);
    }
}

