/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ConvertEnumToSealedClassIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertEnumToSealedClassIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClass;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class ConvertEnumToSealedClassIntention
extends SelfTargetingRangeIntention<KtClass> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClass element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.nameIdentifier ?: return null");
        PsiElement nameIdentifier = psiElement2;
        KtModifierList ktModifierList = element3.getModifierList();
        if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierList, (String)"element.modifierList?.ge\u2026M_KEYWORD) ?: return null");
        KtModifierList enumKeyword = ktModifierList;
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)enumKeyword), PsiUtilsKt.getEndOffset(nameIdentifier));
    }

    @Override
    public void applyTo(@NotNull KtClass element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        String string = element3.getName();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name ?: return");
        String name2 = string;
        CharSequence charSequence = name2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        for (KtDeclaration klass2 : KotlinRefactoringUtilKt.withExpectedActuals(element3)) {
            PsiElement nonWhiteSibling;
            PsiElement psiElement2;
            Object v9;
            PsiElement semicolon2;
            KtClassBody body2;
            block20: {
                Object v8;
                block19: {
                    KtClassBody ktClassBody;
                    ClassDescriptor classDescriptor2;
                    KtDeclaration ktDeclaration = klass2;
                    if (!(ktDeclaration instanceof KtClass)) {
                        ktDeclaration = null;
                    }
                    if ((KtClass)ktDeclaration == null) {
                        continue;
                    }
                    if (ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)klass2, null, 1, null) == null) {
                        continue;
                    }
                    boolean isExpect = classDescriptor2.isExpect();
                    boolean isActual = classDescriptor2.isActual();
                    klass2.removeModifier(KtTokens.ENUM_KEYWORD);
                    klass2.addModifier(KtTokens.SEALED_KEYWORD);
                    KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default(klass2, false, 2, null);
                    for (KtDeclaration member : ((KtClass)klass2).getDeclarations()) {
                        KtElementImplStub defaultEntry;
                        boolean $i$f$forEach;
                        if (!(member instanceof KtEnumEntry)) continue;
                        KtObjectDeclaration obj = (KtObjectDeclaration)psiFactory.createDeclaration("object " + ((KtEnumEntry)member).getName());
                        Object object = ((KtEnumEntry)member).getInitializerList();
                        if (object == null || (object = ((KtInitializerList)object).getInitializers()) == null) {
                            object = CollectionsKt.emptyList();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"member.initializerList?.\u2026itializers ?: emptyList()");
                        Object initializers = object;
                        Collection collection = (Collection)initializers;
                        boolean bl2 = false;
                        if (!collection.isEmpty()) {
                            Iterable $this$forEach$iv = (Iterable)initializers;
                            $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                                boolean bl3 = false;
                                StringBuilder stringBuilder = new StringBuilder().append(((KtClass)klass2).getName());
                                KtSuperTypeListEntry ktSuperTypeListEntry = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktSuperTypeListEntry, (String)"it");
                                obj.addSuperTypeListEntry(psiFactory.createSuperTypeCallEntry(stringBuilder.append(ktSuperTypeListEntry.getText()).toString()));
                            }
                        } else {
                            defaultEntry = isExpect ? (KtSuperTypeListEntry)psiFactory.createSuperTypeEntry(name2) : (KtSuperTypeListEntry)psiFactory.createSuperTypeCallEntry(name2 + "()");
                            obj.addSuperTypeListEntry((KtSuperTypeListEntry)defaultEntry);
                        }
                        if (isActual) {
                            obj.addModifier(KtTokens.ACTUAL_KEYWORD);
                        }
                        if (((KtEnumEntry)member).getBody() != null) {
                            $i$f$forEach = false;
                            boolean bl4 = false;
                            KtElementImplStub body3 = defaultEntry;
                            boolean bl5 = false;
                            obj.add((PsiElement)body3);
                        }
                        member.delete();
                        KtClass this_$iv = (KtClass)klass2;
                        boolean $i$f$addDeclaration = false;
                        KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody(this_$iv);
                        PsiElement psiElement3 = body$iv.getRBrace();
                        if (psiElement3 == null && (psiElement3 = body$iv.getLastChild()) == null) {
                            Intrinsics.throwNpe();
                        }
                        Iterator anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement3, (Class[])new Class[]{PsiWhiteSpace.class});
                        PsiElement psiElement4 = body$iv.addAfter(obj, (PsiElement)anchor$iv);
                        if (psiElement4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtObjectDeclaration");
                        }
                        KtObjectDeclaration cfr_ignored_0 = (KtObjectDeclaration)psiElement4;
                    }
                    if (((KtClass)klass2).getBody() == null) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    body2 = ktClassBody;
                    boolean bl8 = false;
                    Sequence $this$firstOrNull$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.getAllChildren((PsiElement)body2), (Function1)applyTo.3.semicolon.1.INSTANCE);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl9 = false;
                        ASTNode aSTNode = it.getNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
                        if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.SEMICOLON))) continue;
                        v8 = element$iv;
                        break block19;
                    }
                    v8 = null;
                }
                if ((semicolon2 = (PsiElement)v8) == null) continue;
                Sequence<PsiElement> $this$firstOrNull$iv = PsiUtilsKt.siblings(semicolon2, true, false);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl10 = false;
                    if (!(!(it instanceof PsiWhiteSpace))) continue;
                    v9 = element$iv;
                    break block20;
                }
                v9 = null;
            }
            if ((psiElement2 = (nonWhiteSibling = (PsiElement)v9)) == null || (psiElement2 = psiElement2.getPrevSibling()) == null) {
                psiElement2 = semicolon2;
            }
            body2.deleteChildRange(semicolon2, psiElement2);
            if (nonWhiteSibling == null) continue;
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)((KtClass)klass2).getProject());
            PsiElement psiElement5 = nonWhiteSibling.getFirstChild();
            if (psiElement5 == null) {
                psiElement5 = nonWhiteSibling;
            }
            codeStyleManager.reformat(psiElement5);
        }
    }

    public ConvertEnumToSealedClassIntention() {
        super(KtClass.class, "Convert to sealed class", null, 4, null);
    }
}

