/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/InfixCallToOrdinaryIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "idea"})
public final class InfixCallToOrdinaryIntention
extends SelfTargetingIntention<KtBinaryExpression> {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3.getOperationToken(), (Object)((Object)KtTokens.IDENTIFIER)) ^ true || element3.getLeft() == null || element3.getRight() == null) {
            return false;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = element3.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"element.operationReference");
        return ktOperationReferenceExpression.getTextRange().containsOffset(caretOffset);
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Companion.convert(element3);
    }

    public InfixCallToOrdinaryIntention() {
        super(KtBinaryExpression.class, "Replace infix call with ordinary call", null, 4, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/InfixCallToOrdinaryIntention$Companion;", "", "()V", "convert", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "idea"})
    public static final class Companion {
        @NotNull
        public final KtExpression convert(@NotNull KtBinaryExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            KtExpression ktExpression = element3.getRight();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize(ktExpression);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"KtPsiUtil.safeDeparenthesize(element.right!!)");
            KtExpression argument2 = ktExpression2;
            KtExpression ktExpression3 = argument2;
            String pattern = "$0.$1" + (ktExpression3 instanceof KtLambdaExpression ? " $2:'{}'" : "($2)");
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            Object[] objectArray = new Object[3];
            KtExpression ktExpression4 = element3.getLeft();
            if (ktExpression4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"element.left!!");
            objectArray[0] = ktExpression4;
            KtOperationReferenceExpression ktOperationReferenceExpression = element3.getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"element.operationReference");
            String string = ktOperationReferenceExpression.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.operationReference.text");
            objectArray[1] = string;
            objectArray[2] = argument2;
            KtExpression replacement2 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, pattern, objectArray, false, 4, null);
            PsiElement psiElement2 = element3.replace((PsiElement)replacement2);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

