/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u001f\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00028\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u0006\u0010!\u001a\u00020\u0007J\u001d\u0010\"\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010%J\u001d\u0010\"\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020\u0007J#\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020$H\u0086\u0002J\u001d\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010.\u001a\u00020'H&\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$J\u0010\u00101\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\b\u00102\u001a\u00020\u0017H\u0016J\b\u00103\u001a\u00020\u0007H\u0016R\u0014\u0010\n\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00102\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "TElement", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "elementType", "Ljava/lang/Class;", "text", "", "familyName", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)V", "defaultText", "getDefaultText", "()Ljava/lang/String;", "getElementType", "()Ljava/lang/Class;", "<set-?>", "Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;", "inspection", "getInspection", "()Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;", "setInspection$idea_core", "(Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;)V", "allowCaretInsideElement", "", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "equals", "other", "", "getFamilyName", "getTarget", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;)Lcom/intellij/psi/PsiElement;", "offset", "", "(ILcom/intellij/psi/PsiFile;)Lcom/intellij/psi/PsiElement;", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "isApplicableTo", "caretOffset", "(Lcom/intellij/psi/PsiElement;I)Z", "isAvailable", "setText", "startInWriteAction", "toString", "idea-core"})
public abstract class SelfTargetingIntention<TElement extends PsiElement>
implements IntentionAction {
    @NotNull
    private final String defaultText;
    @Nullable
    private IntentionBasedInspection<TElement> inspection;
    @NotNull
    private final Class<TElement> elementType;
    private String text;
    private final String familyName;

    @NotNull
    protected final String getDefaultText() {
        return this.defaultText;
    }

    protected final void setText(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.text = text2;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getFamilyName() {
        return this.familyName;
    }

    public abstract boolean isApplicableTo(@NotNull TElement var1, int var2);

    public abstract void applyTo(@NotNull TElement var1, @Nullable Editor var2);

    @Nullable
    public final TElement getTarget(int offset2, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PsiElement leaf1 = file2.findElementAt(offset2);
        PsiElement leaf2 = file2.findElementAt(offset2 - 1);
        PsiElement commonParent = leaf1 != null && leaf2 != null ? PsiTreeUtil.findCommonParent((PsiElement)leaf1, (PsiElement)leaf2) : null;
        Sequence elementsToCheck = SequencesKt.emptySequence();
        if (leaf1 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParentsWithSelf(leaf1), (Function1)((Function1)new Function1<PsiElement, Boolean>(commonParent){
                final /* synthetic */ PsiElement $commonParent;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$commonParent) ^ true;
                }
                {
                    this.$commonParent = psiElement2;
                    super(1);
                }
            })));
        }
        if (leaf2 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParentsWithSelf(leaf2), (Function1)((Function1)new Function1<PsiElement, Boolean>(commonParent){
                final /* synthetic */ PsiElement $commonParent;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$commonParent) ^ true;
                }
                {
                    this.$commonParent = psiElement2;
                    super(1);
                }
            })));
        }
        if (commonParent != null && !(commonParent instanceof PsiFile)) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, PsiUtilsKt.getParentsWithSelf(commonParent));
        }
        for (PsiElement element3 : elementsToCheck) {
            if (this.elementType.isInstance(element3)) {
                PsiElement psiElement2 = element3;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type TElement");
                }
                if (this.isApplicableTo(psiElement2, offset2)) {
                    return (TElement)element3;
                }
            }
            if (this.allowCaretInsideElement(element3)) continue;
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
            if (!PsiUtilsKt.containsInside(textRange, offset2)) continue;
            break;
        }
        return null;
    }

    @Nullable
    public final TElement getTarget(@NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset2 = caretModel.getOffset();
        return this.getTarget(offset2, file2);
    }

    protected boolean allowCaretInsideElement(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return !(element3 instanceof KtBlockExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            CreateByPatternKt.setCREATE_BY_PATTERN_MAY_NOT_REFORMAT(true);
        }
        try {
            boolean bl = this.getTarget(editor2, file2) != null;
            return bl;
        }
        finally {
            CreateByPatternKt.setCREATE_BY_PATTERN_MAY_NOT_REFORMAT(false);
        }
    }

    @Nullable
    public final IntentionBasedInspection<TElement> getInspection() {
        return this.inspection;
    }

    public final void setInspection$idea_core(@Nullable IntentionBasedInspection<TElement> intentionBasedInspection) {
        this.inspection = intentionBasedInspection;
    }

    public final void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (editor2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        TElement TElement = this.getTarget(editor2, file2);
        if (TElement == null) {
            return;
        }
        TElement target = TElement;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(target)) {
            return;
        }
        this.applyTo(target, editor2);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof IntentionWrapper) {
            return Intrinsics.areEqual((Object)this, (Object)((IntentionWrapper)other).getAction());
        }
        if (other instanceof IntentionBasedInspection.IntentionBasedQuickFix) {
            return Intrinsics.areEqual((Object)this, ((IntentionBasedInspection.IntentionBasedQuickFix)((Object)other)).getIntention());
        }
        return other instanceof SelfTargetingIntention && Intrinsics.areEqual(this.getClass(), ((SelfTargetingIntention)other).getClass()) && Intrinsics.areEqual((Object)this.text, (Object)((SelfTargetingIntention)other).text);
    }

    @NotNull
    public final Class<TElement> getElementType() {
        return this.elementType;
    }

    public SelfTargetingIntention(@NotNull Class<TElement> elementType, @NotNull String text2, @NotNull String familyName) {
        Intrinsics.checkParameterIsNotNull(elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)familyName, (String)"familyName");
        this.elementType = elementType;
        this.text = text2;
        this.familyName = familyName;
        this.defaultText = this.text;
    }

    public /* synthetic */ SelfTargetingIntention(Class clazz, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            string2 = string;
        }
        this(clazz, string, string2);
    }
}

