/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SplitIfIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFirstValidOperator", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getRight", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "condition", "commentSaver", "Lorg/jetbrains/kotlin/idea/util/CommentSaver;", "isApplicableTo", "", "caretOffset", "", "isOperatorValid", "idea"})
public final class SplitIfIntention
extends SelfTargetingIntention<KtExpression> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            if (!(ktExpression instanceof KtIfExpression)) return false;
            if (this.getFirstValidOperator((KtIfExpression)element3) == null) return false;
            PsiElement psiElement2 = ((KtIfExpression)element3).getIfKeyword();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.ifKeyword");
            if (!psiElement2.getTextRange().containsOffset(caretOffset)) return false;
            return true;
        }
        boolean bl = this.isOperatorValid((KtOperationReferenceExpression)element3);
        return bl;
    }

    @Override
    public void applyTo(@NotNull KtExpression element3, @Nullable Editor editor2) {
        KtIfExpression ktIfExpression;
        KtIfExpression ifExpression2;
        KtOperationReferenceExpression ktOperationReferenceExpression;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        if (ktExpression instanceof KtIfExpression) {
            ktOperationReferenceExpression = this.getFirstValidOperator((KtIfExpression)element3);
            if (ktOperationReferenceExpression == null) {
                Intrinsics.throwNpe();
            }
        } else {
            ktOperationReferenceExpression = (KtOperationReferenceExpression)element3;
        }
        KtOperationReferenceExpression operator = ktOperationReferenceExpression;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)operator;
        boolean $i$f$getNonStrictParentOfType = false;
        KtIfExpression ktIfExpression2 = ifExpression2 = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtIfExpression.class, (boolean)false);
        if (ktIfExpression2 == null) {
            Intrinsics.throwNpe();
        }
        CommentSaver commentSaver = new CommentSaver((PsiElement)ktIfExpression2, false, 2, null);
        PsiElement psiElement2 = operator.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtBinaryExpression expression2 = (KtBinaryExpression)psiElement2;
        KtExpression ktExpression2 = ifExpression2.getCondition();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ifExpression.condition!!");
        KtExpression ktExpression3 = KtPsiUtil.safeDeparenthesize(this.getRight(expression2, ktExpression2, commentSaver));
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"KtPsiUtil.safeDeparenthe\u2026ndition!!, commentSaver))");
        KtExpression rightExpression = ktExpression3;
        KtExpression ktExpression4 = expression2.getLeft();
        if (ktExpression4 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression5 = KtPsiUtil.safeDeparenthesize(ktExpression4);
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"KtPsiUtil.safeDeparenthesize(expression.left!!)");
        KtExpression leftExpression = ktExpression5;
        KtExpression ktExpression6 = ifExpression2.getThen();
        if (ktExpression6 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"ifExpression.then!!");
        KtExpression thenBranch = ktExpression6;
        KtExpression elseBranch = ifExpression2.getElse();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        KtIfExpression innerIf = psiFactory.createIf(rightExpression, thenBranch, elseBranch);
        IElementType iElementType = operator.getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            ktIfExpression = psiFactory.createIf(leftExpression, KtPsiFactory.createSingleStatementBlock$default(psiFactory, innerIf, null, null, 6, null), elseBranch);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            PsiElement container2 = ifExpression2.getParent();
            if (container2 instanceof KtBlockExpression && elseBranch == null && UtilsKt.isExitStatement(KtPsiUtilKt.lastBlockStatementOrThis(thenBranch))) {
                PsiElement secondIf = container2.addAfter((PsiElement)innerIf, (PsiElement)ifExpression2);
                container2.addAfter(psiFactory.createNewLine(), (PsiElement)ifExpression2);
                PsiElement firstIf = ifExpression2.replace((PsiElement)KtPsiFactory.createIf$default(psiFactory, leftExpression, thenBranch, null, 4, null));
                CommentSaver.restore$default(commentSaver, new PsiChildRange(firstIf, secondIf), false, false, false, 14, null);
                return;
            }
            ktIfExpression = psiFactory.createIf(leftExpression, thenBranch, innerIf);
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        KtIfExpression newIf = ktIfExpression;
        PsiElement result2 = ifExpression2.replace((PsiElement)newIf);
        CommentSaver.restore$default(commentSaver, result2, false, 2, null);
    }

    private final KtExpression getRight(KtBinaryExpression element3, KtExpression condition2, CommentSaver commentSaver) {
        TextRange conditionRange = RangeUtilsKt.getRange((PsiElement)condition2);
        KtExpression ktExpression = element3.getRight();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.right!!");
        int startOffset = PsiUtilsKt.getStartOffset((PsiElement)ktExpression) - RangeUtilsKt.getStart(conditionRange);
        int endOffset = conditionRange.getLength();
        String string = condition2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"condition.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(startOffset, endOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String rightString = string4;
        KtExpression expression2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression(rightString);
        commentSaver.elementCreatedByText((PsiElement)expression2, (PsiElement)condition2, new TextRange(startOffset, endOffset));
        return expression2;
    }

    private final KtOperationReferenceExpression getFirstValidOperator(KtIfExpression element3) {
        Object v3;
        block2: {
            KtExpression ktExpression = element3.getCondition();
            if (ktExpression == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.condition ?: return null");
            KtExpression condition2 = ktExpression;
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)condition2), KtOperationReferenceExpression.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"PsiTreeUtil.findChildren\u2026ceExpression::class.java)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtOperationReferenceExpression it = (KtOperationReferenceExpression)element$iv;
                boolean bl = false;
                KtOperationReferenceExpression ktOperationReferenceExpression = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"it");
                if (!this.isOperatorValid(ktOperationReferenceExpression)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        return v3;
    }

    private final boolean isOperatorValid(KtOperationReferenceExpression element3) {
        KtBinaryExpression expression2;
        block10: {
            IElementType operator = element3.getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)operator, (Object)((Object)KtTokens.ANDAND)) ^ true && Intrinsics.areEqual((Object)operator, (Object)((Object)KtTokens.OROR)) ^ true) {
                return false;
            }
            PsiElement psiElement2 = element3.getParent();
            if (!(psiElement2 instanceof KtBinaryExpression)) {
                psiElement2 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
            if (ktBinaryExpression == null) {
                return false;
            }
            expression2 = ktBinaryExpression;
            if (expression2.getRight() == null || expression2.getLeft() == null) {
                return false;
            }
            do {
                PsiElement psiElement3;
                if (!((psiElement3 = expression2.getParent()) instanceof KtBinaryExpression)) {
                    psiElement3 = null;
                }
                if ((KtBinaryExpression)psiElement3 != null) continue;
                break block10;
            } while (!(Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)operator) ^ true));
            return false;
        }
        PsiElement psiElement4 = expression2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"expression.parent");
        PsiElement psiElement5 = psiElement4.getParent();
        if (!(psiElement5 instanceof KtIfExpression)) {
            psiElement5 = null;
        }
        KtIfExpression ktIfExpression = (KtIfExpression)psiElement5;
        if (ktIfExpression == null) {
            return false;
        }
        KtIfExpression ifExpression2 = ktIfExpression;
        if (ifExpression2.getCondition() == null) {
            return false;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ifExpression2.getCondition()), (PsiElement)((PsiElement)element3), (boolean)false)) {
            return false;
        }
        return ifExpression2.getThen() != null;
    }

    public SplitIfIntention() {
        super(KtExpression.class, "Split 'if' into two", null, 4, null);
    }
}

