/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a)\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000b\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\r\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u00010\u0003H\u0002\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\r\u001a\u0014\u0010\u0010\u001a\u00020\u0003*\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a8\u0006\u0011"}, d2={"appendConditionWithSubjectRemoved", "", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "conditionExpression", "subject", "combineWhenConditions", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "conditions", "", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "(Lorg/jetbrains/kotlin/psi/KtPsiFactory;[Lorg/jetbrains/kotlin/psi/KtWhenCondition;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "getSubjectToIntroduce", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "getWhenConditionSubjectCandidate", "introduceSubject", "toExpression", "idea"})
public final class BranchedTransformationUtilsKt {
    @NotNull
    public static final KtExpression toExpression(@NotNull KtWhenCondition $this$toExpression, @Nullable KtExpression subject) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$this$toExpression, (String)"$this$toExpression");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$this$toExpression, false, 2, null);
        KtWhenCondition ktWhenCondition = $this$toExpression;
        if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            Object object;
            String op = ((KtWhenConditionIsPattern)$this$toExpression).isNegated() ? "!is" : "is";
            String string = "$0 " + op + " $1";
            Object[] objectArray = new Object[2];
            Object object2 = subject;
            if (object2 == null) {
                object2 = objectArray[0] = "_";
            }
            if ((object = ((KtWhenConditionIsPattern)$this$toExpression).getTypeReference()) == null) {
                object = "";
            }
            objectArray[1] = object;
            ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, string, objectArray, false, 4, null);
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            Object object;
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtWhenConditionInRange)$this$toExpression).getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"operationReference");
            String op = ktOperationReferenceExpression.getText();
            String string = "$0 " + op + " $1";
            Object[] objectArray = new Object[2];
            Object object3 = subject;
            if (object3 == null) {
                object3 = objectArray[0] = "_";
            }
            if ((object = ((KtWhenConditionInRange)$this$toExpression).getRangeExpression()) == null) {
                object = "";
            }
            objectArray[1] = object;
            ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, string, objectArray, false, 4, null);
        } else if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            if (subject != null) {
                Object[] objectArray = new Object[2];
                objectArray[0] = subject;
                Object object = ((KtWhenConditionWithExpression)$this$toExpression).getExpression();
                if (object == null) {
                    object = "";
                }
                objectArray[1] = object;
                ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "$0 == $1", objectArray, false, 4, null);
            } else {
                KtExpression ktExpression2 = ((KtWhenConditionWithExpression)$this$toExpression).getExpression();
                if (ktExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                ktExpression = ktExpression2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression!!");
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown JetWhenCondition type: " + $this$toExpression);
        }
        return ktExpression;
    }

    @Nullable
    public static final KtExpression getSubjectToIntroduce(@NotNull KtWhenExpression $this$getSubjectToIntroduce) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getSubjectToIntroduce, (String)"$this$getSubjectToIntroduce");
        if ($this$getSubjectToIntroduce.getSubjectExpression() != null) {
            return null;
        }
        KtExpression lastCandidate = null;
        Iterator<KtWhenEntry> iterator2 = $this$getSubjectToIntroduce.getEntries().iterator();
        while (iterator2.hasNext()) {
            KtWhenCondition[] conditions2;
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry.getConditions(), (String)"entry.conditions");
            if (!entry.isElse()) {
                KtWhenCondition[] ktWhenConditionArray = conditions2;
                int n = 0;
                if (ktWhenConditionArray.length == 0) {
                    return null;
                }
            }
            for (KtWhenCondition condition2 : conditions2) {
                KtNameReferenceExpression candidate2;
                if (!(condition2 instanceof KtWhenConditionWithExpression)) {
                    return null;
                }
                KtExpression ktExpression = ((KtWhenConditionWithExpression)condition2).getExpression();
                KtExpression ktExpression2 = ktExpression != null ? BranchedTransformationUtilsKt.getWhenConditionSubjectCandidate(ktExpression) : null;
                if (!(ktExpression2 instanceof KtNameReferenceExpression)) {
                    ktExpression2 = null;
                }
                if ((KtNameReferenceExpression)ktExpression2 == null) {
                    return null;
                }
                if (lastCandidate == null) {
                    lastCandidate = candidate2;
                    continue;
                }
                if (KotlinPsiUnifierKt.matches((PsiElement)lastCandidate, (PsiElement)candidate2)) continue;
                return null;
            }
        }
        return lastCandidate;
    }

    private static final KtExpression getWhenConditionSubjectCandidate(@Nullable KtExpression $this$getWhenConditionSubjectCandidate) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = $this$getWhenConditionSubjectCandidate;
        if (ktExpression2 instanceof KtIsExpression) {
            ktExpression = ((KtIsExpression)$this$getWhenConditionSubjectCandidate).getLeftHandSide();
        } else if (ktExpression2 instanceof KtBinaryExpression) {
            IElementType op;
            KtExpression lhs = ((KtBinaryExpression)$this$getWhenConditionSubjectCandidate).getLeft();
            IElementType iElementType = ((KtBinaryExpression)$this$getWhenConditionSubjectCandidate).getOperationToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"operationToken");
            IElementType iElementType2 = op = iElementType;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.IN_KEYWORD)) || Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.NOT_IN))) {
                ktExpression = lhs;
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.EQEQ))) {
                KtExpression ktExpression3 = lhs;
                if (!(ktExpression3 instanceof KtNameReferenceExpression)) {
                    ktExpression3 = null;
                }
                KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression3;
                ktExpression = ktNameReferenceExpression != null ? (KtExpression)ktNameReferenceExpression : ((KtBinaryExpression)$this$getWhenConditionSubjectCandidate).getRight();
            } else {
                KtExpression rightCandidate;
                KtExpression leftCandidate;
                ktExpression = Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.OROR)) ? (KotlinPsiUnifierKt.matches((PsiElement)(leftCandidate = BranchedTransformationUtilsKt.getWhenConditionSubjectCandidate(lhs)), (PsiElement)(rightCandidate = BranchedTransformationUtilsKt.getWhenConditionSubjectCandidate(((KtBinaryExpression)$this$getWhenConditionSubjectCandidate).getRight()))) ? leftCandidate : null) : null;
            }
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    @Nullable
    public static final KtWhenExpression introduceSubject(@NotNull KtWhenExpression $this$introduceSubject) {
        KtWhenExpression ktWhenExpression;
        Intrinsics.checkParameterIsNotNull((Object)$this$introduceSubject, (String)"$this$introduceSubject");
        KtExpression ktExpression = BranchedTransformationUtilsKt.getSubjectToIntroduce($this$introduceSubject);
        if (ktExpression == null) {
            return null;
        }
        KtExpression subject = ktExpression;
        CommentSaver commentSaver = new CommentSaver((PsiElement)$this$introduceSubject, true);
        KtExpression ktExpression2 = CreateByPatternKt.buildExpression$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$this$introduceSubject, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>($this$introduceSubject, subject){
            final /* synthetic */ KtWhenExpression $this_introduceSubject;
            final /* synthetic */ KtExpression $subject;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                Intrinsics.checkParameterIsNotNull($this$buildExpression, (String)"$receiver");
                $this$buildExpression.appendFixedText("when(").appendExpression(this.$subject).appendFixedText("){\n");
                Iterator<KtWhenEntry> iterator2 = this.$this_introduceSubject.getEntries().iterator();
                while (iterator2.hasNext()) {
                    KtWhenEntry entry;
                    KtWhenEntry ktWhenEntry = entry = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
                    KtExpression branchExpression = ktWhenEntry.getExpression();
                    if (entry.isElse()) {
                        $this$buildExpression.appendFixedText("else");
                    } else {
                        KtWhenCondition[] ktWhenConditionArray;
                        Intrinsics.checkExpressionValueIsNotNull((Object)entry.getConditions(), (String)"entry.conditions");
                        int n = ktWhenConditionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            void i2;
                            KtWhenCondition condition2 = ktWhenConditionArray[n2];
                            if (i2 > 0) {
                                $this$buildExpression.appendFixedText(",");
                            }
                            KtWhenCondition ktWhenCondition = condition2;
                            if (ktWhenCondition == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenConditionWithExpression");
                            }
                            KtExpression conditionExpression = ((KtWhenConditionWithExpression)ktWhenCondition).getExpression();
                            BranchedTransformationUtilsKt.access$appendConditionWithSubjectRemoved($this$buildExpression, conditionExpression, this.$subject);
                            ++i2;
                        }
                    }
                    $this$buildExpression.appendFixedText("->");
                    $this$buildExpression.appendExpression(branchExpression);
                    $this$buildExpression.appendFixedText("\n");
                }
                $this$buildExpression.appendFixedText("}");
            }
            {
                this.$this_introduceSubject = ktWhenExpression;
                this.$subject = ktExpression;
                super(1);
            }
        }, 1, null);
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
        }
        KtWhenExpression whenExpression2 = (KtWhenExpression)ktExpression2;
        PsiElement $this$replaced$iv = (PsiElement)$this$introduceSubject;
        boolean $i$f$replaced = false;
        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)whenExpression2);
        PsiElement psiElement2 = result$iv;
        if (!(psiElement2 instanceof KtWhenExpression)) {
            psiElement2 = null;
        }
        if ((ktWhenExpression = (KtWhenExpression)psiElement2) == null) {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
            }
            ktWhenExpression = (KtWhenExpression)ktExpression3;
        }
        KtWhenExpression result2 = ktWhenExpression;
        CommentSaver.restore$default(commentSaver, (PsiElement)result2, false, 2, null);
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void appendConditionWithSubjectRemoved(@NotNull BuilderByPattern<KtExpression> $this$appendConditionWithSubjectRemoved, KtExpression conditionExpression, KtExpression subject) {
        KtExpression ktExpression = conditionExpression;
        if (ktExpression instanceof KtIsExpression) {
            if (((KtIsExpression)conditionExpression).isNegated()) {
                $this$appendConditionWithSubjectRemoved.appendFixedText("!");
            }
            $this$appendConditionWithSubjectRemoved.appendFixedText("is ");
            Object object = ((KtIsExpression)conditionExpression).getTypeReference();
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            $this$appendConditionWithSubjectRemoved.appendNonFormattedText((String)object);
            return;
        } else {
            IElementType op;
            if (!(ktExpression instanceof KtBinaryExpression)) throw (Throwable)new IllegalStateException();
            KtExpression lhs = ((KtBinaryExpression)conditionExpression).getLeft();
            KtExpression rhs = ((KtBinaryExpression)conditionExpression).getRight();
            IElementType iElementType = ((KtBinaryExpression)conditionExpression).getOperationToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"conditionExpression.operationToken");
            IElementType iElementType2 = op = iElementType;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.IN_KEYWORD))) {
                $this$appendConditionWithSubjectRemoved.appendFixedText("in ").appendExpression(rhs);
                return;
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.NOT_IN))) {
                $this$appendConditionWithSubjectRemoved.appendFixedText("!in ").appendExpression(rhs);
                return;
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.EQEQ))) {
                $this$appendConditionWithSubjectRemoved.appendExpression(KotlinPsiUnifierKt.matches((PsiElement)subject, (PsiElement)lhs) ? rhs : lhs);
                return;
            } else {
                if (!Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.OROR))) throw (Throwable)new IllegalStateException();
                BranchedTransformationUtilsKt.appendConditionWithSubjectRemoved($this$appendConditionWithSubjectRemoved, lhs, subject);
                $this$appendConditionWithSubjectRemoved.appendFixedText(", ");
                BranchedTransformationUtilsKt.appendConditionWithSubjectRemoved($this$appendConditionWithSubjectRemoved, rhs, subject);
            }
        }
    }

    @Nullable
    public static final KtExpression combineWhenConditions(@NotNull KtPsiFactory $this$combineWhenConditions, @NotNull KtWhenCondition[] conditions2, @Nullable KtExpression subject) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$this$combineWhenConditions, (String)"$this$combineWhenConditions");
        Intrinsics.checkParameterIsNotNull((Object)conditions2, (String)"conditions");
        switch (conditions2.length) {
            case 0: {
                ktExpression = null;
                break;
            }
            case 1: {
                ktExpression = BranchedTransformationUtilsKt.toExpression(conditions2[0], subject);
                break;
            }
            default: {
                ktExpression = CreateByPatternKt.buildExpression$default($this$combineWhenConditions, false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(conditions2, subject){
                    final /* synthetic */ KtWhenCondition[] $conditions;
                    final /* synthetic */ KtExpression $subject;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                        Collection<KtExpression> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkParameterIsNotNull($this$buildExpression, (String)"$receiver");
                        KtWhenCondition[] ktWhenConditionArray = this.$conditions;
                        BuilderByPattern<KtExpression> builderByPattern = $this$buildExpression;
                        boolean $i$f$map = false;
                        void var4_5 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        void var7_8 = $this$mapTo$iv$iv;
                        int n = ((void)var7_8).length;
                        for (int j = 0; j < n; ++j) {
                            void it;
                            void item$iv$iv;
                            void var11_12 = item$iv$iv = var7_8[j];
                            collection = destination$iv$iv;
                            boolean bl = false;
                            KtExpression ktExpression = BranchedTransformationUtilsKt.toExpression((KtWhenCondition)it, this.$subject);
                            collection.add(ktExpression);
                        }
                        collection = (List)destination$iv$iv;
                        builderByPattern.appendExpressions((Iterable<KtExpression>)collection, "||");
                    }
                    {
                        this.$conditions = ktWhenConditionArray;
                        this.$subject = ktExpression;
                        super(1);
                    }
                }, 1, null);
            }
        }
        return ktExpression;
    }

    public static final /* synthetic */ void access$appendConditionWithSubjectRemoved(BuilderByPattern $this$access_u24appendConditionWithSubjectRemoved, KtExpression conditionExpression, KtExpression subject) {
        BranchedTransformationUtilsKt.appendConditionWithSubjectRemoved($this$access_u24appendConditionWithSubjectRemoved, conditionExpression, subject);
    }
}

