/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchingState;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.SequenceTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatch;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatcher;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/MapTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/SequenceTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "indexVariable", "mapping", "Lorg/jetbrains/kotlin/psi/KtExpression;", "mapNotNull", "", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "affectsIndex", "getAffectsIndex", "()Z", "functionName", "", "getIndexVariable", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getInputVariable", "getLoop", "()Lorg/jetbrains/kotlin/psi/KtForExpression;", "getMapNotNull", "getMapping", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "presentation", "getPresentation", "()Ljava/lang/String;", "generateCode", "chainedCallGenerator", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ChainedCallGenerator;", "Matcher", "idea"})
public final class MapTransformation
implements SequenceTransformation {
    private final String functionName;
    @NotNull
    private final KtForExpression loop;
    @NotNull
    private final KtCallableDeclaration inputVariable;
    @Nullable
    private final KtCallableDeclaration indexVariable;
    @NotNull
    private final KtExpression mapping;
    private final boolean mapNotNull;

    @Override
    public boolean getAffectsIndex() {
        return this.mapNotNull;
    }

    @Override
    @NotNull
    public String getPresentation() {
        return this.functionName + "{}";
    }

    @Override
    @NotNull
    public KtExpression generateCode(@NotNull ChainedCallGenerator chainedCallGenerator2) {
        Intrinsics.checkParameterIsNotNull((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
        KtLambdaExpression lambda2 = UtilsKt.generateLambda(this.inputVariable, this.indexVariable, this.mapping, chainedCallGenerator2.getReformat());
        return ChainedCallGenerator.DefaultImpls.generate$default(chainedCallGenerator2, this.functionName + "$0:'{}'", new Object[]{lambda2}, null, false, 12, null);
    }

    @Override
    @NotNull
    public KtForExpression getLoop() {
        return this.loop;
    }

    @NotNull
    public final KtCallableDeclaration getInputVariable() {
        return this.inputVariable;
    }

    @Nullable
    public final KtCallableDeclaration getIndexVariable() {
        return this.indexVariable;
    }

    @NotNull
    public final KtExpression getMapping() {
        return this.mapping;
    }

    public final boolean getMapNotNull() {
        return this.mapNotNull;
    }

    public MapTransformation(@NotNull KtForExpression loop, @NotNull KtCallableDeclaration inputVariable, @Nullable KtCallableDeclaration indexVariable, @NotNull KtExpression mapping2, boolean mapNotNull2) {
        Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
        Intrinsics.checkParameterIsNotNull((Object)inputVariable, (String)"inputVariable");
        Intrinsics.checkParameterIsNotNull((Object)mapping2, (String)"mapping");
        this.loop = loop;
        this.inputVariable = inputVariable;
        this.indexVariable = indexVariable;
        this.mapping = mapping2;
        this.mapNotNull = mapNotNull2;
        this.functionName = this.indexVariable != null ? (this.mapNotNull ? "mapIndexedNotNull" : "mapIndexed") : (this.mapNotNull ? "mapNotNull" : "map");
    }

    @Override
    @Nullable
    public SequenceTransformation mergeWithPrevious(@NotNull SequenceTransformation previousTransformation, boolean reformat) {
        Intrinsics.checkParameterIsNotNull((Object)previousTransformation, (String)"previousTransformation");
        return SequenceTransformation.DefaultImpls.mergeWithPrevious(this, previousTransformation, reformat);
    }

    @Override
    @NotNull
    public String buildPresentation(@Nullable String prevTransformationsPresentation) {
        return SequenceTransformation.DefaultImpls.buildPresentation(this, prevTransformationsPresentation);
    }

    @Override
    public int getChainCallCount() {
        return SequenceTransformation.DefaultImpls.getChainCallCount(this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/MapTransformation$Matcher;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatcher;", "()V", "embeddedBreakOrContinuePossible", "", "getEmbeddedBreakOrContinuePossible", "()Z", "indexVariableAllowed", "getIndexVariableAllowed", "match", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatch$Sequence;", "state", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/MatchingState;", "idea"})
    public static final class Matcher
    implements TransformationMatcher {
        public static final Matcher INSTANCE;

        @Override
        public boolean getIndexVariableAllowed() {
            return true;
        }

        @Override
        public boolean getEmbeddedBreakOrContinuePossible() {
            return true;
        }

        @Override
        @Nullable
        public TransformationMatch.Sequence match(@NotNull MatchingState state) {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Object object = CollectionsKt.firstOrNull(state.getStatements());
            if (!(object instanceof KtProperty)) {
                object = null;
            }
            KtProperty ktProperty = (KtProperty)object;
            if (ktProperty == null) {
                return null;
            }
            KtProperty declaration2 = ktProperty;
            KtExpression ktExpression = declaration2.getInitializer();
            if (ktExpression == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"declaration.initializer ?: return null");
            KtExpression initializer2 = ktExpression;
            if (CommonUtilsKt.hasWriteUsages(declaration2)) {
                return null;
            }
            List restStatements = CollectionsKt.drop((Iterable)state.getStatements(), (int)1);
            if (initializer2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)initializer2).getOperationToken(), (Object)((Object)KtTokens.ELVIS))) {
                KtExpression ktExpression2 = ((KtBinaryExpression)initializer2).getRight();
                if (!(ktExpression2 instanceof KtContinueExpression)) {
                    ktExpression2 = null;
                }
                KtContinueExpression ktContinueExpression = (KtContinueExpression)ktExpression2;
                if (ktContinueExpression == null) {
                    return null;
                }
                KtContinueExpression continueExpression = ktContinueExpression;
                if (Intrinsics.areEqual((Object)CommonUtilsKt.targetLoop(continueExpression), (Object)state.getInnerLoop()) ^ true) {
                    return null;
                }
                KtExpression ktExpression3 = ((KtBinaryExpression)initializer2).getLeft();
                if (ktExpression3 == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"initializer.left ?: return null");
                KtExpression mapping2 = ktExpression3;
                if (UtilsKt.containsEmbeddedBreakOrContinue(mapping2)) {
                    return null;
                }
                MapTransformation transformation = state.getIndexVariable() != null && CommonUtilsKt.hasUsages(state.getIndexVariable(), mapping2) ? new MapTransformation(state.getOuterLoop(), state.getInputVariable(), state.getIndexVariable(), mapping2, true) : new MapTransformation(state.getOuterLoop(), state.getInputVariable(), null, mapping2, true);
                MatchingState newState = MatchingState.copy$default(state, null, null, restStatements, declaration2, null, false, null, false, null, null, null, 2035, null);
                return new TransformationMatch.Sequence(transformation, newState);
            }
            if (UtilsKt.containsEmbeddedBreakOrContinue(initializer2)) {
                return null;
            }
            MapTransformation transformation = state.getIndexVariable() != null && CommonUtilsKt.hasUsages(state.getIndexVariable(), initializer2) ? new MapTransformation(state.getOuterLoop(), state.getInputVariable(), state.getIndexVariable(), initializer2, false) : new MapTransformation(state.getOuterLoop(), state.getInputVariable(), null, initializer2, false);
            MatchingState newState = MatchingState.copy$default(state, null, null, restStatements, declaration2, null, false, null, false, null, null, null, 2035, null);
            return new TransformationMatch.Sequence(transformation, newState);
        }

        private Matcher() {
        }

        static {
            Matcher matcher2;
            INSTANCE = matcher2 = new Matcher();
        }

        @Override
        public boolean getShouldUseInputVariables() {
            return TransformationMatcher.DefaultImpls.getShouldUseInputVariables(this);
        }
    }
}

