/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.parameterInfo.custom;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.diff.util.DiffUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.parameterInfo.HintType;
import org.jetbrains.kotlin.idea.parameterInfo.LambdaReturnValueHintsKt;
import org.jetbrains.kotlin.idea.parameterInfo.custom.KotlinCodeHintsModel;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00032\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/KotlinCodeHintsPass;", "Lcom/intellij/codeHighlighting/EditorBoundHighlightingPass;", "myRootElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "myTraverser", "Lcom/intellij/psi/SyntaxTraverser;", "canShowHintsAtOffset", "", "offset", "", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processLambdaReturnHints", "element", "actualElements", "", "", "Companion", "idea"})
public final class KotlinCodeHintsPass
extends EditorBoundHighlightingPass {
    private final SyntaxTraverser<PsiElement> myTraverser;
    private final PsiElement myRootElement;
    public static final Companion Companion = new Companion(null);

    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkParameterIsNotNull((Object)progress2, (String)"progress");
        PsiFile psiFile = this.myFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"myFile");
        if (Intrinsics.areEqual((Object)psiFile.getLanguage(), (Object)((Object)KotlinLanguage.INSTANCE)) ^ true) {
            return;
        }
        if (this.myDocument == null) {
            return;
        }
        Project project = this.myRootElement.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myRootElement.project");
        KotlinCodeHintsModel kotlinCodeHintsModel = KotlinCodeHintsModel.Companion.getInstance(project);
        InlayParameterHintsProvider provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage((Language)KotlinLanguage.INSTANCE);
        if (provider2 == null || !provider2.canShowHintsWhenDisabled() && !KotlinCodeHintsPass.Companion.isEnabled() || DiffUtil.isDiffEditor((Editor)this.myEditor)) {
            kotlinCodeHintsModel.removeAll(this.myDocument);
            return;
        }
        if (HintType.LAMBDA_RETURN_EXPRESSION.getEnabled()) {
            HashMap actualHints = new HashMap();
            Iterable $this$forEach$iv = (Iterable)this.myTraverser;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement element3 = (PsiElement)element$iv;
                boolean bl = false;
                PsiElement psiElement2 = element3;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
                this.processLambdaReturnHints(psiElement2, actualHints);
            }
            kotlinCodeHintsModel.update(this.myDocument, actualHints);
        } else {
            kotlinCodeHintsModel.removeAll(this.myDocument);
        }
    }

    private final void processLambdaReturnHints(PsiElement element3, Map<PsiElement, String> actualElements) {
        if (!(element3 instanceof KtExpression)) {
            return;
        }
        for (InlayInfo returnHint : LambdaReturnValueHintsKt.provideLambdaReturnValueHints((KtExpression)element3)) {
            int offset2 = returnHint.getOffset();
            if (!this.canShowHintsAtOffset(offset2)) continue;
            actualElements.put(element3, StringsKt.substringAfter$default((String)returnHint.getText(), (String)"@TYPE@", null, (int)2, null));
        }
    }

    public void doApplyInformationToEditor() {
    }

    private final boolean canShowHintsAtOffset(int offset2) {
        TextRange rootRange;
        TextRange textRange = rootRange = this.myRootElement.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"rootRange");
        if (textRange.getStartOffset() < offset2 && offset2 < rootRange.getEndOffset()) {
            return true;
        }
        return this.myDocument != null && this.myDocument.getTextLength() == rootRange.getLength();
    }

    public KotlinCodeHintsPass(@NotNull PsiElement myRootElement, @NotNull Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)myRootElement, (String)"myRootElement");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        super(editor2, myRootElement.getContainingFile(), true);
        this.myRootElement = myRootElement;
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)this.myRootElement);
        Intrinsics.checkExpressionValueIsNotNull((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(myRootElement)");
        this.myTraverser = syntaxTraverser;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/KotlinCodeHintsPass$Companion;", "", "()V", "isEnabled", "", "()Z", "Factory", "idea"})
    public static final class Companion {
        private final boolean isEnabled() {
            EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
            return editorSettingsExternalizable.isShowParameterNameHints();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/KotlinCodeHintsPass$Companion$Factory;", "Lcom/intellij/openapi/components/ProjectComponent;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "(Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
        public static final class Factory
        implements ProjectComponent,
        TextEditorHighlightingPassFactory {
            @Nullable
            public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
                if (Intrinsics.areEqual((Object)file2.getLanguage(), (Object)((Object)KotlinLanguage.INSTANCE)) ^ true) {
                    return null;
                }
                return (TextEditorHighlightingPass)new KotlinCodeHintsPass((PsiElement)file2, editor2);
            }

            public Factory(@NotNull TextEditorHighlightingPassRegistrar registrar) {
                Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
                registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
            }
        }
    }
}

