/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.project.KotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/project/KotlinCodeBlockModificationListener;", "", "modificationTracker", "Lcom/intellij/psi/util/PsiModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "treeAspect", "Lcom/intellij/pom/tree/TreeAspect;", "(Lcom/intellij/psi/util/PsiModificationTracker;Lcom/intellij/openapi/project/Project;Lcom/intellij/pom/tree/TreeAspect;)V", "lastAffectedModule", "Lcom/intellij/openapi/module/Module;", "lastAffectedModuleModCount", "", "modificationTrackerImpl", "Lcom/intellij/psi/impl/PsiModificationTrackerImpl;", "perModuleChangesHighwatermark", "Ljava/lang/Long;", "perModuleModCount", "", "getModificationCount", "module", "hasPerModuleModificationCounts", "", "Companion", "idea-core"})
public final class KotlinCodeBlockModificationListener {
    private final Map<Module, Long> perModuleModCount;
    private final PsiModificationTrackerImpl modificationTrackerImpl;
    private Module lastAffectedModule;
    private long lastAffectedModuleModCount;
    private Long perModuleChangesHighwatermark;
    private final TreeAspect treeAspect;
    private static final Class<? extends KtDeclaration>[] BLOCK_DECLARATION_TYPES;
    public static final Companion Companion;

    public final long getModificationCount(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Long l = this.perModuleModCount.get(module);
        if (l == null) {
            l = this.perModuleChangesHighwatermark;
        }
        return l != null ? l.longValue() : this.modificationTrackerImpl.getOutOfCodeBlockModificationCount();
    }

    public final boolean hasPerModuleModificationCounts() {
        return this.perModuleChangesHighwatermark != null;
    }

    public KotlinCodeBlockModificationListener(@NotNull PsiModificationTracker modificationTracker2, @NotNull Project project, @NotNull TreeAspect treeAspect) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)modificationTracker2, (String)"modificationTracker");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)treeAspect, (String)"treeAspect");
        this.treeAspect = treeAspect;
        KotlinCodeBlockModificationListener kotlinCodeBlockModificationListener = this;
        boolean bl = false;
        kotlinCodeBlockModificationListener.perModuleModCount = map2 = (Map)new LinkedHashMap();
        this.modificationTrackerImpl = (PsiModificationTrackerImpl)modificationTracker2;
        this.lastAffectedModuleModCount = -1L;
        PomModel pomModel = PomManager.getModel((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)pomModel, (String)"PomManager.getModel(project)");
        PomModel model = pomModel;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect()");
        final MessageBusConnection messageBusConnection2 = messageBusConnection;
        model.addModelListener(new PomModelListener(){

            public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
                Intrinsics.checkParameterIsNotNull((Object)aspect, (String)"aspect");
                return Intrinsics.areEqual((Object)aspect, (Object)treeAspect);
            }

            public void modelChanged(@NotNull PomModelEvent event) {
                block11: {
                    KtFile file2;
                    block10: {
                        boolean bl;
                        ASTNode[] changedElements;
                        block9: {
                            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                            TreeChangeEvent treeChangeEvent = (TreeChangeEvent)event.getChangeSet((PomModelAspect)treeAspect);
                            if (treeChangeEvent == null) {
                                return;
                            }
                            TreeChangeEvent changeSet = treeChangeEvent;
                            ASTNode aSTNode = changeSet.getRootElement();
                            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"changeSet.rootElement");
                            PsiElement psiElement2 = aSTNode.getPsi();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"changeSet.rootElement.psi");
                            PsiFile psiFile = psiElement2.getContainingFile();
                            if (!(psiFile instanceof KtFile)) {
                                psiFile = null;
                            }
                            KtFile ktFile2 = (KtFile)psiFile;
                            if (ktFile2 == null) {
                                return;
                            }
                            file2 = ktFile2;
                            ASTNode[] aSTNodeArray = changeSet.getChangedElements();
                            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNodeArray, (String)"changeSet.changedElements");
                            ASTNode[] $this$any$iv = changedElements = aSTNodeArray;
                            boolean $i$f$any = false;
                            ASTNode[] aSTNodeArray2 = $this$any$iv;
                            int n = aSTNodeArray2.length;
                            for (int j = 0; j < n; ++j) {
                                ASTNode element$iv;
                                ASTNode it = element$iv = aSTNodeArray2[j];
                                boolean bl2 = false;
                                ASTNode aSTNode2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"it");
                                PsiElement psiElement3 = aSTNode2.getPsi();
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"it.psi");
                                if (!(Companion.getInsideCodeBlockModificationScope(psiElement3) == null)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                        if (bl) break block10;
                        ASTNode[] aSTNodeArray = changedElements;
                        boolean bl3 = false;
                        if (!(aSTNodeArray.length == 0)) break block11;
                    }
                    messageBusConnection2.deliverImmediately();
                    if (file2.isPhysical()) {
                        VirtualFile virtualFile2 = file2.getVirtualFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
                        if (!Companion.isReplLine(virtualFile2)) {
                            lastAffectedModule = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file2));
                            lastAffectedModuleModCount = modificationTrackerImpl.getOutOfCodeBlockModificationCount();
                            modificationTrackerImpl.incCounter();
                        }
                    }
                    Companion.incOutOfBlockModificationCount(file2);
                }
            }
        });
        messageBusConnection2.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public final void modificationCountChanged() {
                long newModCount = modificationTrackerImpl.getOutOfCodeBlockModificationCount();
                Module affectedModule = lastAffectedModule;
                if (affectedModule != null && newModCount == lastAffectedModuleModCount + 1L) {
                    if (perModuleChangesHighwatermark == null) {
                        perModuleChangesHighwatermark = lastAffectedModuleModCount;
                    }
                    perModuleModCount.put(affectedModule, newModCount);
                } else {
                    perModuleChangesHighwatermark = null;
                    perModuleModCount.clear();
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        BLOCK_DECLARATION_TYPES = new Class[]{KtProperty.class, KtNamedFunction.class, KtScriptInitializer.class};
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0019H\u0002R\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/project/KotlinCodeBlockModificationListener$Companion;", "", "()V", "BLOCK_DECLARATION_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "[Ljava/lang/Class;", "getInsideCodeBlockModificationScope", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "Lcom/intellij/psi/PsiElement;", "getInstance", "Lorg/jetbrains/kotlin/idea/project/KotlinCodeBlockModificationListener;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "incOutOfBlockModificationCount", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isBlockDeclaration", "", "declaration", "isReplLine", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-core"})
    public static final class Companion {
        private final boolean isReplLine(VirtualFile file2) {
            return Intrinsics.areEqual((Object)((Boolean)file2.getUserData(KotlinCodeBlockModificationListenerKt.getKOTLIN_CONSOLE_KEY())), (Object)true);
        }

        private final void incOutOfBlockModificationCount(KtFile file2) {
            Long l = (Long)file2.getUserData(KotlinCodeBlockModificationListenerKt.access$getFILE_OUT_OF_BLOCK_MODIFICATION_COUNT$p());
            if (l == null) {
                l = 0L;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"file.getUserData(FILE_OU\u2026_MODIFICATION_COUNT) ?: 0");
            long count = l;
            file2.putUserData(KotlinCodeBlockModificationListenerKt.access$getFILE_OUT_OF_BLOCK_MODIFICATION_COUNT$p(), count + 1L);
        }

        @Nullable
        public final KtElement getInsideCodeBlockModificationScope(@NotNull PsiElement element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Object $this$getTopmostParentOfType$iv = element3;
            boolean $i$f$getTopmostParentOfType = false;
            KtLambdaExpression lambda2 = (KtLambdaExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)$this$getTopmostParentOfType$iv, KtLambdaExpression.class);
            if (lambda2 instanceof KtLambdaExpression) {
                $this$getTopmostParentOfType$iv = (PsiElement)lambda2;
                $i$f$getTopmostParentOfType = false;
                KtSuperTypeCallEntry ktSuperTypeCallEntry = (KtSuperTypeCallEntry)PsiTreeUtil.getTopmostParentOfType((PsiElement)$this$getTopmostParentOfType$iv, KtSuperTypeCallEntry.class);
                if (ktSuperTypeCallEntry != null) {
                    $this$getTopmostParentOfType$iv = ktSuperTypeCallEntry;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = $this$getTopmostParentOfType$iv;
                    boolean bl3 = false;
                    return (KtElement)it;
                }
            }
            Class[] classArray = BLOCK_DECLARATION_TYPES;
            PsiElement psiElement2 = KtPsiUtil.getTopmostParentOfTypes(element3, Arrays.copyOf(classArray, classArray.length));
            if (!(psiElement2 instanceof KtDeclaration)) {
                psiElement2 = null;
            }
            KtDeclaration ktDeclaration = (KtDeclaration)psiElement2;
            if (ktDeclaration == null) {
                return null;
            }
            KtDeclaration blockDeclaration = ktDeclaration;
            if (KtPsiUtil.isLocal(blockDeclaration)) {
                return null;
            }
            KtDeclaration ktDeclaration2 = blockDeclaration;
            if (ktDeclaration2 instanceof KtNamedFunction) {
                if (((KtNamedFunction)blockDeclaration).hasBlockBody()) {
                    KtExpression ktExpression;
                    KtExpression ktExpression2 = ((KtNamedFunction)blockDeclaration).getBodyExpression();
                    if (ktExpression2 != null) {
                        KtExpression ktExpression3 = ktExpression2;
                        boolean bl = false;
                        boolean bl4 = false;
                        KtExpression it = ktExpression3;
                        boolean bl5 = false;
                        ktExpression = PsiUtilsKt.isAncestor$default((PsiElement)it, element3, false, 2, null) ? ktExpression3 : null;
                    } else {
                        ktExpression = null;
                    }
                    return ktExpression;
                }
                if (((KtNamedFunction)blockDeclaration).hasDeclaredReturnType()) {
                    KtExpression ktExpression;
                    KtExpression ktExpression4 = ((KtNamedFunction)blockDeclaration).getInitializer();
                    if (ktExpression4 != null) {
                        KtExpression ktExpression5 = ktExpression4;
                        boolean bl = false;
                        boolean bl6 = false;
                        KtExpression it = ktExpression5;
                        boolean bl7 = false;
                        ktExpression = PsiUtilsKt.isAncestor$default((PsiElement)it, element3, false, 2, null) ? ktExpression5 : null;
                    } else {
                        ktExpression = null;
                    }
                    return ktExpression;
                }
            } else if (ktDeclaration2 instanceof KtProperty) {
                if (((KtProperty)blockDeclaration).getTypeReference() != null) {
                    Iterator<KtPropertyAccessor> iterator2 = ((KtProperty)blockDeclaration).getAccessors().iterator();
                    while (iterator2.hasNext()) {
                        KtExpression ktExpression;
                        KtPropertyAccessor accessor;
                        KtPropertyAccessor ktPropertyAccessor = accessor = iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor, (String)"accessor");
                        KtExpression ktExpression6 = ktPropertyAccessor.getInitializer();
                        if (ktExpression6 == null) {
                            ktExpression6 = ktExpression = accessor.getBodyExpression();
                        }
                        if (ktExpression6 == null) continue;
                        KtExpression ktExpression7 = ktExpression;
                        boolean it = false;
                        boolean bl7 = false;
                        KtExpression it2 = ktExpression7;
                        boolean bl = false;
                        ktExpression = PsiUtilsKt.isAncestor$default((PsiElement)it2, element3, false, 2, null) ? ktExpression7 : null;
                        if (ktExpression == null) continue;
                        ktExpression7 = ktExpression;
                        it = false;
                        bl7 = false;
                        it2 = ktExpression7;
                        boolean bl8 = false;
                        return it2;
                    }
                }
            } else {
                if (ktDeclaration2 instanceof KtScriptInitializer) {
                    Object object;
                    Object object2;
                    KtExpression ktExpression = ((KtScriptInitializer)blockDeclaration).getBody();
                    if (!(ktExpression instanceof KtCallExpression)) {
                        ktExpression = null;
                    }
                    if ((object2 = (KtCallExpression)ktExpression) != null && (object2 = ((KtCallExpression)object2).getLambdaArguments()) != null && (object2 = (KtLambdaArgument)CollectionsKt.lastOrNull((List)object2)) != null && (object2 = ((KtLambdaArgument)object2).getLambdaExpression()) != null) {
                        Object object3 = object2;
                        boolean bl = false;
                        boolean bl9 = false;
                        Object it = object3;
                        boolean bl10 = false;
                        object = PsiUtilsKt.isAncestor$default((PsiElement)it, element3, false, 2, null) ? object3 : null;
                    } else {
                        object = null;
                    }
                    return (KtElement)object;
                }
                throw (Throwable)new IllegalStateException();
            }
            return null;
        }

        public final boolean isBlockDeclaration(@NotNull KtDeclaration declaration2) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                Class[] $this$any$iv = BLOCK_DECLARATION_TYPES;
                boolean $i$f$any = false;
                Class[] classArray = $this$any$iv;
                int n = classArray.length;
                for (int j = 0; j < n; ++j) {
                    Class element$iv;
                    Class it = element$iv = classArray[j];
                    boolean bl2 = false;
                    if (!it.isInstance(declaration2)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public final KotlinCodeBlockModificationListener getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (KotlinCodeBlockModificationListener)project.getComponent(KotlinCodeBlockModificationListener.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

