/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;

public class KtDeclarationTreeNode
extends AbstractPsiBasedNode<KtDeclaration> {
    public static final String CLASS_INITIALIZER = "<class initializer>";

    protected KtDeclarationTreeNode(Project project, KtDeclaration ktDeclaration, ViewSettings viewSettings) {
        super(project, (Object)ktDeclaration, viewSettings);
    }

    protected PsiElement extractPsiFromValue() {
        return (PsiElement)this.getValue();
    }

    protected Collection<AbstractTreeNode> getChildrenImpl() {
        return Collections.emptyList();
    }

    protected void updateImpl(PresentationData data) {
        KtDeclaration declaration2 = (KtDeclaration)this.getValue();
        if (declaration2 != null) {
            String text2;
            String string = text2 = declaration2 instanceof KtAnonymousInitializer ? CLASS_INITIALIZER : declaration2.getName();
            if (text2 == null) {
                return;
            }
            KotlinCodeStyleSettings settings2 = (KotlinCodeStyleSettings)CodeStyle.getSettings((Project)this.getProject()).getCustomSettings(KotlinCodeStyleSettings.class);
            if (declaration2 instanceof KtProperty) {
                KtProperty property2 = (KtProperty)declaration2;
                KtTypeReference ref2 = property2.getTypeReference();
                if (ref2 != null) {
                    if (settings2.SPACE_BEFORE_TYPE_COLON) {
                        text2 = text2 + " ";
                    }
                    text2 = text2 + ":";
                    if (settings2.SPACE_AFTER_TYPE_COLON) {
                        text2 = text2 + " ";
                    }
                    text2 = text2 + ref2.getText();
                }
            } else if (declaration2 instanceof KtFunction) {
                KtFunction function2 = (KtFunction)declaration2;
                KtTypeReference receiverTypeRef = function2.getReceiverTypeReference();
                if (receiverTypeRef != null) {
                    text2 = receiverTypeRef.getText() + "." + text2;
                }
                text2 = text2 + "(";
                List<KtParameter> parameters2 = function2.getValueParameters();
                for (KtParameter parameter : parameters2) {
                    KtTypeReference typeReference2;
                    if (parameter.getName() != null) {
                        text2 = text2 + parameter.getName();
                        if (settings2.SPACE_BEFORE_TYPE_COLON) {
                            text2 = text2 + " ";
                        }
                        text2 = text2 + ":";
                        if (settings2.SPACE_AFTER_TYPE_COLON) {
                            text2 = text2 + " ";
                        }
                    }
                    if ((typeReference2 = parameter.getTypeReference()) != null) {
                        text2 = text2 + typeReference2.getText();
                    }
                    text2 = text2 + ", ";
                }
                if (parameters2.size() > 0) {
                    text2 = text2.substring(0, text2.length() - 2);
                }
                text2 = text2 + ")";
                KtTypeReference typeReference3 = function2.getTypeReference();
                if (typeReference3 != null) {
                    if (settings2.SPACE_BEFORE_TYPE_COLON) {
                        text2 = text2 + " ";
                    }
                    text2 = text2 + ":";
                    if (settings2.SPACE_AFTER_TYPE_COLON) {
                        text2 = text2 + " ";
                    }
                    text2 = text2 + typeReference3.getText();
                }
            }
            data.setPresentableText(text2);
        }
    }

    protected boolean isDeprecated() {
        return KtPsiUtil.isDeprecated((KtModifierListOwner)this.getValue());
    }
}

