/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddReturnToUnusedLastExpressionInFunctionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "isLastStatementInFunctionBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Factory", "idea"})
public final class AddReturnToUnusedLastExpressionInFunctionFix
extends KotlinQuickFixAction<KtElement> {
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getText() {
        return "Add 'return' before the expression";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Object t = this.getElement();
        if (!(t instanceof KtExpression)) {
            t = null;
        }
        KtExpression ktExpression = (KtExpression)t;
        if (ktExpression == null) {
            return false;
        }
        KtExpression expr2 = ktExpression;
        BindingContext context2 = ResolutionUtils.analyze(expr2, BodyResolveMode.PARTIAL);
        if (!this.isLastStatementInFunctionBody(expr2)) {
            return false;
        }
        KotlinType kotlinType2 = CallUtilKt.getType(expr2, context2);
        if (kotlinType2 == null) {
            return false;
        }
        KotlinType exprType = kotlinType2;
        if (KotlinTypeKt.isError(exprType)) {
            return false;
        }
        PsiElement psiElement2 = expr2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"expr.parent");
        PsiElement psiElement3 = psiElement2.getParent();
        if (!(psiElement3 instanceof KtNamedFunction)) {
            psiElement3 = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement3;
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction function2 = ktNamedFunction;
        Annotated annotated = ResolutionUtils.resolveToDescriptorIfAny$default(function2, null, 1, null);
        if (annotated == null || (annotated = annotated.getReturnType()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)annotated, (String)"function.resolveToDescri\u2026eturnType ?: return false");
        Annotated functionReturnType = annotated;
        return !KotlinTypeKt.isError((KotlinType)functionReturnType) && TypeUtilsKt.isSubtypeOf(exprType, (KotlinType)functionReturnType);
    }

    private final boolean isLastStatementInFunctionBody(@NotNull KtExpression $this$isLastStatementInFunctionBody) {
        PsiElement psiElement2 = $this$isLastStatementInFunctionBody.getParent();
        if (!(psiElement2 instanceof KtBlockExpression)) {
            psiElement2 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement2;
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression body2 = ktBlockExpression;
        List<KtExpression> list2 = body2.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"body.statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull(list2);
        if (ktExpression == null) {
            return false;
        }
        KtExpression last = ktExpression;
        return last == $this$isLastStatementInFunctionBody;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement element3 = ktElement;
        element3.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression("return " + element3.getText()));
    }

    public AddReturnToUnusedLastExpressionInFunctionFix(@NotNull KtElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddReturnToUnusedLastExpressionInFunctionFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @Override
        @NotNull
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.UNUSED_EXPRESSION.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.UNUSED_EXPRESSION.cast(diagnostic)");
            SimpleDiagnostic casted = (SimpleDiagnostic)d;
            Object e = casted.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"casted.psiElement");
            return new AddReturnToUnusedLastExpressionInFunctionFix((KtElement)e);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

