/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfo;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\"\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\nH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeParameterTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lorg/jetbrains/kotlin/types/KotlinType;)V", "containingDeclarationName", "", "isPrimaryConstructorParameter", "", "typeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinTypeInfo;", "typePresentation", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "startInWriteAction", "idea"})
public final class ChangeParameterTypeFix
extends KotlinQuickFixAction<KtParameter> {
    private final String typePresentation;
    private final KotlinTypeInfo typeInfo;
    private final String containingDeclarationName;
    private final boolean isPrimaryConstructorParameter;

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.containingDeclarationName != null;
    }

    @NotNull
    public String getText() {
        KtParameter ktParameter = (KtParameter)this.getElement();
        if (ktParameter == null) {
            return "";
        }
        KtParameter element3 = ktParameter;
        return this.isPrimaryConstructorParameter ? "Change parameter '" + element3.getName() + "' type of primary constructor of class '" + this.containingDeclarationName + "' to '" + this.typePresentation + '\'' : "Change parameter '" + element3.getName() + "' type of function '" + this.containingDeclarationName + "' to '" + this.typePresentation + '\'';
    }

    @NotNull
    public String getFamilyName() {
        String string = KotlinBundle.message("change.type.family", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBundle.message(\"change.type.family\")");
        return string;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtParameter ktParameter = (KtParameter)this.getElement();
        if (ktParameter == null) {
            return;
        }
        KtParameter element3 = ktParameter;
        PsiElement $this$getStrictParentOfType$iv = element3;
        boolean $i$f$getStrictParentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtFunction.class, (boolean)true);
        if (ktFunction == null) {
            return;
        }
        KtFunction function2 = ktFunction;
        int parameterIndex2 = function2.getValueParameters().indexOf(element3);
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny(function2, BodyResolveMode.FULL);
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        KotlinChangeSignatureConfiguration configuration2 = new KotlinChangeSignatureConfiguration(this, parameterIndex2){
            final /* synthetic */ ChangeParameterTypeFix this$0;
            final /* synthetic */ int $parameterIndex;

            @NotNull
            public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                KotlinMethodDescriptor kotlinMethodDescriptor = originalDescriptor;
                boolean bl = false;
                boolean bl2 = false;
                KotlinMethodDescriptor $this$apply = kotlinMethodDescriptor;
                boolean bl3 = false;
                ((KotlinParameterInfo)$this$apply.getParameters().get($this$apply.getReceiver() != null ? this.$parameterIndex + 1 : this.$parameterIndex)).setCurrentTypeInfo(ChangeParameterTypeFix.access$getTypeInfo$p(this.this$0));
                return kotlinMethodDescriptor;
            }

            public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                return true;
            }
            {
                this.this$0 = $outer;
                this.$parameterIndex = $captured_local_variable$1;
            }

            public boolean forcePerformForSelectedFunctionOnly() {
                return KotlinChangeSignatureConfiguration.DefaultImpls.forcePerformForSelectedFunctionOnly(this);
            }
        };
        Project project2 = element3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"element.project");
        KotlinChangeSignatureKt.runChangeSignature(project2, descriptor2, configuration2, element3, this.getText());
    }

    public ChangeParameterTypeFix(@NotNull KtParameter element3, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element3);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.renderType(type2);
        this.typeInfo = new KotlinTypeInfo(false, null, IdeDescriptorRenderers.SOURCE_CODE_NOT_NULL_TYPE_APPROXIMATION.renderType(type2), 2, null);
        KtNamedDeclaration declaration2 = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element3, KtNamedDeclaration.class);
        Object object = declaration2;
        if (object == null || (object = object.getFqName()) == null || (object = ((FqName)object).asString()) == null) {
            KtNamedDeclaration ktNamedDeclaration = declaration2;
            object = ktNamedDeclaration != null ? ktNamedDeclaration.getName() : null;
        }
        this.containingDeclarationName = object;
        this.isPrimaryConstructorParameter = declaration2 instanceof KtPrimaryConstructor;
    }

    public static final /* synthetic */ KotlinTypeInfo access$getTypeInfo$p(ChangeParameterTypeFix $this) {
        return $this.typeInfo;
    }
}

