/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "type", "", "(Lorg/jetbrains/kotlin/psi/KtProperty;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class ChangeToMutableCollectionFix
extends KotlinQuickFixAction<KtProperty> {
    private final String type;
    private static final String COLLECTIONS = "kotlin.collections";
    private static final Map<String, String> mutableConversionMap;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return "Change type to Mutable" + this.type;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtProperty ktProperty = (KtProperty)this.getElement();
            if (ktProperty == null) {
                return;
            }
            KtProperty property2 = ktProperty;
            BindingContext context2 = ResolutionUtils.analyze(property2, BodyResolveMode.PARTIAL);
            Object object = property2.getInitializer();
            if (object == null || (object = CallUtilKt.getType((KtExpression)object, context2)) == null) {
                return;
            }
            Object type2 = object;
            Companion.applyFix(property2, (KotlinType)type2);
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block2;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset(property2));
        }
    }

    public ChangeToMutableCollectionFix(@NotNull KtProperty property2, @NotNull String type2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)property2);
        this.type = type2;
    }

    static {
        Companion = new Companion(null);
        mutableConversionMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"kotlin.collections.listOf", (Object)"mutableListOf"), TuplesKt.to((Object)"kotlin.collections.setOf", (Object)"mutableSetOf"), TuplesKt.to((Object)"kotlin.collections.mapOf", (Object)"mutableMapOf")});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "COLLECTIONS", "", "mutableConversionMap", "", "applyFix", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isApplicable", "", "isReadOnlyListOrMap", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtProperty> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.NO_SET_METHOD.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.NO_SET_METHOD.cast(diagnostic)");
            Object e = ((SimpleDiagnostic)d).getPsiElement();
            if (!(e instanceof KtArrayAccessExpression)) {
                e = null;
            }
            KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)e;
            if (ktArrayAccessExpression == null) {
                return null;
            }
            KtArrayAccessExpression element3 = ktArrayAccessExpression;
            KtExpression ktExpression = element3.getArrayExpression();
            if (ktExpression == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.arrayExpression ?: return null");
            KtExpression arrayExpr = ktExpression;
            BindingContext context2 = ResolutionUtils.analyze(arrayExpr, BodyResolveMode.PARTIAL);
            KotlinType kotlinType2 = CallUtilKt.getType(arrayExpr, context2);
            if (kotlinType2 == null) {
                return null;
            }
            KotlinType type2 = kotlinType2;
            if (!this.isReadOnlyListOrMap(type2, PlatformKt.getBuiltIns(element3))) {
                return null;
            }
            KtReference ktReference = ReferenceUtilKt.getMainReference(arrayExpr);
            Object object = ktReference != null ? ktReference.resolve() : null;
            if (!(object instanceof KtProperty)) {
                object = null;
            }
            KtProperty ktProperty = (KtProperty)object;
            if (ktProperty == null) {
                return null;
            }
            KtProperty property2 = ktProperty;
            if (!this.isApplicable(property2)) {
                return null;
            }
            Object object2 = type2.getConstructor().getDeclarationDescriptor();
            if (object2 == null || (object2 = object2.getName()) == null || (object2 = ((Name)object2).asString()) == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"type.constructor.declara\u2026asString() ?: return null");
            Object typeName = object2;
            return new ChangeToMutableCollectionFix(property2, (String)typeName);
        }

        private final boolean isReadOnlyListOrMap(@NotNull KotlinType $this$isReadOnlyListOrMap, KotlinBuiltIns builtIns) {
            Annotated annotated = $this$isReadOnlyListOrMap.getConstructor().getDeclarationDescriptor();
            if (annotated == null || (annotated = annotated.getDefaultType()) == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)annotated, (String)"constructor.declarationD\u2026faultType ?: return false");
            Annotated leftDefaultType = annotated;
            Object[] objectArray = new SimpleType[2];
            ClassDescriptor classDescriptor2 = builtIns.getList();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"builtIns.list");
            objectArray[0] = classDescriptor2.getDefaultType();
            ClassDescriptor classDescriptor3 = builtIns.getMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"builtIns.map");
            objectArray[1] = classDescriptor3.getDefaultType();
            return CollectionsKt.listOf((Object[])objectArray).contains(leftDefaultType);
        }

        public final boolean isApplicable(@NotNull KtProperty property2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            return property2.isLocal() && property2.getInitializer() != null;
        }

        /*
         * WARNING - void declaration
         */
        public final void applyFix(@NotNull KtProperty property2, @NotNull KotlinType type2) {
            block22: {
                Object object;
                KtPsiFactory psiFactory;
                block21: {
                    KtExpression ktExpression;
                    void $this$replaced$iv;
                    String string;
                    PsiElement result$iv;
                    KtExpression initializer2;
                    block19: {
                        block20: {
                            KtExpression ktExpression2;
                            void $this$replaced$iv2;
                            KtExpression ktExpression3;
                            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                            KtExpression ktExpression4 = property2.getInitializer();
                            if (ktExpression4 == null) {
                                return;
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"property.initializer ?: return");
                            initializer2 = ktExpression4;
                            Object object2 = ResolutionUtils.resolveToCall$default(initializer2, null, 1, null);
                            String fqName2 = object2 != null && (object2 = object2.getResultingDescriptor()) != null && (object2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object2)) != null ? ((FqName)object2).asString() : null;
                            psiFactory = KtPsiFactoryKt.KtPsiFactory$default(property2, false, 2, null);
                            object = mutableConversionMap;
                            boolean bl = false;
                            String mutableOf = (String)object.get(fqName2);
                            if (mutableOf == null) break block19;
                            KtExpression ktExpression5 = initializer2;
                            if (!(ktExpression5 instanceof KtCallExpression)) {
                                ktExpression5 = null;
                            }
                            if ((ktExpression3 = (KtCallExpression)ktExpression5) == null || (ktExpression3 = ktExpression3.getCalleeExpression()) == null) break block20;
                            object = (PsiElement)ktExpression3;
                            PsiElement newElement$iv = (PsiElement)psiFactory.createExpression(mutableOf);
                            boolean $i$f$replaced = false;
                            result$iv = $this$replaced$iv2.replace(newElement$iv);
                            PsiElement psiElement2 = result$iv;
                            if (!(psiElement2 instanceof KtExpression)) {
                                psiElement2 = null;
                            }
                            if ((ktExpression2 = (KtExpression)psiElement2) == null) {
                                PsiElement psiElement3 = result$iv;
                                if (psiElement3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                }
                                ktExpression2 = ((KtParenthesizedExpression)psiElement3).getExpression();
                                if (ktExpression2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                }
                            }
                            ktExpression3 = ktExpression2;
                            if (ktExpression2 != null) break block21;
                        }
                        return;
                    }
                    KotlinBuiltIns builtIns = PlatformKt.getBuiltIns(property2);
                    TypeConstructor $i$f$replaced = type2.getConstructor();
                    ClassDescriptor classDescriptor2 = builtIns.getList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"builtIns.list");
                    if (Intrinsics.areEqual((Object)$i$f$replaced, (Object)classDescriptor2.getDefaultType().getConstructor())) {
                        string = "toMutableList";
                    } else {
                        ClassDescriptor classDescriptor3 = builtIns.getSet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"builtIns.set");
                        if (Intrinsics.areEqual((Object)$i$f$replaced, (Object)classDescriptor3.getDefaultType().getConstructor())) {
                            string = "toMutableSet";
                        } else {
                            ClassDescriptor classDescriptor4 = builtIns.getMap();
                            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor4, (String)"builtIns.map");
                            string = Intrinsics.areEqual((Object)$i$f$replaced, (Object)classDescriptor4.getDefaultType().getConstructor()) ? "toMutableMap" : null;
                        }
                    }
                    if (string == null) {
                        return;
                    }
                    String toMutable2 = string;
                    result$iv = (PsiElement)initializer2;
                    PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, "($0).$1()", new Object[]{initializer2, toMutable2}, false, 4, null);
                    boolean $i$f$replaced2 = false;
                    PsiElement result$iv2 = $this$replaced$iv.replace(newElement$iv);
                    PsiElement psiElement4 = result$iv2;
                    if (!(psiElement4 instanceof KtExpression)) {
                        psiElement4 = null;
                    }
                    if ((ktExpression = (KtExpression)psiElement4) == null) {
                        PsiElement psiElement5 = result$iv2;
                        if (psiElement5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        }
                        ktExpression = ((KtParenthesizedExpression)psiElement5).getExpression();
                        if (ktExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                    }
                    if (ktExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
                    }
                    KtDotQualifiedExpression dotQualifiedExpression = (KtDotQualifiedExpression)ktExpression;
                    KtExpression receiver2 = dotQualifiedExpression.getReceiverExpression();
                    KtExpression deparenthesize = KtPsiUtil.deparenthesize(dotQualifiedExpression.getReceiverExpression());
                    if (deparenthesize != null && Intrinsics.areEqual((Object)receiver2, (Object)deparenthesize) ^ true) {
                        receiver2.replace((PsiElement)deparenthesize);
                    }
                }
                KtTypeReference ktTypeReference = property2.getTypeReference();
                if (ktTypeReference == null) break block22;
                object = ktTypeReference;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Mutable");
                Object object3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                it.replace((PsiElement)psiFactory.createType(stringBuilder.append(object3.getText()).toString()));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

