/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.quickfix.EnableUnsupportedFeatureFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\r\u000e\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "element", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "apiVersionOnly", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature;Z)V", "getApiVersionOnly", "()Z", "getFeature", "()Lorg/jetbrains/kotlin/config/LanguageFeature;", "Companion", "InModule", "InProject", "Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix$InModule;", "Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix$InProject;", "idea-jvm"})
public abstract class EnableUnsupportedFeatureFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    private final LanguageFeature feature;
    private final boolean apiVersionOnly;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final LanguageFeature getFeature() {
        return this.feature;
    }

    protected final boolean getApiVersionOnly() {
        return this.apiVersionOnly;
    }

    private EnableUnsupportedFeatureFix(PsiElement element3, LanguageFeature feature, boolean apiVersionOnly) {
        super(element3);
        this.feature = feature;
        this.apiVersionOnly = apiVersionOnly;
    }

    public /* synthetic */ EnableUnsupportedFeatureFix(PsiElement element3, LanguageFeature feature, boolean apiVersionOnly, DefaultConstructorMarker $constructor_marker) {
        this(element3, feature, apiVersionOnly);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix$InModule;", "Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix;", "element", "Lcom/intellij/psi/PsiElement;", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "apiVersionOnly", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature;Z)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea-jvm"})
    public static final class InModule
    extends EnableUnsupportedFeatureFix {
        @NotNull
        public String getFamilyName() {
            return "Increase module " + (this.getApiVersionOnly() ? "API version" : "language version");
        }

        @NotNull
        public String getText() {
            String string;
            if (this.getApiVersionOnly()) {
                string = "Set module API version to " + this.getFeature().getSinceApiVersion().getVersionString();
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Set module language version to ");
                LanguageVersion languageVersion = this.getFeature().getSinceVersion();
                if (languageVersion == null) {
                    Intrinsics.throwNpe();
                }
                string = stringBuilder.append(languageVersion.getDescription()).toString();
            }
            return string;
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
            String string;
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file2));
            if (module == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026siElement(file) ?: return");
            Module module2 = module;
            KotlinFacetSettings facetSettings = KotlinFacetSettingsProvider.Companion.getInstance(project).getInitializedSettings(module2);
            LanguageVersion languageVersion = facetSettings.getApiLevel();
            if (languageVersion != null) {
                LanguageVersion languageVersion2 = languageVersion;
                boolean bl = false;
                boolean bl2 = false;
                LanguageVersion apiLevel = languageVersion2;
                boolean bl3 = false;
                string2 = ApiVersion.Companion.createByLanguageVersion(apiLevel).compareTo(this.getFeature().getSinceApiVersion()) < 0 ? this.getFeature().getSinceApiVersion().getVersionString() : null;
            } else {
                string2 = null;
            }
            String targetApiLevel = string2;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            ModuleFileIndex moduleFileIndex = moduleRootManager.getFileIndex();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleFileIndex, (String)"ModuleRootManager.getInstance(module).fileIndex");
            FileIndex fileIndex = (FileIndex)moduleFileIndex;
            VirtualFile virtualFile2 = file2.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
            boolean forTests = FileIndexUtilsKt.isInTestSourceContentKotlinAware(fileIndex, virtualFile2);
            KotlinProjectConfigurator kotlinProjectConfigurator = ConfigureKotlinInProjectUtilsKt.findApplicableConfigurator(module2);
            if (this.getApiVersionOnly()) {
                string = null;
            } else {
                LanguageVersion languageVersion3 = this.getFeature().getSinceVersion();
                if (languageVersion3 == null) {
                    Intrinsics.throwNpe();
                }
                string = languageVersion3.getVersionString();
            }
            kotlinProjectConfigurator.updateLanguageVersion(module2, string, targetApiLevel, this.getFeature().getSinceApiVersion(), forTests);
        }

        public InModule(@NotNull PsiElement element3, @NotNull LanguageFeature feature, boolean apiVersionOnly) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
            super(element3, feature, apiVersionOnly, null);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix$InProject;", "Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix;", "element", "Lcom/intellij/psi/PsiElement;", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "apiVersionOnly", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature;Z)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea-jvm"})
    public static final class InProject
    extends EnableUnsupportedFeatureFix {
        @NotNull
        public String getFamilyName() {
            return "Increase project " + (this.getApiVersionOnly() ? "API version" : "language version");
        }

        @NotNull
        public String getText() {
            String string;
            if (this.getApiVersionOnly()) {
                string = "Set project API version to " + this.getFeature().getSinceApiVersion().getVersionString();
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Set project language version to ");
                LanguageVersion languageVersion = this.getFeature().getSinceVersion();
                if (languageVersion == null) {
                    Intrinsics.throwNpe();
                }
                string = stringBuilder.append(languageVersion.getVersionString()).toString();
            }
            return string;
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            LanguageVersion languageVersion = this.getFeature().getSinceVersion();
            if (languageVersion == null) {
                Intrinsics.throwNpe();
            }
            LanguageVersion targetVersion = languageVersion;
            KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project).update((Function1)new Function1<CommonCompilerArguments, Unit>(this, project, targetVersion){
                final /* synthetic */ InProject this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ LanguageVersion $targetVersion;

                public final void invoke(@NotNull CommonCompilerArguments $this$update) {
                    ApiVersion parsedApiVersion;
                    ApiVersion apiVersion;
                    Intrinsics.checkParameterIsNotNull((Object)$this$update, (String)"$receiver");
                    String string = $this$update.getApiVersion();
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        apiVersion = ApiVersion.Companion.parse(it);
                    } else {
                        apiVersion = parsedApiVersion = null;
                    }
                    if (parsedApiVersion != null && this.this$0.getFeature().getSinceApiVersion().compareTo(parsedApiVersion) > 0) {
                        if (!EnableUnsupportedFeatureFixKt.checkUpdateRuntime(this.$project, this.this$0.getFeature().getSinceApiVersion())) {
                            return;
                        }
                        $this$update.setApiVersion(this.this$0.getFeature().getSinceApiVersion().getVersionString());
                    }
                    if (!this.this$0.getApiVersionOnly()) {
                        $this$update.setLanguageVersion(this.$targetVersion.getVersionString());
                    }
                }
                {
                    this.this$0 = inProject;
                    this.$project = project;
                    this.$targetVersion = languageVersion;
                    super(1);
                }
            });
            RootUtilsKt.invalidateProjectRoots(project);
        }

        public InProject(@NotNull PsiElement element3, @NotNull LanguageFeature feature, boolean apiVersionOnly) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
            super(element3, feature, apiVersionOnly, null);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/EnableUnsupportedFeatureFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea-jvm"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected EnableUnsupportedFeatureFix createAction(@NotNull Diagnostic diagnostic) {
            boolean apiVersionOnly;
            void feature;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.UNSUPPORTED_FEATURE.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.UNSUPPORTED_FEATURE.cast(diagnostic)");
            Pair pair2 = (Pair)((DiagnosticWithParameters1)d).getA();
            LanguageFeature languageFeature = (LanguageFeature)((Object)pair2.component1());
            LanguageVersionSettings languageFeatureSettings = (LanguageVersionSettings)pair2.component2();
            LanguageVersion languageVersion = feature.getSinceVersion();
            if (languageVersion == null) {
                return null;
            }
            LanguageVersion sinceVersion = languageVersion;
            boolean bl = apiVersionOnly = sinceVersion.compareTo((Enum)languageFeatureSettings.getLanguageVersion()) <= 0 && feature.getSinceApiVersion().compareTo(languageFeatureSettings.getApiVersion()) > 0;
            if (!sinceVersion.isStable()) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isInternal()) {
                    return null;
                }
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)diagnostic.getPsiElement());
            if (module == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026siElement) ?: return null");
            Module module2 = module;
            if (Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType(module2), (Object)BuildSystemType.JPS.INSTANCE)) {
                KotlinFacetSettings facetSettings;
                Object object = KotlinFacet.Companion.get(module2);
                KotlinFacetSettings kotlinFacetSettings = object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null ? object.getSettings() : (facetSettings = null);
                if (facetSettings == null || facetSettings.getUseProjectSettings()) {
                    PsiElement psiElement2 = diagnostic.getPsiElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
                    void v8 = feature;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"feature");
                    return new InProject(psiElement2, (LanguageFeature)v8, apiVersionOnly);
                }
            }
            PsiElement psiElement3 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"diagnostic.psiElement");
            void v10 = feature;
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"feature");
            return new InModule(psiElement3, (LanguageFeature)v10, apiVersionOnly);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

