/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.ExperimentalFixesFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.MakeModuleExperimentalFix;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ExperimentalFixesFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
public final class ExperimentalFixesFactory
extends KotlinIntentionActionsFactory {
    public static final ExperimentalFixesFactory INSTANCE;

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        KtClassOrObject containingClassOrObject;
        FqName fqName2;
        DiagnosticFactory<?> factory2;
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
        PsiElement element3 = psiElement2;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate(element3, true, new Class[]{KtDeclarationWithBody.class, KtClassOrObject.class, KtProperty.class, KtTypeAlias.class}, doCreateActions.containingDeclaration.1.INSTANCE);
        if (ktDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        KtDeclaration containingDeclaration2 = ktDeclaration;
        DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
        DiagnosticFactory<?> diagnosticFactory2 = factory2 = diagnosticFactory;
        if (Intrinsics.areEqual(diagnosticFactory2, Errors.EXPERIMENTAL_API_USAGE)) {
            Object d = Errors.EXPERIMENTAL_API_USAGE.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"EXPERIMENTAL_API_USAGE.cast(diagnostic)");
            fqName2 = (FqName)((DiagnosticWithParameters1)d).getA();
        } else if (Intrinsics.areEqual(diagnosticFactory2, Errors.EXPERIMENTAL_API_USAGE_ERROR)) {
            Object d = Errors.EXPERIMENTAL_API_USAGE_ERROR.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"EXPERIMENTAL_API_USAGE_ERROR.cast(diagnostic)");
            fqName2 = (FqName)((DiagnosticWithParameters1)d).getA();
        } else if (Intrinsics.areEqual(diagnosticFactory2, Errors.EXPERIMENTAL_OVERRIDE)) {
            Object d = Errors.EXPERIMENTAL_OVERRIDE.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"EXPERIMENTAL_OVERRIDE.cast(diagnostic)");
            fqName2 = (FqName)((DiagnosticWithParameters2)d).getA();
        } else if (Intrinsics.areEqual(diagnosticFactory2, Errors.EXPERIMENTAL_OVERRIDE_ERROR)) {
            Object d = Errors.EXPERIMENTAL_OVERRIDE_ERROR.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"EXPERIMENTAL_OVERRIDE_ERROR.cast(diagnostic)");
            fqName2 = (FqName)((DiagnosticWithParameters2)d).getA();
        } else {
            fqName2 = null;
        }
        if (fqName2 == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"when (factory) {\n       \u2026  } ?: return emptyList()");
        FqName annotationFqName = fqName2;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(containingDeclaration2, null, 1, null);
        if (declarationDescriptor == null || (declarationDescriptor = DescriptorUtilsKt.getModule(declarationDescriptor)) == null) {
            return CollectionsKt.emptyList();
        }
        DeclarationDescriptor moduleDescriptor2 = declarationDescriptor;
        ClassDescriptor classDescriptor2 = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)moduleDescriptor2, annotationFqName, NoLookupLocation.FROM_IDE);
        if (classDescriptor2 == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor annotationClassDescriptor = classDescriptor2;
        Set<KotlinTarget> set2 = AnnotationChecker.Companion.applicableTargetSet(annotationClassDescriptor);
        if (set2 == null) {
            set2 = KotlinTarget.Companion.getDEFAULT_TARGET_SET();
        }
        Set<KotlinTarget> applicableTargets = set2;
        PsiElement psiElement3 = element3;
        BindingContext context2 = psiElement3 instanceof KtElement ? ResolutionUtils.analyze$default((KtElement)element3, null, 1, null) : ResolutionUtils.analyze$default(containingDeclaration2, null, 1, null);
        Function2<KtDeclaration, Set<? extends KotlinTarget>, Boolean> $fun$isApplicableTo$1 = new Function2<KtDeclaration, Set<? extends KotlinTarget>, Boolean>(context2){
            final /* synthetic */ BindingContext $context;

            public final boolean invoke(@NotNull KtDeclaration declaration2, @NotNull Set<? extends KotlinTarget> applicableTargets) {
                boolean bl;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                    Intrinsics.checkParameterIsNotNull(applicableTargets, (String)"applicableTargets");
                    KtElement ktElement = declaration2;
                    DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
                    if (!(declarationDescriptor instanceof ClassDescriptor)) {
                        declarationDescriptor = null;
                    }
                    List<KotlinTarget> actualTargetList = AnnotationChecker.Companion.getDeclarationSiteActualTargetList(ktElement, (ClassDescriptor)declarationDescriptor, this.$context);
                    Iterable $this$any$iv = actualTargetList;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            boolean bl2 = false;
                            if (!applicableTargets.contains((Object)((Object)it))) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$context = bindingContext2;
                super(2);
            }
        };
        boolean bl = false;
        List result2 = new ArrayList();
        ExperimentalFixesFactory experimentalFixesFactory = this;
        boolean bl2 = false;
        boolean bl3 = false;
        ExperimentalFixesFactory $this$run = experimentalFixesFactory;
        boolean bl4 = false;
        String suffix = " to '" + containingDeclaration2.getName() + '\'';
        if ($fun$isApplicableTo$1.invoke(containingDeclaration2, applicableTargets)) {
            result2.add(new AddAnnotationFix(containingDeclaration2, annotationFqName, suffix, null, 8, null));
        }
        result2.add(new AddAnnotationFix(containingDeclaration2, ExperimentalUsageChecker.Companion.getUSE_EXPERIMENTAL_FQ_NAME(), suffix, annotationFqName));
        if (containingDeclaration2 instanceof KtCallableDeclaration && (containingClassOrObject = KtPsiUtilKt.getContainingClassOrObject(containingDeclaration2)) != null) {
            String suffix2 = " to containing class '" + containingClassOrObject.getName() + '\'';
            if ($fun$isApplicableTo$1.invoke((KtDeclaration)containingClassOrObject, applicableTargets)) {
                result2.add(new AddAnnotationFix(containingClassOrObject, annotationFqName, suffix2, null, 8, null));
            } else {
                result2.add(new AddAnnotationFix(containingClassOrObject, ExperimentalUsageChecker.Companion.getUSE_EXPERIMENTAL_FQ_NAME(), suffix2, annotationFqName));
            }
        }
        KtFile ktFile2 = containingDeclaration2.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"containingDeclaration.containingKtFile");
        KtFile containingFile = ktFile2;
        Module module = ProjectStructureUtilKt.getModule((PsiElement)containingFile);
        if (module != null) {
            result2.add(new MakeModuleExperimentalFix(containingFile, module, annotationFqName));
        }
        return result2;
    }

    private ExperimentalFixesFactory() {
    }

    static {
        ExperimentalFixesFactory experimentalFixesFactory;
        INSTANCE = experimentalFixesFactory = new ExperimentalFixesFactory();
    }
}

