/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.RemoveEmptyPrimaryConstructorIntention;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedFunctionParameterFix;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.EditCommaSeparatedListHelper;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedFunctionParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "parameter", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "Companion", "idea"})
public final class RemoveUnusedFunctionParameterFix
extends KotlinQuickFixAction<KtParameter> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Change signature of function/constructor";
    }

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                object = (KtParameter)this.getElement();
                if (object == null) break block2;
                KtParameter ktParameter = object;
                boolean bl = false;
                boolean bl2 = false;
                KtParameter it = ktParameter;
                boolean bl3 = false;
                object = "Remove parameter '" + it.getName() + '\'';
                if (object != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        RemoveEmptyPrimaryConstructorIntention removeConstructorIntention;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtParameter ktParameter = (KtParameter)this.getElement();
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter = ktParameter;
        PsiElement psiElement2 = parameter.getParent();
        if (!(psiElement2 instanceof KtParameterList)) {
            psiElement2 = null;
        }
        KtParameterList ktParameterList = (KtParameterList)psiElement2;
        if (ktParameterList == null) {
            return;
        }
        KtParameterList parameterList2 = ktParameterList;
        ValueParameterDescriptor valueParameterDescriptor = ResolutionUtils.resolveToParameterDescriptorIfAny(parameter, BodyResolveMode.FULL);
        if (valueParameterDescriptor == null) {
            return;
        }
        ValueParameterDescriptor parameterDescriptor = valueParameterDescriptor;
        int parameterSize = parameterList2.getParameters().size();
        List<KtTypeParameter> typeParameters2 = Companion.typeParameters(parameter.getTypeReference());
        PsiElement psiElement3 = parameterList2.getParent();
        if (!(psiElement3 instanceof KtPrimaryConstructor)) {
            psiElement3 = null;
        }
        KtPrimaryConstructor primaryConstructor2 = (KtPrimaryConstructor)psiElement3;
        ChangeFunctionSignatureFix.Companion.runRemoveParameter(parameterDescriptor, parameter);
        Companion.runRemoveUnusedTypeParameters(typeParameters2);
        if (parameterSize > 1) {
            Editor editor3;
            List<KtParameter> list2 = parameterList2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameterList.parameters");
            KtParameter nextParameter = (KtParameter)CollectionsKt.getOrNull(list2, (int)parameterDescriptor.getIndex());
            if (nextParameter != null && (editor3 = editor2) != null && (editor3 = editor3.getCaretModel()) != null) {
                editor3.moveToOffset(PsiUtilsKt.getStartOffset(nextParameter));
            }
        }
        if (primaryConstructor2 != null && (removeConstructorIntention = new RemoveEmptyPrimaryConstructorIntention()).isApplicableTo(primaryConstructor2)) {
            Editor editor4 = editor2;
            if (editor4 != null && (editor4 = editor4.getCaretModel()) != null) {
                editor4.moveToOffset(PsiUtilsKt.getEndOffset(primaryConstructor2));
            }
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(removeConstructorIntention, primaryConstructor2){
                final /* synthetic */ RemoveEmptyPrimaryConstructorIntention $removeConstructorIntention;
                final /* synthetic */ KtPrimaryConstructor $primaryConstructor;

                public final void invoke() {
                    this.$removeConstructorIntention.applyTo(this.$primaryConstructor, (Editor)null);
                }
                {
                    this.$removeConstructorIntention = removeEmptyPrimaryConstructorIntention;
                    this.$primaryConstructor = ktPrimaryConstructor;
                    super(0);
                }
            });
        }
    }

    public RemoveUnusedFunctionParameterFix(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        super((PsiElement)parameter);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedFunctionParameterFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "runRemoveUnusedTypeParameters", "", "typeParameters", "", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtParameter> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.UNUSED_PARAMETER.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.UNUSED_PARAMETER.cast(diagnostic)");
            Object e = ((DiagnosticWithParameters1)d).getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"Errors.UNUSED_PARAMETER.\u2026st(diagnostic).psiElement");
            KtParameter parameter = (KtParameter)e;
            PsiElement psiElement2 = parameter.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parameter.parent");
            PsiElement parameterOwner = psiElement2.getParent();
            if (parameterOwner instanceof KtFunctionLiteral || parameterOwner instanceof KtNamedFunction && ((KtNamedFunction)parameterOwner).getName() == null || parameterOwner instanceof KtPropertyAccessor) {
                return null;
            }
            return new RemoveUnusedFunctionParameterFix(parameter);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtTypeParameter> typeParameters(@Nullable KtTypeReference typeReference2) {
            List list2;
            if (typeReference2 == null) {
                return CollectionsKt.emptyList();
            }
            KtTypeParameterListOwnerStub parameterParent2 = (KtTypeParameterListOwnerStub)PsiUtilsKt.getParentOfTypesAndPredicate(typeReference2, true, new Class[]{KtNamedFunction.class, KtProperty.class, KtClass.class}, typeParameters.parameterParent.1.INSTANCE);
            KtTypeElement ktTypeElement = typeReference2.getTypeElement();
            if (ktTypeElement != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$forEachDescendantOfType$iv$iv$iv;
                void $this$collectDescendantsOfType$iv;
                PsiElement psiElement2 = (PsiElement)ktTypeElement;
                Function1 predicate$iv = typeParameters.1.INSTANCE;
                boolean $i$f$collectDescendantsOfType22 = false;
                void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
                boolean $i$f$collectDescendantsOfType = false;
                ArrayList result$iv$iv = new ArrayList();
                void var9_11 = $this$collectDescendantsOfType$iv$iv;
                Function1 action$iv$iv$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(predicate$iv, result$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ ArrayList $result;
                    {
                        this.$predicate = function1;
                        this.$result = arrayList;
                        super(1);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final void invoke(@NotNull PsiElement it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                            this.$result.add(it);
                        }
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $captured_local_variable$1;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                        if (element3 instanceof KtNameReferenceExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
                Iterable $this$mapNotNull$iv = result$iv$iv;
                boolean $i$f$mapNotNull = false;
                Iterable $i$f$collectDescendantsOfType22 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KtTypeParameter ktTypeParameter;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    KtNameReferenceExpression it = (KtNameReferenceExpression)element$iv$iv;
                    boolean bl2 = false;
                    PsiReference psiReference = it.getReference();
                    Object object = psiReference != null ? psiReference.resolve() : null;
                    if (!(object instanceof KtTypeParameter)) {
                        object = null;
                    }
                    if ((KtTypeParameter)object == null) {
                        ktTypeParameter = null;
                    } else {
                        KtTypeParameter typeParameter;
                        KtTypeParameterListOwnerStub parent2 = (KtTypeParameterListOwnerStub)PsiUtilsKt.getParentOfTypesAndPredicate(typeParameter, true, new Class[]{KtNamedFunction.class, KtProperty.class, KtClass.class}, typeParameters.2.parent.1.INSTANCE);
                        ktTypeParameter = Intrinsics.areEqual((Object)parent2, (Object)parameterParent2) ? typeParameter : null;
                    }
                    if (ktTypeParameter == null) continue;
                    KtTypeParameter ktTypeParameter2 = ktTypeParameter;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    KtTypeParameter it$iv$iv = ktTypeParameter2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        public final void runRemoveUnusedTypeParameters(@NotNull List<? extends KtTypeParameter> typeParameters2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(typeParameters2, (String)"typeParameters");
            Iterable $this$filter$iv = typeParameters2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block6: {
                    KtTypeParameter typeParameter = (KtTypeParameter)element$iv$iv;
                    boolean bl2 = false;
                    Query query = ReferencesSearch.search((PsiElement)typeParameter);
                    Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(typeParameter)");
                    Iterable $this$none$iv = (Iterable)query;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            Object object;
                            PsiReference it = (PsiReference)element$iv;
                            boolean bl3 = false;
                            PsiReference psiReference = it;
                            if (!(psiReference instanceof KtSimpleNameReference)) {
                                psiReference = null;
                            }
                            if (!(!(((object = (KtSimpleNameReference)psiReference) != null && (object = (KtSimpleNameExpression)((AbstractKtReference)object).getExpression()) != null ? object.getParent() : null) instanceof KtTypeConstraint))) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List unusedTypeParams = (List)destination$iv$iv;
            if (unusedTypeParams.isEmpty()) {
                return;
            }
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(unusedTypeParams){
                final /* synthetic */ List $unusedTypeParams;

                public final void invoke() {
                    Iterable $this$forEach$iv = this.$unusedTypeParams;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PsiElement $this$getChildOfType$iv;
                        KtTypeParameterList typeParameterList;
                        KtTypeParameter typeParameter = (KtTypeParameter)element$iv;
                        boolean bl = false;
                        PsiElement psiElement2 = typeParameter.getParent();
                        if (!(psiElement2 instanceof KtTypeParameterList)) {
                            psiElement2 = null;
                        }
                        if ((KtTypeParameterList)psiElement2 == null) {
                            continue;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterList.getParent(), (String)"typeParameterList.parent");
                        boolean $i$f$getChildOfType2 = false;
                        KtTypeConstraintList typeConstraintList = (KtTypeConstraintList)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtTypeConstraintList.class);
                        if (typeConstraintList != null) {
                            PsiElement prev2;
                            PsiElement psiElement3;
                            Object v4;
                            block9: {
                                List<KtTypeConstraint> list2 = typeConstraintList.getConstraints();
                                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeConstraintList.constraints");
                                Iterable $i$f$getChildOfType2 = list2;
                                boolean bl2 = false;
                                Iterable iterable = $i$f$getChildOfType2;
                                boolean bl3 = false;
                                for (T t : iterable) {
                                    KtTypeConstraint it = (KtTypeConstraint)t;
                                    boolean bl4 = false;
                                    KtTypeConstraint ktTypeConstraint = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeConstraint, (String)"it");
                                    KtSimpleNameExpression ktSimpleNameExpression = ktTypeConstraint.getSubjectTypeParameterName();
                                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)typeParameter.getText())) continue;
                                    v4 = t;
                                    break block9;
                                }
                                v4 = null;
                            }
                            KtTypeConstraint typeConstraint = v4;
                            if (typeConstraint != null) {
                                EditCommaSeparatedListHelper.INSTANCE.removeItem((KtElement)typeConstraint);
                            }
                            if (typeConstraintList.getConstraints().size() == 0 && Intrinsics.areEqual((Object)((psiElement3 = (prev2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)typeConstraintList, false, 1, null))) != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : null), (Object)((Object)KtTokens.WHERE_KEYWORD))) {
                                PsiElement psiElement4 = prev2;
                                if (psiElement4 != null) {
                                    psiElement4.delete();
                                }
                            }
                        }
                        if (typeParameterList.getParameters().size() == 1) {
                            typeParameterList.delete();
                            continue;
                        }
                        EditCommaSeparatedListHelper.INSTANCE.removeItem((KtElement)typeParameter);
                    }
                }
                {
                    this.$unusedTypeParams = list2;
                    super(0);
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

