/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithLambdaFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "expression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class SurroundWithLambdaFix
extends KotlinQuickFixAction<KtExpression>
implements HighPriorityAction {
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Surround with lambda";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression nameReference = ktExpression;
        KtExpression newExpression2 = CreateByPatternKt.buildExpression$default(new KtPsiFactory(project, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(nameReference){
            final /* synthetic */ KtExpression $nameReference;

            public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                Intrinsics.checkParameterIsNotNull($this$buildExpression, (String)"$receiver");
                $this$buildExpression.appendFixedText("{ ");
                $this$buildExpression.appendExpression(this.$nameReference);
                $this$buildExpression.appendFixedText(" }");
            }
            {
                this.$nameReference = ktExpression;
                super(1);
            }
        }, 1, null);
        nameReference.replace((PsiElement)newExpression2);
    }

    public SurroundWithLambdaFix(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        super((PsiElement)expression2);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SurroundWithLambdaFix.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Surro\u2026ithLambdaFix::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithLambdaFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtExpression> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
            DiagnosticFactory<?> diagnosticFactory2 = diagnosticFactory;
            KotlinType expectedType = null;
            KotlinType expressionType = null;
            DiagnosticFactory<?> diagnosticFactory3 = diagnosticFactory2;
            if (Intrinsics.areEqual(diagnosticFactory3, Errors.TYPE_MISMATCH)) {
                Object d = Errors.TYPE_MISMATCH.cast(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.TYPE_MISMATCH.cast(diagnostic)");
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)d;
                Object a = diagnosticWithParameters.getA();
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                expectedType = (KotlinType)a;
                Object b = diagnosticWithParameters.getB();
                Intrinsics.checkExpressionValueIsNotNull(b, (String)"diagnosticWithParameters.b");
                expressionType = (KotlinType)b;
            } else if (Intrinsics.areEqual(diagnosticFactory3, Errors.CONSTANT_EXPECTED_TYPE_MISMATCH)) {
                void $this$analyzeWithContent$iv$iv;
                PsiFile psiFile = diagnostic.getPsiFile();
                if (psiFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                }
                KtDeclarationContainer $this$analyzeWithContent$iv = (KtFile)psiFile;
                boolean $i$f$analyzeWithContent = false;
                KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
                ResolutionFacade resolutionFacade$iv$iv = ResolutionUtils.getResolutionFacade((KtElement)((Object)$this$analyzeWithContent$iv));
                boolean $i$f$analyzeWithContent2 = false;
                BindingContext context2 = resolutionFacade$iv$iv.analyzeWithAllCompilerChecks(CollectionsKt.listOf((Object)$this$analyzeWithContent$iv$iv)).getBindingContext();
                Object d = Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.CONSTANT_EXPECTED\u2026MISMATCH.cast(diagnostic)");
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)d;
                PsiElement psiElement2 = diagnostic.getPsiElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
                PsiElement diagnosticElement = psiElement2;
                if (!(diagnosticElement instanceof KtExpression)) {
                    LOG.error("Unexpected element: " + diagnosticElement.getText());
                    return null;
                }
                Object b = diagnosticWithParameters.getB();
                Intrinsics.checkExpressionValueIsNotNull(b, (String)"diagnosticWithParameters.b");
                expectedType = (KotlinType)b;
                KotlinType kotlinType2 = context2.getType((KtExpression)diagnosticElement);
                if (kotlinType2 == null) {
                    return null;
                }
                expressionType = kotlinType2;
            } else {
                LOG.error("Unexpected diagnostic: " + DefaultErrorMessages.render(diagnostic));
                return null;
            }
            if (!FunctionTypesKt.isFunctionType(expectedType)) {
                return null;
            }
            if (expectedType.getArguments().size() != 1) {
                return null;
            }
            KotlinType kotlinType3 = expectedType.getArguments().get(0).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"expectedType.arguments[0].type");
            KotlinType lambdaReturnType = kotlinType3;
            if (!(TypeUtilsKt.isSubtypeOf(TypeUtilsKt.makeNotNullable(expressionType), lambdaReturnType) || TypeUtilsKt.isPrimitiveNumberType(expressionType) && TypeUtilsKt.isPrimitiveNumberType(lambdaReturnType))) {
                return null;
            }
            PsiElement psiElement3 = diagnostic.getPsiElement();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression diagnosticElement = (KtExpression)psiElement3;
            return new SurroundWithLambdaFix(diagnosticElement);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

