/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionTable;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinAwareMoveFilesOrDirectoriesProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForExistingElement;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveToKotlinFileProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinDestinationFolderComboBox;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinFileChooserDialog;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class MoveKotlinTopLevelDeclarationsDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = "MoveKotlinTopLevelDeclarationsDialog.RECENTS_KEY";
    private final MoveCallback moveCallback;
    private final PsiDirectory initialTargetDirectory;
    private JCheckBox cbSearchInComments;
    private JCheckBox cbSearchTextOccurrences;
    private JPanel mainPanel;
    private ReferenceEditorComboWithBrowseButton classPackageChooser;
    private ComboboxWithBrowseButton destinationFolderCB;
    private JPanel targetPanel;
    private JRadioButton rbMoveToPackage;
    private JRadioButton rbMoveToFile;
    private TextFieldWithBrowseButton fileChooser;
    private JPanel memberInfoPanel;
    private JTextField tfFileNameInPackage;
    private JCheckBox cbSpecifyFileNameInPackage;
    private JCheckBox cbUpdatePackageDirective;
    private JCheckBox cbSearchReferences;
    private KotlinMemberSelectionTable memberTable;

    public MoveKotlinTopLevelDeclarationsDialog(@NotNull Project project, @NotNull Set<KtNamedDeclaration> elementsToMove2, @Nullable String targetPackageName, @Nullable PsiDirectory targetDirectory2, @Nullable KtFile targetFile, boolean moveToPackage, boolean searchInComments, boolean searchForTextOccurences, @Nullable MoveCallback moveCallback) {
        if (project == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(0);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(1);
        }
        if (project == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(0);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(1);
        }
        if (project == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(0);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(1);
        }
        if (project == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(0);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.$$$setupUI$$$();
        List<KtFile> sourceFiles = MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(elementsToMove2);
        this.moveCallback = moveCallback;
        this.initialTargetDirectory = targetDirectory2;
        this.init();
        this.setTitle(MoveHandler.REFACTORING_NAME);
        this.initSearchOptions(searchInComments, searchForTextOccurences);
        this.initPackageChooser(targetPackageName, targetDirectory2, sourceFiles);
        this.initFileChooser(targetFile, elementsToMove2, sourceFiles);
        this.initMoveToButtons(moveToPackage);
        this.initMemberInfo(elementsToMove2, sourceFiles);
        this.updateControls();
    }

    private static List<KtFile> getSourceFiles(@NotNull Collection<KtNamedDeclaration> elementsToMove2) {
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(2);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(2);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(2);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(2);
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.map(elementsToMove2, (Function1)new Function1<KtNamedDeclaration, KtFile>(){

            public KtFile invoke(KtNamedDeclaration declaration2) {
                return declaration2.getContainingKtFile();
            }
        }));
    }

    @NotNull
    private static PsiDirectory getSourceDirectory(@NotNull Collection<KtFile> sourceFiles) {
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(3);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(3);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(3);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(3);
        }
        PsiDirectory psiDirectory = (PsiDirectory)CollectionsKt.single((List)CollectionsKt.distinct((Iterable)CollectionsKt.map(sourceFiles, (Function1)new Function1<KtFile, PsiDirectory>(){

            public PsiDirectory invoke(KtFile jetFile) {
                return jetFile.getParent();
            }
        })));
        if (psiDirectory == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(4);
        }
        if (psiDirectory == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(4);
        }
        if (psiDirectory == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(4);
        }
        if (psiDirectory == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(4);
        }
        return psiDirectory;
    }

    private static List<KtNamedDeclaration> getAllDeclarations(Collection<KtFile> sourceFiles) {
        return CollectionsKt.filterIsInstance((Iterable)CollectionsKt.flatMap(sourceFiles, (Function1)new Function1<KtFile, Iterable<?>>(){

            public Iterable<?> invoke(KtFile ktFile2) {
                return KtPsiUtilKt.getFileOrScriptDeclarations(ktFile2);
            }
        }), KtNamedDeclaration.class);
    }

    private static boolean arePackagesAndDirectoryMatched(List<KtFile> sourceFiles) {
        for (KtFile sourceFile : sourceFiles) {
            if (PackageUtilsKt.packageMatchesDirectory(sourceFile)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<PsiFile> getFilesExistingInTargetDir(@NotNull List<KtFile> sourceFiles, @Nullable String targetFileName, final @Nullable PsiDirectory targetDirectory2) {
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(5);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(5);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(5);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(5);
        }
        if (targetDirectory2 == null) {
            List<PsiFile> list2 = Collections.emptyList();
            if (list2 == null) {
                MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(6);
            }
            if (list2 == null) {
                MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(6);
            }
            if (list2 == null) {
                MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(6);
            }
            if (list2 == null) {
                MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(6);
            }
            return list2;
        }
        List fileNames = targetFileName != null ? Collections.singletonList(targetFileName) : CollectionsKt.map(sourceFiles, (Function1)new Function1<KtFile, String>(){

            public String invoke(KtFile jetFile) {
                return jetFile.getName();
            }
        });
        List list3 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.map((Iterable)fileNames, (Function1)new Function1<String, PsiFile>(){

            public PsiFile invoke(String s) {
                return targetDirectory2.findFile(s);
            }
        }));
        if (list3 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(7);
        }
        if (list3 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(7);
        }
        if (list3 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(7);
        }
        if (list3 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(7);
        }
        return list3;
    }

    private void initMemberInfo(final @NotNull Set<KtNamedDeclaration> elementsToMove2, @NotNull List<KtFile> sourceFiles) {
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(8);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(9);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(8);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(9);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(8);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(9);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(8);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(9);
        }
        final List memberInfos = CollectionsKt.map(MoveKotlinTopLevelDeclarationsDialog.getAllDeclarations(sourceFiles), (Function1)new Function1<KtNamedDeclaration, KotlinMemberInfo>(){

            public KotlinMemberInfo invoke(KtNamedDeclaration declaration2) {
                KotlinMemberInfo memberInfo = new KotlinMemberInfo(declaration2, false);
                memberInfo.setChecked(elementsToMove2.contains(declaration2));
                return memberInfo;
            }
        });
        KotlinMemberSelectionPanel selectionPanel = new KotlinMemberSelectionPanel(this.getTitle(), memberInfos, null);
        this.memberTable = selectionPanel.getTable();
        MemberInfoModelImpl memberInfoModel = new MemberInfoModelImpl();
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)memberInfos));
        selectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)new MemberInfoChangeListener<KtNamedDeclaration, KotlinMemberInfo>(){

            private boolean shouldUpdateFileNameField(final Collection<KotlinMemberInfo> changedMembers) {
                if (!MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.isEnabled()) {
                    return true;
                }
                List previousDeclarations = CollectionsKt.filterNotNull((Iterable)CollectionsKt.map((Iterable)memberInfos, (Function1)new Function1<KotlinMemberInfo, KtNamedDeclaration>(){

                    public KtNamedDeclaration invoke(KotlinMemberInfo info2) {
                        return changedMembers.contains((Object)info2) != info2.isChecked() ? (KtNamedDeclaration)info2.getMember() : null;
                    }
                }));
                String suggestedText = previousDeclarations.isEmpty() ? "" : MoveUtilsKt.guessNewFileName(previousDeclarations);
                return MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.getText().equals(suggestedText);
            }

            public void memberInfoChanged(MemberInfoChange<KtNamedDeclaration, KotlinMemberInfo> event) {
                MoveKotlinTopLevelDeclarationsDialog.this.updatePackageDirectiveCheckBox();
                MoveKotlinTopLevelDeclarationsDialog.this.updateFileNameInPackageField();
                if (this.shouldUpdateFileNameField(event.getChangedMembers())) {
                    MoveKotlinTopLevelDeclarationsDialog.this.updateSuggestedFileName();
                }
            }
        });
        this.memberInfoPanel.add((Component)((Object)selectionPanel), "Center");
    }

    private void updateSuggestedFileName() {
        this.tfFileNameInPackage.setText(MoveUtilsKt.guessNewFileName(this.getSelectedElementsToMove()));
    }

    private void updateFileNameInPackageField() {
        boolean movingSingleFileToPackage = this.isMoveToPackage() && MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(this.getSelectedElementsToMove()).size() == 1;
        this.cbSpecifyFileNameInPackage.setEnabled(movingSingleFileToPackage);
        this.tfFileNameInPackage.setEnabled(movingSingleFileToPackage && this.cbSpecifyFileNameInPackage.isSelected());
    }

    private void initPackageChooser(String targetPackageName, PsiDirectory targetDirectory2, List<KtFile> sourceFiles) {
        if (targetPackageName != null) {
            this.classPackageChooser.prependItem(targetPackageName);
        }
        ((KotlinDestinationFolderComboBox)this.destinationFolderCB).setData(this.myProject, targetDirectory2, new Pass<String>(){

            public void pass(String s) {
                MoveKotlinTopLevelDeclarationsDialog.this.setErrorText(s);
            }
        }, (EditorComboBox)this.classPackageChooser.getChildComponent());
        this.cbSpecifyFileNameInPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$3(0);
                }
                if (e == null) {
                    9.$$$reportNull$$$2(0);
                }
                if (e == null) {
                    9.$$$reportNull$$$1(0);
                }
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                MoveKotlinTopLevelDeclarationsDialog.this.updateFileNameInPackageField();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$9", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$9", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$2(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$9", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$3(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$9", "actionPerformed"));
            }
        });
        this.cbUpdatePackageDirective.setSelected(MoveKotlinTopLevelDeclarationsDialog.arePackagesAndDirectoryMatched(sourceFiles));
    }

    private void initSearchOptions(boolean searchInComments, boolean searchForTextOccurences) {
        this.cbSearchInComments.setSelected(searchInComments);
        this.cbSearchTextOccurrences.setSelected(searchForTextOccurences);
    }

    private void initMoveToButtons(boolean moveToPackage) {
        if (moveToPackage) {
            this.rbMoveToPackage.setSelected(true);
        } else {
            this.rbMoveToFile.setSelected(true);
        }
        this.rbMoveToPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$3(0);
                }
                if (e == null) {
                    10.$$$reportNull$$$2(0);
                }
                if (e == null) {
                    10.$$$reportNull$$$1(0);
                }
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                MoveKotlinTopLevelDeclarationsDialog.this.classPackageChooser.requestFocus();
                MoveKotlinTopLevelDeclarationsDialog.this.updateControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$10", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$10", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$2(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$10", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$3(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$10", "actionPerformed"));
            }
        });
        this.rbMoveToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$3(0);
                }
                if (e == null) {
                    11.$$$reportNull$$$2(0);
                }
                if (e == null) {
                    11.$$$reportNull$$$1(0);
                }
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                MoveKotlinTopLevelDeclarationsDialog.this.fileChooser.requestFocus();
                MoveKotlinTopLevelDeclarationsDialog.this.updateControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$11", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$11", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$2(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$11", "actionPerformed"));
            }

            private static /* synthetic */ void $$$reportNull$$$3(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$11", "actionPerformed"));
            }
        });
    }

    private void initFileChooser(@Nullable KtFile targetFile, @NotNull Set<KtNamedDeclaration> elementsToMove2, @NotNull List<KtFile> sourceFiles) {
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(10);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(11);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(10);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(11);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(10);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(11);
        }
        if (elementsToMove2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(10);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(11);
        }
        final PsiDirectory sourceDir = sourceFiles.get(0).getParent();
        assert (sourceDir != null) : sourceFiles.get(0).getVirtualFile().getPath();
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KtFile selectedFile;
                KotlinFileChooserDialog dialog2 = new KotlinFileChooserDialog("Choose Containing File", MoveKotlinTopLevelDeclarationsDialog.this.myProject);
                File targetFile = new File(MoveKotlinTopLevelDeclarationsDialog.this.getTargetFilePath());
                PsiFile targetPsiFile = KotlinRefactoringUtilKt.toPsiFile(targetFile, MoveKotlinTopLevelDeclarationsDialog.this.myProject);
                if (targetPsiFile instanceof KtFile) {
                    dialog2.select((KtFile)targetPsiFile);
                } else {
                    PsiDirectory targetDir = KotlinRefactoringUtilKt.toPsiDirectory(targetFile.getParentFile(), MoveKotlinTopLevelDeclarationsDialog.this.myProject);
                    if (targetDir == null) {
                        targetDir = sourceDir;
                    }
                    dialog2.selectDirectory(targetDir);
                }
                dialog2.showDialog();
                KtFile ktFile2 = selectedFile = dialog2.isOK() ? (KtFile)dialog2.getSelected() : null;
                if (selectedFile != null) {
                    MoveKotlinTopLevelDeclarationsDialog.this.fileChooser.setText(selectedFile.getVirtualFile().getPath());
                }
            }
        });
        String initialTargetPath = targetFile != null ? targetFile.getVirtualFile().getPath() : sourceFiles.get(0).getVirtualFile().getParent().getPath() + "/" + MoveUtilsKt.guessNewFileName(elementsToMove2);
        this.fileChooser.setText(initialTargetPath);
    }

    private void createUIComponents() {
        this.classPackageChooser = this.createPackageChooser();
        this.destinationFolderCB = new KotlinDestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return MoveKotlinTopLevelDeclarationsDialog.this.getTargetPackage();
            }
        };
    }

    private ReferenceEditorComboWithBrowseButton createPackageChooser() {
        PackageNameReferenceEditorCombo packageChooser = new PackageNameReferenceEditorCombo("", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)packageChooser.getChildComponent()).getDocument();
        document.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    14.$$$reportNull$$$3(0);
                }
                if (e == null) {
                    14.$$$reportNull$$$2(0);
                }
                if (e == null) {
                    14.$$$reportNull$$$1(0);
                }
                if (e == null) {
                    14.$$$reportNull$$$0(0);
                }
                MoveKotlinTopLevelDeclarationsDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$14", "documentChanged"));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$14", "documentChanged"));
            }

            private static /* synthetic */ void $$$reportNull$$$2(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$14", "documentChanged"));
            }

            private static /* synthetic */ void $$$reportNull$$$3(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$14", "documentChanged"));
            }
        });
        return packageChooser;
    }

    private void updateControls() {
        boolean moveToPackage = this.isMoveToPackage();
        this.classPackageChooser.setEnabled(moveToPackage);
        this.updateFileNameInPackageField();
        this.fileChooser.setEnabled(!moveToPackage);
        this.updatePackageDirectiveCheckBox();
        UIUtil.setEnabled((Component)this.targetPanel, (moveToPackage && this.hasAnySourceRoots() ? 1 : 0) != 0, (boolean)true);
        this.updateSuggestedFileName();
        this.validateButtons();
    }

    private boolean isFullFileMove() {
        Map fileToElements = CollectionsKt.groupBy(this.getSelectedElementsToMove(), (Function1)new Function1<KtNamedDeclaration, KtFile>(){

            public KtFile invoke(KtNamedDeclaration declaration2) {
                return declaration2.getContainingKtFile();
            }
        });
        for (Map.Entry entry : fileToElements.entrySet()) {
            if (KtPsiUtilKt.getFileOrScriptDeclarations((KtFile)entry.getKey()).size() == ((List)entry.getValue()).size()) continue;
            return false;
        }
        return true;
    }

    private void updatePackageDirectiveCheckBox() {
        this.cbUpdatePackageDirective.setEnabled(this.isMoveToPackage() && this.isFullFileMove());
    }

    private boolean hasAnySourceRoots() {
        return !JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)this.myProject).isEmpty();
    }

    private void saveRefactoringSettings() {
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = this.isSearchInComments();
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = this.isSearchInNonJavaFiles();
        refactoringSettings.MOVE_PREVIEW_USAGES = this.isPreviewUsages();
    }

    @Nullable
    private Pair<VirtualFile, ? extends MoveDestination> selectPackageBasedTargetDirAndDestination(boolean askIfDoesNotExist) {
        PsiDirectory selectedPsiDirectory;
        int ret;
        String packageName = this.getTargetPackage();
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        PackageWrapper targetPackage = new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName);
        if (!targetPackage.exists() && askIfDoesNotExist && (ret = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"package.does.not.exist", (Object[])new Object[]{packageName}), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) != 0) {
            return null;
        }
        DirectoryChooser.ItemWrapper selectedItem = (DirectoryChooser.ItemWrapper)this.destinationFolderCB.getComboBox().getSelectedItem();
        PsiDirectory psiDirectory = selectedPsiDirectory = selectedItem != null ? selectedItem.getDirectory() : null;
        if (selectedPsiDirectory == null) {
            if (this.initialTargetDirectory != null) {
                selectedPsiDirectory = this.initialTargetDirectory;
            } else {
                return Pair.create(null, (Object)new MultipleRootsMoveDestination(targetPackage));
            }
        }
        VirtualFile targetDirectory2 = selectedPsiDirectory.getVirtualFile();
        return Pair.create((Object)targetDirectory2, (Object)new AutocreatingSingleSourceRootMoveDestination(targetPackage, targetDirectory2));
    }

    private boolean checkTargetFileName(String fileName) {
        if (FileTypeManager.getInstance().getFileTypeByFileName(fileName) == KotlinFileType.INSTANCE) {
            return true;
        }
        this.setErrorText("Can't move to non-Kotlin file");
        return false;
    }

    @Nullable
    private KotlinMoveTarget selectMoveTarget() {
        File targetDir;
        PsiDirectory psiDirectory;
        int ret;
        String message2 = this.verifyBeforeRun();
        if (message2 != null) {
            this.setErrorText(message2);
            return null;
        }
        this.setErrorText(null);
        List<KtFile> sourceFiles = MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(this.getSelectedElementsToMove());
        PsiDirectory sourceDirectory = MoveKotlinTopLevelDeclarationsDialog.getSourceDirectory(sourceFiles);
        if (this.isMoveToPackage()) {
            String targetFileName;
            Pair<VirtualFile, ? extends MoveDestination> targetDirWithMoveDestination = this.selectPackageBasedTargetDirAndDestination(true);
            if (targetDirWithMoveDestination == null) {
                return null;
            }
            VirtualFile targetDir2 = (VirtualFile)targetDirWithMoveDestination.getFirst();
            final MoveDestination moveDestination = (MoveDestination)targetDirWithMoveDestination.getSecond();
            String string = targetFileName = sourceFiles.size() > 1 ? null : this.tfFileNameInPackage.getText();
            if (targetFileName != null && !this.checkTargetFileName(targetFileName)) {
                return null;
            }
            PsiDirectory targetDirectory2 = moveDestination.getTargetIfExists(sourceDirectory);
            List<PsiFile> filesExistingInTargetDir = MoveKotlinTopLevelDeclarationsDialog.getFilesExistingInTargetDir(sourceFiles, targetFileName, targetDirectory2);
            if (!filesExistingInTargetDir.isEmpty()) {
                String question;
                int ret2;
                if (filesExistingInTargetDir.size() > 1) {
                    String filePathsToReport = StringUtil.join(filesExistingInTargetDir, (Function)new Function<PsiFile, String>(){

                        public String fun(PsiFile file2) {
                            return file2.getVirtualFile().getPath();
                        }
                    }, (String)"\n");
                    Messages.showErrorDialog((Project)this.myProject, (String)("Cannot perform refactoring since the following files already exist:\n\n" + filePathsToReport), (String)RefactoringBundle.message((String)"move.title"));
                    return null;
                }
                PsiFile targetFile = filesExistingInTargetDir.get(0);
                if (!sourceFiles.contains(targetFile) && (ret2 = Messages.showYesNoDialog((Project)this.myProject, (String)(question = String.format("File '%s' already exists. Do you want to move selected declarations to this file?", targetFile.getVirtualFile().getPath())), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) != 0) {
                    return null;
                }
                if (targetFile instanceof KtFile) {
                    return new KotlinMoveTargetForExistingElement((KtFile)targetFile);
                }
            }
            return new KotlinMoveTargetForDeferredFile(new FqName(this.getTargetPackage()), moveDestination.getTargetIfExists((PsiFile)sourceFiles.get(0)), targetDir2, (Function1<? super KtFile, ? extends KtFile>)new Function1<KtFile, KtFile>(){

                public KtFile invoke(@NotNull KtFile originalFile) {
                    if (originalFile == null) {
                        17.$$$reportNull$$$3(0);
                    }
                    if (originalFile == null) {
                        17.$$$reportNull$$$2(0);
                    }
                    if (originalFile == null) {
                        17.$$$reportNull$$$1(0);
                    }
                    if (originalFile == null) {
                        17.$$$reportNull$$$0(0);
                    }
                    return KotlinRefactoringUtilKt.getOrCreateKotlinFile(targetFileName != null ? targetFileName : originalFile.getName(), moveDestination.getTargetDirectory((PsiFile)originalFile));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$17", "invoke"));
                }

                private static /* synthetic */ void $$$reportNull$$$1(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$17", "invoke"));
                }

                private static /* synthetic */ void $$$reportNull$$$2(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$17", "invoke"));
                }

                private static /* synthetic */ void $$$reportNull$$$3(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$17", "invoke"));
                }
            });
        }
        final File targetFile = new File(this.getTargetFilePath());
        if (!this.checkTargetFileName(targetFile.getName())) {
            return null;
        }
        KtFile jetFile = (KtFile)KotlinRefactoringUtilKt.toPsiFile(targetFile, this.myProject);
        if (jetFile != null) {
            if (sourceFiles.size() == 1 && sourceFiles.contains(jetFile)) {
                this.setErrorText("Can't move to the original file");
                return null;
            }
            return new KotlinMoveTargetForExistingElement(jetFile);
        }
        Path targetFilePath = targetFile.toPath();
        Path targetDirPath = targetFilePath.getParent();
        if (targetDirPath == null || !targetDirPath.startsWith(this.getProject().getBasePath())) {
            this.setErrorText("Incorrect target path. Directory " + targetDirPath + " does not belong to current project.");
            return null;
        }
        if (KotlinRefactoringUtilKt.toPsiDirectory(targetDirPath.toFile(), this.myProject) == null && (ret = Messages.showYesNoDialog((Project)this.myProject, (String)"You are about to move all declarations to the directory that does not exist. Do you want to create it?", (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) == 0) {
            try {
                DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)this.getProject()), (String)targetDirPath.toString());
            }
            catch (IncorrectOperationException e) {
                this.setErrorText("Failed to create parent directory: " + targetDirPath);
                return null;
            }
        }
        PsiDirectory psiDirectory2 = psiDirectory = (targetDir = targetDirPath.toFile()) != null ? KotlinRefactoringUtilKt.toPsiDirectory(targetDir, this.myProject) : null;
        if (psiDirectory == null) {
            this.setErrorText("No directory found for file: " + targetFile.getPath());
            return null;
        }
        Set sourcePackageFqNames = (Set)CollectionsKt.mapTo(sourceFiles, new LinkedHashSet(), (Function1)new Function1<KtFile, FqName>(){

            public FqName invoke(KtFile file2) {
                return file2.getPackageFqName();
            }
        });
        FqName targetPackageFqName = (FqName)CollectionsKt.singleOrNull((Iterable)sourcePackageFqNames);
        if (targetPackageFqName == null) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
            if (psiPackage == null) {
                this.setErrorText("Could not find package corresponding to " + targetDir.getPath());
                return null;
            }
            targetPackageFqName = new FqName(psiPackage.getQualifiedName());
        }
        final String finalTargetPackageFqName = targetPackageFqName.asString();
        return new KotlinMoveTargetForDeferredFile(targetPackageFqName, psiDirectory, null, (Function1<? super KtFile, ? extends KtFile>)new Function1<KtFile, KtFile>(){

            public KtFile invoke(@NotNull KtFile originalFile) {
                if (originalFile == null) {
                    19.$$$reportNull$$$3(0);
                }
                if (originalFile == null) {
                    19.$$$reportNull$$$2(0);
                }
                if (originalFile == null) {
                    19.$$$reportNull$$$1(0);
                }
                if (originalFile == null) {
                    19.$$$reportNull$$$0(0);
                }
                return KotlinRefactoringUtilKt.getOrCreateKotlinFile(targetFile.getName(), psiDirectory, finalTargetPackageFqName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$19", "invoke"));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$19", "invoke"));
            }

            private static /* synthetic */ void $$$reportNull$$$2(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$19", "invoke"));
            }

            private static /* synthetic */ void $$$reportNull$$$3(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$19", "invoke"));
            }
        });
    }

    @Nullable
    private String verifyBeforeRun() {
        if (this.memberTable.getSelectedMemberInfos().isEmpty()) {
            return "At least one member must be selected";
        }
        if (this.isMoveToPackage()) {
            String name2 = this.getTargetPackage();
            if (name2.length() != 0 && !PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(name2)) {
                return "'" + name2 + "' is invalid destination package name";
            }
        } else {
            PsiFile targetFile = KotlinRefactoringUtilKt.toPsiFile(new File(this.getTargetFilePath()), this.myProject);
            if (targetFile != null && !(targetFile instanceof KtFile)) {
                return KotlinRefactoringBundle.message("refactoring.move.non.kotlin.file", new Object[0]);
            }
        }
        if (MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(this.getSelectedElementsToMove()).size() == 1 && this.tfFileNameInPackage.getText().isEmpty()) {
            return "File name may not be empty";
        }
        return null;
    }

    private List<KtNamedDeclaration> getSelectedElementsToMove() {
        return CollectionsKt.map((Iterable)this.memberTable.getSelectedMemberInfos(), (Function1)new Function1<KotlinMemberInfo, KtNamedDeclaration>(){

            public KtNamedDeclaration invoke(KotlinMemberInfo info2) {
                return (KtNamedDeclaration)info2.getMember();
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    protected final String getTargetPackage() {
        return this.classPackageChooser.getText().trim();
    }

    protected final String getTargetFilePath() {
        return this.fileChooser.getText();
    }

    protected void canRun() throws ConfigurationException {
        String message2 = this.verifyBeforeRun();
        if (message2 != null) {
            throw new ConfigurationException(message2);
        }
    }

    protected void doAction() {
        KotlinMoveTarget target = this.selectMoveTarget();
        if (target == null) {
            return;
        }
        this.saveRefactoringSettings();
        List<KtNamedDeclaration> elementsToMove2 = this.getSelectedElementsToMove();
        List<KtFile> sourceFiles = MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(elementsToMove2);
        final PsiDirectory sourceDirectory = MoveKotlinTopLevelDeclarationsDialog.getSourceDirectory(sourceFiles);
        for (PsiElement psiElement2 : elementsToMove2) {
            String message2 = target.verify(psiElement2.getContainingFile());
            if (message2 == null) continue;
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)message2, null, (Project)this.myProject);
            return;
        }
        try {
            boolean deleteSourceFile = false;
            if (this.isFullFileMove()) {
                int n;
                if (this.isMoveToPackage()) {
                    Pair<VirtualFile, ? extends MoveDestination> pair2 = this.selectPackageBasedTargetDirAndDestination(false);
                    final MoveDestination moveDestination = (MoveDestination)pair2.getSecond();
                    PsiDirectory targetDir = moveDestination.getTargetIfExists(sourceDirectory);
                    String targetFileName = sourceFiles.size() > 1 ? null : this.tfFileNameInPackage.getText();
                    List<PsiFile> filesExistingInTargetDir = MoveKotlinTopLevelDeclarationsDialog.getFilesExistingInTargetDir(sourceFiles, targetFileName, targetDir);
                    if (filesExistingInTargetDir.isEmpty() || filesExistingInTargetDir.size() == 1 && sourceFiles.contains(filesExistingInTargetDir.get(0))) {
                        PsiDirectory targetDirectory2 = ApplicationUtilsKt.runWriteAction(new Function0<PsiDirectory>(){

                            public PsiDirectory invoke() {
                                return moveDestination.getTargetDirectory(sourceDirectory);
                            }
                        });
                        for (KtFile sourceFile : sourceFiles) {
                            MoveUtilsKt.setUpdatePackageDirective(sourceFile, this.cbUpdatePackageDirective.isSelected());
                        }
                        MoveFilesOrDirectoriesProcessor processor2 = sourceFiles.size() == 1 && targetFileName != null ? new MoveToKotlinFileProcessor(this.myProject, (KtFile)CollectionsKt.single(sourceFiles), targetDirectory2, targetFileName, this.isSearchInComments(), this.isSearchInNonJavaFiles(), this.moveCallback) : new KotlinAwareMoveFilesOrDirectoriesProcessor(this.myProject, sourceFiles, targetDirectory2, this.cbSearchReferences.isSelected(), this.isSearchInComments(), this.isSearchInNonJavaFiles(), this.moveCallback);
                        this.invokeRefactoring((BaseRefactoringProcessor)processor2);
                        return;
                    }
                }
                if ((n = Messages.showYesNoCancelDialog((Project)this.myProject, (String)"You are about to move all declarations out of the source file(s). Do you want to delete empty files?", (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) == 2) {
                    return;
                }
                deleteSourceFile = n == 0;
            }
            MoveDeclarationsDescriptor moveDeclarationsDescriptor = new MoveDeclarationsDescriptor(this.myProject, MoveKotlinDeclarationsProcessorKt.MoveSource(elementsToMove2), target, MoveDeclarationsDelegate.TopLevel.INSTANCE, this.isSearchInComments(), this.isSearchInNonJavaFiles(), deleteSourceFile, this.moveCallback, false, null, true, this.cbSearchReferences.isSelected());
            this.invokeRefactoring(new MoveKotlinDeclarationsProcessor(moveDeclarationsDescriptor, Mover.Default.INSTANCE));
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)this.myProject);
        }
    }

    private boolean isSearchInNonJavaFiles() {
        return this.cbSearchTextOccurrences.isSelected();
    }

    private boolean isSearchInComments() {
        return this.cbSearchInComments.isSelected();
    }

    private boolean isMoveToPackage() {
        return this.rbMoveToPackage.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classPackageChooser.getChildComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesExistingInTargetDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceDirectory";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesExistingInTargetDir";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initMemberInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initFileChooser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesExistingInTargetDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceDirectory";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesExistingInTargetDir";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initMemberInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initFileChooser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesExistingInTargetDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceDirectory";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesExistingInTargetDir";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initMemberInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initFileChooser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$3(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesExistingInTargetDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceDirectory";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesExistingInTargetDir";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initMemberInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initFileChooser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JTextField jTextField;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, "Center");
        this.memberInfoPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.classPackageChooser;
        jPanel7.add((Component)referenceEditorComboWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToPackage = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("To package:");
        jRadioButton2.setMnemonic('A');
        jRadioButton2.setDisplayedMnemonicIndex(4);
        jPanel7.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.fileChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToFile = jRadioButton = new JRadioButton();
        jRadioButton.setText("To file:");
        jRadioButton.setMnemonic('F');
        jRadioButton.setDisplayedMnemonicIndex(3);
        jPanel7.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tfFileNameInPackage = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel7.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.cbSpecifyFileNameInPackage = jCheckBox3 = new JCheckBox();
        jCheckBox3.setHorizontalAlignment(2);
        jCheckBox3.setHorizontalTextPosition(11);
        jCheckBox3.setText("File name:");
        jCheckBox3.setMnemonic('N');
        jCheckBox3.setDisplayedMnemonicIndex(5);
        jPanel7.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 0, null, null, null, 5));
        this.targetPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 5));
        JLabel jLabel = new JLabel();
        jLabel.setText("Destination directory:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.destinationFolderCB;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.cbUpdatePackageDirective = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Update package directive");
        jCheckBox2.setMnemonic('U');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null, 5));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.cbSearchInComments = nonFocusableCheckBox;
        nonFocusableCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        jPanel8.add((Component)nonFocusableCheckBox, new GridConstraints(1, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.cbSearchTextOccurrences = nonFocusableCheckBox2;
        nonFocusableCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        jPanel8.add((Component)nonFocusableCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 3, 0, 0, null, null, null));
        this.cbSearchReferences = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Search references");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(7);
        jPanel8.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MemberInfoModelImpl
    extends AbstractMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> {
        private MemberInfoModelImpl() {
        }
    }
}

