/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.intentions.OperatorToFunctionIntention;
import org.jetbrains.kotlin.idea.kdoc.KDocReference;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.idea.references.KtDestructuringDeclarationReference;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceAccess;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\n\u001a\u0012\u0010\u0015\u001a\u00020\u0014*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000f\u001a\u001a\u0010\u0017\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001a\u0010\u0017\u001a\u00020\u0014*\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u000b*\u00020\u001d\u001a\u0014\u0010\u001e\u001a\u00020\u0014*\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002\u001a\u0012\u0010 \u001a\u00020\u0014*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000f\u001a\u0012\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020\u0014\u001a\u001e\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0&*\u00020#2\u0006\u0010$\u001a\u00020\u0014\u001a\u001c\u0010'\u001a\u00020#*\n\u0012\u0006\b\u0001\u0012\u00020#0(2\b\u0010)\u001a\u0004\u0018\u00010*\u001a\u0010\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190,*\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0007\"\u0015\u0010\u0000\u001a\u00020\u0005*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\t\"\u0015\u0010\u0000\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\f\"\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"mainReference", "Lorg/jetbrains/kotlin/idea/kdoc/KDocReference;", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "getMainReference", "(Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;)Lorg/jetbrains/kotlin/idea/kdoc/KDocReference;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/idea/references/KtReference;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "(Lorg/jetbrains/kotlin/psi/KtReferenceExpression;)Lorg/jetbrains/kotlin/idea/references/KtReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "unwrappedTargets", "", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiReference;", "getUnwrappedTargets", "(Lcom/intellij/psi/PsiReference;)Ljava/util/Set;", "canBePsiMethodReference", "", "canBeReferenceTo", "candidateTarget", "canBeResolvedViaImport", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getCalleeByLambdaArgument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isConstructorOf", "unwrappedCandidate", "matchesTarget", "readWriteAccess", "Lorg/jetbrains/kotlin/idea/references/ReferenceAccess;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "useResolveForReadWrite", "readWriteAccessWithFullExpression", "Lkotlin/Pair;", "renameImplicitConventionalCall", "Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "newName", "", "resolveMainReferenceToDescriptors", "", "idea-core"})
public final class ReferenceUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PsiElement> getUnwrappedTargets(@NotNull PsiReference $this$unwrappedTargets) {
        Set set2;
        Intrinsics.checkParameterIsNotNull((Object)$this$unwrappedTargets, (String)"$this$unwrappedTargets");
        unwrappedTargets.1 $fun$adjust$1 = unwrappedTargets.1.INSTANCE;
        PsiReference psiReference = $this$unwrappedTargets;
        if (psiReference instanceof PsiPolyVariantReference) {
            void $this$mapNotNullTo$iv;
            ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)$this$unwrappedTargets).multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"multiResolve(false)");
            ResolveResult[] resolveResultArray2 = resolveResultArray;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            void var8_8 = $this$forEach$iv$iv;
            int n = ((void)var8_8).length;
            for (int j = 0; j < n; ++j) {
                PsiElement psiElement2;
                void element$iv$iv;
                void element$iv = element$iv$iv = var8_8[j];
                boolean bl = false;
                void it = element$iv;
                boolean bl2 = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                PsiElement psiElement3 = v1.getElement();
                if ((psiElement3 != null ? unwrappedTargets.1.INSTANCE.invoke(psiElement3) : null) == null) continue;
                psiElement2 = psiElement2;
                boolean bl3 = false;
                boolean bl4 = false;
                PsiElement it$iv = psiElement2;
                boolean bl5 = false;
                destination$iv.add(it$iv);
            }
            set2 = (Set)destination$iv;
        } else {
            PsiElement psiElement4 = $this$unwrappedTargets.resolve();
            set2 = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((Object)(psiElement4 != null ? $fun$adjust$1.invoke(psiElement4) : null)));
        }
        return set2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean canBeReferenceTo(@NotNull PsiReference $this$canBeReferenceTo, @NotNull PsiElement candidateTarget) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canBeReferenceTo, (String)"$this$canBeReferenceTo");
        Intrinsics.checkParameterIsNotNull((Object)candidateTarget, (String)"candidateTarget");
        PsiElement psiElement2 = $this$canBeReferenceTo.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
        if (Intrinsics.areEqual((Object)psiElement2.getContainingFile(), (Object)candidateTarget.getContainingFile())) return true;
        PsiElement psiElement3 = $this$canBeReferenceTo.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
        if (!ProjectRootsUtil.isInProjectOrLibSource(psiElement3, true)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean matchesTarget(@NotNull PsiReference $this$matchesTarget, @NotNull PsiElement candidateTarget) {
        boolean bl;
        boolean bl2;
        PsiElement it;
        Intrinsics.checkParameterIsNotNull((Object)$this$matchesTarget, (String)"$this$matchesTarget");
        Intrinsics.checkParameterIsNotNull((Object)candidateTarget, (String)"candidateTarget");
        if (!ReferenceUtilKt.canBeReferenceTo($this$matchesTarget, candidateTarget)) {
            return false;
        }
        PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped(candidateTarget);
        psiElement3 = psiElement3;
        if (psiElement2 == null) return false;
        PsiElement psiElement3 = psiElement3.getOriginalElement();
        psiElement3 = psiElement3;
        if (psiElement4 == null) return false;
        PsiElement unwrappedCandidate = psiElement3;
        PsiReference psiReference = $this$matchesTarget;
        if (psiReference instanceof KtInvokeFunctionReference) {
            if (!(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof PsiMethod)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)((PsiNamedElement)candidateTarget).getName(), (Object)OperatorNameConventions.INVOKE.asString()) ^ true) {
                return false;
            }
        } else if (psiReference instanceof KtDestructuringDeclarationReference ? !(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof KtParameter) && !(candidateTarget instanceof PsiMethod) : psiReference instanceof KtSimpleNameReference && unwrappedCandidate instanceof PsiMethod && !ReferenceUtilKt.canBePsiMethodReference((KtSimpleNameReference)$this$matchesTarget)) {
            return false;
        }
        PsiElement psiElement5 = $this$matchesTarget.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"element");
        PsiElement element3 = psiElement5;
        if (candidateTarget instanceof KtImportAlias && element3 instanceof KtSimpleNameExpression && Intrinsics.areEqual((Object)((KtSimpleNameExpression)element3).getReferencedName(), (Object)((KtImportAlias)candidateTarget).getName())) {
            DeclarationDescriptor declarationDescriptor;
            Object object;
            Iterable iterable;
            Iterator $this$mapNotNullTo$iv$iv;
            KtImportDirective ktImportDirective = ((KtImportAlias)candidateTarget).getImportDirective();
            if (ktImportDirective == null) return false;
            KtImportDirective ktImportDirective2 = ktImportDirective;
            FqName fqName2 = ktImportDirective2.getImportedFqName();
            if (fqName2 == null) return false;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"importDirective.importedFqName ?: return false");
            FqName importedFqName = fqName2;
            KtFile ktFile2 = ktImportDirective2.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"importDirective.containingKtFile");
            Collection<DeclarationDescriptor> importedDescriptors = ResolutionUtils.resolveImportReference(ktFile2, importedFqName);
            Iterable $this$mapNotNull$iv = ReferenceUtilKt.getUnwrappedTargets($this$matchesTarget);
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean bl3 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsiElement psiElement6;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                PsiElement it2 = (PsiElement)element$iv$iv;
                boolean bl5 = false;
                if ((it2 instanceof KtConstructor ? (PsiElement)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)it2) : it2) == null) continue;
                psiElement6 = psiElement6;
                boolean bl6 = false;
                boolean bl7 = false;
                PsiElement it$iv$iv = psiElement6;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List importableTargets = (List)destination$iv$iv;
            Iterable $this$any$iv2 = importedDescriptors;
            boolean $i$f$any = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                return false;
            }
            $this$mapNotNullTo$iv$iv = $this$any$iv2.iterator();
            do {
                if (!$this$mapNotNullTo$iv$iv.hasNext()) return false;
                Object element$iv = $this$mapNotNullTo$iv$iv.next();
                DeclarationDescriptor declarationDescriptor2 = (DeclarationDescriptor)element$iv;
                boolean bl9 = false;
                iterable = importableTargets;
                declarationDescriptor = declarationDescriptor2;
                if (declarationDescriptor instanceof DeclarationDescriptorWithSource) continue;
                declarationDescriptor = null;
            } while (!CollectionsKt.contains((Iterable)iterable, (object = (DeclarationDescriptorWithSource)declarationDescriptor) != null && (object = object.getSource()) != null ? KotlinSourceElementKt.getPsi((SourceElement)object) : null));
            return true;
        }
        if (element3 instanceof KtLabelReferenceExpression) {
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            PsiElement psiElement7 = ((KtLabelReferenceExpression)element3).getParent();
            if (!(psiElement7 instanceof KtContainerNode)) {
                psiElement7 = null;
            }
            KtContainerNode ktContainerNode = (KtContainerNode)psiElement7;
            Object object = ktContainerNode != null ? ktContainerNode.getParent() : null;
            PsiElement importedFqName = object;
            if (importedFqName instanceof KtReturnExpression) {
                $this$forEach$iv = ReferenceUtilKt.getUnwrappedTargets($this$matchesTarget);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (PsiElement)element$iv;
                    boolean bl10 = false;
                    if (!(it instanceof KtFunctionLiteral)) {
                        if (!(it instanceof KtNamedFunction)) continue;
                        CharSequence charSequence = ((KtNamedFunction)it).getName();
                        boolean bl9 = false;
                        boolean bl11 = false;
                        if (!(charSequence == null || charSequence.length() == 0)) continue;
                    }
                    KtFunction cfr_ignored_0 = (KtFunction)it;
                    KtLabeledExpression ktLabeledExpression = KtPsiUtilKt.getLabeledParent((KtExpression)it, ((KtLabelReferenceExpression)element3).getReferencedName());
                    if (ktLabeledExpression != null) {
                        if (!Intrinsics.areEqual((Object)candidateTarget, (Object)ktLabeledExpression)) continue;
                        return true;
                    }
                    Object object2 = ReferenceUtilKt.getCalleeByLambdaArgument((KtFunction)it);
                    if (object2 == null || (object2 = ReferenceUtilKt.getMainReference((KtSimpleNameExpression)object2)) == null) {
                        continue;
                    }
                    Object calleeReference = object2;
                    if (!ReferenceUtilKt.matchesTarget((PsiReference)calleeReference, candidateTarget)) continue;
                    return true;
                }
            } else if (importedFqName instanceof KtBreakExpression || importedFqName instanceof KtContinueExpression) {
                $this$forEach$iv = ReferenceUtilKt.getUnwrappedTargets($this$matchesTarget);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtExpression ktExpression;
                    it = (PsiElement)element$iv;
                    boolean bl12 = false;
                    PsiElement psiElement8 = it;
                    if (!(psiElement8 instanceof KtExpression)) {
                        psiElement8 = null;
                    }
                    if ((ktExpression = (KtExpression)psiElement8) == null || (ktExpression = KtPsiUtilKt.getLabeledParent(ktExpression, ((KtLabelReferenceExpression)element3).getReferencedName())) == null) {
                        continue;
                    }
                    KtExpression ktExpression2 = ktExpression;
                    if (!Intrinsics.areEqual((Object)candidateTarget, (Object)ktExpression2)) continue;
                    return true;
                }
            }
        }
        Set<PsiElement> set2 = ReferenceUtilKt.getUnwrappedTargets($this$matchesTarget);
        PsiManager manager = candidateTarget.getManager();
        Iterable $this$any$iv = set2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (PsiElement)element$iv;
                boolean bl13 = false;
                if (!manager.areElementsEquivalent(unwrappedCandidate, it)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) {
            return true;
        }
        if ($this$matchesTarget instanceof KtReference) {
            boolean bl14;
            $this$any$iv = set2;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator $this$any$iv2 = $this$any$iv.iterator();
            do {
                Object element$iv;
                if (!$this$any$iv2.hasNext()) return false;
                element$iv = $this$any$iv2.next();
                it = (PsiElement)element$iv;
                boolean bl15 = false;
                if (ReferenceUtilKt.isConstructorOf(it, unwrappedCandidate)) return true;
                if (it instanceof KtObjectDeclaration && ((KtObjectDeclaration)it).isCompanion()) {
                    PsiElement psiElement9 = it;
                    boolean $i$f$getNonStrictParentOfType = false;
                    if (Intrinsics.areEqual((Object)((KtClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement9, KtClass.class, (boolean)false)), (Object)unwrappedCandidate)) {
                        return true;
                    }
                }
                bl14 = false;
            } while (!bl14);
            return true;
        }
        if ($this$matchesTarget instanceof PsiJavaCodeReferenceElement && unwrappedCandidate instanceof KtConstructor) {
            PsiNewExpression psiNewExpression;
            PsiElement psiElement10;
            PsiElement psiElement11 = $this$matchesTarget.getElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement11, (String)"getElement()");
            PsiElement parent2 = psiElement11.getParent();
            if (parent2 instanceof PsiAnonymousClass) {
                parent2 = parent2.getParent();
            }
            if (!((psiElement10 = parent2) instanceof PsiNewExpression)) {
                psiElement10 = null;
            }
            if (Intrinsics.areEqual((psiNewExpression = (PsiNewExpression)psiElement10) != null && (psiNewExpression = psiNewExpression.resolveConstructor()) != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiNewExpression) : null, (Object)unwrappedCandidate)) {
                return true;
            }
        }
        if (!($this$matchesTarget instanceof PsiJavaCodeReferenceElement)) return false;
        if (!(candidateTarget instanceof KtObjectDeclaration)) return false;
        if (ReferenceUtilKt.getUnwrappedTargets($this$matchesTarget).size() != 1) return false;
        PsiElement referredClass = (PsiElement)CollectionsKt.first((Iterable)ReferenceUtilKt.getUnwrappedTargets($this$matchesTarget));
        if (!(referredClass instanceof KtClass)) return false;
        if (!((KtClass)referredClass).getCompanionObjects().contains(candidateTarget)) return false;
        if (((PsiJavaCodeReferenceElement)$this$matchesTarget).getParent() instanceof PsiImportStaticStatement) {
            return true;
        }
        PsiElement psiElement12 = ((PsiJavaCodeReferenceElement)$this$matchesTarget).getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement12, (String)"parent");
        PsiReference psiReference2 = psiElement12.getReference();
        Object object = psiReference2;
        if (psiReference2 == null) return false;
        Set<PsiElement> set3 = ReferenceUtilKt.getUnwrappedTargets(object);
        object = set3;
        if (set3 == null) return false;
        Iterable $this$any$iv3 = (Iterable)object;
        boolean $i$f$any2 = false;
        if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
            return false;
        }
        Iterator iterator3 = $this$any$iv3.iterator();
        do {
            if (!iterator3.hasNext()) return false;
            Object element$iv = iterator3.next();
            PsiElement it3 = (PsiElement)element$iv;
            boolean bl16 = false;
            if (it3 instanceof KtProperty || it3 instanceof KtNamedFunction) {
                PsiElement psiElement13 = it3.getParent();
                if (Intrinsics.areEqual((Object)(psiElement13 != null ? psiElement13.getParent() : null), (Object)candidateTarget)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canBePsiMethodReference(@NotNull KtSimpleNameReference $this$canBePsiMethodReference) {
        void $this$getParentOfTypeAndBranch$iv;
        void $this$getParentOfTypeAndBranch$iv2;
        void $this$getParentOfTypeAndBranch$iv3;
        Intrinsics.checkParameterIsNotNull((Object)$this$canBePsiMethodReference, (String)"$this$canBePsiMethodReference");
        PsiElement psiElement2 = $this$canBePsiMethodReference.getElement();
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)$this$canBePsiMethodReference.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"element");
        PsiElement psiElement3 = ktSimpleNameExpression.getParent();
        if (!(psiElement3 instanceof KtCallExpression)) {
            psiElement3 = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)psiElement3;
        if (Intrinsics.areEqual((Object)psiElement2, (Object)(ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null))) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression2 = (KtSimpleNameExpression)$this$canBePsiMethodReference.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression2, (String)"element");
        PsiElement psiElement4 = (PsiElement)ktSimpleNameExpression2;
        Function1 branch$iv = canBePsiMethodReference.callableReference.1.INSTANCE;
        boolean strict$iv22 = false;
        boolean $i$f$getParentOfTypeAndBranch = false;
        void $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv3;
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement5 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallableReferenceExpression.class, (boolean)strict$iv22);
        KtCallableReferenceExpression callableReference2 = (KtCallableReferenceExpression)(psiElement5 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement5, (PsiElement)$this$getParentOfTypeAndBranch$iv3, branch$iv) : null);
        if (callableReference2 != null) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression3 = (KtSimpleNameExpression)$this$canBePsiMethodReference.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression3, (String)"element");
        PsiElement strict$iv22 = (PsiElement)ktSimpleNameExpression3;
        Function1 branch$iv2 = canBePsiMethodReference.binaryOperator.1.INSTANCE;
        boolean strict$iv32 = false;
        boolean $i$f$getParentOfTypeAndBranch2 = false;
        void $this$getParentOfType$iv$iv2 = $this$getParentOfTypeAndBranch$iv2;
        boolean $i$f$getParentOfType2 = false;
        PsiElement psiElement6 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv2, KtBinaryExpression.class, (boolean)strict$iv32);
        KtBinaryExpression binaryOperator2 = (KtBinaryExpression)(psiElement6 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement6, (PsiElement)$this$getParentOfTypeAndBranch$iv2, branch$iv2) : null);
        if (binaryOperator2 != null) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression4 = (KtSimpleNameExpression)$this$canBePsiMethodReference.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression4, (String)"element");
        PsiElement strict$iv32 = (PsiElement)ktSimpleNameExpression4;
        Function1 branch$iv3 = canBePsiMethodReference.unaryOperator.1.INSTANCE;
        boolean strict$iv = false;
        boolean $i$f$getParentOfTypeAndBranch3 = false;
        void $this$getParentOfType$iv$iv3 = $this$getParentOfTypeAndBranch$iv;
        boolean $i$f$getParentOfType3 = false;
        PsiElement psiElement7 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv3, KtUnaryExpression.class, (boolean)strict$iv);
        KtUnaryExpression unaryOperator2 = (KtUnaryExpression)(psiElement7 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement7, (PsiElement)$this$getParentOfTypeAndBranch$iv, branch$iv3) : null);
        if (unaryOperator2 != null) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression5 = (KtSimpleNameExpression)$this$canBePsiMethodReference.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression5, (String)"element");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)ktSimpleNameExpression5;
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtImportDirective.class, (boolean)false) != null;
    }

    private static final boolean isConstructorOf(@NotNull PsiElement $this$isConstructorOf, PsiElement unwrappedCandidate) {
        return $this$isConstructorOf instanceof PsiMethod && ((PsiMethod)$this$isConstructorOf).isConstructor() && Intrinsics.areEqual((Object)((PsiMethod)$this$isConstructorOf).getContainingClass(), (Object)unwrappedCandidate) ? true : $this$isConstructorOf instanceof KtConstructor && ((KtConstructor)$this$isConstructorOf).getContainingClassOrObject().isEquivalentTo(unwrappedCandidate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression renameImplicitConventionalCall(@NotNull AbstractKtReference<? extends KtExpression> $this$renameImplicitConventionalCall, @Nullable String newName2) {
        void newExpression2;
        Intrinsics.checkParameterIsNotNull($this$renameImplicitConventionalCall, (String)"$this$renameImplicitConventionalCall");
        if (newName2 == null) {
            return $this$renameImplicitConventionalCall.getExpression();
        }
        Pair<KtExpression, KtSimpleNameExpression> pair2 = OperatorToFunctionIntention.Companion.convert($this$renameImplicitConventionalCall.getExpression());
        KtExpression ktExpression = (KtExpression)pair2.component1();
        KtSimpleNameExpression newNameElement = (KtSimpleNameExpression)pair2.component2();
        ReferenceUtilKt.getMainReference(newNameElement).handleElementRename(newName2);
        return newExpression2;
    }

    @NotNull
    public static final KtSimpleNameReference getMainReference(@NotNull KtSimpleNameExpression $this$mainReference) {
        PsiReference element$iv2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$this$mainReference, (String)"$this$mainReference");
            PsiReference[] psiReferenceArray = $this$mainReference.getReferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"references");
            PsiReference[] $this$firstIsInstance$iv = psiReferenceArray;
            boolean $i$f$firstIsInstance = false;
            for (PsiReference element$iv2 : $this$firstIsInstance$iv) {
                if (!(element$iv2 instanceof KtSimpleNameReference)) {
                    continue;
                }
                break block2;
            }
            throw (Throwable)new NoSuchElementException("No element of given type found");
        }
        return (KtSimpleNameReference)element$iv2;
    }

    @NotNull
    public static final KtReference getMainReference(@NotNull KtReferenceExpression $this$mainReference) {
        KtReference ktReference;
        Intrinsics.checkParameterIsNotNull((Object)$this$mainReference, (String)"$this$mainReference");
        if ($this$mainReference instanceof KtSimpleNameExpression) {
            ktReference = ReferenceUtilKt.getMainReference((KtSimpleNameExpression)$this$mainReference);
        } else {
            PsiReference element$iv2;
            block4: {
                PsiReference[] psiReferenceArray = $this$mainReference.getReferences();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"references");
                PsiReference[] $this$firstIsInstance$iv = psiReferenceArray;
                boolean $i$f$firstIsInstance = false;
                for (PsiReference element$iv2 : $this$firstIsInstance$iv) {
                    if (!(element$iv2 instanceof KtReference)) {
                        continue;
                    }
                    break block4;
                }
                throw (Throwable)new NoSuchElementException("No element of given type found");
            }
            ktReference = (KtReference)element$iv2;
        }
        return ktReference;
    }

    @NotNull
    public static final KDocReference getMainReference(@NotNull KDocName $this$mainReference) {
        PsiReference element$iv2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$this$mainReference, (String)"$this$mainReference");
            PsiReference[] psiReferenceArray = $this$mainReference.getReferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"references");
            PsiReference[] $this$firstIsInstance$iv = psiReferenceArray;
            boolean $i$f$firstIsInstance = false;
            for (PsiReference element$iv2 : $this$firstIsInstance$iv) {
                if (!(element$iv2 instanceof KDocReference)) {
                    continue;
                }
                break block2;
            }
            throw (Throwable)new NoSuchElementException("No element of given type found");
        }
        return (KDocReference)element$iv2;
    }

    @Nullable
    public static final KtReference getMainReference(@NotNull KtElement $this$mainReference) {
        KtReference ktReference;
        Intrinsics.checkParameterIsNotNull((Object)$this$mainReference, (String)"$this$mainReference");
        if ($this$mainReference instanceof KtReferenceExpression) {
            ktReference = ReferenceUtilKt.getMainReference((KtReferenceExpression)$this$mainReference);
        } else if ($this$mainReference instanceof KDocName) {
            ktReference = ReferenceUtilKt.getMainReference((KDocName)$this$mainReference);
        } else {
            PsiReference psiReference;
            block5: {
                PsiReference[] psiReferenceArray = $this$mainReference.getReferences();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"references");
                PsiReference[] $this$firstIsInstanceOrNull$iv = psiReferenceArray;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (PsiReference element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof KtReference)) continue;
                    psiReference = element$iv;
                    break block5;
                }
                psiReference = null;
            }
            ktReference = (KtReference)psiReference;
        }
        return ktReference;
    }

    @NotNull
    public static final Collection<DeclarationDescriptor> resolveMainReferenceToDescriptors(@NotNull KtElement $this$resolveMainReferenceToDescriptors) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveMainReferenceToDescriptors, (String)"$this$resolveMainReferenceToDescriptors");
        BindingContext bindingContext2 = ResolutionUtils.analyze($this$resolveMainReferenceToDescriptors, BodyResolveMode.PARTIAL);
        Object object = ReferenceUtilKt.getMainReference($this$resolveMainReferenceToDescriptors);
        if (object == null || (object = object.resolveToDescriptors(bindingContext2)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final ReferenceAccess readWriteAccess(@NotNull KtExpression $this$readWriteAccess, boolean useResolveForReadWrite) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readWriteAccess, (String)"$this$readWriteAccess");
        return (ReferenceAccess)((Object)ReferenceUtilKt.readWriteAccessWithFullExpression($this$readWriteAccess, useResolveForReadWrite).getFirst());
    }

    @NotNull
    public static final Pair<ReferenceAccess, KtExpression> readWriteAccessWithFullExpression(@NotNull KtExpression $this$readWriteAccessWithFullExpression, boolean useResolveForReadWrite) {
        KtUnaryExpression unaryExpression;
        PsiElement parent2;
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)$this$readWriteAccessWithFullExpression, (String)"$this$readWriteAccessWithFullExpression");
        KtExpression expression2 = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis($this$readWriteAccessWithFullExpression);
        while ((psiElement2 = (parent2 = expression2.getParent())) instanceof KtParenthesizedExpression || psiElement2 instanceof KtAnnotatedExpression || psiElement2 instanceof KtLabeledExpression) {
            PsiElement psiElement3 = parent2;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            expression2 = (KtExpression)psiElement3;
        }
        KtBinaryExpression assignment = KtPsiUtilKt.getAssignmentByLHS(expression2);
        if (assignment != null) {
            psiElement2 = assignment.getOperationToken();
            if (Intrinsics.areEqual((Object)psiElement2, (Object)((Object)KtTokens.EQ))) {
                return TuplesKt.to((Object)((Object)ReferenceAccess.WRITE), (Object)assignment);
            }
            if (!useResolveForReadWrite) {
                return TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)assignment);
            }
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(assignment, null, 1, null);
            if (resolvedCall2 == null) {
                return TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)assignment);
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
                return TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)assignment);
            }
            return ((ImmutableSet)OperatorConventions.ASSIGNMENT_OPERATIONS.values()).contains((Object)resolvedCall3.getResultingDescriptor().getName()) ? TuplesKt.to((Object)((Object)ReferenceAccess.READ), (Object)assignment) : TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)assignment);
        }
        PsiElement psiElement4 = expression2.getParent();
        if (!(psiElement4 instanceof KtUnaryExpression)) {
            psiElement4 = null;
        }
        return (unaryExpression = (KtUnaryExpression)psiElement4) != null && CollectionsKt.contains((Iterable)((Iterable)AddToStdlibKt.constant(readWriteAccessWithFullExpression.1.INSTANCE)), (Object)unaryExpression.getOperationToken()) ? TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)unaryExpression) : TuplesKt.to((Object)((Object)ReferenceAccess.READ), (Object)expression2);
    }

    public static final boolean canBeResolvedViaImport(@NotNull KtReference $this$canBeResolvedViaImport, @NotNull DeclarationDescriptor target, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canBeResolvedViaImport, (String)"$this$canBeResolvedViaImport");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if ($this$canBeResolvedViaImport instanceof KDocReference) {
            return ((KDocName)((KDocReference)$this$canBeResolvedViaImport).getElement()).getQualifiedName().size() == 1;
        }
        return ReferenceUtilKt.canBeResolvedViaImport($this$canBeResolvedViaImport.getElement(), target, bindingContext2);
    }

    public static final boolean canBeResolvedViaImport(@NotNull KtElement $this$canBeResolvedViaImport, @NotNull DeclarationDescriptor target, @NotNull BindingContext bindingContext2) {
        block10: {
            CallTypeAndReceiver<?, ?> callTypeAndReceiver;
            block12: {
                block11: {
                    Intrinsics.checkParameterIsNotNull((Object)$this$canBeResolvedViaImport, (String)"$this$canBeResolvedViaImport");
                    Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                    Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                    if (!ImportsUtils.canBeReferencedViaImport(target)) {
                        return false;
                    }
                    if (DescriptorUtilsKt.isExtension(target)) {
                        return true;
                    }
                    if (!($this$canBeResolvedViaImport instanceof KtNameReferenceExpression)) {
                        return false;
                    }
                    callTypeAndReceiver = CallTypeAndReceiver.Companion.detect((KtSimpleNameExpression)$this$canBeResolvedViaImport);
                    if (callTypeAndReceiver.getReceiver() == null) break block10;
                    if (!(target instanceof PropertyDescriptor)) break block11;
                    KotlinType kotlinType2 = ((PropertyDescriptor)target).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"target.type");
                    if (FunctionTypesKt.isExtensionFunctionType(kotlinType2)) break block12;
                }
                return false;
            }
            if (!(callTypeAndReceiver instanceof CallTypeAndReceiver.DOT) && !(callTypeAndReceiver instanceof CallTypeAndReceiver.SAFE)) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((Call)bindingContext2.get(BindingContext.CALL, $this$canBeResolvedViaImport), bindingContext2);
            if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) {
                resolvedCall2 = null;
            }
            VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
            if (variableAsFunctionResolvedCall == null) {
                return false;
            }
            VariableAsFunctionResolvedCall resolvedCall3 = variableAsFunctionResolvedCall;
            ExplicitReceiverKind explicitReceiverKind = resolvedCall3.getVariableCall().getExplicitReceiverKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)explicitReceiverKind), (String)"resolvedCall.variableCall.explicitReceiverKind");
            if (explicitReceiverKind.isDispatchReceiver()) {
                return false;
            }
        }
        return !(((KtNameReferenceExpression)$this$canBeResolvedViaImport).getParent() instanceof KtThisExpression) && !(((KtNameReferenceExpression)$this$canBeResolvedViaImport).getParent() instanceof KtSuperExpression);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KtSimpleNameExpression getCalleeByLambdaArgument(@NotNull KtFunction $this$getCalleeByLambdaArgument) {
        KtCallExpression ktCallExpression;
        KtValueArgument argument2;
        void $this$getParentOfTypeAndBranch$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$getCalleeByLambdaArgument, (String)"$this$getCalleeByLambdaArgument");
        PsiElement psiElement2 = $this$getCalleeByLambdaArgument;
        Function1 branch$iv = getCalleeByLambdaArgument.argument.1.INSTANCE;
        boolean strict$iv = false;
        boolean $i$f$getParentOfTypeAndBranch = false;
        void $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtValueArgument.class, (boolean)strict$iv);
        KtValueArgument ktValueArgument = (KtValueArgument)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement3, (PsiElement)$this$getParentOfTypeAndBranch$iv, branch$iv) : null);
        if (ktValueArgument == null) {
            return null;
        }
        KtValueArgument ktValueArgument2 = argument2 = ktValueArgument;
        if (ktValueArgument2 instanceof KtLambdaArgument) {
            PsiElement psiElement4 = ((KtLambdaArgument)argument2).getParent();
            if (!(psiElement4 instanceof KtCallExpression)) {
                psiElement4 = null;
            }
            ktCallExpression = (KtCallExpression)psiElement4;
        } else {
            PsiElement psiElement5 = argument2.getParent();
            if (!(psiElement5 instanceof KtValueArgumentList)) {
                psiElement5 = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement5;
            Object object = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
            if (!(object instanceof KtCallExpression)) {
                object = null;
            }
            ktCallExpression = (KtCallExpression)object;
        }
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        KtExpression ktExpression = callExpression2.getCalleeExpression();
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        return (KtSimpleNameExpression)ktExpression;
    }
}

