/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.AbstractTestClassConfigurationProducer;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.run.JavaRunConfigurationExtensionManagerUtil;
import org.jetbrains.kotlin.idea.run.JvmMppUtilsKt;
import org.jetbrains.kotlin.idea.run.KotlinJUnitRunConfigurationProducerKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/intellij/execution/junit/JUnitConfiguration;", "()V", "createDelegatingContextWithLightElement", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "fromContext", "lightElement", "Lcom/intellij/psi/PsiMember;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "onFirstRun", "", "performRunnable", "Ljava/lang/Runnable;", "settingsMatchTemplate", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "shouldReplace", "self", "other", "Companion", "idea-jvm"})
public final class KotlinJUnitRunConfigurationProducer
extends RunConfigurationProducer<JUnitConfiguration> {
    public static final Companion Companion = new Companion(null);

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.isProducedBy(JUnitConfigurationProducer.class) || other.isProducedBy(AbstractPatternBasedConfigurationProducer.class);
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context2)) {
            return false;
        }
        Location location2 = context2.getLocation();
        if (location2 == null || (location2 = location2.getPsiElement()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"context.location?.psiElement ?: return false");
        Location leaf = location2;
        PsiMethod method = Companion.getTestMethod((PsiElement)leaf);
        PsiClass testClass = Companion.getTestClass((PsiElement)leaf);
        TestObject testObject = configuration2.getTestObject();
        if (!testObject.isConfiguredByElement(configuration2, testClass, method, null, null)) {
            return false;
        }
        return this.settingsMatchTemplate(configuration2, context2);
    }

    private final boolean settingsMatchTemplate(JUnitConfiguration configuration2, ConfigurationContext context2) {
        String vmParameters;
        RunConfiguration predefinedConfiguration = context2.getOriginalConfiguration((ConfigurationType)JUnitConfigurationType.getInstance());
        RunConfiguration runConfiguration = predefinedConfiguration;
        if (!(runConfiguration instanceof CommonJavaRunConfigurationParameters)) {
            runConfiguration = null;
        }
        CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters = (CommonJavaRunConfigurationParameters)runConfiguration;
        String string = vmParameters = commonJavaRunConfigurationParameters != null ? commonJavaRunConfigurationParameters.getVMParameters() : null;
        if (vmParameters != null && Intrinsics.areEqual((Object)configuration2.getVMParameters(), (Object)vmParameters) ^ true) {
            return false;
        }
        Project project = configuration2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"configuration.project");
        RunManager runManager = RunManager.Companion.getInstance(project);
        ConfigurationFactory configurationFactory = this.getConfigurationFactory();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"configurationFactory");
        RunnerAndConfigurationSettings template2 = runManager.getConfigurationTemplate(configurationFactory);
        RunConfiguration runConfiguration2 = template2.getConfiguration();
        if (runConfiguration2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.run.ModuleBasedConfigurationAny /* = com.intellij.execution.configurations.ModuleBasedConfiguration<*, *> */");
        }
        RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)runConfiguration2).getConfigurationModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)runConfigurationModule, (String)"(template.configuration \u2026nAny).configurationModule");
        Module predefinedModule = runConfigurationModule.getModule();
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration2.getConfigurationModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
        Module configurationModule = javaRunConfigurationModule.getModule();
        Location location2 = context2.getLocation();
        return Intrinsics.areEqual((Object)configurationModule, location2 != null && (location2 = location2.getModule()) != null ? JvmMppUtilsKt.asJvmModule((Module)location2) : null) || Intrinsics.areEqual((Object)configurationModule, (Object)predefinedModule);
    }

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        DumbService dumbService = DumbService.getInstance((Project)context2.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(context.project)");
        if (dumbService.isDumb()) {
            return false;
        }
        Location location2 = context2.getLocation();
        if (location2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"context.location ?: return false");
        Location location3 = location2;
        PsiElement psiElement2 = location3.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"location.psiElement");
        PsiElement leaf = psiElement2;
        Module module = context2.getModule();
        if (module == null || (module = JvmMppUtilsKt.asJvmModule(module)) == null) {
            return false;
        }
        Module module2 = module;
        if (!ProjectRootsUtil.isInProjectOrLibSource$default(leaf, false, 2, null)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        PsiMethod method = Companion.getTestMethod(leaf);
        if (method != null) {
            configuration2.beMethodConfiguration(KotlinJUnitRunConfigurationProducerKt.access$toLocation(method));
            JavaRunConfigurationExtensionManagerUtil.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location3);
            configuration2.setModule(module2);
            return true;
        }
        PsiClass testClass = Companion.getTestClass(leaf);
        if (testClass != null) {
            configuration2.beClassConfiguration(testClass);
            JavaRunConfigurationExtensionManagerUtil.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location3);
            configuration2.setModule(module2);
            return true;
        }
        return false;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context2, @NotNull Runnable performRunnable) {
        PsiMember psiMember;
        Intrinsics.checkParameterIsNotNull((Object)fromContext, (String)"fromContext");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)performRunnable, (String)"performRunnable");
        PsiElement psiElement2 = fromContext.getSourceElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"fromContext.sourceElement");
        PsiElement leaf = psiElement2;
        PsiMethod psiMethod = Companion.getTestMethod(leaf);
        if (!(psiMethod instanceof PsiMember)) {
            psiMethod = null;
        }
        if ((psiMember = (PsiMember)psiMethod) == null) {
            psiMember = (PsiMember)Companion.getTestClass(leaf);
        }
        if (psiMember == null) {
            super.onFirstRun(fromContext, context2, performRunnable);
            return;
        }
        PsiMember sourceElement = psiMember;
        ConfigurationFromContext contextWithLightElement = this.createDelegatingContextWithLightElement(fromContext, sourceElement);
        new AbstractTestClassConfigurationProducer((ConfigurationType)JUnitConfigurationType.getInstance()){}.onFirstRun(contextWithLightElement, context2, performRunnable);
    }

    private final ConfigurationFromContext createDelegatingContextWithLightElement(ConfigurationFromContext fromContext, PsiMember lightElement) {
        return new ConfigurationFromContext(fromContext, lightElement){
            final /* synthetic */ ConfigurationFromContext $fromContext;
            final /* synthetic */ PsiMember $lightElement;

            @NotNull
            public RunnerAndConfigurationSettings getConfigurationSettings() {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.$fromContext.getConfigurationSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)runnerAndConfigurationSettings, (String)"fromContext.configurationSettings");
                return runnerAndConfigurationSettings;
            }

            public void setConfigurationSettings(@NotNull RunnerAndConfigurationSettings configurationSettings) {
                Intrinsics.checkParameterIsNotNull((Object)configurationSettings, (String)"configurationSettings");
                this.$fromContext.setConfigurationSettings(configurationSettings);
            }

            @NotNull
            public PsiMember getSourceElement() {
                return this.$lightElement;
            }
            {
                this.$fromContext = $captured_local_variable$0;
                this.$lightElement = $captured_local_variable$1;
            }
        };
    }

    public KotlinJUnitRunConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer$Companion;", "", "()V", "getTestClass", "Lcom/intellij/psi/PsiClass;", "leaf", "Lcom/intellij/psi/PsiElement;", "getTestClassInFile", "Lorg/jetbrains/kotlin/psi/KtClass;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getTestMethod", "Lcom/intellij/psi/PsiMethod;", "isJUnitTestClass", "", "idea-jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PsiClass getTestClass(@NotNull PsiElement leaf) {
            void $this$getParentOfType$iv;
            Intrinsics.checkParameterIsNotNull((Object)leaf, (String)"leaf");
            PsiFile psiFile = leaf.getContainingFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile2 = (KtFile)psiFile;
            if (ktFile2 == null) {
                return null;
            }
            KtFile containingFile = ktFile2;
            PsiElement psiElement2 = leaf;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
            if (!this.isJUnitTestClass(ktClass2)) {
                ktClass2 = this.getTestClassInFile(containingFile);
            }
            KtClass ktClass3 = ktClass2;
            return ktClass3 != null ? LightClassUtilsKt.toLightClass(ktClass3) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PsiMethod getTestMethod(@NotNull PsiElement leaf) {
            void $this$getParentOfType$iv;
            Intrinsics.checkParameterIsNotNull((Object)leaf, (String)"leaf");
            PsiElement psiElement2 = leaf;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedFunction.class, (boolean)strict$iv);
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            KtTypeParameterListOwner owner = (KtTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)function2, (Class[])new Class[]{KtFunction.class, KtClass.class});
            if (owner instanceof KtClass) {
                PsiMethod psiMethod;
                block6: {
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)owner);
                    if (ktLightClass == null) {
                        return null;
                    }
                    KtLightClass delegate = ktLightClass;
                    PsiMethod[] psiMethodArray = delegate.getMethods();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"delegate.methods");
                    PsiMethod[] $this$firstOrNull$iv = psiMethodArray;
                    boolean $i$f$firstOrNull = false;
                    PsiMethod[] psiMethodArray2 = $this$firstOrNull$iv;
                    int n = psiMethodArray2.length;
                    for (int j = 0; j < n; ++j) {
                        PsiMethod element$iv;
                        PsiMethod it = element$iv = psiMethodArray2[j];
                        boolean bl = false;
                        PsiMethod psiMethod2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"it");
                        if (!Intrinsics.areEqual((Object)psiMethod2.getNavigationElement(), (Object)function2)) continue;
                        psiMethod = element$iv;
                        break block6;
                    }
                    psiMethod = null;
                }
                if (psiMethod == null) {
                    return null;
                }
                PsiMethod method = psiMethod;
                if (JUnitUtil.isTestMethod((Location)KotlinJUnitRunConfigurationProducerKt.access$toLocation(method), (boolean)false)) {
                    return method;
                }
            }
            return null;
        }

        private final boolean isJUnitTestClass(@Nullable KtClass $this$isJUnitTestClass) {
            boolean bl;
            Object object = $this$isJUnitTestClass;
            if (object != null && (object = LightClassUtilsKt.toLightClass(object)) != null) {
                Object object2 = object;
                boolean bl2 = false;
                boolean bl3 = false;
                Object it = object2;
                boolean bl4 = false;
                bl = JUnitUtil.isTestClass((PsiClass)((PsiClass)it), (boolean)false, (boolean)true);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final KtClass getTestClassInFile(KtFile ktFile2) {
            Object v0;
            block3: {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ktFile2.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtClass)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtClass it = (KtClass)element$iv;
                    boolean bl = false;
                    if (!Companion.isJUnitTestClass(it)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            return v0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

