/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchRunnerUtilKt;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myAlarm", "Lcom/intellij/util/Alarm;", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getScratchPanel", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runScratch", "panel", "Companion", "idea-jvm"})
public final class ScratchFileAutoRunner
implements DocumentListener {
    private final Alarm myAlarm;
    private final Project project;
    private static final int auto_run_delay = 2000;
    public static final Companion Companion = new Companion(null);

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(event.getDocument());
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"FileDocumentManager.getI\u2026event.document) ?: return");
        VirtualFile file2 = virtualFile2;
        if (this.project.isDisposed()) {
            return;
        }
        ScratchTopPanel scratchTopPanel = this.getScratchPanel(file2, this.project);
        if (scratchTopPanel == null) {
            return;
        }
        ScratchTopPanel panel = scratchTopPanel;
        if (!panel.getScratchFile().getOptions().isInteractiveMode()) {
            return;
        }
        if (ScratchRunnerUtilKt.isScratchChanged(this.project, file2)) {
            this.runScratch(panel);
        }
    }

    private final void runScratch(ScratchTopPanel panel) {
        this.myAlarm.cancelAllRequests();
        if (ScratchCompilationSupport.INSTANCE.isInProgress(panel.getScratchFile())) {
            ScratchCompilationSupport.INSTANCE.forceStop();
        }
        this.myAlarm.addRequest(new Runnable(panel){
            final /* synthetic */ ScratchTopPanel $panel;

            public final void run() {
                PsiFile psiFile = this.$panel.getScratchFile().getPsiFile();
                if (psiFile != null && psiFile.isValid() && !this.$panel.getScratchFile().hasErrors()) {
                    RunScratchAction.Companion.doAction(this.$panel, true);
                }
            }
            {
                this.$panel = scratchTopPanel;
            }
        }, 2000, true);
    }

    private final ScratchTopPanel getScratchPanel(VirtualFile file2, Project project) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        Pair<TextEditor, ScratchTopPanel> pair2 = ScratchUtilsKt.getEditorWithScratchPanel(fileEditorManager, file2);
        return pair2 != null ? (ScratchTopPanel)pair2.getSecond() : null;
    }

    public ScratchFileAutoRunner(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion;", "", "()V", "auto_run_delay", "", "addListener", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getInstance", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "kotlin.jvm.PlatformType", "idea-jvm"})
    public static final class Companion {
        public final void addListener(@NotNull Project project, @NotNull TextEditor editor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
            if (ScratchUtilsKt.getScratchPanel(editor2) != null) {
                Editor editor3 = editor2.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
                editor3.getDocument().addDocumentListener((DocumentListener)this.getInstance(project));
                Disposer.register((Disposable)((Disposable)editor2), (Disposable)new Disposable(editor2, project){
                    final /* synthetic */ TextEditor $editor;
                    final /* synthetic */ Project $project;

                    public final void dispose() {
                        Editor editor2 = this.$editor.getEditor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                        editor2.getDocument().removeDocumentListener((DocumentListener)org.jetbrains.kotlin.idea.scratch.ScratchFileAutoRunner$Companion.access$getInstance(ScratchFileAutoRunner.Companion, this.$project));
                    }
                    {
                        this.$editor = textEditor;
                        this.$project = project;
                    }
                });
            }
        }

        private final ScratchFileAutoRunner getInstance(Project project) {
            return (ScratchFileAutoRunner)ServiceManager.getService((Project)project, ScratchFileAutoRunner.class);
        }

        private Companion() {
        }

        public static final /* synthetic */ ScratchFileAutoRunner access$getInstance(Companion $this, Project project) {
            return $this.getInstance(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

