/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileLanguageProvider;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction;", "Lorg/jetbrains/kotlin/idea/scratch/actions/ScratchAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "idea-jvm"})
public final class RunScratchAction
extends ScratchAction {
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ScratchTopPanel scratchTopPanel = ScratchUtilsKt.getScratchPanelFromSelectedEditor(project2);
        if (scratchTopPanel == null) {
            return;
        }
        ScratchTopPanel scratchPanel = scratchTopPanel;
        Companion.doAction(scratchPanel, false);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(!ScratchCompilationSupport.INSTANCE.isAnyInProgress());
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        if (presentation2.isEnabled()) {
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
            Presentation presentation4 = this.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation4, (String)"templatePresentation");
            presentation3.setText(presentation4.getText());
        } else {
            Presentation presentation5 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation5, (String)"e.presentation");
            presentation5.setText("Other Scratch file execution is in progress");
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ScratchTopPanel scratchTopPanel = ScratchUtilsKt.getScratchPanelFromSelectedEditor(project2);
        if (scratchTopPanel == null) {
            return;
        }
        ScratchTopPanel panel = scratchTopPanel;
        Presentation presentation6 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation6, (String)"e.presentation");
        presentation6.setVisible(!ScratchCompilationSupport.INSTANCE.isInProgress(panel.getScratchFile()));
    }

    public RunScratchAction() {
        block0: {
            String string = KotlinBundle.message("scratch.run.button", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBundle.message(\"scratch.run.button\")");
            Icon icon = AllIcons.Actions.Execute;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Actions.Execute");
            super(string, icon);
            KeymapManager keymapManager = KeymapManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)keymapManager, (String)"KeymapManager.getInstance()");
            Object[] objectArray = keymapManager.getActiveKeymap().getShortcuts("Kotlin.RunScratch");
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"KeymapManager.getInstanc\u2026cuts(\"Kotlin.RunScratch\")");
            Shortcut shortcut = (Shortcut)ArraysKt.firstOrNull((Object[])objectArray);
            if (shortcut == null) break block0;
            Shortcut shortcut2 = shortcut;
            boolean bl = false;
            boolean bl2 = false;
            Shortcut it = shortcut2;
            boolean bl3 = false;
            Presentation presentation = this.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
            presentation.setText(presentation.getText() + " (" + KeymapUtil.getShortcutText((Shortcut)it) + ')');
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction$Companion;", "", "()V", "doAction", "", "scratchPanel", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;", "isAutoRun", "", "idea-jvm"})
    public static final class Companion {
        public final void doAction(@NotNull ScratchTopPanel scratchPanel, boolean isAutoRun) {
            ScratchExecutor executor;
            Intrinsics.checkParameterIsNotNull((Object)scratchPanel, (String)"scratchPanel");
            ScratchFile scratchFile = scratchPanel.getScratchFile();
            PsiFile psiFile = scratchFile.getPsiFile();
            if (psiFile == null) {
                return;
            }
            PsiFile psiFile2 = psiFile;
            boolean isMakeBeforeRun = scratchFile.getOptions().isMakeBeforeRun();
            boolean isRepl = scratchFile.getOptions().isRepl();
            Language language = psiFile2.getLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"psiFile.language");
            ScratchFileLanguageProvider scratchFileLanguageProvider = ScratchFileLanguageProvider.Companion.get(language);
            if (scratchFileLanguageProvider == null) {
                return;
            }
            ScratchFileLanguageProvider provider2 = scratchFileLanguageProvider;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isMakeBeforeRun = " + isMakeBeforeRun + ", isRepl = " + isRepl);
            ScratchOutputHandler defaultOutputHandler = provider2.getOutputHandler();
            Module module = scratchPanel.getModule();
            ScratchExecutor scratchExecutor = executor = isRepl ? provider2.createReplExecutor(scratchFile) : provider2.createCompilingExecutor(scratchFile);
            if (executor == null) {
                defaultOutputHandler.error(scratchFile, "Couldn't run " + psiFile2.getName());
                return;
            }
            executor.addOutputHandler(defaultOutputHandler);
            executor.addOutputHandler(new ScratchOutputHandlerAdapter(executor, scratchPanel){
                final /* synthetic */ ScratchExecutor $executor;
                final /* synthetic */ ScratchTopPanel $scratchPanel;

                public void onStart(@NotNull ScratchFile file2) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    ScratchCompilationSupport.INSTANCE.start(file2, this.$executor);
                    this.$scratchPanel.updateToolbar();
                }

                public void onFinish(@NotNull ScratchFile file2) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    ScratchCompilationSupport.INSTANCE.stop();
                    this.$scratchPanel.updateToolbar();
                }
                {
                    this.$executor = $captured_local_variable$0;
                    this.$scratchPanel = $captured_local_variable$1;
                }
            });
            Function0<Unit> $fun$executeScratch$2 = new Function0<Unit>(executor){
                final /* synthetic */ ScratchExecutor $executor;

                public final void invoke() {
                    try {
                        this.$executor.execute();
                    }
                    catch (Throwable ex) {
                        this.$executor.errorOccurs("Exception occurs during Run Scratch Action", ex, true);
                    }
                }
                {
                    this.$executor = scratchExecutor;
                    super(0);
                }
            };
            if (!isAutoRun && module != null && isMakeBeforeRun) {
                Project project = scratchPanel.getScratchFile().getProject();
                ProjectTaskManager.getInstance((Project)project).build(new Module[]{module}, new ProjectTaskNotification(executor, module, project, $fun$executeScratch$2){
                    final /* synthetic */ ScratchExecutor $executor;
                    final /* synthetic */ Module $module;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ doAction.2 $executeScratch$2;

                    public final void finished(@NotNull ProjectTaskResult result2) {
                        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                        if (result2.isAborted() || result2.getErrors() > 0) {
                            ScratchExecutor.errorOccurs$default(this.$executor, "There were compilation errors in module " + this.$module.getName(), null, false, 6, null);
                        }
                        if (DumbService.isDumb((Project)this.$project)) {
                            DumbService.getInstance((Project)this.$project).smartInvokeLater(new Runnable(this){
                                final /* synthetic */ doAction.3 this$0;

                                public final void run() {
                                    this.this$0.$executeScratch$2.invoke();
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        } else {
                            this.$executeScratch$2.invoke();
                        }
                    }
                    {
                        this.$executor = scratchExecutor;
                        this.$module = module;
                        this.$project = project;
                        this.$executeScratch$2 = var4_4;
                    }
                });
            } else {
                $fun$executeScratch$2.invoke();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

