/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesManager;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtCompilingExecutor;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0002$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010\u001e\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "backgroundProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "checkForErrors", "", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "compileFileToTempDir", "Ljava/io/File;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "originalFile", "module", "Lcom/intellij/openapi/module/Module;", "mainClassName", "", "tempOutDir", "execute", "", "stop", "writeClassFilesToTempDir", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "findExpression", "psiElement", "Lcom/intellij/psi/PsiElement;", "lineStart", "", "lineEnd", "Companion", "ProcessOutputParser", "idea-jvm"})
public final class KtCompilingExecutor
extends ScratchExecutor {
    private ProgressIndicator backgroundProcessIndicator;
    private final List<ScratchExpression> expressions;
    private static final int TIMEOUT_MS = 30000;
    public static final Companion Companion = new Companion(null);

    @Override
    public void execute() {
        this.getHandler().onStart(this.getFile());
        PsiFile psiFile = this.getFile().getPsiFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile2 = (KtFile)psiFile;
        if (ktFile2 == null) {
            ScratchExecutor.errorOccurs$default(this, "Couldn't find KtFile for current editor", null, true, 2, null);
            return;
        }
        KtFile psiFile2 = ktFile2;
        if (!this.checkForErrors(psiFile2)) {
            return;
        }
        KtScratchSourceFileProcessor.Result result2 = (KtScratchSourceFileProcessor.Result)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtScratchSourceFileProcessor.Result>(this){
            final /* synthetic */ KtCompilingExecutor this$0;

            @NotNull
            public final KtScratchSourceFileProcessor.Result invoke() {
                return new KtScratchSourceFileProcessor().process(KtCompilingExecutor.access$getExpressions$p(this.this$0));
            }
            {
                this.this$0 = ktCompilingExecutor;
                super(0);
            }
        });
        KtScratchSourceFileProcessor.Result result3 = result2;
        if (result3 instanceof KtScratchSourceFileProcessor.Result.Error) {
            ScratchExecutor.errorOccurs$default(this, ((KtScratchSourceFileProcessor.Result.Error)result2).getMessage(), null, true, 2, null);
            return;
        }
        if (result3 instanceof KtScratchSourceFileProcessor.Result.OK) {
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "After processing by KtScratchSourceFileProcessor:\n " + ((KtScratchSourceFileProcessor.Result.OK)result2).getCode());
            new Task.Backgroundable(this, psiFile2, result2, psiFile2.getProject(), "Running Kotlin Scratch...", true){
                final /* synthetic */ KtCompilingExecutor this$0;
                final /* synthetic */ KtFile $psiFile;
                final /* synthetic */ KtScratchSourceFileProcessor.Result $result;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    KtCompilingExecutor.access$setBackgroundProcessIndicator$p(this.this$0, indicator);
                    KtFile modifiedScratchSourceFile2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>(this){
                        final /* synthetic */ execute.1 this$0;

                        @NotNull
                        public final KtFile invoke() {
                            Project project = this.this$0.$psiFile.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
                            return new KtPsiFactory(project, false, 2, null).createFileWithLightClassSupport("tmp.kt", ((KtScratchSourceFileProcessor.Result.OK)this.this$0.$result).getCode(), (PsiElement)this.this$0.$psiFile);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                    try {
                        File file2 = (File)DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode((Computable)new Computable<File>(this, modifiedScratchSourceFile2){
                            final /* synthetic */ execute.1 this$0;
                            final /* synthetic */ KtFile $modifiedScratchSourceFile;

                            @Nullable
                            public final File compute() {
                                return KtCompilingExecutor.access$compileFileToTempDir(this.this$0.this$0, this.$modifiedScratchSourceFile);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$modifiedScratchSourceFile = ktFile2;
                            }
                        });
                        if (file2 == null) {
                            return;
                        }
                        File tempDir2 = file2;
                        try {
                            Module module = KtCompilingExecutor.access$getFile$p(this.this$0).getModule();
                            String string = ((KtScratchSourceFileProcessor.Result.OK)this.$result).getMainClassName();
                            String string2 = tempDir2.getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tempDir.path");
                            GeneralCommandLine commandLine = KtCompilingExecutor.access$createCommandLine(this.this$0, this.$psiFile, module, string, string2);
                            Logger logger = ScratchUtilsKt.getLOG();
                            String string3 = commandLine.getCommandLineString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"commandLine.commandLineString");
                            ScratchUtilsKt.printDebugMessage(logger, string3);
                            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
                            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator, KtCompilingExecutor.access$getTIMEOUT_MS$cp());
                            Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"processHandler.runProces\u2026or(indicator, TIMEOUT_MS)");
                            ProcessOutput executionResult = processOutput;
                            if (executionResult.isTimeout()) {
                                ScratchExecutor.errorOccurs$default(this.this$0, "Couldn't get scratch execution result - stopped by timeout (" + KtCompilingExecutor.access$getTIMEOUT_MS$cp() + " ms)", null, false, 6, null);
                            } else if (executionResult.isCancelled()) {
                            } else {
                                this.this$0.new ProcessOutputParser().parse(executionResult);
                            }
                        }
                        finally {
                            tempDir2.delete();
                            KtCompilingExecutor.access$getHandler$p(this.this$0).onFinish(KtCompilingExecutor.access$getFile$p(this.this$0));
                        }
                    }
                    catch (Throwable e) {
                        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), ((KtScratchSourceFileProcessor.Result.OK)this.$result).getCode());
                        String string = e.getMessage();
                        if (string == null) {
                            string = "Couldn't compile " + this.$psiFile.getName();
                        }
                        this.this$0.errorOccurs(string, e, true);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$psiFile = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                }
            }.queue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            if (progressIndicator != null) {
                progressIndicator.cancel();
            }
        }
        finally {
            this.getHandler().onFinish(this.getFile());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File compileFileToTempDir(KtFile psiFile) {
        void bindingContext2;
        if (!this.checkForErrors(psiFile)) {
            return null;
        }
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(psiFile);
        Pair pair2 = DebuggerUtils.analyzeInlinedFunctions$default(DebuggerUtils.INSTANCE, resolutionFacade, psiFile, false, null, 8, null);
        BindingContext bindingContext3 = (BindingContext)pair2.component1();
        List files2 = (List)pair2.component2();
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Analyzed files: \n" + CollectionsKt.joinToString$default((Iterable)files2, (CharSequence)"\n", null, null, (int)0, null, (Function1)compileFileToTempDir.1.INSTANCE, (int)30, null));
        GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(psiFile){
            final /* synthetic */ KtFile $psiFile;

            public boolean shouldGeneratePackagePart(@NotNull KtFile ktFile2) {
                Intrinsics.checkParameterIsNotNull((Object)ktFile2, (String)"ktFile");
                return Intrinsics.areEqual((Object)ktFile2, (Object)this.$psiFile);
            }

            public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
                Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                return true;
            }

            public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
                Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                return Intrinsics.areEqual((Object)processingClassOrObject.getContainingKtFile(), (Object)this.$psiFile);
            }

            public boolean shouldGenerateScript(@NotNull KtScript script) {
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                return false;
            }

            public boolean shouldGenerateCodeFragment(@NotNull KtCodeFragment script) {
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                return false;
            }
            {
                this.$psiFile = $captured_local_variable$0;
            }
        };
        Project project = this.getFile().getProject();
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.BINARIES");
        ModuleDescriptor moduleDescriptor2 = resolutionFacade.getModuleDescriptor();
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"CompilerConfiguration.EMPTY");
        GenerationState state = new GenerationState.Builder(project, classBuilderFactory, moduleDescriptor2, (BindingContext)bindingContext2, files2, compilerConfiguration).generateDeclaredClassFilter(generateClassFilter2).build();
        KotlinCodegenFacade.compileCorrectFiles(state, CompilationErrorHandler.THROW_EXCEPTION);
        return this.writeClassFilesToTempDir(state);
    }

    private final File writeClassFilesToTempDir(GenerationState state) {
        List<OutputFile> list2 = state.getFactory().asList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"state.factory.asList()");
        List<OutputFile> classFiles = ClassFileUtilsKt.filterClassFiles(list2);
        File file2 = FileUtil.createTempDirectory((String)"compile", (String)"scratch");
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempDirectory(\"compile\", \"scratch\")");
        File dir = file2;
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Temp output dir: " + dir.getPath());
        for (OutputFile classFile : classFiles) {
            File tmpOutFile = new File(dir, classFile.getRelativePath());
            tmpOutFile.getParentFile().mkdirs();
            tmpOutFile.createNewFile();
            FilesKt.writeBytes((File)tmpOutFile, (byte[])classFile.asByteArray());
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Generated class file: " + classFile.getRelativePath());
        }
        return dir;
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine createCommandLine(KtFile originalFile, Module module, String mainClassName, String tempOutDir) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Project project = originalFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"originalFile.project");
        JavaParameters javaParameters = new JavaParametersBuilder(project).withSdkFrom(module, true).withMainClassName(mainClassName).build();
        javaParameters.getClassPath().add(tempOutDir);
        if (module != null) {
            javaParameters.getClassPath().addAll(JavaParametersBuilder.Companion.getModuleDependencies(module));
        }
        Project project2 = originalFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"originalFile.project");
        ScriptDependenciesManager scriptDependenciesManager = ScriptDependenciesManager.Companion.getInstance(project2);
        VirtualFile virtualFile2 = originalFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"originalFile.virtualFile");
        ScriptDependencies scriptDependencies2 = scriptDependenciesManager.getScriptDependencies(virtualFile2);
        Iterable iterable = scriptDependencies2.getClasspath();
        PathsList pathsList = javaParameters.getClassPath();
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        pathsList.addAll((List)collection);
        GeneralCommandLine generalCommandLine = javaParameters.toCommandLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"javaParameters.toCommandLine()");
        return generalCommandLine;
    }

    private final boolean checkForErrors(KtFile psiFile) {
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(this, psiFile){
            final /* synthetic */ KtCompilingExecutor this$0;
            final /* synthetic */ KtFile $psiFile;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void $this$filterTo$iv$iv;
                try {
                    AnalyzingUtils.checkForSyntacticErrors((PsiElement)this.$psiFile);
                }
                catch (IllegalArgumentException e) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Couldn't compile " + this.$psiFile.getName();
                    }
                    ScratchExecutor.errorOccurs$default(this.this$0, string, null, true, 2, null);
                    return false;
                }
                AnalysisResult analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks(this.$psiFile, new KtFile[0]);
                if (analysisResult.isError()) {
                    String string = analysisResult.getError().getMessage();
                    if (string == null) {
                        string = "Couldn't compile " + this.$psiFile.getName();
                    }
                    ScratchExecutor.errorOccurs$default(this.this$0, string, null, true, 2, null);
                    return false;
                }
                BindingContext bindingContext2 = analysisResult.getBindingContext();
                Diagnostics diagnostics2 = bindingContext2.getDiagnostics();
                Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics2, (String)"bindingContext.diagnostics");
                Iterable $this$filter$iv = diagnostics2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Diagnostic it = (Diagnostic)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSeverity() == Severity.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List diagnostics3 = (List)destination$iv$iv;
                $this$filter$iv = diagnostics3;
                $i$f$filter = false;
                if (!$this$filter$iv.isEmpty()) {
                    PsiFile scratchPsiFile = KtCompilingExecutor.access$getFile$p(this.this$0).getPsiFile();
                    Iterable $this$forEach$iv = diagnostics3;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String errorText2;
                        Diagnostic diagnostic = (Diagnostic)element$iv;
                        boolean bl = false;
                        Intrinsics.checkExpressionValueIsNotNull((Object)DefaultErrorMessages.render(diagnostic), (String)"DefaultErrorMessages.render(diagnostic)");
                        if (Intrinsics.areEqual((Object)this.$psiFile, (Object)scratchPsiFile)) {
                            PsiElement psiElement2 = diagnostic.getPsiElement();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
                            if (Intrinsics.areEqual((Object)psiElement2.getContainingFile(), (Object)this.$psiFile)) {
                                List list2 = KtCompilingExecutor.access$getExpressions$p(this.this$0);
                                PsiElement psiElement3 = diagnostic.getPsiElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"diagnostic.psiElement");
                                ScratchExpression scratchExpression = KtCompilingExecutor.access$findExpression(this.this$0, list2, psiElement3);
                                if (scratchExpression == null) {
                                    Logger logger = ScratchUtilsKt.getLOG();
                                    StringBuilder stringBuilder = new StringBuilder().append("Couldn't find expression to report error: ");
                                    PsiElement psiElement4 = diagnostic.getPsiElement();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"diagnostic.psiElement");
                                    logger.error(stringBuilder.append(PsiUtilsKt.getElementTextWithContext(psiElement4)).toString());
                                    KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText2);
                                    continue;
                                }
                                KtCompilingExecutor.access$getHandler$p(this.this$0).handle(KtCompilingExecutor.access$getFile$p(this.this$0), scratchExpression, new ScratchOutput(errorText2, ScratchOutputType.ERROR));
                                continue;
                            }
                            KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText2);
                            continue;
                        }
                        KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText2);
                    }
                    KtCompilingExecutor.access$getHandler$p(this.this$0).onFinish(KtCompilingExecutor.access$getFile$p(this.this$0));
                    return false;
                }
                return true;
            }
            {
                this.this$0 = ktCompilingExecutor;
                this.$psiFile = ktFile2;
                super(0);
            }
        });
    }

    private final ScratchExpression findExpression(@NotNull List<ScratchExpression> $this$findExpression, PsiElement psiElement2) {
        int elementLine = KotlinRefactoringUtilKt.getLineNumber$default(psiElement2, false, 1, null);
        return (ScratchExpression)ApplicationUtilsKt.runReadAction((Function0)new Function0<ScratchExpression>($this$findExpression, elementLine){
            final /* synthetic */ List $this_findExpression;
            final /* synthetic */ int $elementLine;

            @Nullable
            public final ScratchExpression invoke() {
                Object v0;
                block1: {
                    Iterable $this$firstOrNull$iv = this.$this_findExpression;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        ScratchExpression it = (ScratchExpression)element$iv;
                        boolean bl = false;
                        int n = this.$elementLine;
                        if (!(it.getLineStart() <= n && it.getLineEnd() >= n)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
            {
                this.$this_findExpression = list2;
                this.$elementLine = n;
                super(0);
            }
        });
    }

    private final ScratchExpression findExpression(@NotNull List<ScratchExpression> $this$findExpression, int lineStart, int lineEnd) {
        return (ScratchExpression)ApplicationUtilsKt.runReadAction((Function0)new Function0<ScratchExpression>($this$findExpression, lineStart, lineEnd){
            final /* synthetic */ List $this_findExpression;
            final /* synthetic */ int $lineStart;
            final /* synthetic */ int $lineEnd;

            @Nullable
            public final ScratchExpression invoke() {
                Object v0;
                block1: {
                    Iterable $this$firstOrNull$iv = this.$this_findExpression;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        ScratchExpression it = (ScratchExpression)element$iv;
                        boolean bl = false;
                        if (!(it.getLineStart() == this.$lineStart && it.getLineEnd() == this.$lineEnd)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
            {
                this.$this_findExpression = list2;
                this.$lineStart = n;
                this.$lineEnd = n2;
                super(0);
            }
        });
    }

    public KtCompilingExecutor(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        super(file2);
        this.expressions = file2.getExpressions();
    }

    static {
        TIMEOUT_MS = 30000;
    }

    public static final /* synthetic */ ProgressIndicator access$getBackgroundProcessIndicator$p(KtCompilingExecutor $this) {
        return $this.backgroundProcessIndicator;
    }

    public static final /* synthetic */ void access$setBackgroundProcessIndicator$p(KtCompilingExecutor $this, ProgressIndicator progressIndicator) {
        $this.backgroundProcessIndicator = progressIndicator;
    }

    public static final /* synthetic */ File access$compileFileToTempDir(KtCompilingExecutor $this, KtFile psiFile) {
        return $this.compileFileToTempDir(psiFile);
    }

    public static final /* synthetic */ GeneralCommandLine access$createCommandLine(KtCompilingExecutor $this, KtFile originalFile, Module module, String mainClassName, String tempOutDir) {
        return $this.createCommandLine(originalFile, module, mainClassName, tempOutDir);
    }

    public static final /* synthetic */ int access$getTIMEOUT_MS$cp() {
        return TIMEOUT_MS;
    }

    public static final /* synthetic */ ScratchExpression access$findExpression(KtCompilingExecutor $this, List $this$access_u24findExpression, PsiElement psiElement2) {
        return $this.findExpression($this$access_u24findExpression, psiElement2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor$ProcessOutputParser;", "", "(Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;)V", "extractLineInfoFrom", "Lkotlin/Pair;", "", "encoded", "", "isGeneratedOutput", "", "line", "isOutputEnd", "isResultEnd", "parse", "", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "parseStdOut", "out", "idea-jvm"})
    private final class ProcessOutputParser {
        public final void parse(@NotNull ProcessOutput processOutput) {
            Intrinsics.checkParameterIsNotNull((Object)processOutput, (String)"processOutput");
            String string = processOutput.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processOutput.stdout");
            String out = string;
            String string2 = processOutput.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"processOutput.stderr");
            String err = string2;
            CharSequence charSequence = err;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                KtCompilingExecutor.this.getHandler().error(KtCompilingExecutor.this.getFile(), err);
            }
            charSequence = out;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                this.parseStdOut(out);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseStdOut(String out) {
            boolean bl = false;
            ArrayList<String> results2 = new ArrayList<String>();
            boolean bl2 = false;
            ArrayList<String> userOutput = new ArrayList<String>();
            for (String line : StringsKt.split$default((CharSequence)out, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)) {
                ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Compiling executor output: " + line);
                if (this.isOutputEnd(line)) {
                    return;
                }
                if (this.isGeneratedOutput(line)) {
                    String lineWoPrefix = StringsKt.removePrefix((String)line, (CharSequence)"##scratch##generated##");
                    if (this.isResultEnd(lineWoPrefix)) {
                        void startLine;
                        Pair<Integer, Integer> extractedLineInfo;
                        if (this.extractLineInfoFrom(lineWoPrefix) == null) {
                            ScratchExecutor.errorOccurs$default(KtCompilingExecutor.this, "Couldn't extract line info from line: " + lineWoPrefix, null, true, 2, null);
                            return;
                        }
                        Pair<Integer, Integer> pair2 = extractedLineInfo;
                        int n = ((Number)pair2.component1()).intValue();
                        int endLine = ((Number)pair2.component2()).intValue();
                        ScratchExpression scratchExpression = KtCompilingExecutor.this.findExpression(KtCompilingExecutor.this.expressions, (int)startLine, endLine);
                        if (scratchExpression == null) {
                            ScratchUtilsKt.getLOG().error("Couldn't find expression with start line = " + (int)startLine + ", end line = " + endLine + ".\n" + CollectionsKt.joinToString$default((Iterable)KtCompilingExecutor.this.expressions, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                        } else {
                            Iterable $this$forEach$iv = userOutput;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String output = (String)element$iv;
                                boolean bl3 = false;
                                KtCompilingExecutor.this.getHandler().handle(KtCompilingExecutor.this.getFile(), scratchExpression, new ScratchOutput(output, ScratchOutputType.OUTPUT));
                            }
                            $this$forEach$iv = results2;
                            $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String result2 = (String)element$iv;
                                boolean bl4 = false;
                                KtCompilingExecutor.this.getHandler().handle(KtCompilingExecutor.this.getFile(), scratchExpression, new ScratchOutput(result2, ScratchOutputType.RESULT));
                            }
                        }
                        boolean bl5 = false;
                        results2 = new ArrayList();
                        bl5 = false;
                        userOutput = new ArrayList();
                        continue;
                    }
                    if (!(Intrinsics.areEqual((Object)lineWoPrefix, (Object)Unit.INSTANCE.toString()) ^ true)) continue;
                    results2.add(lineWoPrefix);
                    continue;
                }
                userOutput.add(line);
            }
        }

        private final boolean isOutputEnd(String line) {
            return Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)line, (CharSequence)"\n"), (Object)"end##!@#%^&*");
        }

        private final boolean isResultEnd(String line) {
            return StringsKt.startsWith$default((String)line, (String)"end##", (boolean)false, (int)2, null);
        }

        private final boolean isGeneratedOutput(String line) {
            return StringsKt.startsWith$default((String)line, (String)"##scratch##generated##", (boolean)false, (int)2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> extractLineInfoFrom(String encoded) {
            List lineInfo = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)encoded, (CharSequence)"end##"), (CharSequence)"\n"), (char[])new char[]{'|'}, (boolean)false, (int)0, (int)6, null);
            if (lineInfo.size() == 2) {
                try {
                    void a;
                    String string = (String)lineInfo.get(0);
                    boolean bl = false;
                    Integer n = Integer.parseInt(string);
                    string = (String)lineInfo.get(1);
                    Integer n2 = n;
                    bl = false;
                    int n3 = Integer.parseInt(string);
                    Pair pair2 = TuplesKt.to((Object)n2, (Object)n3);
                    int n4 = ((Number)pair2.component1()).intValue();
                    int b = ((Number)pair2.component2()).intValue();
                    if (a > -1 && b > -1) {
                        return TuplesKt.to((Object)((int)a), (Object)b);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor$Companion;", "", "()V", "TIMEOUT_MS", "", "idea-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

