/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.repl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "history", "Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory;", "osProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "execute", "", "sendCommandToProcess", "command", "", "stop", "ReplHistory", "ReplOSProcessHandler", "idea-jvm"})
public final class KtScratchReplExecutor
extends ScratchExecutor {
    private final ReplHistory history;
    private OSProcessHandler osProcessHandler;

    @Override
    public void execute() {
        this.getHandler().onStart(this.getFile());
        Module module = this.getFile().getModule();
        GeneralCommandLine cmdLine = KotlinConsoleKeeper.Companion.createReplCommandLine(this.getFile().getProject(), module);
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Execute REPL: " + cmdLine.getCommandLineString());
        OSProcessHandler oSProcessHandler = this.osProcessHandler = (OSProcessHandler)new ReplOSProcessHandler(cmdLine);
        if (oSProcessHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osProcessHandler");
        }
        oSProcessHandler.startNotify();
        Iterable $this$forEach$iv = this.getFile().getExpressions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ScratchExpression expression2 = (ScratchExpression)element$iv;
            boolean bl = false;
            this.history.addEntry(expression2);
            KtScratchReplExecutor ktScratchReplExecutor = this;
            boolean $i$f$runReadAction = false;
            Object object2 = object = ApplicationManager.getApplication().runReadAction(new Computable<T>(expression2){
                final /* synthetic */ ScratchExpression $expression$inlined;
                {
                    this.$expression$inlined = scratchExpression;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$expression$inlined.getElement().getText();
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"runReadAction { expression.element.text }");
            ktScratchReplExecutor.sendCommandToProcess((String)object2);
        }
        this.sendCommandToProcess(":quit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            OSProcessHandler oSProcessHandler = this.osProcessHandler;
            if (oSProcessHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"osProcessHandler");
            }
            oSProcessHandler.getProcess().destroy();
        }
        finally {
            this.getHandler().onFinish(this.getFile());
        }
    }

    private final void sendCommandToProcess(String command2) {
        Charset charset;
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Send to REPL: " + command2);
        OSProcessHandler oSProcessHandler = this.osProcessHandler;
        if (oSProcessHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osProcessHandler");
        }
        OutputStream outputStream2 = oSProcessHandler.getProcessInput();
        if (outputStream2 == null) {
            RunExecuteActionsKt.logError$default(this.getClass(), "<p>Broken execute stream</p>", null, 4, null);
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"osProcessHandler.process\u2026oken execute stream</p>\")");
        OutputStream processInputOS = outputStream2;
        OSProcessHandler oSProcessHandler2 = this.osProcessHandler;
        if (oSProcessHandler2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osProcessHandler");
        }
        if ((charset = oSProcessHandler2.getCharset()) == null) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"osProcessHandler.charset ?: Charsets.UTF_8");
        Charset charset2 = charset;
        String xmlRes = ReplUtilKt.replInputAsXml(command2);
        String string = xmlRes + '\n';
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes2 = byArray;
        processInputOS.write(bytes2);
        processInputOS.flush();
    }

    public KtScratchReplExecutor(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        super(file2);
        this.history = new ReplHistory();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\nJ\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory;", "", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Lkotlin/collections/ArrayList;", "processedEntriesCount", "", "addEntry", "", "entry", "entryProcessed", "lastProcessedEntry", "lastUnprocessedEntry", "idea-jvm"})
    private static final class ReplHistory {
        private ArrayList<ScratchExpression> entries;
        private int processedEntriesCount;

        public final void addEntry(@NotNull ScratchExpression entry) {
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            this.entries.add(entry);
        }

        @Nullable
        public final ScratchExpression lastUnprocessedEntry() {
            ArrayList<ScratchExpression> arrayList = this.entries;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<ScratchExpression> it = arrayList;
            boolean bl3 = false;
            ArrayList<ScratchExpression> arrayList2 = this.processedEntriesCount < this.entries.size() ? arrayList : null;
            return arrayList2 != null ? arrayList2.get(this.processedEntriesCount) : null;
        }

        @Nullable
        public final ScratchExpression lastProcessedEntry() {
            int lastProcessedEntryIndex = this.processedEntriesCount - 1;
            ArrayList<ScratchExpression> arrayList = this.entries;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<ScratchExpression> it = arrayList;
            boolean bl3 = false;
            ArrayList<ScratchExpression> arrayList2 = lastProcessedEntryIndex < this.entries.size() ? arrayList : null;
            return arrayList2 != null ? arrayList2.get(lastProcessedEntryIndex) : null;
        }

        public final void entryProcessed() {
            int n = this.processedEntriesCount;
            this.processedEntriesCount = n + 1;
        }

        public ReplHistory() {
            ReplHistory replHistory = this;
            boolean bl = false;
            ArrayList arrayList = new ArrayList();
            replHistory.entries = arrayList;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001c\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplOSProcessHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor;Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "handleReplMessage", "", "text", "", "notifyProcessTerminated", "exitCode", "", "notifyTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "parseReplOutput", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "idea-jvm"})
    private final class ReplOSProcessHandler
    extends OSProcessHandler {
        private final DocumentBuilderFactory factory;

        public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> outputType) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Intrinsics.checkParameterIsNotNull(outputType, (String)"outputType");
            if (StringsKt.startsWith$default((String)text2, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2, null)) {
                return;
            }
            if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                this.handleReplMessage(text2);
            }
        }

        protected void notifyProcessTerminated(int exitCode) {
            KtScratchReplExecutor.this.getHandler().onFinish(KtScratchReplExecutor.this.getFile());
        }

        private final InputSource strToSource(String s, Charset encoding) {
            byte[] byArray;
            String string = s;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string2.getBytes(encoding);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray = byArray2;
            InputStream inputStream = new ByteArrayInputStream(byArray3);
            return new InputSource(inputStream);
        }

        static /* synthetic */ InputSource strToSource$default(ReplOSProcessHandler replOSProcessHandler, String string, Charset charset, int n, Object object) {
            if ((n & 2) != 0) {
                charset = Charsets.UTF_8;
            }
            return replOSProcessHandler.strToSource(string, charset);
        }

        private final void handleReplMessage(String text2) {
            Document output;
            Document document;
            if (StringsKt.isBlank((CharSequence)text2)) {
                return;
            }
            try {
                document = this.factory.newDocumentBuilder().parse(ReplOSProcessHandler.strToSource$default(this, text2, null, 2, null));
            }
            catch (Exception e) {
                KtScratchReplExecutor.this.getHandler().error(KtScratchReplExecutor.this.getFile(), "Couldn't parse REPL output: " + text2);
                return;
            }
            Document document2 = output = document;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"output");
            Node node = document2.getFirstChild();
            if (node == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element root = (Element)node;
            String outputType = root.getAttribute("type");
            String string = root.getTextContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root.textContent");
            String content2 = ReplUtilKt.replRemoveLineBreaksInTheEnd(ReplUtilKt.replNormalizeLineBreaks(ReplUtilKt.replUnescapeLineBreaks(string)));
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "REPL output: " + outputType + ' ' + content2);
            if (SetsKt.setOf((Object[])new String[]{"SUCCESS", "COMPILE_ERROR", "INTERNAL_ERROR", "RUNTIME_ERROR", "READLINE_END"}).contains(outputType)) {
                KtScratchReplExecutor.this.history.entryProcessed();
            }
            String string2 = outputType;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"outputType");
            ScratchOutput result2 = this.parseReplOutput(content2, string2);
            if (result2 != null) {
                ScratchExpression lastExpression;
                ScratchExpression scratchExpression = lastExpression = Intrinsics.areEqual((Object)outputType, (Object)"USER_OUTPUT") ? KtScratchReplExecutor.this.history.lastUnprocessedEntry() : KtScratchReplExecutor.this.history.lastProcessedEntry();
                if (lastExpression != null) {
                    KtScratchReplExecutor.this.getHandler().handle(KtScratchReplExecutor.this.getFile(), lastExpression, result2);
                }
            }
        }

        private final ScratchOutput parseReplOutput(String text2, String outputType) {
            ScratchOutput scratchOutput;
            switch (outputType) {
                case "USER_OUTPUT": {
                    scratchOutput = new ScratchOutput(text2, ScratchOutputType.OUTPUT);
                    break;
                }
                case "REPL_RESULT": {
                    scratchOutput = new ScratchOutput(text2, ScratchOutputType.RESULT);
                    break;
                }
                case "RUNTIME_ERROR": 
                case "INTERNAL_ERROR": 
                case "COMPILE_ERROR": 
                case "REPL_INCOMPLETE": {
                    scratchOutput = new ScratchOutput(text2, ScratchOutputType.ERROR);
                    break;
                }
                default: {
                    scratchOutput = null;
                }
            }
            return scratchOutput;
        }

        public ReplOSProcessHandler(GeneralCommandLine cmd) {
            Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
            super(cmd);
            this.factory = DocumentBuilderFactory.newInstance();
        }
    }
}

