/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchFileAutoRunner;
import org.jetbrains.kotlin.idea.scratch.ScratchFileLanguageProvider;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchFileHook;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isPluggable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectClosed", "", "projectOpened", "ScratchEditorListener", "idea-jvm"})
public final class ScratchFileHook
implements ProjectComponent {
    @NotNull
    private final Project project;

    public void projectOpened() {
        this.project.getMessageBus().connect((Disposable)this.project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new ScratchEditorListener());
    }

    public void projectClosed() {
        Iterable $this$forEach$iv = ScratchUtilsKt.getAllEditorsWithScratchPanel(this.project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$editor$_u24__u24 = (Pair)element$iv;
            boolean bl = false;
            TextEditor editor2 = (TextEditor)$dstr$editor$_u24__u24.component1();
            ScratchUtilsKt.removeScratchPanel(editor2);
        }
    }

    private final boolean isPluggable(VirtualFile file2) {
        if (!file2.isValid()) {
            return false;
        }
        if (!(ScratchFileService.getInstance().getRootType(file2) instanceof ScratchRootType)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file2);
        if (psiFile == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiManager.getInstance(p\u2026ile(file) ?: return false");
        PsiFile psiFile2 = psiFile;
        FileType fileType = psiFile2.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"psiFile.fileType");
        return ScratchFileLanguageProvider.Companion.get(fileType) != null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScratchFileHook(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchFileHook$ScratchEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "(Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchFileHook;)V", "fileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "idea-jvm"})
    private final class ScratchEditorListener
    implements FileEditorManagerListener {
        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            if (!ScratchFileHook.this.isPluggable(file2)) {
                return;
            }
            TextEditor textEditor = ScratchUtilsKt.getEditorWithoutScratchPanel(source, file2);
            if (textEditor == null) {
                return;
            }
            TextEditor editor2 = textEditor;
            ScratchTopPanel.Companion.createPanel(ScratchFileHook.this.getProject(), file2, editor2);
            ScratchFileAutoRunner.Companion.addListener(ScratchFileHook.this.getProject(), editor2);
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        }
    }
}

