/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinPropertyAccessorsReferenceSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "propertyNames", "", "", "method", "Lcom/intellij/psi/PsiMethod;", "idea"})
public final class KotlinPropertyAccessorsReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        PsiMethod psiMethod = queryParameters.getMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"queryParameters.method");
        PsiMethod method = psiMethod;
        SearchScope searchScope2 = queryParameters.getEffectiveSearchScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"queryParameters.effectiveSearchScope");
        SearchScope onlyKotlinFiles = SearchUtilKt.restrictToKotlinSources(searchScope2);
        if (Intrinsics.areEqual((Object)onlyKotlinFiles, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return;
        }
        for (String propertyName : this.propertyNames(method)) {
            SearchRequestCollector searchRequestCollector = queryParameters.getOptimizer();
            if (searchRequestCollector == null) {
                Intrinsics.throwNpe();
            }
            searchRequestCollector.searchWord(propertyName, onlyKotlinFiles, (short)1, true, (PsiElement)method);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> propertyNames(PsiMethod method) {
        void $this$mapTo$iv$iv;
        PsiNamedElement unwrapped = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)method);
        if (unwrapped instanceof KtProperty) {
            return CollectionsKt.listOfNotNull((Object)unwrapped.getName());
        }
        Name name2 = Name.identifier(method.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(method.name)");
        Iterable $this$map$iv = SyntheticJavaPropertyDescriptor.Companion.propertyNamesByAccessorName(name2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            Name name3 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = p1.asString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public KotlinPropertyAccessorsReferenceSearcher() {
        super(true);
    }
}

