/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.idea.versions.VersionedLibrary;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a,\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\r\u001a\u00020\n\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u000f\u00a8\u0006\u0018"}, d2={"collectModulesWithOutdatedRuntime", "", "Lcom/intellij/openapi/module/Module;", "libraries", "Lorg/jetbrains/kotlin/idea/versions/VersionedLibrary;", "findKotlinRuntimeLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "module", "predicate", "Lkotlin/Function2;", "Lcom/intellij/openapi/project/Project;", "", "findOutdatedKotlinLibraries", "project", "getKotlinLibraryVersion", "", "library", "getOutdatedRuntimeLibraryVersion", "isKotlinJavaRuntime", "isKotlinJsRuntime", "isKotlinRuntime", "isRuntimeOutdated", "libraryVersion", "runtimeVersion", "idea-jvm"})
public final class OutdatedKotlinRuntimeCheckerKt {
    @NotNull
    public static final List<VersionedLibrary> findOutdatedKotlinLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (KotlinPluginUtil.isSnapshotVersion()) {
            return CollectionsKt.emptyList();
        }
        if (KotlinPluginUtil.isDevVersion()) {
            return CollectionsKt.emptyList();
        }
        if (project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        ArrayList<VersionedLibrary> outdatedLibraries = new ArrayList<VersionedLibrary>();
        for (Map.Entry entry : KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project).entrySet()) {
            Object object = entry;
            boolean bl2 = false;
            Library library2 = (Library)object.getKey();
            object = entry;
            bl2 = false;
            Collection modules = (Collection)object.getValue();
            Library library3 = library2;
            Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
            String string = OutdatedKotlinRuntimeCheckerKt.getOutdatedRuntimeLibraryVersion(library3, project);
            if (string == null) continue;
            object = string;
            bl2 = false;
            boolean bl3 = false;
            Object version = object;
            boolean bl4 = false;
            Collection collection = modules;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"modules");
            outdatedLibraries.add(new VersionedLibrary(library2, (String)version, collection));
        }
        return outdatedLibraries;
    }

    private static final String getOutdatedRuntimeLibraryVersion(Library library2, Project project) {
        String string = OutdatedKotlinRuntimeCheckerKt.getKotlinLibraryVersion(library2, project);
        if (string == null) {
            return null;
        }
        String libraryVersion = string;
        String runtimeVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
        return OutdatedKotlinRuntimeCheckerKt.isRuntimeOutdated(libraryVersion, runtimeVersion) ? libraryVersion : null;
    }

    private static final String getKotlinLibraryVersion(Library library2, Project project) {
        String string = JavaRuntimeDetectionUtil.getJavaRuntimeVersion(library2);
        if (string == null) {
            string = JsLibraryStdDetectionUtil.INSTANCE.getJsLibraryStdVersion(library2, project);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Library findKotlinRuntimeLibrary(@NotNull Module module, @NotNull Function2<? super Library, ? super Project, Boolean> predicate2) {
        Object v4;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(module).orderEntries");
            OrderEntry[] $this$filterIsInstance$iv = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            OrderEntry[] orderEntryArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List orderEntries = (List)destination$iv$iv;
            Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)orderEntries), (Function1)findKotlinRuntimeLibrary.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Library it = (Library)element$iv;
                boolean bl = false;
                Library library2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"it");
                Project project = module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                if (!((Boolean)predicate2.invoke((Object)library2, (Object)project)).booleanValue()) continue;
                v4 = element$iv;
                break block2;
            }
            v4 = null;
        }
        return v4;
    }

    public static /* synthetic */ Library findKotlinRuntimeLibrary$default(Module module, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = findKotlinRuntimeLibrary.1.INSTANCE;
        }
        return OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary(module, (Function2<? super Library, ? super Project, Boolean>)function2);
    }

    private static final boolean isKotlinRuntime(Library library2, Project project) {
        return OutdatedKotlinRuntimeCheckerKt.isKotlinJavaRuntime(library2) || OutdatedKotlinRuntimeCheckerKt.isKotlinJsRuntime(library2, project);
    }

    private static final boolean isKotlinJavaRuntime(Library library2) {
        Object[] objectArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        return JavaRuntimeDetectionUtil.getRuntimeJar(ArraysKt.asList((Object[])objectArray)) != null;
    }

    private static final boolean isKotlinJsRuntime(Library library2, Project project) {
        return JsLibraryStdDetectionUtil.hasJsStdlibJar$default(JsLibraryStdDetectionUtil.INSTANCE, library2, project, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> collectModulesWithOutdatedRuntime(@NotNull List<VersionedLibrary> libraries) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Iterable $this$flatMap$iv = libraries;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VersionedLibrary it = (VersionedLibrary)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getUsedInModules();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isRuntimeOutdated(@Nullable String libraryVersion, @NotNull String runtimeVersion) {
        Intrinsics.checkParameterIsNotNull((Object)runtimeVersion, (String)"runtimeVersion");
        return libraryVersion == null || StringsKt.startsWith$default((String)libraryVersion, (String)"internal-", (boolean)false, (int)2, null) != StringsKt.startsWith$default((String)runtimeVersion, (String)"internal-", (boolean)false, (int)2, null) || VersionComparatorUtil.compare((String)StringsKt.substringBefore$default((String)runtimeVersion, (String)"-release-", null, (int)2, null), (String)libraryVersion) > 0;
    }

    public static final /* synthetic */ boolean access$isKotlinRuntime(Library library2, Project project) {
        return OutdatedKotlinRuntimeCheckerKt.isKotlinRuntime(library2, project);
    }
}

