/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.File;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;", "", "sourceContentResolver", "Lkotlin/Function1;", "", "Ljava/io/Reader;", "(Lkotlin/jvm/functions/Function1;)V", "groups", "", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapGroup;", "getGroups", "()Ljava/util/List;", "getSourceContentResolver", "()Lkotlin/jvm/functions/Function1;", "debug", "", "writer", "Ljava/io/PrintStream;", "debugVerbose", "generatedJsFile", "Ljava/io/File;", "js.parser"})
public final class SourceMap {
    @NotNull
    private final List<SourceMapGroup> groups;
    @NotNull
    private final Function1<String, Reader> sourceContentResolver;

    @NotNull
    public final List<SourceMapGroup> getGroups() {
        return this.groups;
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(@NotNull PrintStream writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        boolean bl = false;
        for (SourceMapGroup group : (Iterable)this.groups) {
            void index2;
            writer.print("" + (int)(index2 + true) + ':');
            for (SourceMapSegment segment : group.getSegments()) {
                writer.print("" + ' ' + (segment.getGeneratedColumnNumber() + 1) + ':' + (segment.getSourceLineNumber() + 1) + ',' + (segment.getSourceColumnNumber() + 1));
            }
            writer.println();
            ++index2;
        }
    }

    public static /* synthetic */ void debug$default(SourceMap sourceMap2, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream2, (String)"System.out");
            printStream = printStream2;
        }
        sourceMap2.debug(printStream);
    }

    /*
     * WARNING - void declaration
     */
    public final void debugVerbose(@NotNull PrintStream writer, @NotNull File generatedJsFile) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)generatedJsFile, (String)"generatedJsFile");
        boolean bl = generatedJsFile.exists();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SourceMap$debugVerbose$22 = false;
            String $i$a$-assert-SourceMap$debugVerbose$22 = generatedJsFile + " does not exist!";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-SourceMap$debugVerbose$22));
        }
        Collection $this$toTypedArray$iv22 = FilesKt.readLines$default((File)generatedJsFile, null, (int)1, null);
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv22;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] generatedLines = stringArray;
        boolean $this$toTypedArray$iv22 = false;
        for (SourceMapGroup group : (Iterable)this.groups) {
            void $this$mapTo$iv$iv;
            void index2;
            writer.print("" + (int)(index2 + true) + ':');
            String generatedLine = generatedLines[index2];
            Iterable $this$map$iv22 = group.getSegments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv22;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SourceMapSegment sourceMapSegment = (SourceMapSegment)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                Pair pair2 = TuplesKt.to((Object)it.getGeneratedColumnNumber(), (Object)it);
                collection2.add(pair2);
            }
            Map segmentsByColumn = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            int $this$map$iv22 = 0;
            int n = ((CharSequence)generatedLine).length();
            while ($this$map$iv22 < n) {
                void i2;
                if ((SourceMapSegment)segmentsByColumn.get((int)i2) != null) {
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Iterable $dstr$_u24__u24$sourceFile$sourceLine$sourceColumn = iterable;
                    boolean bl6 = false;
                    String sourceFile = ((SourceMapSegment)((Object)$dstr$_u24__u24$sourceFile$sourceLine$sourceColumn)).component2();
                    int sourceLine = ((SourceMapSegment)((Object)$dstr$_u24__u24$sourceFile$sourceLine$sourceColumn)).component3();
                    int sourceColumn = ((SourceMapSegment)((Object)$dstr$_u24__u24$sourceFile$sourceLine$sourceColumn)).component4();
                    writer.print('<' + sourceFile + ':' + (sourceLine + 1) + ':' + (sourceColumn + 1) + '>');
                }
                writer.print(generatedLine.charAt((int)i2));
                ++i2;
            }
            writer.println();
            ++index2;
        }
    }

    @NotNull
    public final Function1<String, Reader> getSourceContentResolver() {
        return this.sourceContentResolver;
    }

    public SourceMap(@NotNull Function1<? super String, ? extends Reader> sourceContentResolver) {
        List list2;
        Intrinsics.checkParameterIsNotNull(sourceContentResolver, (String)"sourceContentResolver");
        this.sourceContentResolver = sourceContentResolver;
        SourceMap sourceMap2 = this;
        boolean bl = false;
        sourceMap2.groups = list2 = (List)new ArrayList();
    }
}

